/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ManorChairBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape LOWER_BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)13.95, (double)1.875, (double)2.0, (double)15.95, (double)13.875), Block.m_49796_((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)14.025, (double)14.0, (double)1.975, (double)16.0, (double)16.0, (double)13.975), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)10.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0)});
    private static final VoxelShape UPPER_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape LOWER_N = LOWER_BASE;
    private static final VoxelShape LOWER_E = ManorChairBlock.rotateShape(LOWER_BASE, Direction.EAST);
    private static final VoxelShape LOWER_S = ManorChairBlock.rotateShape(LOWER_BASE, Direction.SOUTH);
    private static final VoxelShape LOWER_W = ManorChairBlock.rotateShape(LOWER_BASE, Direction.WEST);
    private static final VoxelShape UPPER_N = UPPER_BASE;
    private static final VoxelShape UPPER_E = ManorChairBlock.rotateShape(UPPER_BASE, Direction.EAST);
    private static final VoxelShape UPPER_S = ManorChairBlock.rotateShape(UPPER_BASE, Direction.SOUTH);
    private static final VoxelShape UPPER_W = ManorChairBlock.rotateShape(UPPER_BASE, Direction.WEST);

    public ManorChairBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.BLOCK));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            FluidState fluid = level.m_6425_(pos);
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockPos above;
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && level.m_8055_(above = pos.m_7494_()).m_247087_()) {
            FluidState fluid = level.m_6425_(above);
            level.m_7731_(above, (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_)), 3);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos otherPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState otherState = level.m_8055_(otherPos);
        if (otherState.m_60713_((Block)this) && otherState.m_61143_(HALF) != half) {
            level.m_46961_(otherPos, !player.m_7500_());
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Direction f = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return switch (f) {
                case Direction.NORTH -> LOWER_N;
                case Direction.EAST -> LOWER_E;
                case Direction.SOUTH -> LOWER_S;
                case Direction.WEST -> LOWER_W;
                default -> LOWER_N;
            };
        }
        return switch (f) {
            case Direction.NORTH -> UPPER_N;
            case Direction.EAST -> UPPER_E;
            case Direction.SOUTH -> UPPER_S;
            case Direction.WEST -> UPPER_W;
            default -> UPPER_N;
        };
    }

    public boolean m_6104_(BlockState state, BlockState neighbor, Direction side) {
        if (neighbor.m_60734_() == this && state.m_61143_((Property)FACING) == neighbor.m_61143_((Property)FACING)) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && neighbor.m_61143_(HALF) == DoubleBlockHalf.UPPER && side == Direction.UP) {
                return true;
            }
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER && neighbor.m_61143_(HALF) == DoubleBlockHalf.LOWER && side == Direction.DOWN) {
                return true;
            }
        }
        return super.m_6104_(state, neighbor, side);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos targetPos = pos;
        BlockState targetState = state;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER && ((targetState = level.m_8055_(targetPos = pos.m_7495_())).m_60734_() != state.m_60734_() || targetState.m_61143_(HALF) != DoubleBlockHalf.LOWER)) {
            return InteractionResult.PASS;
        }
        if (((IGravityEntity)player).roundabout$getGravityDirection() != Direction.DOWN) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            float yaw = ((Direction)state.m_61143_((Property)FACING)).m_122435_();
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                y -= 1.0;
            }
            if (player.m_146892_().f_82480_ > y) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.f_8906_.m_9774_(x, y, z, yaw, sp.m_146909_());
                    sp.m_5616_(yaw);
                    sp.m_5618_(yaw);
                    IPlayerEntity ipe = (IPlayerEntity)player;
                    ipe.roundabout$SetPoseEmote((byte)11);
                } else {
                    player.m_6021_(x, y, z);
                    player.m_146922_(yaw);
                    player.m_5616_(yaw);
                    player.m_5618_(yaw);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction to) {
        VoxelShape rotated = shape;
        int times = switch (to) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        for (int i = 0; i < times; ++i) {
            VoxelShape next = Shapes.m_83040_();
            for (AABB box : rotated.m_83299_()) {
                double minX = box.f_82288_;
                double minY = box.f_82289_;
                double minZ = box.f_82290_;
                double maxX = box.f_82291_;
                double maxY = box.f_82292_;
                double maxZ = box.f_82293_;
                double nMinX = 1.0 - maxZ;
                double nMinZ = minX;
                double nMaxX = 1.0 - minZ;
                double nMaxZ = maxX;
                next = Shapes.m_83110_((VoxelShape)next, (VoxelShape)Block.m_49796_((double)(nMinX * 16.0), (double)(minY * 16.0), (double)(nMinZ * 16.0), (double)(nMaxX * 16.0), (double)(maxY * 16.0), (double)(nMaxZ * 16.0)));
            }
            rotated = next.m_83296_();
        }
        return rotated;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState above;
        BlockState below;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (half == DoubleBlockHalf.UPPER ? !(below = level.m_8055_(pos.m_7495_())).m_60713_((Block)this) || below.m_61143_(HALF) != DoubleBlockHalf.LOWER || below.m_61143_((Property)FACING) != facing : !(above = level.m_8055_(pos.m_7494_())).m_60713_((Block)this) || above.m_61143_(HALF) != DoubleBlockHalf.UPPER || above.m_61143_((Property)FACING) != facing) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }
}

