/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.hydra.jojomod.block.FogBlock;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.item.FogBlockItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.CreativeInventoryListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class FogInventoryScreen
extends EffectRenderingInventoryScreen<ItemPickerMenu> {
    private static final ResourceLocation CREATIVE_TABS_LOCATION = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int NUM_ROWS = 5;
    private static final int NUM_COLS = 9;
    private static final int TAB_WIDTH = 26;
    private static final int TAB_HEIGHT = 32;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    static final SimpleContainer CONTAINER = new SimpleContainer(45);
    private static final Component TRASH_SLOT_TOOLTIP = Component.m_237115_((String)"inventory.binSlot");
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static CreativeModeTab selectedTab = ModItems.FOG_BLOCK_ITEMS;
    private float scrollOffs;
    private boolean scrolling;
    private EditBox searchBox;
    @Nullable
    private List<Slot> originalSlots;
    @Nullable
    private Slot destroyItemSlot;
    private CreativeInventoryListener listener;
    private boolean ignoreTextInput;
    private boolean hasClickedOutside;
    private final Set<TagKey<Item>> visibleTags = new HashSet<TagKey<Item>>();
    private final boolean displayOperatorCreativeTab;
    private Button doneButton;

    public FogInventoryScreen(Player $$0, FeatureFlagSet $$1, boolean $$2) {
        super((AbstractContainerMenu)new ItemPickerMenu($$0), $$0.m_150109_(), CommonComponents.f_237098_);
        $$0.f_36096_ = this.f_97732_;
        this.f_97727_ = 136;
        this.f_97726_ = 195;
        this.displayOperatorCreativeTab = $$2;
        CreativeModeTabs.m_269226_((FeatureFlagSet)$$1, (boolean)this.hasPermissions($$0), (HolderLookup.Provider)$$0.m_9236_().m_9598_());
    }

    private boolean hasPermissions(Player $$0) {
        return $$0.m_36337_() && this.displayOperatorCreativeTab;
    }

    private void tryRefreshInvalidatedTabs(FeatureFlagSet $$0, boolean $$1, HolderLookup.Provider $$2) {
        if (CreativeModeTabs.m_269226_((FeatureFlagSet)$$0, (boolean)$$1, (HolderLookup.Provider)$$2)) {
            for (CreativeModeTab $$3 : CreativeModeTabs.m_257478_()) {
                Collection $$4 = $$3.m_260957_();
                if ($$3 != selectedTab) continue;
                if ($$3.m_257962_() == CreativeModeTab.Type.CATEGORY && $$4.isEmpty()) {
                    this.selectTab(CreativeModeTabs.m_257543_());
                    continue;
                }
                this.refreshCurrentTabContents($$4);
            }
        }
    }

    private void refreshCurrentTabContents(Collection<ItemStack> $$0) {
        int $$1 = ((ItemPickerMenu)this.f_97732_).getRowIndexForScroll(this.scrollOffs);
        ((ItemPickerMenu)this.f_97732_).items.clear();
        this.refreshSearchResults();
        this.scrollOffs = ((ItemPickerMenu)this.f_97732_).getScrollForRowIndex($$1);
        ((ItemPickerMenu)this.f_97732_).scrollTo(this.scrollOffs);
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null) {
            if (this.f_96541_.f_91074_ != null) {
                this.tryRefreshInvalidatedTabs(this.f_96541_.f_91074_.f_108617_.m_247016_(), this.hasPermissions((Player)this.f_96541_.f_91074_), (HolderLookup.Provider)this.f_96541_.f_91074_.m_9236_().m_9598_());
            }
            this.searchBox.m_94120_();
        }
    }

    protected void m_6597_(@Nullable Slot $$0, int $$1, int $$2, ClickType $$3) {
        if ($$3 == ClickType.SWAP || $$3 == ClickType.QUICK_MOVE) {
            return;
        }
        if (this.isCreativeSlot($$0)) {
            this.searchBox.m_94201_();
            this.searchBox.m_94208_(0);
        }
        boolean flag = $$3 == ClickType.QUICK_MOVE;
        ClickType clickType = $$3 = $$1 == -999 && $$3 == ClickType.PICKUP ? ClickType.THROW : $$3;
        if ($$0 == null && selectedTab.m_257962_() != CreativeModeTab.Type.INVENTORY && $$3 != ClickType.QUICK_CRAFT) {
            if (!((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_() && this.hasClickedOutside) {
                if ($$2 == 0) {
                    this.f_96541_.f_91074_.m_36176_(((ItemPickerMenu)this.f_97732_).m_142621_(), true);
                    C2SPacketUtil.inventoryToServerPacket(-1, ((ItemPickerMenu)this.f_97732_).m_142621_(), (byte)1);
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                }
                if ($$2 == 1) {
                    ItemStack $$18 = ((ItemPickerMenu)this.f_97732_).m_142621_().m_41620_(1);
                    this.f_96541_.f_91074_.m_36176_($$18, true);
                    C2SPacketUtil.inventoryToServerPacket(-1, $$18, (byte)1);
                }
            }
        } else {
            if ($$0 != null && !$$0.m_8010_((Player)this.f_96541_.f_91074_)) {
                return;
            }
            if (selectedTab.m_257962_() == CreativeModeTab.Type.INVENTORY) {
                if ($$0 == this.destroyItemSlot) {
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                } else if ($$3 == ClickType.THROW && $$0 != null && $$0.m_6657_()) {
                    ItemStack $$6 = $$0.m_6201_($$2 == 0 ? 1 : $$0.m_7993_().m_41741_());
                    ItemStack $$7 = $$0.m_7993_();
                    this.f_96541_.f_91074_.m_36176_($$6, true);
                    C2SPacketUtil.inventoryToServerPacket(-1, $$6, (byte)1);
                } else if ($$3 == ClickType.THROW && !((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_()) {
                    this.f_96541_.f_91074_.m_36176_(((ItemPickerMenu)this.f_97732_).m_142621_(), true);
                    C2SPacketUtil.inventoryToServerPacket(-1, ((ItemPickerMenu)this.f_97732_).m_142621_(), (byte)1);
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                } else {
                    this.f_96541_.f_91074_.f_36095_.m_150399_($$0 == null ? $$1 : ((SlotWrapper)$$0).target.f_40219_, $$2, $$3, (Player)this.f_96541_.f_91074_);
                    this.f_96541_.f_91074_.f_36095_.m_38946_();
                }
            } else if ($$3 != ClickType.QUICK_CRAFT && $$0.f_40218_ == CONTAINER) {
                ItemStack $$8 = ((ItemPickerMenu)this.f_97732_).m_142621_();
                ItemStack $$9 = $$0.m_7993_();
                if ($$3 == ClickType.SWAP) {
                    if (!$$9.m_41619_()) {
                        this.f_96541_.f_91074_.m_150109_().m_6836_($$2, $$9.m_255036_($$9.m_41741_()));
                        this.f_96541_.f_91074_.f_36095_.m_38946_();
                    }
                    return;
                }
                if ($$3 == ClickType.CLONE) {
                    BlockItem BI;
                    ItemStack $$10;
                    Item item;
                    if (((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_() && $$0.m_6657_() && (item = ($$10 = $$0.m_7993_()).m_41720_()) instanceof BlockItem && (BI = (BlockItem)item).m_40614_() instanceof FogBlock) {
                        ((ItemPickerMenu)this.f_97732_).m_142503_($$10.m_255036_($$10.m_41741_()));
                        if (this.f_96541_.f_91074_ != null) {
                            this.f_96541_.f_91074_.f_36095_.m_38946_();
                        }
                    }
                    return;
                }
                if ($$3 == ClickType.THROW) {
                    if (!$$9.m_41619_()) {
                        ItemStack $$11 = $$9.m_255036_($$2 == 0 ? 1 : $$9.m_41741_());
                        this.f_96541_.f_91074_.m_36176_($$11, true);
                        C2SPacketUtil.inventoryToServerPacket(-1, $$11, (byte)1);
                    }
                    return;
                }
                if (!$$8.m_41619_() && !$$9.m_41619_() && ItemStack.m_150942_((ItemStack)$$8, (ItemStack)$$9)) {
                    if ($$2 == 0) {
                        if (flag) {
                            $$8.m_41764_($$8.m_41741_());
                        } else if ($$8.m_41613_() < $$8.m_41741_()) {
                            $$8.m_41769_(1);
                        }
                    } else {
                        $$8.m_41774_(1);
                    }
                } else if (!$$9.m_41619_() && $$8.m_41619_()) {
                    int $$12 = flag ? $$9.m_41741_() : $$9.m_41613_();
                    ((ItemPickerMenu)this.f_97732_).m_142503_($$9.m_255036_($$12));
                } else if ($$2 == 0) {
                    this.f_96541_.f_91074_.m_36176_($$8, true);
                    C2SPacketUtil.inventoryToServerPacket(-1, $$8, (byte)1);
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                } else if (!((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_()) {
                    C2SPacketUtil.inventoryToServerPacket(-1, ((ItemPickerMenu)this.f_97732_).m_142621_().m_255036_(1), (byte)1);
                    ((ItemPickerMenu)this.f_97732_).m_142621_().m_41774_(1);
                }
            } else if (this.f_97732_ != null) {
                ItemStack $$13 = $$0 == null ? ItemStack.f_41583_ : ((ItemPickerMenu)this.f_97732_).m_38853_($$0.f_40219_).m_7993_();
                ((ItemPickerMenu)this.f_97732_).m_150399_($$0 == null ? $$1 : $$0.f_40219_, $$2, $$3, (Player)this.f_96541_.f_91074_);
                if (AbstractContainerMenu.m_38947_((int)$$2) == 2) {
                    for (int $$14 = 0; $$14 < 9; ++$$14) {
                        C2SPacketUtil.inventoryToServerPacket(36 + $$14, ((ItemPickerMenu)this.f_97732_).m_38853_(45 + $$14).m_7993_(), (byte)1);
                    }
                } else if ($$0 != null) {
                    ItemStack $$15 = ((ItemPickerMenu)this.f_97732_).m_38853_($$0.f_40219_).m_7993_();
                    C2SPacketUtil.inventoryToServerPacket($$0.f_40219_ - ((ItemPickerMenu)this.f_97732_).f_38839_.size() + 9 + 36, $$15, (byte)1);
                    int $$16 = 45 + $$2;
                    if ($$3 == ClickType.SWAP) {
                        C2SPacketUtil.inventoryToServerPacket($$16 - ((ItemPickerMenu)this.f_97732_).f_38839_.size() + 9 + 36, $$13, (byte)1);
                    } else if ($$3 == ClickType.THROW && !$$13.m_41619_()) {
                        ItemStack $$17 = $$13.m_255036_($$2 == 0 ? 1 : $$13.m_41741_());
                        this.f_96541_.f_91074_.m_36176_($$17, true);
                        C2SPacketUtil.inventoryToServerPacket(-1, $$17, (byte)1);
                    }
                    this.f_96541_.f_91074_.f_36095_.m_38946_();
                }
            }
        }
    }

    private boolean isCreativeSlot(@Nullable Slot $$0) {
        return $$0 != null && $$0.f_40218_ == CONTAINER;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 82, this.f_97736_ + 6, 80, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94194_(false);
        this.searchBox.m_94182_(false);
        this.m_7787_((GuiEventListener)this.searchBox);
        CreativeModeTab $$0 = selectedTab;
        selectedTab = ModItems.FOG_BLOCK_ITEMS;
        this.selectTab($$0);
        this.f_96541_.f_91074_.f_36095_.m_38943_((ContainerListener)this.listener);
        this.listener = new CreativeInventoryListener(this.f_96541_);
        this.f_96541_.f_91074_.f_36095_.m_38893_((ContainerListener)this.listener);
        int buttonWidth = 80;
        int buttonHeight = 20;
        int padding = 62;
        int spacing = 10;
        int totalWidth = 3 * buttonWidth + 2 * spacing;
        int startX = (this.f_96543_ - totalWidth) / 2;
        int y = this.f_96544_ - buttonHeight - padding;
        this.doneButton = Button.m_253074_((Component)Component.m_237115_((String)"config.roundabout.major.close"), btn -> this.forceClose()).m_253046_(buttonWidth, buttonHeight).m_252794_(startX + buttonWidth + spacing, y).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
    }

    public void forceClose() {
        this.m_7379_();
        this.f_96541_.m_91152_(null);
    }

    public void m_6574_(Minecraft $$0, int $$1, int $$2) {
        int $$3 = ((ItemPickerMenu)this.f_97732_).getRowIndexForScroll(this.scrollOffs);
        String $$4 = this.searchBox.m_94155_();
        this.m_6575_($$0, $$1, $$2);
        this.searchBox.m_94144_($$4);
        if (!this.searchBox.m_94155_().isEmpty()) {
            this.refreshSearchResults();
        }
        this.scrollOffs = ((ItemPickerMenu)this.f_97732_).getScrollForRowIndex($$3);
        ((ItemPickerMenu)this.f_97732_).scrollTo(this.scrollOffs);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_150109_() != null) {
            this.f_96541_.f_91074_.f_36095_.m_38943_((ContainerListener)this.listener);
        }
    }

    public boolean m_5534_(char $$0, int $$1) {
        if (this.ignoreTextInput) {
            return false;
        }
        String $$2 = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_($$0, $$1)) {
            if (!Objects.equals($$2, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int $$0, int $$1, int $$2) {
        this.ignoreTextInput = false;
        boolean $$3 = !this.isCreativeSlot(this.f_97734_) || this.f_97734_.m_6657_();
        boolean $$4 = InputConstants.m_84827_((int)$$0, (int)$$1).m_84876_().isPresent();
        if ($$3 && $$4 && this.m_97805_($$0, $$1)) {
            this.ignoreTextInput = true;
            return true;
        }
        String $$5 = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_($$0, $$1, $$2)) {
            if (!Objects.equals($$5, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && $$0 != 256 ? true : super.m_7933_($$0, $$1, $$2);
    }

    public boolean m_7920_(int $$0, int $$1, int $$2) {
        this.ignoreTextInput = false;
        return super.m_7920_($$0, $$1, $$2);
    }

    private void refreshSearchResults() {
        ((ItemPickerMenu)this.f_97732_).items.clear();
        this.visibleTags.clear();
        String $$0 = this.searchBox.m_94155_();
        if ($$0.isEmpty()) {
            ((ItemPickerMenu)this.f_97732_).items.addAll(selectedTab.m_260957_());
        } else {
            SearchTree $$1;
            if ($$0.startsWith("#")) {
                $$0 = $$0.substring(1);
                $$1 = this.f_96541_.m_231372_(SearchRegistry.f_119942_);
                this.updateVisibleTags($$0);
            } else {
                $$1 = this.f_96541_.m_231372_(SearchRegistry.f_119941_);
            }
            List sift = $$1.m_6293_($$0.toLowerCase(Locale.ROOT));
            ArrayList theStacks = Lists.newArrayList();
            for (ItemStack stack : sift) {
                if (stack.m_41619_() || !(stack.m_41720_() instanceof FogBlockItem)) continue;
                theStacks.add(stack);
            }
            ((ItemPickerMenu)this.f_97732_).items.addAll((Collection)theStacks);
        }
        this.scrollOffs = 0.0f;
        ((ItemPickerMenu)this.f_97732_).scrollTo(0.0f);
    }

    private void updateVisibleTags(String $$0) {
        Predicate<ResourceLocation> $$2;
        int $$1 = $$0.indexOf(58);
        if ($$1 == -1) {
            $$2 = $$1x -> $$1x.m_135815_().contains($$0);
        } else {
            String $$3 = $$0.substring(0, $$1).trim();
            String $$4 = $$0.substring($$1 + 1).trim();
            $$2 = $$2x -> $$2x.m_135827_().contains($$3) && $$2x.m_135815_().contains($$4);
        }
        BuiltInRegistries.f_257033_.m_203613_().filter($$1x -> $$2.test($$1x.f_203868_())).forEach(this.visibleTags::add);
    }

    protected void m_280003_(GuiGraphics $$0, int $$1, int $$2) {
        if (selectedTab.m_40789_()) {
            $$0.m_280614_(this.f_96547_, selectedTab.m_40786_(), 8, 6, 0x404040, false);
        }
    }

    private boolean isHovering2(Slot $$0, double $$1, double $$2) {
        return this.m_6774_($$0.f_40220_, $$0.f_40221_, 16, 16, $$1, $$2);
    }

    @Nullable
    private Slot findSlot2(double $$0, double $$1) {
        for (int $$2 = 0; $$2 < ((ItemPickerMenu)this.f_97732_).f_38839_.size(); ++$$2) {
            Slot $$3 = (Slot)((ItemPickerMenu)this.f_97732_).f_38839_.get($$2);
            if (!this.isHovering2($$3, $$0, $$1) || !$$3.m_6659_()) continue;
            return $$3;
        }
        return null;
    }

    public boolean m_6375_(double $$0, double $$1, int $$2) {
        boolean $$3;
        if ($$2 == 0) {
            double $$32 = $$0 - (double)this.f_97735_;
            double $$4 = $$1 - (double)this.f_97736_;
            if (selectedTab.m_257962_() != CreativeModeTab.Type.INVENTORY && this.insideScrollbar($$0, $$1)) {
                this.scrolling = this.canScroll();
                return true;
            }
        }
        boolean bl = $$3 = this.f_96541_.f_91066_.f_92097_.m_90830_($$2) && !this.f_96541_.f_91072_.m_105290_();
        if ($$3) {
            Slot $$4 = this.findSlot2($$0, $$1);
            int $$6 = this.f_97735_;
            int $$7 = this.f_97736_;
            boolean $$8 = this.m_7467_($$0, $$1, $$6, $$7, $$2);
            int $$9 = -1;
            if ($$4 != null) {
                $$9 = $$4.f_40219_;
            }
            if ($$8) {
                $$9 = -999;
            }
            this.m_6597_($$4, $$9, $$2, ClickType.CLONE);
        }
        return super.m_6375_($$0, $$1, $$2);
    }

    public boolean m_6348_(double $$0, double $$1, int $$2) {
        if ($$2 == 0) {
            double $$3 = $$0 - (double)this.f_97735_;
            double $$4 = $$1 - (double)this.f_97736_;
            this.scrolling = false;
        }
        return super.m_6348_($$0, $$1, $$2);
    }

    protected boolean m_97805_(int $$0, int $$1) {
        return false;
    }

    public void m_7379_() {
        if (!((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_()) {
            this.f_96541_.f_91074_.m_36176_(((ItemPickerMenu)this.f_97732_).m_142621_(), true);
            C2SPacketUtil.inventoryToServerPacket(-1, ((ItemPickerMenu)this.f_97732_).m_142621_(), (byte)1);
            ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
        }
        super.m_7379_();
    }

    private boolean canScroll() {
        return selectedTab.m_40791_() && ((ItemPickerMenu)this.f_97732_).canScroll();
    }

    private void selectTab(CreativeModeTab $$0) {
        CreativeModeTab $$1 = selectedTab;
        selectedTab = $$0;
        this.f_97737_.clear();
        ((ItemPickerMenu)this.f_97732_).items.clear();
        this.m_238391_();
        if (selectedTab.m_257962_() == CreativeModeTab.Type.INVENTORY) {
            InventoryMenu $$9 = this.f_96541_.f_91074_.f_36095_;
            if (this.originalSlots == null) {
                this.originalSlots = ImmutableList.copyOf((Collection)((ItemPickerMenu)this.f_97732_).f_38839_);
            }
            ((ItemPickerMenu)this.f_97732_).f_38839_.clear();
            for (int $$10 = 0; $$10 < $$9.f_38839_.size(); ++$$10) {
                int $$15;
                int $$14;
                if ($$10 >= 5 && $$10 < 9) {
                    int $$11 = $$10 - 5;
                    int $$12 = $$11 / 2;
                    int $$13 = $$11 % 2;
                    $$14 = 54 + $$12 * 54;
                    $$15 = 6 + $$13 * 27;
                } else if ($$10 >= 0 && $$10 < 5) {
                    $$14 = -2000;
                    $$15 = -2000;
                } else if ($$10 == 45) {
                    $$14 = 35;
                    $$15 = 20;
                } else {
                    int $$20 = $$10 - 9;
                    int $$21 = $$20 % 9;
                    int $$22 = $$20 / 9;
                    $$14 = 9 + $$21 * 18;
                    $$15 = $$10 >= 36 ? 112 : 54 + $$22 * 18;
                }
                SlotWrapper $$26 = new SlotWrapper((Slot)$$9.f_38839_.get($$10), $$10, $$14, $$15);
                ((ItemPickerMenu)this.f_97732_).f_38839_.add((Object)$$26);
            }
            this.destroyItemSlot = new Slot((Container)CONTAINER, 0, 173, 112);
            ((ItemPickerMenu)this.f_97732_).f_38839_.add((Object)this.destroyItemSlot);
        }
        this.searchBox.m_94194_(true);
        this.searchBox.m_94190_(false);
        this.searchBox.m_93692_(true);
        if ($$1 != $$0) {
            this.searchBox.m_94144_("");
        }
        this.refreshSearchResults();
        this.scrollOffs = 0.0f;
        ((ItemPickerMenu)this.f_97732_).scrollTo(0.0f);
    }

    public boolean m_6050_(double $$0, double $$1, double $$2) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = ((ItemPickerMenu)this.f_97732_).subtractInputFromScroll(this.scrollOffs, $$2);
        ((ItemPickerMenu)this.f_97732_).scrollTo(this.scrollOffs);
        return true;
    }

    protected boolean m_7467_(double $$0, double $$1, int $$2, int $$3, int $$4) {
        boolean $$5 = $$0 < (double)$$2 || $$1 < (double)$$3 || $$0 >= (double)($$2 + this.f_97726_) || $$1 >= (double)($$3 + this.f_97727_);
        this.hasClickedOutside = $$5 && !this.checkTabClicked(selectedTab, $$0, $$1);
        return this.hasClickedOutside;
    }

    protected boolean insideScrollbar(double $$0, double $$1) {
        int $$2 = this.f_97735_;
        int $$3 = this.f_97736_;
        int $$4 = $$2 + 175;
        int $$5 = $$3 + 18;
        int $$6 = $$4 + 14;
        int $$7 = $$5 + 112;
        return $$0 >= (double)$$4 && $$1 >= (double)$$5 && $$0 < (double)$$6 && $$1 < (double)$$7;
    }

    public boolean m_7979_(double $$0, double $$1, int $$2, double $$3, double $$4) {
        if (this.scrolling) {
            int $$5 = this.f_97736_ + 18;
            int $$6 = $$5 + 112;
            this.scrollOffs = ((float)$$1 - (float)$$5 - 7.5f) / ((float)($$6 - $$5) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            ((ItemPickerMenu)this.f_97732_).scrollTo(this.scrollOffs);
            return true;
        }
        return super.m_7979_($$0, $$1, $$2, $$3, $$4);
    }

    public void m_88315_(GuiGraphics $$0, int $$1, int $$2, float $$3) {
        this.m_280273_($$0);
        super.m_88315_($$0, $$1, $$2, $$3);
        if (this.destroyItemSlot != null && selectedTab.m_257962_() == CreativeModeTab.Type.INVENTORY && this.m_6774_(this.destroyItemSlot.f_40220_, this.destroyItemSlot.f_40221_, 16, 16, $$1, $$2)) {
            $$0.m_280557_(this.f_96547_, TRASH_SLOT_TOOLTIP, $$1, $$2);
        }
        this.m_280072_($$0, $$1, $$2);
    }

    public List<Component> m_280553_(ItemStack $$0) {
        boolean $$1 = this.f_97734_ != null && this.f_97734_ instanceof CustomCreativeSlot;
        boolean $$2 = selectedTab.m_257962_() == CreativeModeTab.Type.CATEGORY;
        boolean $$3 = true;
        TooltipFlag.Default $$4 = this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        TooltipFlag.Default $$5 = $$1 ? $$4.m_257777_() : $$4;
        List $$6 = $$0.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)$$5);
        if ($$2 && $$1) {
            return $$6;
        }
        ArrayList $$7 = Lists.newArrayList((Iterable)$$6);
        if ($$3 && $$1) {
            this.visibleTags.forEach($$2x -> {
                if ($$0.m_204117_($$2x)) {
                    $$7.add(1, Component.m_237113_((String)("#" + String.valueOf($$2x.f_203868_()))).m_130940_(ChatFormatting.DARK_PURPLE));
                }
            });
        }
        boolean $$8 = true;
        return $$7;
    }

    protected void m_7286_(GuiGraphics drawContext, float partialTick, int mouseX, int mouseY) {
        drawContext.m_280218_(new ResourceLocation("roundabout", "textures/gui/tab_inventory.png"), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.searchBox.m_88315_(drawContext, mouseX, mouseY, partialTick);
        int $$5 = this.f_97735_ + 175;
        int $$6 = this.f_97736_ + 18;
        int $$7 = $$6 + 112;
        if (selectedTab.m_40791_()) {
            drawContext.m_280218_(CREATIVE_TABS_LOCATION, $$5, $$6 + (int)((float)($$7 - $$6 - 17) * this.scrollOffs), 232 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        }
    }

    private int getTabX(CreativeModeTab $$0) {
        int $$1 = $$0.m_257903_();
        int $$2 = 27;
        int $$3 = 27 * $$1;
        if ($$0.m_6563_()) {
            $$3 = this.f_97726_ - 27 * (7 - $$1) + 1;
        }
        return $$3;
    }

    private int getTabY(CreativeModeTab $$0) {
        int $$1 = 0;
        $$1 = $$0.m_258064_() == CreativeModeTab.Row.TOP ? ($$1 -= 32) : ($$1 += this.f_97727_);
        return $$1;
    }

    protected boolean checkTabClicked(CreativeModeTab $$0, double $$1, double $$2) {
        int $$3 = this.getTabX($$0);
        int $$4 = this.getTabY($$0);
        return $$1 >= (double)$$3 && $$1 <= (double)($$3 + 26) && $$2 >= (double)$$4 && $$2 <= (double)($$4 + 32);
    }

    protected boolean checkTabHovering(GuiGraphics $$0, CreativeModeTab $$1, int $$2, int $$3) {
        int $$5;
        int $$4 = this.getTabX($$1);
        if (this.m_6774_($$4 + 3, ($$5 = this.getTabY($$1)) + 3, 21, 27, $$2, $$3)) {
            $$0.m_280557_(this.f_96547_, $$1.m_40786_(), $$2, $$3);
            return true;
        }
        return false;
    }

    protected void renderTabButton(GuiGraphics $$0, CreativeModeTab $$1) {
        boolean $$2 = $$1 == selectedTab;
        boolean $$3 = $$1.m_258064_() == CreativeModeTab.Row.TOP;
        int $$4 = $$1.m_257903_();
        int $$5 = $$4 * 26;
        int $$6 = 0;
        int $$7 = this.f_97735_ + this.getTabX($$1);
        int $$8 = this.f_97736_;
        int $$9 = 32;
        if ($$2) {
            $$6 += 32;
        }
        if ($$3) {
            $$8 -= 28;
        } else {
            $$6 += 64;
            $$8 += this.f_97727_ - 4;
        }
        $$0.m_280218_(CREATIVE_TABS_LOCATION, $$7, $$8, $$5, $$6, 26, 32);
        ClientUtil.pushPoseAndCooperate($$0.m_280168_(), 50);
        $$0.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int n = $$3 ? 1 : -1;
        ItemStack $$10 = $$1.m_40787_();
        $$0.m_280480_($$10, $$7 += 5, $$8 += 8 + n);
        $$0.m_280370_(this.f_96547_, $$10, $$7, $$8);
        ClientUtil.popPoseAndCooperate($$0.m_280168_(), 50);
    }

    public boolean isInventoryOpen() {
        return selectedTab.m_257962_() == CreativeModeTab.Type.INVENTORY;
    }

    public static class ItemPickerMenu
    extends AbstractContainerMenu {
        public final NonNullList<ItemStack> items = NonNullList.m_122779_();
        private final AbstractContainerMenu inventoryMenu;

        public ItemPickerMenu(Player $$0) {
            super(null, 0);
            this.inventoryMenu = $$0.f_36095_;
            Inventory $$1 = $$0.m_150109_();
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                for (int $$3 = 0; $$3 < 9; ++$$3) {
                    this.m_38897_(new CustomCreativeSlot((Container)CONTAINER, $$2 * 9 + $$3, 9 + $$3 * 18, 18 + $$2 * 18));
                }
            }
            this.scrollTo(0.0f);
        }

        public void m_150399_(int $$0, int $$1, ClickType $$2, Player $$3) {
            if ($$2 == ClickType.CLONE && !$$3.m_150110_().f_35937_ && this.m_142621_().m_41619_() && $$0 >= 0) {
                BlockItem BI;
                ItemStack $$33;
                Item item;
                Slot $$32 = (Slot)this.f_38839_.get($$0);
                if ($$32.m_6657_() && (item = ($$33 = $$32.m_7993_()).m_41720_()) instanceof BlockItem && (BI = (BlockItem)item).m_40614_() instanceof FogBlock) {
                    this.m_142503_($$33.m_255036_($$33.m_41741_()));
                }
                this.inventoryMenu.m_38946_();
            } else {
                super.m_150399_($$0, $$1, $$2, $$3);
            }
        }

        public boolean m_6875_(Player $$0) {
            return true;
        }

        protected int calculateRowCount() {
            return Mth.m_184652_((int)this.items.size(), (int)9) - 5;
        }

        protected int getRowIndexForScroll(float $$0) {
            return Math.max((int)((double)($$0 * (float)this.calculateRowCount()) + 0.5), 0);
        }

        protected float getScrollForRowIndex(int $$0) {
            return Mth.m_14036_((float)((float)$$0 / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
        }

        protected float subtractInputFromScroll(float $$0, double $$1) {
            return Mth.m_14036_((float)($$0 - (float)($$1 / (double)this.calculateRowCount())), (float)0.0f, (float)1.0f);
        }

        public void scrollTo(float $$0) {
            int $$1 = this.getRowIndexForScroll($$0);
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                for (int $$3 = 0; $$3 < 9; ++$$3) {
                    int $$4 = $$3 + ($$2 + $$1) * 9;
                    if ($$4 >= 0 && $$4 < this.items.size()) {
                        CONTAINER.m_6836_($$3 + $$2 * 9, (ItemStack)this.items.get($$4));
                        continue;
                    }
                    CONTAINER.m_6836_($$3 + $$2 * 9, ItemStack.f_41583_);
                }
            }
        }

        public boolean canScroll() {
            return this.items.size() > 45;
        }

        public ItemStack m_7648_(Player $$0, int $$1) {
            Slot $$2;
            if ($$1 >= this.f_38839_.size() - 9 && $$1 < this.f_38839_.size() && ($$2 = (Slot)this.f_38839_.get($$1)) != null && $$2.m_6657_()) {
                $$2.m_269060_(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        }

        public boolean m_5882_(ItemStack $$0, Slot $$1) {
            return $$1.f_40218_ != CONTAINER;
        }

        public boolean m_5622_(Slot $$0) {
            return $$0.f_40218_ != CONTAINER;
        }

        public ItemStack m_142621_() {
            return this.inventoryMenu.m_142621_();
        }

        public void m_142503_(ItemStack $$0) {
            this.inventoryMenu.m_142503_($$0);
        }
    }

    static class SlotWrapper
    extends Slot {
        final Slot target;

        public SlotWrapper(Slot $$0, int $$1, int $$2, int $$3) {
            super($$0.f_40218_, $$1, $$2, $$3);
            this.target = $$0;
        }

        public void m_142406_(Player $$0, ItemStack $$1) {
            this.target.m_142406_($$0, $$1);
        }

        public boolean m_5857_(ItemStack $$0) {
            return this.target.m_5857_($$0);
        }

        public ItemStack m_7993_() {
            return this.target.m_7993_();
        }

        public boolean m_6657_() {
            return this.target.m_6657_();
        }

        public void m_269060_(ItemStack $$0) {
            this.target.m_269060_($$0);
        }

        public void m_5852_(ItemStack $$0) {
            this.target.m_5852_($$0);
        }

        public void m_6654_() {
            this.target.m_6654_();
        }

        public int m_6641_() {
            return this.target.m_6641_();
        }

        public int m_5866_(ItemStack $$0) {
            return this.target.m_5866_($$0);
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return this.target.m_7543_();
        }

        public ItemStack m_6201_(int $$0) {
            return this.target.m_6201_($$0);
        }

        public boolean m_6659_() {
            return this.target.m_6659_();
        }

        public boolean m_8010_(Player $$0) {
            return this.target.m_8010_($$0);
        }
    }

    static class CustomCreativeSlot
    extends Slot {
        public CustomCreativeSlot(Container $$0, int $$1, int $$2, int $$3) {
            super($$0, $$1, $$2, $$3);
        }

        public boolean m_8010_(Player $$0) {
            ItemStack $$1 = this.m_7993_();
            return super.m_8010_($$0) && !$$1.m_41619_() ? $$1.m_246617_($$0.m_9236_().m_246046_()) && $$1.m_41737_("CustomCreativeLock") == null : $$1.m_41619_();
        }
    }
}

