/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.stand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.client.models.layers.ModEntityRendererClient;
import net.hydra.jojomod.client.models.stand.WalkingHeartModel;
import net.hydra.jojomod.client.models.stand.renderers.StandRenderer;
import net.hydra.jojomod.client.models.stand.renderers.WalkingHeartEyeLayer;
import net.hydra.jojomod.entity.stand.WalkingHeartEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WalkingHeartRenderer
extends StandRenderer<WalkingHeartEntity> {
    private static final ResourceLocation MANGA = new ResourceLocation("roundabout", "textures/stand/walking_heart/base.png");
    private static final ResourceLocation MODEL = new ResourceLocation("roundabout", "textures/stand/walking_heart/model.png");
    private static final ResourceLocation GOTHIC = new ResourceLocation("roundabout", "textures/stand/walking_heart/gothic.png");
    private static final ResourceLocation PALE = new ResourceLocation("roundabout", "textures/stand/walking_heart/pale.png");
    private static final ResourceLocation VERDANT = new ResourceLocation("roundabout", "textures/stand/walking_heart/verdant.png");
    private static final ResourceLocation SPIDER = new ResourceLocation("roundabout", "textures/stand/walking_heart/spider.png");
    private static final ResourceLocation VALENTINE = new ResourceLocation("roundabout", "textures/stand/walking_heart/valentine.png");
    private static final ResourceLocation PURPLE = new ResourceLocation("roundabout", "textures/stand/walking_heart/purple.png");

    public WalkingHeartRenderer(EntityRendererProvider.Context context) {
        super(context, new WalkingHeartModel(context.m_174023_(ModEntityRendererClient.WALKING_HEART_LAYER)), 0.0f);
        this.m_115326_((RenderLayer)new WalkingHeartEyeLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(WalkingHeartEntity entity) {
        return switch (entity.getSkin()) {
            case 1 -> MANGA;
            case 6 -> VALENTINE;
            case 4 -> VERDANT;
            case 2 -> MODEL;
            case 7 -> GOTHIC;
            case 5 -> PALE;
            case 3 -> PURPLE;
            case 8 -> SPIDER;
            default -> MANGA;
        };
    }

    @Override
    public void render(WalkingHeartEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.m_6162_()) {
            matrixStack.m_85841_(0.5f * factor, 0.5f * factor, 0.5f * factor);
        } else {
            matrixStack.m_85841_(0.87f * factor, 0.87f * factor, 0.87f * factor);
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    @Nullable
    protected RenderType getRenderType(WalkingHeartEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.getRenderType(entity, showBody, true, showOutline);
    }
}

