/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.visages.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.hydra.jojomod.client.FacelessLayer;
import net.hydra.jojomod.client.models.layers.HeyYaLayer;
import net.hydra.jojomod.client.models.layers.MandomLayer;
import net.hydra.jojomod.client.models.layers.ShootingArmLayer;
import net.hydra.jojomod.client.models.layers.StoneLayer;
import net.hydra.jojomod.client.models.layers.visages.VisagePartLayer;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.item.ModificationMaskItem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Unique;

public class VisageBasisRenderer
extends LivingEntityRenderer<JojoNPC, PlayerModel<JojoNPC>> {
    @Unique
    protected PlayerModel otherModel;
    @Unique
    protected PlayerModel mainModel;

    public void changeTheModel(ItemStack visage) {
        Item item;
        if (visage != null && !visage.m_41619_() && (item = visage.m_41720_()) instanceof MaskItem) {
            MaskItem MI = (MaskItem)item;
            if (MI.visageData.isCharacterVisage() && MI.visageData.isSlim()) {
                this.f_115290_ = this.otherModel;
                return;
            }
        }
        this.f_115290_ = this.mainModel;
    }

    public VisageBasisRenderer(EntityRendererProvider.Context $$0) {
        super($$0, (EntityModel)new PlayerModel($$0.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, $$0.m_234598_()));
        this.m_115326_((RenderLayer)new ArrowLayer($$0, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, $$0.m_174027_(), $$0.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, $$0.m_174027_()));
        this.m_115326_((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, $$0.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        this.m_115326_(new StoneLayer($$0, this));
        this.m_115326_(new FacelessLayer($$0, this));
        this.m_115326_(new ShootingArmLayer<JojoNPC, PlayerModel<JojoNPC>>($$0, this));
        this.m_115326_(new HeyYaLayer<JojoNPC, PlayerModel<JojoNPC>>($$0, this));
        this.m_115326_(new MandomLayer<JojoNPC, PlayerModel<JojoNPC>>($$0, this));
        this.m_115326_(new VisagePartLayer<JojoNPC, PlayerModel<JojoNPC>>($$0, this));
        this.otherModel = new PlayerModel($$0.m_174023_(ModelLayers.f_171166_), true);
        this.mainModel = (PlayerModel)this.f_115290_;
    }

    public void render(JojoNPC $$0, float $$1, float $$2, PoseStack $$3, MultiBufferSource $$4, int $$5) {
        this.changeTheModel($$0.getBasis());
        this.setModelProperties($$0);
        super.m_7392_((LivingEntity)$$0, $$1, $$2, $$3, $$4, $$5);
    }

    private void setModelProperties(JojoNPC $$0) {
        PlayerModel $$1 = (PlayerModel)this.m_7200_();
        if ($$0.m_5833_()) {
            $$1.m_8009_(false);
            $$1.f_102808_.f_104207_ = true;
            $$1.f_102809_.f_104207_ = true;
        } else {
            $$1.m_8009_(true);
            $$1.f_102817_ = $$0.m_6047_();
            HumanoidModel.ArmPose $$2 = VisageBasisRenderer.getArmPose((LivingEntity)$$0, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose $$3 = VisageBasisRenderer.getArmPose((LivingEntity)$$0, InteractionHand.OFF_HAND);
            if ($$2.m_102897_()) {
                HumanoidModel.ArmPose armPose = $$3 = $$0.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if ($$0.m_5737_() == HumanoidArm.RIGHT) {
                $$1.f_102816_ = $$2;
                $$1.f_102815_ = $$3;
            } else {
                $$1.f_102816_ = $$3;
                $$1.f_102815_ = $$2;
            }
        }
    }

    protected void scale(JojoNPC $$0, PoseStack $$1, float $$2) {
        Item item;
        ItemStack visage = $$0.getBasis();
        if (visage != null && !visage.m_41619_() && (item = visage.m_41720_()) instanceof MaskItem) {
            MaskItem MI = (MaskItem)item;
            if (MI instanceof ModificationMaskItem) {
                ModificationMaskItem MD = (ModificationMaskItem)MI;
                int height = visage.m_41698_("modifications").m_128451_("height");
                int width = visage.m_41698_("modifications").m_128451_("width");
                $$1.m_85841_(0.798f + (float)width * 0.001f, 0.7f + (float)height * 0.001f, 0.798f + (float)width * 0.001f);
            } else {
                Vector3f scale = MI.visageData.scale();
                $$1.m_85841_(scale.x, scale.y, scale.z);
            }
            return;
        }
        float $$3 = 0.9375f;
        $$1.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    private static HumanoidModel.ArmPose getArmPose(LivingEntity $$0, InteractionHand $$1) {
        ItemStack $$2 = $$0.m_21120_($$1);
        if ($$2.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if ($$0.m_7655_() == $$1 && $$0.m_21212_() > 0) {
            UseAnim $$3 = $$2.m_41780_();
            if ($$3 == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if ($$3 == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if ($$3 == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if ($$3 == UseAnim.CROSSBOW && $$1 == $$0.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if ($$3 == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if ($$3 == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if ($$3 == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!$$0.f_20911_ && $$2.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)$$2)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(JojoNPC var1) {
        Item item;
        ItemStack visage = var1.getBasis();
        if (visage != null && !visage.m_41619_() && (item = visage.m_41720_()) instanceof MaskItem) {
            MaskItem MI = (MaskItem)item;
            if (MI.visageData.isCharacterVisage()) {
                return new ResourceLocation("roundabout", "textures/entity/visage/player_skins/" + MI.visageData.getSkinPath() + ".png");
            }
        }
        return null;
    }

    protected boolean shouldShowName(JojoNPC $$0) {
        return super.m_6512_((LivingEntity)$$0) && ($$0.m_6052_() || $$0.m_8077_() && $$0 == this.f_114476_.f_114359_);
    }

    protected void setupRotations(JojoNPC $$0, PoseStack $$1, float $$2, float $$3, float $$4) {
        float $$5 = $$0.m_20998_($$4);
        if ($$0.m_21255_()) {
            super.m_7523_((LivingEntity)$$0, $$1, $$2, $$3, $$4);
            float $$6 = (float)$$0.m_21256_() + $$4;
            float $$7 = Mth.m_14036_((float)($$6 * $$6 / 100.0f), (float)0.0f, (float)1.0f);
            if (!$$0.m_21209_()) {
                $$1.m_252781_(Axis.f_252529_.m_252977_($$7 * (-90.0f - $$0.m_146909_())));
            }
            Vec3 $$8 = $$0.m_20252_($$4);
            Vec3 $$9 = $$0.getDeltaMovementLerped($$4);
            double $$10 = $$9.m_165925_();
            double $$11 = $$8.m_165925_();
            if ($$10 > 0.0 && $$11 > 0.0) {
                double $$12 = ($$9.f_82479_ * $$8.f_82479_ + $$9.f_82481_ * $$8.f_82481_) / Math.sqrt($$10 * $$11);
                double $$13 = $$9.f_82479_ * $$8.f_82481_ - $$9.f_82481_ * $$8.f_82479_;
                $$1.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum($$13) * Math.acos($$12))));
            }
        } else if ($$5 > 0.0f) {
            super.m_7523_((LivingEntity)$$0, $$1, $$2, $$3, $$4);
            float $$14 = $$0.m_20069_() ? -90.0f - $$0.m_146909_() : -90.0f;
            float $$15 = Mth.m_14179_((float)$$5, (float)0.0f, (float)$$14);
            $$1.m_252781_(Axis.f_252529_.m_252977_($$15));
            if ($$0.m_6067_()) {
                $$1.m_252880_(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)$$0, $$1, $$2, $$3, $$4);
        }
    }
}

