/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.UUID;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.UnburnableProjectile;
import net.hydra.jojomod.entity.projectile.CrossfireHurricaneEntity;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersMagiciansRed;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class ConcealedFlameObjectEntity
extends ThrowableItemProjectile
implements UnburnableProjectile {
    private static final EntityDataAccessor<Integer> USER_ID = SynchedEntityData.m_135353_(ConcealedFlameObjectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity standUser;
    public UUID standUserUUID;
    public boolean fireStormCreated = false;
    public int inWaterTicks = 0;
    Direction tempDirection = Direction.UP;
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(ConcealedFlameObjectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    private void initDataTrackerRoundabout(CallbackInfo ci) {
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public ConcealedFlameObjectEntity(EntityType<? extends ThrowableItemProjectile> $$0, Level $$1) {
        super($$0, $$1);
    }

    public ConcealedFlameObjectEntity(LivingEntity living, Level $$1) {
        super(ModEntities.CONCEALED_FLAME_OBJECT, living, $$1);
    }

    public LivingEntity getUser() {
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            return LE;
        }
        return null;
    }

    public int getUserID() {
        return (Integer)this.m_20088_().m_135370_(USER_ID);
    }

    public ConcealedFlameObjectEntity(LivingEntity living, Level $$1, ItemStack itemStack) {
        super(ModEntities.CONCEALED_FLAME_OBJECT, living, $$1);
        this.setUser(living);
        this.m_37446_(itemStack);
    }

    public void setUser(LivingEntity User) {
        this.standUser = User;
        this.m_20088_().m_135381_(USER_ID, (Object)User.m_19879_());
        if (!this.m_9236_().m_5776_()) {
            this.standUserUUID = User.m_20148_();
        }
    }

    public void shootFromRotationDeltaAgnostic(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        Direction gravityDirection = GravityAPI.getGravityDirection($$0);
        if (gravityDirection != Direction.DOWN) {
            Vec2 vecMagic = RotationUtil.rotPlayerToWorld($$0.m_146908_(), $$0.m_146909_(), gravityDirection);
            $$1 = vecMagic.f_82471_;
            $$2 = vecMagic.f_82470_;
        }
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.m_6686_($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
    }

    public ConcealedFlameObjectEntity(Level world, double p_36862_, double p_36863_, double p_36864_, ItemStack itemStack) {
        super(ModEntities.CONCEALED_FLAME_OBJECT, p_36862_, p_36863_, p_36864_, world);
        this.m_37446_(itemStack);
    }

    public boolean isEffectivelyInWater() {
        return this.f_19798_;
    }

    public void tickWater() {
        ++this.inWaterTicks;
        if (this.inWaterTicks > 40) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        LivingEntity LE;
        StandPowers standPowers;
        boolean client = this.m_9236_().m_5776_();
        if (!client) {
            if (this.isEffectivelyInWater()) {
                this.tickWater();
            }
            if (this.getUser() != null) {
                if (MainUtil.cheapDistanceTo2(this.m_20185_(), this.m_20189_(), this.standUser.m_20185_(), this.standUser.m_20189_()) > 80.0 || !this.getUser().m_6084_() || this.getUser().m_213877_()) {
                    this.m_146870_();
                }
            } else {
                this.m_146870_();
            }
        }
        LivingEntity $$0 = this.getUser();
        Vec3 delta = this.m_20184_();
        super.m_8119_();
        this.m_20256_(delta);
        if (!client && this.f_19797_ % 2 == 0 && $$0 instanceof LivingEntity && (standPowers = ((StandUser)(LE = $$0)).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            Vec3 $$2 = this.m_20184_();
            double $$3 = this.m_20185_() + $$2.f_82479_;
            double $$4 = this.m_20186_() + $$2.f_82480_;
            double $$5 = this.m_20189_() + $$2.f_82481_;
            this.m_9236_().m_7106_((ParticleOptions)PMR.getFlameParticle(), $$3, $$4 + 0.5, $$5, 0.0, 0.0, 0.0);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), $$3, $$4 + 0.5, $$5, 0, 0.0, 0.0, 0.0, 0.15);
        }
    }

    public void m_7380_(CompoundTag $$0) {
        CompoundTag compoundtag = new CompoundTag();
        $$0.m_128365_("roundabout.HeldItem", (Tag)this.m_7846_().m_41739_(compoundtag));
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        CompoundTag compoundtag = $$0.m_128469_("roundabout.HeldItem");
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
        this.m_37446_(itemstack);
        super.m_7378_($$0);
    }

    protected void m_8097_() {
        if (!this.f_19804_.m_285897_(USER_ID)) {
            super.m_8097_();
            this.f_19804_.m_135372_(SIZE, (Object)0);
            this.f_19804_.m_135372_(USER_ID, (Object)-1);
        }
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    public boolean m_6087_() {
        return true;
    }

    protected void m_8060_(BlockHitResult $$0) {
        super.m_8060_($$0);
        if (!this.m_9236_().f_46443_) {
            if (!this.m_7846_().m_41619_()) {
                BlockPos pos = $$0.m_82425_().m_121945_($$0.m_82434_());
                this.dropItem(pos);
            }
            this.m_146870_();
        }
    }

    public void dropItem(BlockPos pos) {
        ItemEntity $$4 = new ItemEntity(this.m_9236_(), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.25f), (double)((float)pos.m_123343_() + 0.5f), this.m_7846_());
        $$4.m_32010_(40);
        $$4.m_32052_(this.m_20148_());
        $$4.m_20334_(Math.random() * (double)0.1f - (double)0.05f, (double)0.2f, Math.random() * (double)0.18f - (double)0.05f);
        this.m_9236_().m_7967_((Entity)$$4);
    }

    public void blockBreakParticles(Block block, Vec3 pos) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100, 0.0, 0.0, 0.0, 0.5);
        }
    }

    public void setSize(int idd) {
        this.m_20088_().m_135381_(SIZE, (Object)idd);
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(SIZE);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        StandPowers standPowers;
        LivingEntity user = this.getUser();
        if (source.m_7639_() != null && user != null && (standPowers = ((StandUser)this.getUser()).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            if (source.m_7639_().m_7306_((Entity)this.getUser()) || source.m_7639_().m_20270_((Entity)this) > 7.0f && source.m_269533_(DamageTypeTags.f_268524_)) {
                this.burst(PMR);
                this.m_146870_();
            } else {
                this.burst(PMR);
                PMR.addEXP(4);
                CrossfireHurricaneEntity.blastEntity(source.m_7639_(), (Entity)this, this.getSize(), user, true, PMR, this.fireStormCreated);
                this.m_146870_();
            }
        }
        return true;
    }

    public void burst(PowersMagiciansRed PMR) {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.CROSSFIRE_EXPLODE_EVENT, SoundSource.PLAYERS, 2.0f, 1.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 200, 0.01, 0.01, 0.01, 0.1);
        }
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity $$1 = $$0.m_82443_();
        if ($$1 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)$$1;
        }
        if (!this.m_9236_().f_46443_) {
            Entity $$4 = this.m_19749_();
            DamageSource $$5 = ModDamageTypes.of($$1.m_9236_(), ModDamageTypes.THROWN_OBJECT, $$4);
            if ($$1.m_6469_($$5, 10.0f) && $$1.m_6095_() == EntityType.f_20566_) {
                return;
            }
            this.m_146870_();
        }
    }

    public void shootWithVariance(double $$0, double $$1, double $$2, float $$3, float $$4) {
        Vec3 $$5 = new Vec3($$0, $$1, $$2).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4)).m_82490_((double)$$3);
        this.m_20256_($$5);
        double $$6 = $$5.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)$$5.f_82479_, (double)$$5.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)$$5.f_82480_, (double)$$6) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotationWithVariance(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.shootWithVariance($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_($$9.f_82479_, $$0.m_20096_() ? 0.0 : $$9.f_82480_, $$9.f_82481_));
    }
}

