/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.stand.FollowingStandEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class JusticeEntity
extends FollowingStandEntity {
    protected static final EntityDataAccessor<Integer> JUSTICE_SZ = SynchedEntityData.m_135353_(JusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> JUSTICE_TEAM = SynchedEntityData.m_135353_(JusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final byte PART_3_SKIN = 1;
    public static final byte MANGA_SKIN = 2;
    public static final byte SKELETON_SKIN = 3;
    public static final byte OVA_SKIN = 4;
    public static final byte BOGGED = 5;
    public static final byte STRAY_SKIN = 6;
    public static final byte FLAMED = 7;
    public static final byte TAROT = 8;
    public static final byte WITHER = 9;
    public static final byte TWILIGHT = 10;
    public static final byte PIRATE = 11;
    public static final byte BLUE_FLAMED = 12;
    public static final byte DARK_MIRAGE = 13;
    public static final byte JOJONIUM = 14;
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState idleAnimation2 = new AnimationState();
    public final AnimationState cackleAnimation = new AnimationState();
    public int tsReleaseTime = 0;
    public int cackleTime = 0;
    public boolean stuck = false;

    public JusticeEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public final void setJusticeTeam(Byte team) {
        this.f_19804_.m_135381_(JUSTICE_TEAM, (Object)team);
    }

    public byte getJusticeTeam() {
        return (Byte)this.f_19804_.m_135370_(JUSTICE_TEAM);
    }

    public final void setJusticeSize(Integer size) {
        this.f_19804_.m_135381_(JUSTICE_SZ, (Object)size);
    }

    public int getJusticeSize() {
        return (Integer)this.f_19804_.m_135370_(JUSTICE_SZ);
    }

    protected boolean m_6129_() {
        return false;
    }

    @Override
    protected void m_8097_() {
        if (!this.f_19804_.m_285897_(JUSTICE_SZ)) {
            super.m_8097_();
            this.f_19804_.m_135372_(JUSTICE_SZ, (Object)100);
            this.f_19804_.m_135372_(JUSTICE_TEAM, (Object)0);
        }
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public boolean lockPos() {
        return false;
    }

    @Override
    public void setupAnimationStates() {
        if (this.getUser() != null) {
            if (this.getAnimation() == 0 && this.getIdleAnimation() == 1) {
                this.idleAnimation2.m_216982_(this.f_19797_);
            } else {
                this.idleAnimation2.m_216973_();
            }
            if (this.getAnimation() == 0 && this.getIdleAnimation() == 0) {
                this.idleAnimation.m_216982_(this.f_19797_);
            } else {
                this.idleAnimation.m_216973_();
            }
            if (this.getAnimation() == 2) {
                this.cackleAnimation.m_216982_(this.f_19797_);
            } else {
                this.cackleAnimation.m_216973_();
            }
        }
    }

    @Override
    public boolean m_20147_() {
        return true;
    }

    public void inhaleTick() {
        int perc = this.getJusticeSize() - 2;
        if (perc < 0) {
            if (this.getUser() != null) {
                StandUser user = (StandUser)this.getUser();
                user.roundabout$setMaxSealedTicks(400);
                user.roundabout$setSealedTicks(400);
                user.roundabout$setDrowning(true);
                if (!this.m_9236_().m_5776_() && user instanceof Player) {
                    Player PE = (Player)user;
                    S2CPacketUtil.sendGenericIntToClientPacket((Player)((ServerPlayer)PE), (byte)7, 400);
                }
                user.roundabout$setActive(false);
            }
            this.m_146870_();
            return;
        }
        this.setJusticeSize(perc);
    }

    @Override
    public void playerSetProperties(Player PE) {
        this.setJusticeTeam(((IPlayerEntity)PE).roundabout$getTeamColor());
        super.playerSetProperties(PE);
    }

    @Override
    public void m_8119_() {
        block10: {
            block9: {
                int perc;
                if (this.m_9236_().f_46443_) break block9;
                if (this.cackleTime > 0) {
                    --this.cackleTime;
                    if (this.cackleTime <= 0) {
                        this.setAnimation((byte)0);
                    }
                }
                if ((perc = this.getJusticeSize() + 1) <= 100) {
                    this.setJusticeSize(perc);
                }
                if (this.getAnimation() != 31) break block10;
                ++this.tsReleaseTime;
                if (this.tsReleaseTime <= 24) break block10;
                this.setAnimation((byte)0);
                this.tsReleaseTime = 0;
                break block10;
            }
            if (!(!ConfigManager.getClientConfig().particleSettings.renderJusticeParticlesInFirstPerson.booleanValue() && ClientUtil.checkIfStandIsYoursAndFirstPerson(this) || !ConfigManager.getClientConfig().particleSettings.renderJusticeParticlesWhilePilotingInFirstPerson.booleanValue() && ClientUtil.checkIfStandIsYoursAndFirstPersonandPiloting(this) || this.getSkin() == 13)) {
                int i;
                if (this.getSkin() == 7) {
                    for (i = 0; i < ConfigManager.getClientConfig().particleSettings.justiceSkinFlameParticlesPerTick; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), 0.0, 0.1, 0.0);
                    }
                }
                if (this.getSkin() == 12) {
                    for (i = 0; i < ConfigManager.getClientConfig().particleSettings.justiceSkinFlameParticlesPerTick; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), 0.0, 0.1, 0.0);
                    }
                }
                for (i = 0; i < ConfigManager.getClientConfig().particleSettings.justiceFogParticlesPerTick; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.FOG_CHAIN, this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), 0.0, 0.1, 0.0);
                }
            }
        }
        super.m_8119_();
    }

    public boolean m_6109_() {
        StandEntity ent;
        LivingEntity user = this.getUser();
        if (user != null && (ent = this.getUserData(user).roundabout$getStandPowers().getPilotingStand()) != null && ent.m_7306_((Entity)this)) {
            boolean bl;
            if (user instanceof Player) {
                Player $$0 = (Player)user;
                bl = $$0.m_7578_();
            } else {
                bl = this.m_21515_();
            }
            return bl;
        }
        return super.m_6109_();
    }

    protected float m_274460_() {
        return 0.1f;
    }

    public boolean getFullBlock(BlockState bs, BlockPos bp) {
        Block blk = bs.m_60734_();
        return bs.m_280296_() && (blk.m_180643_(bs, (BlockGetter)this.m_9236_(), bp) || blk instanceof SlabBlock || blk instanceof StairBlock);
    }

    public void m_7023_(Vec3 vec3) {
        LivingEntity livingEntity;
        super.m_7023_(vec3);
        if (this.m_6109_() && (livingEntity = this.getUser()) instanceof Player) {
            Player PE = (Player)livingEntity;
            if (this.m_9236_().m_5776_()) {
                C2SPacketUtil.updatePilot((LivingEntity)this);
            }
        }
    }

    @Override
    public Vec3 getIdleOffset(LivingEntity standUser) {
        if (this.getSkin() != 13) {
            int vis = this.getFadeOut();
            double r = (double)vis / 8.0 * (double)(standUser.m_20205_() / 2.0f + 2.0f * this.getDistanceOut());
            if (r < 0.5) {
                r = 0.5;
            }
            double yawfix = standUser.m_146908_();
            if ((yawfix += (double)(this.getAnchorPlace() + 125)) > 360.0) {
                yawfix -= 360.0;
            } else if (yawfix < 0.0) {
                yawfix += 360.0;
            }
            double ang = (yawfix - 180.0) * Math.PI;
            double mcap = 0.3;
            Vec3 xyz = standUser.m_20184_();
            double yy = xyz.m_7098_() * 0.3;
            if (yy > mcap) {
                yy = mcap;
            } else if (yy < -mcap) {
                yy = -mcap;
            }
            if (this.m_6069_() || this.m_20143_() || this.m_21255_()) {
                yy += 1.0;
            }
            Direction dir = ((IGravityEntity)standUser).roundabout$getGravityDirection();
            Vec3 offset = new Vec3(-(-1.0 * (r * Math.sin(ang / 180.0))), (double)this.getIdleYOffset() - yy + 2.1, -(r * Math.cos(ang / 180.0)));
            if (dir != Direction.DOWN) {
                offset = RotationUtil.vecPlayerToWorld(offset, dir);
            }
            double x1 = standUser.m_20185_() + offset.f_82479_;
            double y1 = standUser.m_20186_() + offset.f_82480_;
            double z1 = standUser.m_20189_() + offset.f_82481_;
            return new Vec3(x1, y1, z1);
        }
        return super.getIdleOffset(standUser);
    }
}

