/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.visages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.entity.goals.JojoNPCGoalPackages;
import net.hydra.jojomod.event.index.Poses;
import net.hydra.jojomod.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class JojoNPC
extends AgeableMob
implements InventoryCarrier,
Npc,
ReputationEventHandler {
    private static final EntityDataAccessor<Integer> DATA_UNHAPPY_COUNTER = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final SimpleContainer inventory = new SimpleContainer(8);
    private static final int MAX_GOSSIP_TOPICS = 10;
    private static final int GOSSIP_COOLDOWN = 1200;
    private static final int GOSSIP_DECAY_INTERVAL = 24000;
    private static final int REPUTATION_CHANGE_PER_EVENT = 25;
    private static final int HOW_FAR_AWAY_TO_TALK_TO_OTHER_VILLAGERS_ABOUT_GOLEMS = 10;
    private static final int HOW_MANY_VILLAGERS_NEED_TO_AGREE_TO_SPAWN_A_GOLEM = 5;
    private static final long TIME_SINCE_SLEEPING_FOR_GOLEM_SPAWNING = 24000L;
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)Items.f_42406_, (Object)Items.f_42620_, (Object)Items.f_42619_, (Object)Items.f_42405_, (Object)Items.f_42404_, (Object)Items.f_42732_, (Object[])new Item[]{Items.f_42733_, Items.f_271133_, Items.f_276594_});
    @VisibleForTesting
    public static final float SPEED_MODIFIER = 0.5f;
    private boolean chasing;
    private int foodLevel;
    private final GossipContainer gossips = new GossipContainer();
    private long lastGossipTime;
    private long lastGossipDecayTime;
    private int villagerXp;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private boolean assignProfessionWhenSpawned;
    protected Vec3 deltaMovementOnPreviousTick = Vec3.f_82478_;
    public Player host = null;
    public boolean isDisplay = false;
    public Poses standPos = null;
    public final AnimationState WRYYY = new AnimationState();
    public final AnimationState GIORNO = new AnimationState();
    public final AnimationState JOSEPH = new AnimationState();
    public final AnimationState KOICHI = new AnimationState();
    public final AnimationState OH_NO = new AnimationState();
    public final AnimationState TORTURE_DANCE = new AnimationState();
    public final AnimationState WAMUU = new AnimationState();
    public final AnimationState JOTARO = new AnimationState();
    public final AnimationState JONATHAN = new AnimationState();
    private static final EntityDataAccessor<Byte> ROUNDABOUT$DATA_KNIFE_COUNT_ID = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ROUNDABOUT$DODGE_TIME = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROUNDABOUT$SKIN_NUMBER = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> ROUNDABOUT$POS = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int roundabout$clientDodgeTime = 0;
    public static final Map<Item, Integer> FOOD_POINTS = ImmutableMap.of((Object)Items.f_42406_, (Object)4, (Object)Items.f_42620_, (Object)1, (Object)Items.f_42619_, (Object)1, (Object)Items.f_42732_, (Object)1);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26360_, (Object)MemoryModuleType.f_26361_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26366_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_217781_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26370_, MemoryModuleType.f_26371_, MemoryModuleType.f_26374_, MemoryModuleType.f_26375_, MemoryModuleType.f_26377_, MemoryModuleType.f_26379_, MemoryModuleType.f_26380_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26323_, MemoryModuleType.f_26363_, MemoryModuleType.f_26324_, MemoryModuleType.f_26325_, MemoryModuleType.f_26326_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, MemoryModuleType.f_26330_, MemoryModuleType.f_26327_});
    private static final ImmutableList<SensorType<? extends Sensor<? super JojoNPC>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26813_, (Object)SensorType.f_26814_, (Object)SensorType.f_26815_, (Object)SensorType.f_26816_, (Object)SensorType.f_26818_);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<JojoNPC, Holder<PoiType>>> POI_MEMORIES = ImmutableMap.of((Object)MemoryModuleType.f_26359_, (p_219625_, p_219626_) -> p_219626_.m_203565_(PoiTypes.f_218060_), (Object)MemoryModuleType.f_26362_, (p_219616_, p_219617_) -> p_219617_.m_203565_(PoiTypes.f_218061_));
    public boolean roundabout$initializedStandUser = false;
    public ItemStack truebasis = ItemStack.f_41583_;
    private static final EntityDataAccessor<Float> DATA_PLAYER_ABSORPTION_ID = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_SCORE_ID = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> DATA_PLAYER_MAIN_HAND = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_LEFT = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_RIGHT = SynchedEntityData.m_135353_(JojoNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private Vector3f sizeOffset = new Vector3f(0.0f, 0.0f, 0.0f);

    public boolean isSimple() {
        return false;
    }

    public void setupAnimationStates() {
        if (this.standPos == Poses.JONATHAN) {
            this.JONATHAN.m_216982_(this.f_19797_);
        } else {
            this.JONATHAN.m_216973_();
        }
        if (this.standPos == Poses.JOTARO) {
            this.JOTARO.m_216982_(this.f_19797_);
        } else {
            this.JOTARO.m_216973_();
        }
        if (this.standPos == Poses.WAMUU) {
            this.WAMUU.m_216982_(this.f_19797_);
        } else {
            this.WAMUU.m_216973_();
        }
        if (this.standPos == Poses.TORTURE_DANCE) {
            this.TORTURE_DANCE.m_216982_(this.f_19797_);
        } else {
            this.TORTURE_DANCE.m_216973_();
        }
        if (this.standPos == Poses.OH_NO) {
            this.OH_NO.m_216982_(this.f_19797_);
        } else {
            this.OH_NO.m_216973_();
        }
        if (this.standPos == Poses.WRY) {
            this.WRYYY.m_216982_(this.f_19797_);
        } else {
            this.WRYYY.m_216973_();
        }
        if (this.standPos == Poses.GIORNO) {
            this.GIORNO.m_216982_(this.f_19797_);
        } else {
            this.GIORNO.m_216973_();
        }
        if (this.standPos == Poses.KOICHI) {
            this.KOICHI.m_216982_(this.f_19797_);
        } else {
            this.KOICHI.m_216973_();
        }
        if (this.standPos == Poses.JOSEPH) {
            this.JOSEPH.m_216982_(this.f_19797_);
        } else {
            this.JOSEPH.m_216973_();
        }
    }

    public ItemStack getBasis() {
        return ModItems.BLANK_MASK.m_7968_();
    }

    public void roundabout$SetPos(byte Pos) {
        this.m_20088_().m_135381_(ROUNDABOUT$POS, (Object)Pos);
    }

    public byte roundabout$GetPos() {
        return (Byte)this.m_20088_().m_135370_(ROUNDABOUT$POS);
    }

    public void setSkinNumber(int Pos) {
        this.m_20088_().m_135381_(ROUNDABOUT$SKIN_NUMBER, (Object)Pos);
    }

    public int getSkinNumber() {
        return (Integer)this.m_20088_().m_135370_(ROUNDABOUT$SKIN_NUMBER);
    }

    public final int roundabout$getKnifeCount() {
        return ((Byte)this.f_19804_.m_135370_(ROUNDABOUT$DATA_KNIFE_COUNT_ID)).byteValue();
    }

    public void roundabout$addKnife() {
        byte knifeCount = (Byte)this.f_19804_.m_135370_(ROUNDABOUT$DATA_KNIFE_COUNT_ID);
        if ((knifeCount = (byte)(knifeCount + 1)) <= 12) {
            ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT$DATA_KNIFE_COUNT_ID, (Object)knifeCount);
        }
    }

    public boolean canSummonStandThroughFightOrFlightActive() {
        return false;
    }

    public int roundabout$getDodgeTime() {
        return (Integer)this.m_20088_().m_135370_(ROUNDABOUT$DODGE_TIME);
    }

    public int roundabout$getClientDodgeTime() {
        return this.roundabout$clientDodgeTime;
    }

    public void roundabout$setClientDodgeTime(int dodgeTime) {
        this.roundabout$clientDodgeTime = dodgeTime;
    }

    public void roundabout$setDodgeTime(int dodgeTime) {
        this.m_20088_().m_135381_(ROUNDABOUT$DODGE_TIME, (Object)dodgeTime);
    }

    public void roundabout$setKnife(byte knives) {
        this.m_20088_().m_135381_(ROUNDABOUT$DATA_KNIFE_COUNT_ID, (Object)knives);
    }

    public CompoundTag getShoulderEntityLeft() {
        return (CompoundTag)this.f_19804_.m_135370_(DATA_SHOULDER_LEFT);
    }

    protected void setShoulderEntityLeft(CompoundTag $$0) {
        this.f_19804_.m_135381_(DATA_SHOULDER_LEFT, (Object)$$0);
    }

    public CompoundTag getShoulderEntityRight() {
        return (CompoundTag)this.f_19804_.m_135370_(DATA_SHOULDER_RIGHT);
    }

    protected void setShoulderEntityRight(CompoundTag $$0) {
        this.f_19804_.m_135381_(DATA_SHOULDER_RIGHT, (Object)$$0);
    }

    public boolean villageDefends() {
        return true;
    }

    public JojoNPC(EntityType<? extends JojoNPC> p_35384_, Level p_35385_) {
        super(p_35384_, p_35385_);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        this.m_21553_(true);
    }

    public Brain<JojoNPC> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<JojoNPC> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public Vec3 getDeltaMovementLerped(float $$0) {
        return this.deltaMovementOnPreviousTick.m_165921_(this.m_20184_(), (double)$$0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public boolean isUsingBrain() {
        return true;
    }

    public void useNotBrain() {
    }

    public boolean hidesInGeneral() {
        return false;
    }

    public boolean runsInGeneral() {
        return false;
    }

    public boolean runsIfLow() {
        return false;
    }

    protected void m_8024_() {
        Raid raid;
        if (this.runsIfLow()) {
            if (!this.roundabout$initializedStandUser) {
                ((IMob)((Object)this)).roundabout$toggleFightOrFlight(true);
                this.roundabout$initializedStandUser = true;
            }
            if (((IMob)((Object)this)).roundabout$getFightOrFlight() && (double)this.m_21223_() > (double)this.m_21233_() * 0.6) {
                this.refreshBrain((ServerLevel)this.m_9236_());
                ((IMob)((Object)this)).roundabout$toggleFightOrFlight(false);
            } else if (!((IMob)((Object)this)).roundabout$getFightOrFlight() && (double)this.m_21223_() < (double)this.m_21233_() * 0.35) {
                this.refreshBrain((ServerLevel)this.m_9236_());
                ((IMob)((Object)this)).roundabout$toggleFightOrFlight(true);
            }
            if (!((IMob)((Object)this)).roundabout$getFightOrFlight()) {
                // empty if block
            }
        }
        if (this.isUsingBrain()) {
            this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        } else {
            this.useNotBrain();
        }
        if (this.assignProfessionWhenSpawned) {
            this.assignProfessionWhenSpawned = false;
        }
        if (!this.m_21525_() && this.f_19796_.m_188503_(100) == 0 && (raid = ((ServerLevel)this.m_9236_()).m_8832_(this.m_20183_())) != null && raid.m_37782_() && !raid.m_37706_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)42);
        }
        super.m_8024_();
    }

    public void m_8119_() {
        this.deltaMovementOnPreviousTick = this.m_20184_();
        super.m_8119_();
        if (this.getUnhappyCounter() > 0) {
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
        this.maybeDecayGossip();
    }

    public int getUnhappyCounter() {
        return (Integer)this.f_19804_.m_135370_(DATA_UNHAPPY_COUNTER);
    }

    private void setUnhappy() {
        this.setUnhappyCounter(40);
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
        }
    }

    public void setUnhappyCounter(int p_35320_) {
        this.f_19804_.m_135381_(DATA_UNHAPPY_COUNTER, (Object)p_35320_);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_35445_) {
        Brain brain = this.m_5490_().m_22073_(p_35445_);
        this.registerBrainGoals((Brain<JojoNPC>)brain);
        return brain;
    }

    public void refreshBrain(ServerLevel p_35484_) {
        Brain<JojoNPC> brain = this.m_6274_();
        brain.m_21933_(p_35484_, (LivingEntity)this);
        this.f_20939_ = brain.m_21973_();
        this.registerBrainGoals(this.m_6274_());
    }

    public void registerBrainGoals(Brain<JojoNPC> p_35425_) {
        if (this.m_6162_()) {
            p_35425_.m_21912_(Schedule.f_38014_);
            p_35425_.m_21900_(Activity.f_37981_, JojoNPCGoalPackages.getPlayPackage(1.0f));
        } else {
            p_35425_.m_21912_(Schedule.f_38015_);
        }
        p_35425_.m_21900_(Activity.f_37978_, JojoNPCGoalPackages.getCorePackage(1.0f));
        p_35425_.m_21903_(Activity.f_37983_, JojoNPCGoalPackages.getMeetPackage(1.0f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26362_, (Object)MemoryStatus.VALUE_PRESENT)));
        p_35425_.m_21900_(Activity.f_37982_, JojoNPCGoalPackages.getRestPackage(1.0f));
        p_35425_.m_21900_(Activity.f_37979_, JojoNPCGoalPackages.getIdlePackage(1.0f));
        if (this.runsInGeneral() || this.runsIfLow() && (double)this.m_21223_() < (double)this.m_21233_() * 0.35) {
            p_35425_.m_21900_(Activity.f_37984_, JojoNPCGoalPackages.getPanicPackage(1.0f));
        }
        p_35425_.m_21900_(Activity.f_37986_, JojoNPCGoalPackages.getPreRaidPackage(1.0f));
        p_35425_.m_21900_(Activity.f_37985_, JojoNPCGoalPackages.getRaidPackage(1.0f));
        if (this.hidesInGeneral()) {
            p_35425_.m_21900_(Activity.f_37987_, JojoNPCGoalPackages.getHidePackage(1.0f));
        }
        p_35425_.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        p_35425_.m_21944_(Activity.f_37979_);
        p_35425_.m_21889_(Activity.f_37979_);
        p_35425_.m_21862_(this.m_9236_().m_46468_(), this.m_9236_().m_46467_());
    }

    public ItemStack getTrueBasis() {
        return this.truebasis;
    }

    public void setTrueBasis(ItemStack basis) {
        this.truebasis = basis;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (this.m_9236_() instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.m_9236_());
        }
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return null;
        }
        return null;
    }

    protected void m_8097_() {
        if (!this.f_19804_.m_285897_(ROUNDABOUT$SKIN_NUMBER)) {
            super.m_8097_();
            this.f_19804_.m_135372_(DATA_UNHAPPY_COUNTER, (Object)0);
            this.f_19804_.m_135372_(ROUNDABOUT$POS, (Object)0);
            this.f_19804_.m_135372_(DATA_PLAYER_ABSORPTION_ID, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(DATA_SCORE_ID, (Object)0);
            this.f_19804_.m_135372_(DATA_PLAYER_MODE_CUSTOMISATION, (Object)0);
            this.f_19804_.m_135372_(ROUNDABOUT$DODGE_TIME, (Object)-1);
            this.f_19804_.m_135372_(ROUNDABOUT$SKIN_NUMBER, (Object)1);
            this.f_19804_.m_135372_(ROUNDABOUT$DATA_KNIFE_COUNT_ID, (Object)0);
            this.f_19804_.m_135372_(DATA_PLAYER_MAIN_HAND, (Object)1);
            this.f_19804_.m_135372_(DATA_SHOULDER_LEFT, (Object)new CompoundTag());
            this.f_19804_.m_135372_(DATA_SHOULDER_RIGHT, (Object)new CompoundTag());
        }
    }

    public void m_7380_(CompoundTag p_35481_) {
        super.m_7380_(p_35481_);
        p_35481_.m_128344_("FoodLevel", (byte)this.foodLevel);
        p_35481_.m_128365_("Gossips", (Tag)this.gossips.m_262795_((DynamicOps)NbtOps.f_128958_));
        p_35481_.m_128405_("Xp", this.villagerXp);
        p_35481_.m_128356_("LastGossipDecay", this.lastGossipDecayTime);
        this.m_252802_(p_35481_);
        p_35481_.m_128405_("skinNumber", this.getSkinNumber());
    }

    public void m_7378_(CompoundTag p_35451_) {
        super.m_7378_(p_35451_);
        if (p_35451_.m_128425_("FoodLevel", 1)) {
            this.foodLevel = p_35451_.m_128445_("FoodLevel");
        }
        ListTag listtag = p_35451_.m_128437_("Gossips", 10);
        this.gossips.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)listtag));
        if (p_35451_.m_128425_("Xp", 3)) {
            this.villagerXp = p_35451_.m_128451_("Xp");
        }
        this.lastGossipDecayTime = p_35451_.m_128454_("LastGossipDecay");
        this.m_21553_(true);
        if (this.m_9236_() instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.m_9236_());
        }
        this.setSkinNumber(p_35451_.m_128451_("skinNumber"));
        if (this.getSkinNumber() == -1) {
            this.rollTheSkin();
        }
    }

    public void rollTheSkin() {
    }

    private boolean hungry() {
        return this.foodLevel < 12;
    }

    public boolean hasExcessFood() {
        return this.countFoodPointsInInventory() >= 24;
    }

    public boolean wantsMoreFood() {
        return this.countFoodPointsInInventory() < 12;
    }

    private int countFoodPointsInInventory() {
        SimpleContainer simplecontainer = this.m_35311_();
        return FOOD_POINTS.entrySet().stream().mapToInt(p_186300_ -> simplecontainer.m_18947_((Item)p_186300_.getKey()) * (Integer)p_186300_.getValue()).sum();
    }

    private void eatUntilFull() {
        if (this.hungry() && this.countFoodPointsInInventory() != 0) {
            for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.m_35311_().m_8020_(i);
                if (itemstack.m_41619_() || (integer = FOOD_POINTS.get(itemstack.m_41720_())) == null) continue;
                for (int k = j = itemstack.m_41613_(); k > 0; --k) {
                    this.foodLevel += integer.intValue();
                    this.m_35311_().m_7407_(i, 1);
                    if (this.hungry()) continue;
                    return;
                }
            }
        }
    }

    public int getPlayerReputation(Player p_35533_) {
        return this.gossips.m_26195_(p_35533_.m_20148_(), p_186302_ -> true);
    }

    private void digestFood(int p_35549_) {
        this.foodLevel -= p_35549_;
    }

    public void eatAndDigestFood() {
        this.eatUntilFull();
        this.digestFood(12);
    }

    public void m_7822_(byte p_35391_) {
        if (p_35391_ == 12) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        } else if (p_35391_ == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123792_);
        } else if (p_35391_ == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        } else if (p_35391_ == 42) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123769_);
        } else {
            super.m_7822_(p_35391_);
        }
    }

    public boolean m_6785_(double p_35535_) {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource p_35498_) {
        return SoundEvents.f_12323_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    public void setChasing(boolean p_150016_) {
        this.chasing = p_150016_;
    }

    public boolean isChasing() {
        return this.chasing;
    }

    public void m_6703_(@javax.annotation.Nullable LivingEntity p_35423_) {
        if (p_35423_ != null && this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8670_(ReputationEventType.f_26987_, (Entity)p_35423_, (ReputationEventHandler)this);
            if (this.m_6084_() && p_35423_ instanceof Player) {
                this.m_9236_().m_7605_((Entity)this, (byte)13);
            }
        }
        super.m_6703_(p_35423_);
    }

    public void m_6667_(DamageSource p_35419_) {
        LOGGER.info("JojoNPC {} died, message: '{}'", (Object)this, (Object)p_35419_.m_6157_((LivingEntity)this).getString());
        Entity entity = p_35419_.m_7639_();
        if (entity != null) {
            this.tellWitnessesThatIWasMurdered(entity);
        }
        this.releaseAllPois();
        super.m_6667_(p_35419_);
    }

    private void releaseAllPois() {
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_);
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26362_);
    }

    public void spawnGolemIfNeeded(ServerLevel p_35398_, long p_35399_, int p_35400_) {
        AABB aabb;
        List list;
        List list1;
        if (this.wantsToSpawnGolem(p_35399_) && (list1 = (list = p_35398_.m_45976_(Villager.class, aabb = this.m_20191_().m_82377_(10.0, 10.0, 10.0))).stream().filter(p_186293_ -> p_186293_.m_35392_(p_35399_)).limit(5L).collect(Collectors.toList())).size() >= p_35400_ && SpawnUtil.m_216403_((EntityType)EntityType.f_20460_, (MobSpawnType)MobSpawnType.MOB_SUMMONED, (ServerLevel)p_35398_, (BlockPos)this.m_20183_(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216412_).isPresent()) {
            list.forEach(GolemSensor::m_26649_);
        }
    }

    public boolean wantsToSpawnGolem(long p_35393_) {
        if (!this.golemSpawnConditionsMet(this.m_9236_().m_46467_())) {
            return false;
        }
        return !this.f_20939_.m_21874_(MemoryModuleType.f_26327_);
    }

    protected void m_7581_(ItemEntity p_35467_) {
        InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)p_35467_);
    }

    public boolean m_7243_(ItemStack p_35543_) {
        Item item = p_35543_.m_41720_();
        return WANTED_ITEMS.contains(item) && this.m_35311_().m_19183_(p_35543_);
    }

    public GossipContainer getGossips() {
        return this.gossips;
    }

    public void setGossips(Tag p_35456_) {
        this.gossips.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_35456_));
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public void m_5802_(BlockPos p_35479_) {
        super.m_5802_(p_35479_);
        this.f_20939_.m_21879_(MemoryModuleType.f_26328_, (Object)this.m_9236_().m_46467_());
        this.f_20939_.m_21936_(MemoryModuleType.f_26370_);
        this.f_20939_.m_21936_(MemoryModuleType.f_26326_);
    }

    public void m_5796_() {
        super.m_5796_();
        this.f_20939_.m_21879_(MemoryModuleType.f_26329_, (Object)this.m_9236_().m_46467_());
    }

    private boolean golemSpawnConditionsMet(long p_35462_) {
        Optional optional = this.f_20939_.m_21952_(MemoryModuleType.f_26328_);
        if (optional.isPresent()) {
            return p_35462_ - (Long)optional.get() < 24000L;
        }
        return false;
    }

    public void gossip(ServerLevel p_35412_, JojoNPC p_35413_, long p_35414_) {
        if (!(p_35414_ >= this.lastGossipTime && p_35414_ < this.lastGossipTime + 1200L || p_35414_ >= p_35413_.lastGossipTime && p_35414_ < p_35413_.lastGossipTime + 1200L)) {
            this.gossips.m_217762_(p_35413_.gossips, this.f_19796_, 10);
            this.lastGossipTime = p_35414_;
            p_35413_.lastGossipTime = p_35414_;
            this.spawnGolemIfNeeded(p_35412_, p_35414_, 5);
        }
    }

    private void maybeDecayGossip() {
        long i = this.m_9236_().m_46467_();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.m_26198_();
            this.lastGossipDecayTime = i;
        }
    }

    private void tellWitnessesThatIWasMurdered(Entity p_35421_) {
        Level $$3 = this.m_9236_();
        if ($$3 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)$$3;
            Optional optional = this.f_20939_.m_21952_(MemoryModuleType.f_148205_);
            if (!optional.isEmpty()) {
                ((NearestVisibleLivingEntities)optional.get()).m_186123_(ReputationEventHandler.class::isInstance).forEach(p_186297_ -> serverlevel.m_8670_(ReputationEventType.f_26988_, p_35421_, (ReputationEventHandler)p_186297_));
            }
        }
    }

    public void releasePoi(MemoryModuleType<GlobalPos> p_35429_) {
        if (this.m_9236_() instanceof ServerLevel) {
            MinecraftServer minecraftserver = ((ServerLevel)this.m_9236_()).m_7654_();
            this.f_20939_.m_21952_(p_35429_).ifPresent(p_186306_ -> {
                ServerLevel serverlevel = minecraftserver.m_129880_(p_186306_.m_122640_());
                if (serverlevel != null) {
                    PoiManager poimanager = serverlevel.m_8904_();
                    Optional optional = poimanager.m_27177_(p_186306_.m_122646_());
                    BiPredicate<JojoNPC, Holder<PoiType>> bipredicate = POI_MEMORIES.get(p_35429_);
                    if (optional.isPresent() && bipredicate.test(this, (Holder<PoiType>)((Holder)optional.get()))) {
                        poimanager.m_27154_(p_186306_.m_122646_());
                        DebugPackets.m_133719_((ServerLevel)serverlevel, (BlockPos)p_186306_.m_122646_());
                    }
                }
            });
        }
    }

    public void playCelebrateSound() {
    }

    @Nullable
    public JojoNPC getBreedOffspring(ServerLevel p_150012_, AgeableMob p_150013_) {
        return null;
    }

    public void m_6814_(ReputationEventType p_35431_, Entity p_35432_) {
        if (p_35431_ == ReputationEventType.f_26985_) {
            this.gossips.m_26191_(p_35432_.m_20148_(), GossipType.MAJOR_POSITIVE, 20);
            this.gossips.m_26191_(p_35432_.m_20148_(), GossipType.MINOR_POSITIVE, 25);
        } else if (p_35431_ == ReputationEventType.f_26989_) {
            this.gossips.m_26191_(p_35432_.m_20148_(), GossipType.TRADING, 2);
        } else if (p_35431_ == ReputationEventType.f_26987_) {
            this.gossips.m_26191_(p_35432_.m_20148_(), GossipType.MINOR_NEGATIVE, 25);
        } else if (p_35431_ == ReputationEventType.f_26988_) {
            this.gossips.m_26191_(p_35432_.m_20148_(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    public Vec3 m_7398_(float p_35318_) {
        float f = Mth.m_14179_((float)p_35318_, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.m_20191_().m_82376_() - 1.0, 0.2);
        return this.m_20318_(p_35318_).m_82549_(vec3.m_82524_(-f));
    }

    public boolean isClientSide() {
        return this.m_9236_().f_46443_;
    }

    protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(p_35288_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_6573_(Player p_35272_) {
        return false;
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public SlotAccess m_141942_(int p_149995_) {
        int i = p_149995_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149995_);
    }

    public void setSizeOffset(Vector3f value) {
        this.sizeOffset = value;
    }

    public Vector3f getSizeOffset() {
        return this.sizeOffset;
    }
}

