/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity.client;

import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ScreenEffectRenderer.class})
public abstract class GravityScreenEffectRenderer {
    @Inject(method={"getViewBlockingState(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void inject_getInWallBlockState(Player player, CallbackInfoReturnable<BlockState> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)player);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.cancel();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Vec3 eyePos = player.m_146892_();
        Vector3f multipliers = RotationUtil.vecPlayerToWorld(player.m_20205_() * 0.8f, 0.1f, player.m_20205_() * 0.8f, gravityDirection);
        for (int i = 0; i < 8; ++i) {
            double d = eyePos.f_82479_ + (double)(((float)((i >> 0) % 2) - 0.5f) * multipliers.x());
            double e = eyePos.f_82480_ + (double)(((float)((i >> 1) % 2) - 0.5f) * multipliers.y());
            double f = eyePos.f_82481_ + (double)(((float)((i >> 2) % 2) - 0.5f) * multipliers.z());
            mutable.m_122169_(d, e, f);
            BlockState blockState = player.m_9236_().m_8055_((BlockPos)mutable);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)player.m_9236_(), (BlockPos)mutable)) continue;
            cir.setReturnValue((Object)blockState);
            return;
        }
        cir.setReturnValue(null);
    }
}

