/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.npcs.Aesthetician;
import net.hydra.jojomod.entity.projectile.CinderellaVisageDisplayEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.LuckyLipstickItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PowersCinderella
extends NewDashPreset {
    public List<CinderellaVisageDisplayEntity> floatingVisages = new ArrayList<CinderellaVisageDisplayEntity>();
    public double spinint = 0.0;
    public double lastSpinInt = 0.0;
    public double maxSpinint = 4.0;
    public boolean hasUIOpen = false;
    public static final byte VISAGE_NOISE = 104;
    public static final byte IMPALE_NOISE = 105;

    public PowersCinderella(LivingEntity self) {
        super(self);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().cinderellaSettings.enableCinderella;
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.CINDERELLA.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public boolean canSummonStand() {
        return true;
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersCinderella(entity);
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        return $$1;
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.doUIClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.doDefaceClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
            }
        }
    }

    public void doDefaceClient() {
        if (!this.onCooldown((byte)1)) {
            if (this.activePower == 23) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            } else {
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
                this.tryPowerPacket((byte)23);
            }
        }
    }

    public void doUIClient() {
        this.tryPowerPacket((byte)21);
        ClientUtil.setCinderellaUI();
        this.hasUIOpen = true;
    }

    @Override
    public void tickPowerEnd() {
        if (this.floatingVisages != null && !this.floatingVisages.isEmpty()) {
            this.removeFloatingVisages();
            if (!this.self.m_9236_().m_5776_()) {
                this.floatingVisagesRotation();
            } else {
                this.lastSpinInt += this.maxSpinint;
            }
        }
    }

    public void floatingVisageInit() {
        if (this.floatingVisages == null) {
            this.floatingVisages = new ArrayList<CinderellaVisageDisplayEntity>();
        }
    }

    public void floatingVisagesRotation() {
        this.floatingVisageInit();
        ArrayList<CinderellaVisageDisplayEntity> hurricaneSpecial2 = new ArrayList<CinderellaVisageDisplayEntity>(this.floatingVisages){};
        if (!hurricaneSpecial2.isEmpty()) {
            int totalnumber = hurricaneSpecial2.size();
            for (CinderellaVisageDisplayEntity value : hurricaneSpecial2) {
                this.transformFloatingVisages(value, totalnumber, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), value.getSize());
            }
        }
    }

    @Override
    public Component getSkinName(byte skinId) {
        return PowersCinderella.getSkinNameT(skinId);
    }

    public static Component getSkinNameT(byte skinId) {
        if (skinId == 2) {
            return Component.m_237115_((String)"skins.roundabout.cinderella.manga");
        }
        if (skinId == 3) {
            return Component.m_237115_((String)"skins.roundabout.cinderella.zombie");
        }
        if (skinId == 4) {
            return Component.m_237115_((String)"skins.roundabout.cinderella.jack_in_the_box");
        }
        if (skinId == 5) {
            return Component.m_237115_((String)"skins.roundabout.cinderella.business");
        }
        if (skinId == 6) {
            return Component.m_237115_((String)"skins.roundabout.cinderella.face_off");
        }
        return Component.m_237115_((String)"skins.roundabout.cinderella.base");
    }

    public void addFloatingVisage(CinderellaVisageDisplayEntity che) {
        this.floatingVisageInit();
        this.floatingVisages.add(che);
    }

    public void transformFloatingVisages(CinderellaVisageDisplayEntity value, int totalnumber, double entityX, double entityY, double entityZ, double rsize) {
        if (value != null) {
            int size = value.getSize();
            double distanceUp = 0.3;
            if (size < value.getMaxSize()) {
                size = (int)((float)size + value.getAccrualRate());
                value.setSize(size);
            }
            distanceUp += rsize / 20.0;
            double offset = 0.0;
            int number = value.getCrossNumber();
            if (this.self.m_9236_().m_5776_()) {
                if (number == 1) {
                    offset = 0.0;
                } else if (number == 2) {
                    offset = 90.0;
                } else if (number == 3) {
                    offset = 180.0;
                } else if (number == 4) {
                    offset = 270.0;
                } else if (number == 5) {
                    offset = 45.0;
                } else if (number == 6) {
                    offset = 135.0;
                } else if (number == 7) {
                    offset = 225.0;
                } else if (number == 8) {
                    offset = 315.0;
                }
                offset += (double)Mth.m_14107_((double)(this.spinint / 2.0));
                if (offset > 360.0) {
                    offset -= 360.0;
                } else if (offset < 0.0) {
                    offset += 360.0;
                }
            } else {
                offset = this.self.m_146908_() % 360.0f;
            }
            double offset2 = offset;
            offset = (offset - 180.0) * Math.PI;
            double distanceOut = 3.0;
            if (number > 4) {
                distanceUp *= 0.5;
            }
            Vec3 finalOffset = new Vec3(-(-1.0 * (distanceOut * Math.sin(offset / 180.0))), distanceUp, -(distanceOut * Math.cos(offset / 180.0)));
            Direction dir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (dir != Direction.DOWN) {
                finalOffset = RotationUtil.vecPlayerToWorld(finalOffset, dir);
            }
            double x1 = entityX + finalOffset.f_82479_;
            double y1 = entityY + finalOffset.f_82480_;
            double z1 = entityZ + finalOffset.f_82481_;
            if (!this.self.m_9236_().m_5776_()) {
                value.m_146867_();
            }
            value.actuallyTick();
            value.storeVec = new Vec3(x1, y1, z1);
            if (this.self.m_9236_().m_5776_()) {
                value.m_146922_((float)offset2);
                value.f_19859_ = (float)offset2;
                value.f_19790_ = x1;
                value.f_19791_ = y1;
                value.f_19792_ = z1;
                value.m_20248_(x1, y1, z1);
            } else {
                value.m_146922_((float)offset2);
                value.f_19859_ = (float)offset2;
                value.f_19790_ = x1;
                value.f_19791_ = y1;
                value.f_19792_ = z1;
                value.m_6034_(x1, y1, z1);
            }
        }
    }

    public void removeFloatingVisages() {
        this.floatingVisageInit();
        ArrayList<CinderellaVisageDisplayEntity> hurricaneSpecial2 = new ArrayList<CinderellaVisageDisplayEntity>(this.floatingVisages){};
        if (!hurricaneSpecial2.isEmpty()) {
            for (CinderellaVisageDisplayEntity value : hurricaneSpecial2) {
                if (!value.m_213877_() && value.m_6084_() && value.getCrossNumber() > 0) continue;
                value.initialized = false;
                this.floatingVisages.remove(value);
            }
        }
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.CINDERELLA_MASK, (byte)-1);
        this.setSkillIcon(context, x, y, 2, StandIcons.CINDERELLA_SCALP, (byte)1);
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.CINDERELLA_SUMMON_EVENT;
        }
        if (soundChoice == 105) {
            return ModSounds.CINDERELLA_ATTACK_EVENT;
        }
        if (soundChoice == 104) {
            return ModSounds.CINDERELLA_VISAGE_CREATION_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    public void clearAllFloatingVisages() {
        this.floatingVisageInit();
        ArrayList<CinderellaVisageDisplayEntity> hurricaneSpecial2 = new ArrayList<CinderellaVisageDisplayEntity>(this.floatingVisages){};
        if (!hurricaneSpecial2.isEmpty()) {
            int totalnumber = hurricaneSpecial2.size();
            for (CinderellaVisageDisplayEntity value : hurricaneSpecial2) {
                value.m_146870_();
            }
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (!this.getSelf().m_9236_().f_46443_ && this.getActivePower() == 23 && this.attackTimeDuring > -1) {
            this.stopSoundsIfNearby((byte)105, 100.0, true);
        }
        if (!(this.getSelf().m_9236_().f_46443_ || this.getActivePower() != 21 && move == 21)) {
            this.stopSoundsIfNearby((byte)104, 100.0, true);
        }
        if (!this.getSelf().m_9236_().m_5776_()) {
            this.clearAllFloatingVisages();
        }
        return super.tryPower(move, forced);
    }

    @Override
    public void tickPower() {
        if (this.self.m_9236_().m_5776_()) {
            if (this.hasUIOpen && !ClientUtil.hasCinderellaUI()) {
                this.hasUIOpen = false;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            }
        } else if (this.getActivePower() == 21) {
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.PINK_SMOKE, this.getSelf().m_20185_(), this.getSelf().m_20186_() + 0.3, this.getSelf().m_20189_(), 1, 2.5, 2.0, 2.5, 0.015);
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)livingEntity;
                if ((this.getStandEntity(this.self) == null || this.getStandEntity(this.self).m_213877_()) && this.canSummonStand()) {
                    ((StandUser)this.self).roundabout$summonStand(this.self.m_9236_(), true, false);
                }
                if (aes.interactingWith != null && aes.interactingWith.isEmpty()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                }
            }
        } else {
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)livingEntity;
                if (aes.interactingWith != null && !aes.interactingWith.isEmpty()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                }
            }
        }
        super.tickPower();
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 23) {
            this.updateDeface();
        }
        super.updateUniqueMoves();
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 23) {
            return this.deface();
        }
        if (move == 21) {
            return this.visages();
        }
        return super.setPowerOther(move, lastMove);
    }

    public void generateFloatingMask(int crossNumber, int maxSize) {
        CinderellaVisageDisplayEntity cross;
        ItemStack stack = ModItems.getVisageStore().get((int)Mth.m_14107_((double)(Math.random() * (double)(ModItems.getVisageStore().size() - 1)))).stack;
        if (stack.m_41720_() instanceof LuckyLipstickItem) {
            stack = ModItems.BLANK_MASK.m_7968_().m_41777_();
        }
        if ((cross = new CinderellaVisageDisplayEntity(this.self, this.self.m_9236_(), stack)) != null) {
            cross.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
            cross.setUser(this.self);
            if (this.floatingVisages == null) {
                this.floatingVisages = new ArrayList<CinderellaVisageDisplayEntity>();
            }
            cross.setCrossNumber(crossNumber);
            cross.setMaxSize(maxSize);
            this.floatingVisages.add(cross);
            this.getSelf().m_9236_().m_7967_((Entity)cross);
        }
    }

    public static int getChargingCrossfireSpecialSize() {
        return 26;
    }

    public boolean visages() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)21);
            this.animateStand((byte)82);
            this.playStandUserOnlySoundsIfNearby((byte)104, 27.0, false, false);
            this.poseStand((byte)2);
            this.generateFloatingMask(1, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(2, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(3, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(4, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(5, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(6, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(7, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(8, PowersCinderella.getChargingCrossfireSpecialSize());
            return true;
        }
        return false;
    }

    public boolean deface() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)23);
            this.playStandUserOnlySoundsIfNearby((byte)105, 27.0, false, false);
            this.animateStand((byte)81);
            this.poseStand((byte)1);
            return true;
        }
        return false;
    }

    public void updateDeface() {
        if (this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > 15) {
                this.standImpale();
            } else if (!this.getSelf().m_9236_().m_5776_() && this.attackTimeDuring % 4 == 0) {
                ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.MENACING, this.getSelf().m_20185_(), this.getSelf().m_20186_() + 0.3, this.getSelf().m_20189_(), 1, 0.2, 0.2, 0.2, 0.05);
            }
        }
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (attackTarget != null && attackTarget.m_6084_()) {
            Entity targetEntity;
            if (this.getActivePower() != 0 || attackTarget.m_20270_((Entity)this.getSelf()) <= 5.0f) {
                this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                this.getSelf().m_146922_(yrot);
                this.getSelf().m_5616_(yrot);
            }
            if ((targetEntity = this.getTargetEntity(this.self, 5.0f)) != null && targetEntity.m_7306_((Entity)attackTarget) && this.getActivePower() == 0 && (!this.onCooldown((byte)1) || this.self instanceof IronGolem)) {
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
            }
        }
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.visage_creation", "instruction.roundabout.press_skill", StandIcons.CINDERELLA_MASK, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.face_removal", "instruction.roundabout.press_skill", StandIcons.CINDERELLA_SCALP, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.visages", "instruction.roundabout.passive", StandIcons.CINDERELLA_VISAGES, 0, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.lucky_lipstick", "instruction.roundabout.passive", StandIcons.CINDERELLA_LIPSTICK, 0, level, bypass));
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        $$1.add((byte)5);
        $$1.add((byte)6);
        return $$1;
    }

    public void standImpale() {
        if (this.self instanceof Player) {
            if (this.isPacketPlayer()) {
                this.setAttackTimeDuring(-15);
                this.tryIntToServerPacket((byte)4, this.getTargetEntityId2(5.0f));
            }
        } else {
            Entity targetEntity = this.getTargetEntity(this.self, 5.0f);
            this.defaceImpact(targetEntity);
        }
    }

    public float getDefaceStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().cinderellaSettings.cinderellaAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(9.0 * ((double)ClientNetworking.getAppropriateConfig().cinderellaSettings.cinderellaAttackMultOnMobs.intValue() * 0.01)));
    }

    public float getDefaceKnockback() {
        return 0.7f;
    }

    @Override
    public void handleStandAttack(Player player, Entity target) {
        this.defaceImpact(target);
    }

    public void defaceImpact(Entity entity) {
        SoundEvent SE;
        this.setAttackTimeDuring(-20);
        if (entity != null) {
            this.hitParticlesCenter(entity);
            float pow = this.getDefaceStrength(entity);
            float knockbackStrength = this.getDefaceKnockback();
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (Entity)this.self)) {
                if (entity instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)entity;
                    MobEffectInstance instance = LE.m_21124_(ModEffects.FACELESS);
                    int lvlFace = -1;
                    if (instance != null) {
                        lvlFace = instance.m_19564_();
                    }
                    if (MainUtil.getMobBleed(entity)) {
                        if (lvlFace < 0) {
                            MainUtil.makeFaceless(entity, 200, 0, (Entity)this.getSelf());
                            MainUtil.makeBleed(entity, 0, 200, (Entity)this.getSelf());
                        } else if (lvlFace == 0) {
                            MainUtil.makeFaceless(entity, 250, 1, (Entity)this.getSelf());
                            MainUtil.makeBleed(entity, 1, 250, (Entity)this.getSelf());
                        } else {
                            MainUtil.makeFaceless(entity, 300, 2, (Entity)this.getSelf());
                            MainUtil.makeBleed(entity, 2, 300, (Entity)this.getSelf());
                            MainUtil.makeMobBleed(entity);
                        }
                    } else {
                        MainUtil.makeFaceless(entity, 200, 0, (Entity)this.getSelf());
                    }
                }
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            }
        }
        if (this.getSelf() instanceof Player) {
            S2CPacketUtil.sendCooldownSyncPacket((Player)((ServerPlayer)this.getSelf()), (byte)1, ClientNetworking.getAppropriateConfig().cinderellaSettings.defaceAttackCooldown);
        }
        this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().cinderellaSettings.defaceAttackCooldown);
        float pitch = 1.0f;
        if (entity != null) {
            SE = ModSounds.PUNCH_3_SOUND_EVENT;
            pitch = 1.2f;
        } else {
            SE = ModSounds.PUNCH_2_SOUND_EVENT;
        }
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), SE, SoundSource.PLAYERS, 0.95f, pitch);
        }
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_() && effect.m_19557_() == 15) {
            MainUtil.makeFaceless((Entity)this.self, 800, 0, (Entity)this.self);
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.CINDERELLA_FAIL_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        Entity TE;
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.getActivePower() == 23 && (TE = this.getTargetEntity((LivingEntity)playerEntity, 5.0f)) != null) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
        }
    }
}

