/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.IBucketItem;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.block.BubbleScaffoldBlockEntity;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.pathfinding.GroundBubbleEntity;
import net.hydra.jojomod.entity.projectile.GoBeyondEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetExplosiveBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetItemLaunchingBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetPlunderBubbleEntity;
import net.hydra.jojomod.entity.projectile.ThrownObjectEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.substand.EncasementBubbleEntity;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.entity.visages.mobs.AvdolNPC;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.index.PlunderTypes;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PowersSoftAndWet
extends NewPunchingStand {
    public List<SoftAndWetBubbleEntity> bubbleList = new ArrayList<SoftAndWetBubbleEntity>();
    public int waterShieldTicks = 0;
    public byte bubbleType;
    public boolean hold1;
    public boolean holdDownClick;
    public static int maxSuperHitTime = 25;
    int bubbleMax;
    int bubbleCd;
    public int shootTicks;
    public int goBeyondChargeTicks;
    public boolean inExplosiveSpinMode;
    public int grabInventorySlot;
    public int chargedFinal;
    public static final byte BARRAGE_NOISE = 20;
    public static final byte BARRAGE_NOISE_2 = 21;
    public static final byte BARRAGE_NOISE_3 = 22;
    Entity goBeyondActiveTarget;
    public int bubbleNumber;
    int bubbleScaffoldCount;
    public int pauseGrowthTicks;
    public BlockPos buildingBubbleScaffoldPos;

    public PowersSoftAndWet(LivingEntity self) {
        super(self);
        this.bubbleType = PlunderTypes.ITEM.id;
        this.hold1 = false;
        this.holdDownClick = false;
        this.bubbleMax = 0;
        this.bubbleCd = 20;
        this.shootTicks = 0;
        this.goBeyondChargeTicks = 0;
        this.inExplosiveSpinMode = false;
        this.grabInventorySlot = 1;
        this.goBeyondActiveTarget = null;
        this.bubbleNumber = 0;
        this.bubbleScaffoldCount = 0;
        this.pauseGrowthTicks = 0;
        this.buildingBubbleScaffoldPos = BlockPos.f_121853_;
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.enableSoftAndWet;
    }

    @Override
    public StandEntity getNewStandEntity() {
        byte sk = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (sk == 3) {
            return (StandEntity)ModEntities.SOFT_AND_WET_KING.m_20615_(this.getSelf().m_9236_());
        }
        if (sk == 9) {
            return (StandEntity)ModEntities.SOFT_AND_WET_DEBUT.m_20615_(this.getSelf().m_9236_());
        }
        if (sk == 5 || sk == 6) {
            return (StandEntity)ModEntities.SOFT_AND_WET_DROWNED.m_20615_(this.getSelf().m_9236_());
        }
        if (sk == 10) {
            return (StandEntity)ModEntities.SOFT_AND_WET_KILLER_QUEEN.m_20615_(this.getSelf().m_9236_());
        }
        return (StandEntity)ModEntities.SOFT_AND_WET.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                this.plunderBubbleSelectClient();
                break;
            }
            case SKILL_1_CROUCH: {
                this.plunderBubbleClusterClient();
                break;
            }
            case SKILL_1_GUARD: 
            case SKILL_1_CROUCH_GUARD: {
                this.clusterRedirectClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.plunderOrItemLaunchBubbleClient();
                break;
            }
            case SKILL_2_CROUCH: {
                this.bubblePopClient();
                break;
            }
            case SKILL_2_GUARD: 
            case SKILL_2_CROUCH_GUARD: {
                this.activatedBubbleRedirectClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.tryToDashClient();
                break;
            }
            case SKILL_3_CROUCH: {
                this.tryToBubbleScaffoldClient();
                break;
            }
            case SKILL_3_GUARD: 
            case SKILL_3_CROUCH_GUARD: {
                this.tryToBigBubbleClient();
                break;
            }
            case SKILL_4_NORMAL: {
                this.shootingModeToggleClient();
                break;
            }
            case SKILL_4_CROUCH: {
                this.waterShieldAttemptClient();
            }
        }
    }

    public boolean goBeyondClient() {
        if (this.inShootingMode()) {
            if (this.canExecuteMoveWithLevel(this.getGoBeyondLevel()) && this.goBeyondCharged() && this.getGoBeyondTarget() != null) {
                this.tryIntPower(11, true, this.getGoBeyondTarget().m_19879_());
                this.tryIntPowerPacket((byte)11, this.getGoBeyondTarget().m_19879_());
                this.setGoBeyondTarget(null);
                this.setGoBeyondChargeTicks(0);
                this.setShootTicks(this.getMaxShootTicks());
            }
            return true;
        }
        return false;
    }

    public void plunderBubbleSelectClient() {
        if (!this.goBeyondClient()) {
            ClientUtil.openPlunderScreen();
        }
    }

    public void plunderBubbleClusterClient() {
        if (!this.goBeyondClient() && this.canExecuteMoveWithLevel(this.getSpreadLevel())) {
            if (!this.onCooldown((byte)4)) {
                if (this.activePower != 22 && !this.canDoBubbleClusterPop()) {
                    this.hold1 = true;
                    int bubbleType = 1;
                    ClientConfig clientConfig = ConfigManager.getClientConfig();
                    if (clientConfig != null && clientConfig.dynamicSettings != null) {
                        bubbleType = clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble;
                    }
                    this.tryIntPower(22, true, bubbleType);
                    this.tryIntPowerPacket((byte)22, bubbleType);
                } else if (!this.onCooldown((byte)9)) {
                    this.hold1 = true;
                    this.tryPower(16, true);
                    this.tryPowerPacket((byte)16);
                }
            } else if ((this.activePower == 22 || this.canDoBubbleClusterRedirect()) && !this.onCooldown((byte)9)) {
                this.hold1 = true;
                this.tryPower(16, true);
                this.tryPowerPacket((byte)16);
            }
        }
    }

    public void clusterRedirectClient() {
        if (!this.goBeyondClient() && this.canExecuteMoveWithLevel(this.getSpreadLevel()) && !this.onCooldown((byte)9)) {
            this.tryPower(34, true);
            this.tryPowerPacket((byte)34);
        }
    }

    public void activatedBubbleRedirectClient() {
        if (!this.inShootingMode() && !this.onCooldown((byte)9)) {
            Vec3 pos = MainUtil.getRaytracePointOnMobOrBlock((Entity)this.self, 30.0f);
            this.tryPosPower(29, true, pos);
            this.tryPosPowerPacket((byte)29, pos);
        }
    }

    public void bubblePopClient() {
        if (!this.onCooldown((byte)5)) {
            Vec3 pos = MainUtil.getRaytracePointOnMobOrBlock((Entity)this.self, 30.0f);
            this.tryPosPower(24, true, pos);
            this.tryPosPowerPacket((byte)24, pos);
        }
    }

    public void plunderOrItemLaunchBubbleClient() {
        if (!this.inShootingMode()) {
            if (!this.onCooldown((byte)1)) {
                int bubbleType = 1;
                ClientConfig clientConfig = ConfigManager.getClientConfig();
                if (clientConfig != null && clientConfig.dynamicSettings != null) {
                    bubbleType = clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble;
                }
                this.tryIntPower(23, true, bubbleType);
                this.tryIntPowerPacket((byte)23, bubbleType);
            }
        } else if (this.canExecuteMoveWithLevel(this.getItemShootingLevel()) && !this.onCooldown((byte)1) && this.canDoBubbleItemLaunch()) {
            this.tryIntPower(35, true, ((Player)this.getSelf()).m_150109_().f_35977_);
            this.tryIntPowerPacket((byte)35, ((Player)this.getSelf()).m_150109_().f_35977_);
        }
    }

    public void shootingModeToggleClient() {
        if (this.canExecuteMoveWithLevel(this.getShootingModeLevel())) {
            this.tryPower(27, true);
            this.tryPowerPacket((byte)27);
            this.getStandUserSelf().roundabout$getStandPowers().tryPower(0, true);
            this.tryPowerPacket((byte)0);
            ClientUtil.stopDestroyingBlock();
        }
    }

    public void waterShieldAttemptClient() {
        if (!this.inShootingMode()) {
            if (!this.onCooldown((byte)7) && this.canExecuteMoveWithLevel(this.getWaterShieldLevel()) && this.canUseWaterShield()) {
                this.tryPower(28, true);
                this.tryPowerPacket((byte)28);
            }
        } else {
            this.shootingModeToggleClient();
        }
    }

    public void tryToBubbleScaffoldClient() {
        if (this.vaultOrFallBraceFails() && this.canExecuteMoveWithLevel(this.getScaffoldLevel()) && !this.onCooldown((byte)2) && this.canBridge()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
            this.tryPowerPacket((byte)25);
        }
    }

    public void tryToBigBubbleClient() {
        if (this.vaultOrFallBraceFails() && !this.onCooldown((byte)8) && this.canBigBubble()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(36, true);
            this.tryPowerPacket((byte)36);
        }
    }

    public void tryToDashClient() {
        if (this.vaultOrFallBraceFails()) {
            this.dash();
        }
    }

    @Override
    public float getMiningMultiplier() {
        return (float)(1.0 * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.miningSpeedMultiplierSoftAndWet.intValue() * 0.01));
    }

    @Override
    public float getPickMiningSpeed() {
        return 12.0f;
    }

    @Override
    public float getAxeMiningSpeed() {
        return 8.0f;
    }

    @Override
    public float getSwordMiningSpeed() {
        return 8.0f;
    }

    @Override
    public float getShovelMiningSpeed() {
        return 8.0f;
    }

    @Override
    public int getMiningLevel() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.getMiningTierSoftAndWet;
    }

    @Override
    public boolean canSummonStand() {
        return !(this.getSelf() instanceof Creeper);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersSoftAndWet(entity);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte getSoundCancelingGroupByte(byte soundChoice) {
        if (soundChoice == 2) {
            return 100;
        }
        if (soundChoice >= 20 && soundChoice <= 21) {
            return 100;
        }
        return super.getSoundCancelingGroupByte(soundChoice);
    }

    @Override
    public void playBarrageClashSound() {
        byte skn;
        if (!this.self.m_9236_().m_5776_() && (skn = ((StandUser)this.getSelf()).roundabout$getStandSkin()) != 10) {
            this.playStandUserOnlySoundsIfNearby((byte)20, 27.0, false, true);
        }
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.SUMMON_SOFT_AND_WET_EVENT;
        }
        if (soundChoice == 20) {
            return ModSounds.SOFT_AND_WET_BARRAGE_EVENT;
        }
        if (soundChoice == 2) {
            return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
        }
        if (soundChoice == 21) {
            return ModSounds.SOFT_AND_WET_BARRAGE_2_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    public void bubbleListInit() {
        if (this.bubbleList == null) {
            this.bubbleList = new ArrayList<SoftAndWetBubbleEntity>();
        }
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)2);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            $$1.add((byte)1);
            if (Level2 > 1 || bypass) {
                $$1.add((byte)9);
                $$1.add((byte)14);
                $$1.add((byte)15);
            }
            if (Level2 > 2 || bypass) {
                $$1.add((byte)12);
                $$1.add((byte)16);
                $$1.add((byte)8);
            }
            if (Level2 > 3 || bypass) {
                $$1.add((byte)7);
                $$1.add((byte)11);
            }
            if (Level2 > 4 || bypass) {
                $$1.add((byte)13);
                $$1.add((byte)17);
            }
            if (Level2 > 5 || bypass) {
                $$1.add((byte)5);
                $$1.add((byte)6);
            }
            if (Level2 > 6 || bypass) {
                $$1.add((byte)3);
                $$1.add((byte)4);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)10);
            }
        }
        return $$1;
    }

    public boolean goBeyondCharged() {
        Player PE;
        LivingEntity livingEntity;
        return this.getInExplosiveSpinMode() || (livingEntity = this.self) instanceof Player && (PE = (Player)livingEntity).m_7500_();
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (this.inShootingMode()) {
            if (!(slot != 1 || this.goBeyondCharged() && this.getGoBeyondTarget() != null)) {
                return true;
            }
            if (slot == 2 && !this.canDoBubbleItemLaunch() && !this.isHoldingSneak()) {
                return true;
            }
        } else {
            if (slot == 1 && !this.canDoBubbleClusterRedirect() && this.isGuarding()) {
                return true;
            }
            if (slot == 2 && !this.canDoBubbleRedirect() && this.isGuarding()) {
                return true;
            }
            if (slot == 4 && this.isHoldingSneak() && !this.canUseWaterShield()) {
                return true;
            }
        }
        if (!(slot != 3 || this.canVault() || this.canFallBrace() || this.isGuarding() || !this.isHoldingSneak() || this.canBridge())) {
            return true;
        }
        if (slot == 3 && !this.canVault() && !this.canFallBrace() && this.isGuarding() && !this.canBigBubble()) {
            return false;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    public boolean hasWaterShield() {
        return this.waterShieldTicks > 0;
    }

    public void setWaterShieldTicks(int ticks) {
        this.waterShieldTicks = ticks;
    }

    public int getWaterShieldTicks() {
        return this.waterShieldTicks;
    }

    public void tickWaterShield() {
        if (this.waterShieldTicks > 0) {
            --this.waterShieldTicks;
        }
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.punch", "instruction.roundabout.press_attack", StandIcons.SOFT_AND_WET_PUNCH, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.guard", "instruction.roundabout.hold_block", StandIcons.SOFT_AND_WET_GUARD, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.encasement_strike", "instruction.roundabout.hold_attack_crouch", StandIcons.ENCASEMENT_STRIKE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.barrage", "instruction.roundabout.barrage", StandIcons.SOFT_AND_WET_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, this.getShootingModeLevel(), "ability.roundabout.bubble_barrage", "instruction.roundabout.shooting_barrage", StandIcons.BUBBLE_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.bubble_selection", "instruction.roundabout.press_skill", StandIcons.PLUNDER_SELECTION, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, this.getGoBeyondLevel(), "ability.roundabout.go_beyond", "instruction.roundabout.press_skill_explosive_spin_mode", StandIcons.GO_BEYOND, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, this.getSpreadLevel(), "ability.roundabout.bubble_spread", "instruction.roundabout.press_skill_crouch", StandIcons.PLUNDER_BUBBLE_FILL, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, this.getSpreadLevel(), "ability.roundabout.bubble_spread_redirect", "instruction.roundabout.press_skill_block", StandIcons.PLUNDER_BUBBLE_FILL_CONTROL, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 80, 0, "ability.roundabout.plunder_bubble", "instruction.roundabout.press_skill", StandIcons.PLUNDER_BUBBLE, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 99, 0, "ability.roundabout.bubble_pop", "instruction.roundabout.press_skill_crouch", StandIcons.PLUNDER_BUBBLE_POP, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 118, 0, "ability.roundabout.bubble_redirect", "instruction.roundabout.press_skill_block", StandIcons.PLUNDER_BUBBLE_CONTROL, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 80, this.getItemShootingLevel(), "ability.roundabout.item_launching_bubble", "instruction.roundabout.press_skill_shooting_mode", StandIcons.ITEM_BUBBLE, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 99, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 118, 0, "ability.roundabout.fall_brace", "instruction.roundabout.press_skill_falling", StandIcons.SOFT_AND_WET_FALL_CATCH, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 80, 0, "ability.roundabout.vault", "instruction.roundabout.press_skill_air", StandIcons.SOFT_AND_WET_VAULT, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 99, this.getScaffoldLevel(), "ability.roundabout.bubble_scaffold", "instruction.roundabout.press_skill_crouch", StandIcons.SOFT_AND_WET_BUBBLE_SCAFFOLD, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 118, 0, "ability.roundabout.encasement_bubble", "instruction.roundabout.press_skill_block", StandIcons.SOFT_AND_WET_BUBBLE_ENCASEMENT, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 80, this.getShootingModeLevel(), "ability.roundabout.shooting_mode", "instruction.roundabout.press_skill", StandIcons.SOFT_SHOOTING_MODE, 4, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 99, this.getWaterShieldLevel(), "ability.roundabout.water_shield", "instruction.roundabout.press_skill_crouch", StandIcons.WATER_SHIELD, 4, level, bypas));
        return $$1;
    }

    public int getGoBeyondLevel() {
        return 7;
    }

    public int getWaterShieldLevel() {
        return 6;
    }

    public int getItemShootingLevel() {
        return 5;
    }

    public int getShootingModeLevel() {
        return 4;
    }

    public int getScaffoldLevel() {
        return 3;
    }

    public int getSpreadLevel() {
        return 2;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.inShootingMode()) {
            if (this.canExecuteMoveWithLevel(this.getGoBeyondLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.GO_BEYOND, (byte)9);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.isGuarding()) {
            if (this.canExecuteMoveWithLevel(this.getSpreadLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_BUBBLE_FILL_CONTROL, (byte)9);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getSpreadLevel())) {
                if (this.canDoBubbleClusterPop()) {
                    this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_BUBBLE_FILL_POP, (byte)5);
                } else {
                    this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_BUBBLE_FILL, (byte)4);
                }
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_SELECTION, (byte)-1);
        }
        if (this.inShootingMode()) {
            if (this.isHoldingSneak()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE_POP, (byte)5);
            } else if (this.canExecuteMoveWithLevel(this.getItemShootingLevel())) {
                this.setSkillIcon(context, x, y, 2, StandIcons.ITEM_BUBBLE, (byte)1);
            } else {
                this.setSkillIcon(context, x, y, 2, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.isGuarding()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE_CONTROL, (byte)9);
        } else if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE_POP, (byte)5);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE, (byte)1);
        }
        if (this.canVault()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_VAULT, (byte)6);
        } else if (this.canFallBrace()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_FALL_CATCH, (byte)0);
        } else if (this.isGuarding()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_BUBBLE_ENCASEMENT, (byte)8);
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getScaffoldLevel())) {
                this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_BUBBLE_SCAFFOLD, (byte)2);
            } else {
                this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
            }
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        if (this.inShootingMode()) {
            this.setSkillIcon(context, x, y, 4, StandIcons.SOFT_SHOOTING_MODE_EXIT, (byte)3);
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getWaterShieldLevel())) {
                this.setSkillIcon(context, x, y, 4, StandIcons.WATER_SHIELD, (byte)7);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.canExecuteMoveWithLevel(this.getShootingModeLevel())) {
            this.setSkillIcon(context, x, y, 4, StandIcons.SOFT_SHOOTING_MODE, (byte)3);
        } else {
            this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
        }
    }

    @Override
    public byte getMaxLevel() {
        return 7;
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 100 : 100 + (currentLevel - 1) * 55;
        amt = (int)((float)amt * this.getLevelMultiplier());
        return amt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseWaterShield() {
        Item item;
        ItemStack stack = this.getSelf().m_21205_();
        ItemStack stack2 = this.getSelf().m_21206_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof PotionItem) {
            PotionItem PI = (PotionItem)item;
            if (PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) return true;
        }
        if (!stack2.m_41619_() && (item = stack2.m_41720_()) instanceof PotionItem) {
            PotionItem PI2 = (PotionItem)item;
            if (PotionUtils.m_43579_((ItemStack)stack2) == Potions.f_43599_) return true;
        }
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof BucketItem) {
            BucketItem BI = (BucketItem)item;
            if (((IBucketItem)BI).roundabout$getContents().m_205067_(FluidTags.f_13131_)) return true;
        }
        if (stack2.m_41619_()) return false;
        item = stack2.m_41720_();
        if (!(item instanceof BucketItem)) return false;
        BucketItem BI2 = (BucketItem)item;
        if (!((IBucketItem)BI2).roundabout$getContents().m_205067_(FluidTags.f_13131_)) return false;
        return true;
    }

    @Override
    public boolean canGuard() {
        if (this.isBubbleBarraging()) {
            return false;
        }
        return super.canGuard();
    }

    public int getUseTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.heatGainedPerShot;
    }

    public int getGoBeyondUseTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveSpinMeterGainedPerShot;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (!this.consumeClickInput) {
            if (this.holdDownClick) {
                if (!keyIsDown) {
                    if (this.getActivePower() == 43) {
                        int atd = this.getAttackTimeDuring();
                        this.tryIntPower(2, true, atd);
                        this.tryIntPowerPacket((byte)2, atd);
                    }
                    this.holdDownClick = false;
                }
            } else if (keyIsDown) {
                if (this.inShootingMode()) {
                    if (!(this.holdDownClick || this.onCooldown((byte)3) || this.getActivePower() != 0 && this.getActivePower() != 33 || !this.getInExplosiveSpinMode() && !this.confirmShot(this.getUseTicks()))) {
                        LivingEntity livingEntity = this.self;
                        if (livingEntity instanceof Player) {
                            Player PE = (Player)livingEntity;
                            IPlayerEntity ipe = (IPlayerEntity)PE;
                            ipe.roundabout$getBubbleShotAim().m_216973_();
                            ipe.roundabout$setBubbleShotAimPoints(10);
                        }
                        this.tryPower(33, true);
                        if (this.getInExplosiveSpinMode()) {
                            this.tryPowerPacket((byte)37);
                        } else {
                            this.tryPowerPacket((byte)33);
                        }
                    }
                } else {
                    Minecraft mc = Minecraft.m_91087_();
                    if (!this.isHoldingSneak()) {
                        super.buttonInputAttack(keyIsDown, options);
                    } else if (this.canAttack()) {
                        this.tryPower(43, true);
                        this.holdDownClick = true;
                        this.tryPowerPacket((byte)43);
                    } else {
                        super.buttonInputAttack(keyIsDown, options);
                    }
                }
            }
        } else if (!keyIsDown) {
            this.consumeClickInput = false;
        }
    }

    public boolean isBubbleBarraging() {
        return this.getActivePower() == 41 || this.getActivePower() == 42;
    }

    @Override
    public void buttonInputBarrage(boolean keyIsDown, Options options) {
        if (keyIsDown && !this.isBubbleBarraging()) {
            if (!this.inShootingMode()) {
                super.buttonInputBarrage(keyIsDown, options);
            } else if (this.getAttackTime() >= this.getAttackTimeMax() || this.getActivePowerPhase() != this.getActivePowerPhaseMax()) {
                this.tryPower(41, true);
                this.tryPowerPacket((byte)41);
            }
        }
    }

    public int getBubbleBarrageWindup() {
        return ClientNetworking.getAppropriateConfig().generalStandSettings.barrageWindup;
    }

    public float getBubbleBarrageChargePitch() {
        return 1.0f / ((float)this.getBubbleBarrageWindup() / 20.0f);
    }

    @Override
    public float getSoundPitchFromByte(byte soundChoice) {
        if (soundChoice == 2) {
            return this.getBubbleBarrageChargePitch();
        }
        return super.getSoundPitchFromByte(soundChoice);
    }

    public int getBubbleBarrageRecoilTime() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.bubbleBarrageRecoilCooldown;
    }

    public void updateBubbleBarrage() {
        if (this.attackTimeDuring == -2 && this.getSelf() instanceof Player) {
            ((StandUser)this.self).roundabout$tryPower(3, true);
        } else if (this.attackTimeDuring > this.getBubbleBarrageLength()) {
            this.attackTimeDuring = -20;
        } else if (this.attackTimeDuring > 0) {
            this.setAttackTime(this.getBubbleBarrageRecoilTime() - 1 - Math.round((float)this.attackTimeDuring / (float)this.getBubbleBarrageLength() * (float)(this.getBubbleBarrageRecoilTime() - 1)));
            this.bubbleBarrageTick();
        }
    }

    public void bubbleBarrageTick() {
        if (!this.self.m_9236_().m_5776_()) {
            this.playBarrageMissNoise(this.attackTimeDuring);
            if (this.attackTimeDuring % 5 == 1) {
                this.generateGroundBubble();
            }
            if (this.activePower == 42 && this.attackTimeDuring == this.getBubbleBarrageLength()) {
                this.attackTimeDuring = -10;
                this.animateStand((byte)13);
            }
            this.findDeflectables();
        }
    }

    public int getBubbleBarrageLength() {
        return 20;
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        StandPowers powers = standUser.roundabout$getStandPowers();
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (standOn && this.getActivePower() == 42 && this.attackTimeDuring > -1) {
            int ClashTime = 15 - Math.round((float)this.attackTimeDuring / (float)this.getBubbleBarrageLength() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.getActivePower() == 43) {
            int ClashTime = Math.min(15, Math.round((float)this.attackTimeDuring / (float)maxSuperHitTime * 15.0f));
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.getActivePower() == 41) {
            int ClashTime = Math.round((float)this.attackTimeDuring / (float)this.getBubbleBarrageWindup() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else {
            super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
        }
    }

    @Override
    public boolean cancelItemUse() {
        return this.getActivePower() == 41 || this.getActivePower() == 42;
    }

    @Override
    public boolean canInterruptPower() {
        if (this.getActivePower() == 41) {
            return true;
        }
        return super.canInterruptPower();
    }

    @Override
    public boolean clickRelease() {
        return this.getActivePower() == 41 || this.getActivePower() == 42 || this.getActivePower() == 45;
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        StandUser SE;
        if (!this.getSelf().m_9236_().m_5776_() && effect.m_19557_() == 50 && !(SE = (StandUser)this.self).roundabout$isLaunchBubbleEncased()) {
            SE.roundabout$setStoredVelocity(new Vec3(0.0, 0.1, 0.0));
            if (this.self.m_6084_()) {
                SE.roundabout$setBubbleLaunchEncased();
            }
            if (SE instanceof Player && !this.self.m_9236_().f_46443_) {
                ((ServerPlayer)SE).m_5661_((Component)Component.m_237115_((String)"text.roundabout.launch_bubble_encased"), true);
            }
            Vec3 storedVec = SE.roundabout$getStoredVelocity();
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.WATER_ENCASE_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            MainUtil.takeLiteralUnresistableKnockbackWithY((Entity)this.self, storedVec.f_82479_, storedVec.f_82480_, storedVec.f_82481_);
        }
    }

    public void creeperSpawnBubble() {
        this.bubbleType = PlunderTypes.SOUND.id;
        SoftAndWetPlunderBubbleEntity bubble = this.getPlunderBubble();
        if (!this.onCooldown((byte)1) && bubble != null) {
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().softAndWetSettings.basicBubbleShotCooldown);
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)23);
            bubble.setPlunderType(this.bubbleType);
            bubble.setSingular(true);
            this.shootBubbleSpeed(bubble, 0.0f);
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().m_9236_().m_7967_((Entity)bubble);
            bubble.setBlockPos(this.self.m_20183_());
            bubble.setFloating();
        }
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (!(this.attackTimeDuring > -1 || !(this.getSelf().f_19789_ > 4.0f) || this.self instanceof FlyingMob || this.getSelf().m_20068_() || this.getSelf().f_19794_ || this.self instanceof EnderDragon || this.self instanceof WitherBoss || ((StandUser)this.getSelf()).roundabout$isBubbleEncased() || this.onCooldown((byte)8))) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BIG_BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
            ((StandUser)this.getSelf()).roundabout$setBubbleEncased((byte)1);
            this.setCooldown((byte)8, ClientNetworking.getAppropriateConfig().softAndWetSettings.encasementBubbleCreateCooldown);
            return;
        }
        if (attackTarget != null && attackTarget.m_6084_() && !this.isDazed(this.getSelf())) {
            double dist = attackTarget.m_20270_((Entity)this.getSelf());
            boolean isCreeper = this.getSelf() instanceof Creeper;
            if (!isCreeper) {
                Entity targetEntity;
                boolean isBasicMob;
                boolean bl = isBasicMob = this.self instanceof Zombie || this.self instanceof Spider || this.self instanceof Skeleton;
                this.bubbleType = this.self instanceof JojoNPC || this.self instanceof Villager || this.self instanceof Raider ? (Math.random() > 0.5 ? PlunderTypes.SIGHT.id : PlunderTypes.FRICTION.id) : (this.self instanceof Sheep ? PlunderTypes.POTION_EFFECTS.id : (isBasicMob ? PlunderTypes.SIGHT.id : PlunderTypes.FRICTION.id));
                if (this.bubbleMax < 10) {
                    if (dist <= 20.0 && this.activePower == 0 && !this.onCooldown((byte)1)) {
                        ((StandUser)this.getSelf()).roundabout$tryIntPower(23, true, this.bubbleType);
                        ++this.bubbleMax;
                        this.bubbleCd = 300;
                    }
                } else {
                    --this.bubbleCd;
                    if (this.bubbleCd <= 0) {
                        this.bubbleMax = 0;
                    }
                }
                if (dist <= 6.0 && (this.activePower == 0 || this.activePower == 1) && (targetEntity = this.getTargetEntity(this.self, -1.0f)) != null && targetEntity.m_7306_((Entity)attackTarget) && this.attackTimeDuring <= -1) {
                    double RNG = Math.random();
                    Objects.requireNonNull(this);
                    if (!(this.activePowerPhase >= 3 && this.attackTime < this.attackTimeMax || this.activePower != 0 && this.activePower != 1)) {
                        if (RNG < 0.5 && (this.self instanceof IronGolem || this.self instanceof Ravager || this.self instanceof Piglin || this.self instanceof AvdolNPC || this.self instanceof ZombifiedPiglin || this.self instanceof Hoglin || this.self instanceof PiglinBrute)) {
                            this.wentForCharge = false;
                            ((StandUser)this.getSelf()).roundabout$tryPower(43, true);
                        } else {
                            this.wentForCharge = false;
                            ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                        }
                    }
                }
            }
        }
    }

    public SoftAndWetPlunderBubbleEntity getPlunderBubble() {
        SoftAndWetPlunderBubbleEntity bubble = new SoftAndWetPlunderBubbleEntity(this.self, this.self.m_9236_());
        bubble.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
        bubble.setUser(this.self);
        bubble.m_5602_((Entity)this.self);
        bubble.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.primaryPlunderBubbleLifespanInTicks;
        return bubble;
    }

    public SoftAndWetItemLaunchingBubbleEntity getItemLaunchingBubble() {
        SoftAndWetItemLaunchingBubbleEntity bubble = new SoftAndWetItemLaunchingBubbleEntity(this.self, this.self.m_9236_());
        bubble.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
        bubble.setUser(this.self);
        bubble.m_5602_((Entity)this.self);
        bubble.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.primaryPlunderBubbleLifespanInTicks;
        return bubble;
    }

    public SoftAndWetExplosiveBubbleEntity getExplosiveBubble() {
        SoftAndWetExplosiveBubbleEntity bubble = new SoftAndWetExplosiveBubbleEntity(this.self, this.self.m_9236_());
        bubble.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
        bubble.setUser(this.self);
        bubble.m_5602_((Entity)this.self);
        bubble.lifeSpan = 400;
        return bubble;
    }

    public GoBeyondEntity getGoBeyondBubble() {
        GoBeyondEntity bubble = new GoBeyondEntity(this.self, this.self.m_9236_());
        bubble.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
        bubble.setUser(this.self);
        bubble.m_5602_((Entity)this.self);
        bubble.ticksUntilDamage = ClientNetworking.getAppropriateConfig().softAndWetSettings.goBeyondTicksUntilItCanHit;
        bubble.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.goBeyondLifespanInTicks;
        return bubble;
    }

    public boolean canShootExplosive(int useTicks) {
        return this.shootTicks + useTicks <= this.getMaxShootTicks();
    }

    public int pauseTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.heatTickDownPauseLength;
    }

    public int getPauseGrowthTicks() {
        return this.pauseGrowthTicks;
    }

    public boolean confirmShot(int useTicks) {
        if (this.canShootExplosive(useTicks)) {
            this.pauseGrowthTicks = this.pauseTicks();
            this.setGoBeyondChargeTicks(this.goBeyondChargeTicks + this.getGoBeyondUseTicks());
            this.setShootTicks(this.shootTicks + useTicks);
            return true;
        }
        return false;
    }

    public int getShootTicks() {
        return this.shootTicks;
    }

    public void setShootTicks(int shootTicks) {
        this.shootTicks = Mth.m_14045_((int)shootTicks, (int)0, (int)this.getMaxShootTicks());
    }

    public boolean getInExplosiveSpinMode() {
        return this.inExplosiveSpinMode;
    }

    public void setInExplosiveSpinMode(boolean mode) {
        this.inExplosiveSpinMode = mode;
    }

    public int getGoBeyondCharge() {
        return this.goBeyondChargeTicks;
    }

    public void setGoBeyondChargeTicks(int goBeyondChargeTicks) {
        this.goBeyondChargeTicks = Mth.m_14045_((int)goBeyondChargeTicks, (int)0, (int)this.getMaxGoBeyondChargeTicks());
        if (this.getInExplosiveSpinMode() && this.getGoBeyondCharge() == 0) {
            this.setInExplosiveSpinMode(false);
        }
        if (!this.getInExplosiveSpinMode() && this.getGoBeyondCharge() >= this.getMaxGoBeyondChargeTicks()) {
            if (this.self.m_9236_().m_5776_()) {
                this.self.m_5496_(ModSounds.EXPLOSIVE_SPIN_MODE_EVENT, 1.0f, 1.0f);
            }
            this.setInExplosiveSpinMode(true);
        }
    }

    @Override
    public void updateGoBeyondTarget() {
        if (this.canExecuteMoveWithLevel(this.getGoBeyondLevel())) {
            if (this.inShootingMode() && this.goBeyondCharged()) {
                Entity TE = MainUtil.getTargetEntity(this.self, 30.0f, 15);
                if (TE != null && !TE.m_7306_((Entity)this.self) && (!(TE instanceof StandEntity) || TE.m_6097_()) && MainUtil.isActuallyALivingEntityNoCap(TE)) {
                    this.setGoBeyondTarget(TE);
                }
            } else {
                this.setGoBeyondTarget(null);
            }
        } else {
            this.setGoBeyondTarget(null);
        }
    }

    public int getMaxShootTicks() {
        return 10000;
    }

    public int getMaxGoBeyondChargeTicks() {
        return 10000;
    }

    public float getExplosiveSpeed() {
        if (this.getInExplosiveSpinMode()) {
            return (float)((double)0.8f * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveBubbleShootSpeedMultiplier.intValue() * 0.01));
        }
        return (float)((double)0.54f * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveBubbleShootSpeedMultiplier.intValue() * 0.01));
    }

    public boolean inShootingMode() {
        return this.getStandUserSelf().roundabout$getCombatMode();
    }

    public boolean shootExplosiveBubble() {
        this.setCooldown((byte)3, 3);
        SoftAndWetExplosiveBubbleEntity bubble = this.getExplosiveBubble();
        if (bubble != null) {
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)33);
            this.shootExplosiveBubbleSpeed(bubble, this.getExplosiveSpeed());
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().m_9236_().m_7967_((Entity)bubble);
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.EXPLOSIVE_BUBBLE_SHOT_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean useWaterShield() {
        block11: {
            block13: {
                block12: {
                    isBucketSpawned = false;
                    var3_2 = this.self;
                    if (!(var3_2 instanceof Player)) break block11;
                    PL = (Player)var3_2;
                    stack = this.getSelf().m_21205_();
                    stack2 = this.getSelf().m_21206_();
                    if (stack.m_41619_() || !((var9_5 = stack.m_41720_()) instanceof PotionItem)) break block12;
                    PI = (PotionItem)var9_5;
                    if (PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) break block12;
                    if (!PL.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                        PL.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                    }
                    if (!PL.m_9236_().m_5776_()) {
                        this.splashWaterShield();
                    }
                    break block11;
                }
                if (stack.m_41619_() || !((var9_5 = stack.m_41720_()) instanceof BucketItem) || !((IBucketItem)(BI = (BucketItem)var9_5)).roundabout$getContents().m_205067_(FluidTags.f_13131_)) break block13;
                isBucketSpawned = true;
                if (!PL.m_9236_().m_5776_()) {
                    this.splashWaterShield();
                }
                break block11;
            }
            if (stack2.m_41619_() || !((var9_5 = stack2.m_41720_()) instanceof PotionItem)) ** GOTO lbl-1000
            PI2 = (PotionItem)var9_5;
            if (PotionUtils.m_43579_((ItemStack)stack2) == Potions.f_43599_) {
                if (!PL.m_150110_().f_35937_) {
                    stack2.m_41774_(1);
                    PL.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                }
                if (!PL.m_9236_().m_5776_()) {
                    this.splashWaterShield();
                }
            } else if (!stack2.m_41619_() && (var9_5 = stack2.m_41720_()) instanceof BucketItem && ((IBucketItem)(BI = (BucketItem)var9_5)).roundabout$getContents().m_205067_(FluidTags.f_13131_)) {
                isBucketSpawned = true;
                if (!PL.m_9236_().m_5776_()) {
                    this.splashWaterShield();
                }
            }
        }
        if (isBucketSpawned) {
            this.setCooldown((byte)7, ClientNetworking.getAppropriateConfig().softAndWetSettings.waterShieldBucketCooldown);
        } else {
            this.setCooldown((byte)7, ClientNetworking.getAppropriateConfig().softAndWetSettings.waterShieldCooldown);
        }
        return true;
    }

    public void splashWaterShield() {
        float width = this.self.m_20205_() * 0.5f;
        float height = this.self.m_20206_() * 0.5f;
        if (((StandUser)this.self).roundabout$isOnStandFire()) {
            ((StandUser)this.self).roundabout$setRemainingStandFireTicks(0);
        }
        ((StandUser)this.self).roundabout$setGasolineTime(-1);
        this.self.m_252836_();
        this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.WATER_ENCASE_EVENT, SoundSource.PLAYERS, 1.0f, (float)(1.5 + Math.random() * 0.04));
        Vec3 vec3 = new Vec3(0.0, (double)this.self.m_20206_() * 0.5, 0.0);
        Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != Direction.DOWN) {
            vec3 = RotationUtil.vecPlayerToWorld(vec3, direction);
        }
        ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49990_.m_49966_()), this.self.m_20185_() + vec3.f_82479_, this.self.m_20186_() + vec3.f_82480_, this.self.m_20189_() + vec3.f_82481_, 120, (double)width, (double)height, (double)width, 0.4);
        this.setWaterShieldTicks(ClientNetworking.getAppropriateConfig().softAndWetSettings.waterShieldDurationInTicks);
    }

    public boolean switchModes() {
        if (this.getStandUserSelf().roundabout$getCombatMode()) {
            this.getStandUserSelf().roundabout$setCombatMode(false);
            if (this.self.m_9236_().m_5776_()) {
                this.self.m_5496_(ModSounds.EXPLOSIVE_BUBBLE_SWITCH_OFF_EVENT, 1.0f, 1.0f);
            }
        } else {
            this.getStandUserSelf().roundabout$setCombatMode(true);
            if (this.self.m_9236_().m_5776_()) {
                this.self.m_5496_(ModSounds.EXPLOSIVE_BUBBLE_SWITCH_EVENT, 1.0f, 1.0f);
            }
        }
        return true;
    }

    public boolean goBeyond() {
        GoBeyondEntity bubble;
        if (!this.self.m_9236_().m_5776_() && this.goBeyondActiveTarget != null && (bubble = this.getGoBeyondBubble()) != null) {
            this.setCooldown((byte)1, 20);
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)23);
            bubble.setChasing(this.goBeyondActiveTarget);
            this.shootBubbleSpeed(bubble, 0.165f);
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().m_9236_().m_7967_((Entity)bubble);
            this.self.m_9236_().m_245803_((Entity)bubble, bubble.m_20183_(), ModSounds.GO_BEYOND_LAUNCH_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
            Vec3 vector = Vec3.m_82503_((Vec2)new Vec2(-52.0f, this.self.f_20883_ - 90.0f));
            Vec3 normvec = new Vec3(0.0, (double)(this.self.m_20192_() * 0.7f), 0.0);
            Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (direction != Direction.DOWN) {
                vector = RotationUtil.vecPlayerToWorld(vector, direction);
                normvec = RotationUtil.vecPlayerToWorld(normvec, direction);
            }
            for (int i = 0; i < 10; ++i) {
                double randomX = Math.random() * 0.5 - 0.25;
                double randomY = Math.random() * 0.5 - 0.25;
                double randomZ = Math.random() * 0.5 - 0.25;
                Vec3 xvec = vector.m_82520_(randomX, randomY, randomZ);
                byte sk = ((StandUser)this.getSelf()).roundabout$getStandSkin();
                if (sk == 10) {
                    ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.HEART_ATTACK_MINI, this.getSelf().m_20185_() + normvec.f_82479_, this.getSelf().m_20186_() + normvec.f_82480_, this.getSelf().m_20189_() + normvec.f_82481_, 0, xvec.f_82479_, xvec.f_82480_, xvec.f_82481_, 0.12);
                    continue;
                }
                ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.PURPLE_STAR, this.getSelf().m_20185_() + normvec.f_82479_, this.getSelf().m_20186_() + normvec.f_82480_, this.getSelf().m_20189_() + normvec.f_82481_, 0, xvec.f_82479_, xvec.f_82480_, xvec.f_82481_, 0.12);
            }
        }
        return true;
    }

    public boolean itemBubbleShot() {
        ItemStack stack = ((Player)this.getSelf()).m_150109_().m_8020_(this.grabInventorySlot);
        if (!(stack.m_41619_() || stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof ShulkerBoxBlock)) {
            SoftAndWetItemLaunchingBubbleEntity bubble;
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().softAndWetSettings.itemBubbleShotCooldown);
            if (!this.self.m_9236_().m_5776_() && (bubble = this.getItemLaunchingBubble()) != null) {
                bubble.setHeldItem(stack.m_255036_(1));
                stack.m_41774_(1);
                this.poseStand((byte)0);
                this.setAttackTimeDuring(-10);
                this.setActivePower((byte)35);
                this.addEXP(1);
                this.shootExplosiveItemBubbleSpeed(bubble, this.getExplosiveItemBubbleSpeed());
                this.bubbleListInit();
                this.bubbleList.add(bubble);
                this.getSelf().m_9236_().m_7967_((Entity)bubble);
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.EXPLOSIVE_BUBBLE_SHOT_EVENT, SoundSource.PLAYERS, 0.7f, (float)(1.2 + Math.random() * 0.04));
            }
        }
        return true;
    }

    public boolean bubbleShot() {
        SoftAndWetPlunderBubbleEntity bubble = this.getPlunderBubble();
        if (bubble != null) {
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().softAndWetSettings.basicBubbleShotCooldown);
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)23);
            bubble.setPlunderType(this.bubbleType);
            bubble.setSingular(true);
            this.shootBubbleSpeed(bubble, this.getBubbleSpeed());
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().m_9236_().m_7967_((Entity)bubble);
            if (this.bubbleType != PlunderTypes.SOUND.id) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
            }
        }
        return true;
    }

    public boolean canDoBubblePop() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (value instanceof SoftAndWetPlunderBubbleEntity && (PBE = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble()) continue;
                return true;
            }
        }
        return !this.bubbleList.isEmpty();
    }

    public boolean canDoBubbleClusterRedirect() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (PBE = (SoftAndWetPlunderBubbleEntity)value).getSingular() || PBE.getActivated() || PBE.getFinished()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDoBubbleClusterPop() {
        this.bubbleListInit();
        if (this.activePower == 22) {
            return true;
        }
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (PBE = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble() || PBE.getSingular() || PBE.getFinished()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDoBubbleRedirect() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!value.getActivated() || value instanceof SoftAndWetPlunderBubbleEntity && ((PBE = (SoftAndWetPlunderBubbleEntity)value).getPlunderType() == PlunderTypes.SIGHT.id || PBE.getPlunderType() == PlunderTypes.FRICTION.id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean clusterBubblePop() {
        this.bubbleListInit();
        if (!this.bubbleList.isEmpty()) {
            ArrayList<SoftAndWetBubbleEntity> bubbleList2;
            this.setCooldown((byte)5, 10);
            if (!this.self.m_9236_().m_5776_() && !(bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){}).isEmpty()) {
                for (SoftAndWetBubbleEntity value : bubbleList2) {
                    SoftAndWetPlunderBubbleEntity plunder;
                    if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (plunder = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble() || plunder.getFinished() || plunder.getSingular()) continue;
                    if (plunder.getPlunderType() == PlunderTypes.ITEM.id) {
                        plunder.forceDropItem();
                    }
                    plunder.popBubble();
                }
            }
        }
        return false;
    }

    public boolean bubblePop() {
        this.bubbleListInit();
        if (!this.self.m_9236_().m_5776_()) {
            ++this.bubbleNumber;
        }
        if (!this.bubbleList.isEmpty()) {
            ArrayList<SoftAndWetBubbleEntity> bubbleList2;
            this.setCooldown((byte)5, 20);
            if (!this.self.m_9236_().m_5776_() && !(bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){}).isEmpty()) {
                for (SoftAndWetBubbleEntity value : bubbleList2) {
                    SoftAndWetPlunderBubbleEntity plunder;
                    if (value instanceof SoftAndWetPlunderBubbleEntity && !(plunder = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble()) {
                        if (plunder.getFinished()) continue;
                        if (plunder.getPlunderType() == PlunderTypes.ITEM.id) {
                            plunder.forceDropItem();
                        }
                        plunder.popBubble();
                        continue;
                    }
                    if (value instanceof SoftAndWetExplosiveBubbleEntity) {
                        SoftAndWetExplosiveBubbleEntity SBE = (SoftAndWetExplosiveBubbleEntity)value;
                        SBE.popWithForce();
                        continue;
                    }
                    if (!(value instanceof SoftAndWetItemLaunchingBubbleEntity)) continue;
                    SoftAndWetItemLaunchingBubbleEntity GBE = (SoftAndWetItemLaunchingBubbleEntity)value;
                    GBE.popWithForce(this.savedPos);
                }
            }
        }
        return false;
    }

    public boolean bubbleClusterRedirect() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (PBE = (SoftAndWetPlunderBubbleEntity)value).getSingular() || PBE.getActivated() || PBE.getFinished()) continue;
                this.shootBubbleSpeed2(PBE, PBE.getSped() * 0.65f);
                PBE.setLaunched(true);
            }
        }
        return false;
    }

    public boolean bubbleRedirect() {
        this.bubbleListInit();
        if (!this.bubbleList.isEmpty() && this.canDoBubbleRedirect()) {
            this.setCooldown((byte)9, 3);
            if (!this.self.m_9236_().m_5776_()) {
                ArrayList<SoftAndWetBubbleEntity> bubbleList3;
                if (this.savedPos != null && !(bubbleList3 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){}).isEmpty()) {
                    int totalnumber = bubbleList3.size();
                    for (SoftAndWetBubbleEntity value : bubbleList3) {
                        SoftAndWetPlunderBubbleEntity PBE;
                        if (!value.getActivated() || value instanceof SoftAndWetPlunderBubbleEntity && ((PBE = (SoftAndWetPlunderBubbleEntity)value).getPlunderType() == PlunderTypes.SIGHT.id || PBE.getPlunderType() == PlunderTypes.FRICTION.id)) continue;
                        Vec3 vector = new Vec3(this.savedPos.m_7096_() - value.m_20185_(), this.savedPos.m_7098_() - value.m_20186_(), this.savedPos.m_7094_() - value.m_20189_()).m_82541_().m_82490_((double)value.getSped());
                        if (totalnumber > 1) {
                            vector = new Vec3(vector.m_7096_() + (Math.random() - 0.5) * (double)totalnumber * (double)value.getSped() * 0.03, vector.m_7098_(), vector.m_7094_() + (Math.random() - 0.5) * (double)totalnumber * (double)value.getSped() * 0.03).m_82541_().m_82490_((double)value.getSped());
                        }
                        value.m_20256_(vector);
                        value.f_19864_ = true;
                        value.f_19812_ = true;
                        if (value.getLaunched()) continue;
                        value.setLaunched(true);
                    }
                }
            } else if (this.savedPos != null) {
                this.self.m_5496_(ModSounds.BUBBLE_HOVERED_OVER_EVENT, 0.2f, (float)((double)0.95f + Math.random() * (double)0.1f));
                this.self.m_9236_().m_7106_((ParticleOptions)ModParticles.POINTER_SOFT, this.savedPos.m_7096_(), this.savedPos.m_7098_() + 0.5, this.savedPos.m_7094_(), 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    @Override
    public boolean hasShootingModeVisually() {
        return true;
    }

    public float getBubbleSpeed() {
        if (this.bubbleType == PlunderTypes.OXYGEN.id) {
            return 0.6f;
        }
        if (this.bubbleType == PlunderTypes.ITEM.id) {
            return 0.5f;
        }
        if (this.bubbleType == PlunderTypes.POTION_EFFECTS.id) {
            return 0.25f;
        }
        if (this.bubbleType == PlunderTypes.SOUND.id) {
            return 0.3f;
        }
        if (this.bubbleType == PlunderTypes.MOISTURE.id) {
            return 0.3f;
        }
        return 0.17f;
    }

    public float getExplosiveItemBubbleSpeed() {
        return 0.25f;
    }

    public void generateGroundBubble() {
        GroundBubbleEntity groundent = new GroundBubbleEntity(this.getSelf().m_9236_(), this.self);
        groundent.bubbleNo = this.bubbleNumber;
        Vec3 pos = MainUtil.getRaytracePointOnMobOrBlock((Entity)this.self, 2.5f);
        groundent.m_146884_(pos);
        groundent.setLifeSpan(120);
        float rando = (float)(Math.random() * (double)0.05f) - 0.025f;
        groundent.m_7910_(groundent.m_6113_() + rando);
        this.getSelf().m_9236_().m_7967_((Entity)groundent);
    }

    public void shootBubble(SoftAndWetBubbleEntity ankh) {
        this.shootBubbleSpeed(ankh, 1.01f);
    }

    public void shootExplosiveBubbleSpeed(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        Vec3 addToPosition = new Vec3(0.0, (double)(this.self.m_20192_() * 0.8f), 0.0);
        Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != Direction.DOWN) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        Vec3 pos = this.self.m_20318_(1.0f).m_82520_(addToPosition.f_82479_, addToPosition.f_82480_, addToPosition.f_82481_).m_82549_(this.self.m_20156_().m_82490_((double)(this.self.m_20205_() * 1.0f)));
        ankh.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        ankh.shootFromRotationDeltaAgnostic((Entity)this.getSelf(), this.getSelf().m_146909_(), this.getSelf().m_146908_(), 1.0f, speed, 0.0f);
    }

    public void shootExplosiveItemBubbleSpeed(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        Vec3 addToPosition = new Vec3(0.0, (double)(this.self.m_20192_() * 0.8f), 0.0);
        Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != Direction.DOWN) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        Vec3 pos = this.self.m_20318_(1.0f).m_82520_(addToPosition.f_82479_, addToPosition.f_82480_, addToPosition.f_82481_).m_82549_(this.self.m_20156_().m_82490_((double)(this.self.m_20205_() * 1.0f)));
        ankh.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        ankh.shootFromRotationDeltaAgnostic((Entity)this.getSelf(), this.getSelf().m_146909_(), this.getSelf().m_146908_(), 1.0f, speed, 0.0f);
    }

    public void shootBubbleSpeed(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        Vec3 addToPosition = new Vec3(0.0, (double)this.self.m_20192_() * 0.71, 0.0);
        Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != Direction.DOWN) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        ankh.m_6034_(this.self.m_20185_() + addToPosition.f_82479_, this.self.m_20186_() + addToPosition.f_82480_, this.self.m_20189_() + addToPosition.f_82481_);
        ankh.shootFromRotationDeltaAgnostic((Entity)this.getSelf(), this.getSelf().m_146909_(), this.getSelf().m_146908_(), 1.0f, speed, 0.0f);
    }

    public void shootBubbleSpeed2(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.shootFromRotationDeltaAgnostic3((Entity)this.getSelf(), this.getSelf().m_146909_(), this.getSelf().m_146908_(), 1.0f, speed);
    }

    public void shootBubbleRandomly(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        Vec3 addToPosition = new Vec3(0.0, (double)this.self.m_20192_() * 0.2, 0.0);
        Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != Direction.DOWN) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        ankh.m_6034_(this.self.m_20185_() + addToPosition.f_82479_, this.self.m_20186_() + addToPosition.f_82480_, this.self.m_20189_() + addToPosition.f_82481_);
        Vec2 yavec = new Vec2(-1.0f * (float)(Math.random() * 50.0), (float)(Math.random() * 360.0));
        if (direction != Direction.DOWN) {
            yavec = RotationUtil.rotPlayerToWorld(yavec.f_82471_, yavec.f_82470_, direction);
        }
        ankh.shootFromRotationDeltaAgnosticR((Entity)this.getSelf(), yavec.f_82470_, yavec.f_82471_, 1.0f, 0.25f, 0.0f);
    }

    public boolean setPowerBubbleBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)42);
        this.poseStand((byte)1);
        this.setAttackTimeMax(this.getBubbleBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.animateStand((byte)12);
        return true;
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 23) {
            return this.bubbleShot();
        }
        if (move == 35) {
            return this.itemBubbleShot();
        }
        if (move == 41) {
            return this.setPowerBubbleBarrageCharge();
        }
        if (move == 29) {
            return this.bubbleRedirect();
        }
        if (move == 24) {
            return this.bubblePop();
        }
        if (move == 42) {
            return this.setPowerBubbleBarrage();
        }
        if (move == 15) {
            return this.fallBraceInit();
        }
        if (move == 17) {
            return this.fallBrace();
        }
        if (move == 19) {
            return this.vault();
        }
        if (move == 27) {
            return this.switchModes();
        }
        if (move == 28) {
            return this.useWaterShield();
        }
        if (move == 33) {
            if (!this.self.m_9236_().m_5776_()) {
                this.setInExplosiveSpinMode(false);
            }
            return this.shootExplosiveBubble();
        }
        if (move == 37) {
            if (!this.self.m_9236_().m_5776_()) {
                this.setInExplosiveSpinMode(true);
            }
            return this.shootExplosiveBubble();
        }
        if (move == 25) {
            return this.bubbleLadder();
        }
        if (move == 31) {
            return this.bubbleLadderPlace();
        }
        if (move == 36) {
            return this.bigEncasementBubbleCreate();
        }
        if (move == 22) {
            return this.bubbleClusterStart();
        }
        if (move == 21) {
            return this.spawnRandomBubble();
        }
        if (move == 34) {
            return this.bubbleClusterRedirect();
        }
        if (move == 43) {
            return this.setPowerKickAttack();
        }
        if (move == 2) {
            return this.setPowerSuperHit();
        }
        if (move == 16) {
            return this.clusterBubblePop();
        }
        if (move == 11) {
            return this.goBeyond();
        }
        return super.setPowerOther(move, lastMove);
    }

    public boolean setPowerSuperHit() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)2);
        this.poseStand((byte)1);
        this.chargedFinal = Math.min(this.chargedFinal, maxSuperHitTime);
        if (this.chargedFinal >= maxSuperHitTime) {
            this.animateStand((byte)26);
        } else {
            this.animateStand((byte)25);
        }
        return true;
    }

    public boolean setPowerKickAttack() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)43);
        this.animateStand((byte)27);
        this.poseStand((byte)2);
        return true;
    }

    @Override
    public byte chooseBarrageSound() {
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 10) {
            return 0;
        }
        double rand = Math.random();
        if (rand > 0.5) {
            return 20;
        }
        return 21;
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 23 || move == 22) {
            this.bubbleType = (byte)chargeTime;
        } else if (move == 2) {
            this.chargedFinal = chargeTime;
        } else if (move == 11) {
            this.goBeyondActiveTarget = this.self.m_9236_().m_6815_(chargeTime);
        } else if (move == 35) {
            this.grabInventorySlot = chargeTime;
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    @Override
    public boolean cancelSprintJump() {
        if (this.getActivePower() == 22) {
            return true;
        }
        if (this.getActivePower() == 41 || this.getActivePower() == 42 || this.getActivePower() == 43) {
            return true;
        }
        return super.cancelSprintJump();
    }

    public void unlockSkin() {
        IPlayerEntity ipe;
        Player PE;
        StandUser user;
        ItemStack stack;
        Level lv = this.getSelf().m_9236_();
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player && !(stack = (user = (StandUser)(PE = (Player)livingEntity)).roundabout$getStandDisc()).m_41619_() && stack.m_150930_(ModItems.STAND_DISC_SOFT_AND_WET) && !(ipe = (IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !lv.m_5776_()) {
            ipe.roundabout$setUnlockedBonusSkin(true);
            lv.m_6263_(null, PE.m_20185_(), PE.m_20186_(), PE.m_20189_(), ModSounds.UNLOCK_SKIN_EVENT, PE.m_5720_(), 2.0f, 1.0f);
            ((ServerLevel)lv).m_8767_((ParticleOptions)ModParticles.HEART_ATTACK_MINI, PE.m_20185_(), PE.m_20186_() + (double)PE.m_20192_(), PE.m_20189_(), 10, 0.5, 0.5, 0.5, 0.2);
            user.roundabout$setStandSkin((byte)10);
            user.roundabout$summonStand(this.getSelf().m_9236_(), true, false);
            ((ServerPlayer)ipe).m_5661_((Component)Component.m_237115_((String)"unlock_skin.roundabout.soft_and_wet.kira"), true);
        }
    }

    public void playBubbleBarrageChargeSound() {
        SoundEvent barrageChargeSound;
        if (!this.self.m_9236_().m_5776_() && (barrageChargeSound = this.getBarrageChargeSound()) != null) {
            this.playSoundsIfNearby((byte)2, 27.0, false);
        }
    }

    public boolean setPowerBubbleBarrageCharge() {
        this.animateStand((byte)11);
        this.attackTimeDuring = 0;
        this.setActivePower((byte)41);
        this.poseStand((byte)1);
        this.playBubbleBarrageChargeSound();
        return true;
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.activePower == 41) {
            basis *= 0.5f;
        } else if (this.activePower == 22) {
            basis *= 0.2f;
        } else if (this.activePower == 43) {
            if (this.getSelf().m_6047_()) {
                float f = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)this.getSelf())), (float)0.0f, (float)1.0f);
                float g = 1.0f / f;
                basis *= g;
            }
            basis *= 0.6f;
        }
        return super.inputSpeedModifiers(basis);
    }

    public boolean bubbleClusterStart() {
        if (!this.self.m_9236_().m_5776_()) {
            this.clusterBubblePop();
        }
        this.setActivePower((byte)22);
        this.poseStand((byte)0);
        this.attackTimeDuring = 0;
        this.animateStand((byte)0);
        return true;
    }

    @Override
    public int getMaxGuardPoints() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetGuardPoints;
    }

    @Override
    public boolean tryBlockPosPower(int move, boolean forced, BlockPos blockPos) {
        return this.tryPower(move, forced);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, Vec3 pos) {
        this.savedPos = pos;
        return this.tryPower(move, forced);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (!(this.self.m_9236_().f_46443_ || this.getActivePower() != 41 && this.getActivePower() != 42 || move == 42 || move == 41 || move == 3)) {
            this.stopSoundsIfNearby((byte)100, 100.0, false);
        }
        return super.tryPower(move, forced);
    }

    public boolean bigEncasementBubbleCreate() {
        EncasementBubbleEntity encasement;
        this.setCooldown((byte)8, ClientNetworking.getAppropriateConfig().softAndWetSettings.encasementBubbleCreateCooldown);
        if (!this.self.m_9236_().m_5776_() && (encasement = (EncasementBubbleEntity)ModEntities.ENCASEMENT_BUBBLE.m_20615_(this.getSelf().m_9236_())) != null) {
            encasement.bubbleNo = this.bubbleNumber;
            Vec3 cvec = new Vec3(0.0, (double)(this.self.m_20192_() * 0.65f), 0.0);
            Direction gravD = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (gravD != Direction.DOWN) {
                cvec = RotationUtil.vecPlayerToWorld(cvec, gravD);
            }
            Vec3 movevec = this.self.m_20318_(1.0f).m_82520_(cvec.f_82479_, cvec.f_82480_, cvec.f_82481_).m_82549_(this.self.m_20156_().m_82490_((double)this.self.m_20205_() * 2.5));
            encasement.m_20248_(movevec.m_7096_(), movevec.m_7098_(), movevec.m_7094_());
            encasement.setUser(this.self);
            encasement.lifeSpan = 200;
            this.getSelf().m_9236_().m_7967_((Entity)encasement);
            this.addEXP(1);
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BIG_BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
        }
        return false;
    }

    @Override
    public void levelUp() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 7) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.max.both").m_130940_(ChatFormatting.AQUA), true);
            } else {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.both").m_130940_(ChatFormatting.AQUA), true);
            }
        }
        super.levelUp();
    }

    @Override
    public void updateMovesFromPacket(byte activePower) {
        if (activePower == 42) {
            Objects.requireNonNull(this);
            this.setActivePowerPhase((byte)3);
        }
        super.updateMovesFromPacket(activePower);
    }

    public boolean bubbleLadderPlace() {
        if (!this.self.m_9236_().m_5776_()) {
            Vec2 adjustedDir = new Vec2(this.self.m_6080_(), this.self.m_146909_());
            Direction gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (gravdir != Direction.DOWN) {
                adjustedDir = RotationUtil.rotPlayerToWorld(adjustedDir, gravdir);
            }
            this.buildingBubbleScaffoldPos = adjustedDir.f_82471_ > 35.0f ? this.buildingBubbleScaffoldPos.m_7495_() : (adjustedDir.f_82471_ < -35.0f ? this.buildingBubbleScaffoldPos.m_7494_() : this.buildingBubbleScaffoldPos.m_121945_(Direction.m_122364_((double)adjustedDir.f_82470_)));
            if (MainUtil.tryPlaceBlock((Entity)this.self, this.buildingBubbleScaffoldPos, false)) {
                boolean heartAttackState = ((StandUser)this.getSelf()).roundabout$getStandSkin() == 10;
                this.self.m_9236_().m_46597_(this.buildingBubbleScaffoldPos, (BlockState)ModBlocks.BUBBLE_SCAFFOLD.m_49966_().m_61124_((Property)BlockStateProperties.f_61360_, (Comparable)Boolean.valueOf(heartAttackState)));
                BlockEntity blockEntity = this.self.m_9236_().m_7702_(this.buildingBubbleScaffoldPos);
                if (blockEntity instanceof BubbleScaffoldBlockEntity) {
                    BubbleScaffoldBlockEntity SBE = (BubbleScaffoldBlockEntity)blockEntity;
                    SBE.standuser = this.self;
                    SBE.bubbleNo = this.bubbleNumber;
                    this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.9 + Math.random() * 0.2));
                    this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.9 + Math.random() * 0.2));
                    this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.9 + Math.random() * 0.2));
                    this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.9 + Math.random() * 0.2));
                }
            }
        }
        return false;
    }

    public boolean bubbleLadder() {
        this.setActivePower((byte)25);
        this.poseStand((byte)9);
        this.addEXP(1);
        this.attackTimeDuring = 0;
        this.bubbleScaffoldCount = 0;
        this.animateStand((byte)1);
        this.buildingBubbleScaffoldPos = this.self.m_20183_();
        if (this.self.m_9236_().m_8055_(this.self.m_20183_()).m_280296_()) {
            Direction gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            this.buildingBubbleScaffoldPos = this.buildingBubbleScaffoldPos.m_121945_(gravdir.m_122424_());
        }
        return true;
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 22) {
            this.updateBubbleCluster();
        } else if (this.getActivePower() == 42) {
            this.updateBubbleBarrage();
        } else if (this.getActivePower() == 41) {
            this.updateBubbleBarrageCharge();
        } else if (this.getActivePower() == 43) {
            this.updateKickAttackCharge();
        } else if (this.getActivePower() == 2) {
            this.updateKickAttack();
        } else if (this.getActivePower() == 25) {
            this.updateBubbleScaffold();
        }
        super.updateUniqueMoves();
    }

    public void updateBubbleBarrageCharge() {
        if (this.attackTimeDuring >= this.getBubbleBarrageWindup()) {
            ((StandUser)this.self).roundabout$tryPower(42, true);
        }
    }

    public void updateKickAttack() {
        if (this.attackTimeDuring > -1 && this.attackTimeDuring == 5) {
            this.encasementKick();
        }
    }

    @Override
    public float getBarrageDamagePlayer() {
        return 8.0f;
    }

    @Override
    public float getBarrageDamageMob() {
        return 18.0f;
    }

    @Override
    public float getBarrageHitStrength(Entity entity) {
        float str = super.getBarrageHitStrength(entity);
        if (str > 0.005f) {
            str = this.getReducedDamage(entity) ? (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnPlayers.intValue() * 0.01))) : (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnMobs.intValue() * 0.01)));
        }
        if (entity instanceof LivingEntity && str >= ((LivingEntity)entity).m_21223_() && ClientNetworking.getAppropriateConfig().generalStandSettings.barragesOnlyKillOnLastHit.booleanValue()) {
            str = entity instanceof Player ? 1.0E-5f : 0.0f;
        }
        return str;
    }

    @Override
    public float multiplyPowerByStandConfigPlayers(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnPlayers.intValue() * 0.01));
    }

    @Override
    public float multiplyPowerByStandConfigMobs(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnMobs.intValue() * 0.01));
    }

    public float multiplyPowerByStandConfigShooting(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetShootingModePower.intValue() * 0.01));
    }

    public float multiplyPowerByStandConfigGoBeyond(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetGoBeyondPower.intValue() * 0.01));
    }

    @Override
    public float getPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(1.45f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(4.0f));
    }

    @Override
    public float getHeavyPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(2.15f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(5.0f));
    }

    public float getExplosiveBubbleStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigShooting(this.multiplyPowerByStandConfigPlayers(1.35f)));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigShooting(this.multiplyPowerByStandConfigMobs(3.0f)));
    }

    public float getGoBeyondStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigGoBeyond(this.multiplyPowerByStandConfigPlayers(11.0f)));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigGoBeyond(this.multiplyPowerByStandConfigMobs(40.0f)));
    }

    public float getKickAttackKnockback() {
        return (float)this.chargedFinal / (float)maxSuperHitTime * 2.2f;
    }

    public float getKickAttackStrength(Entity entity) {
        float punchD = this.getPunchStrength(entity) * 1.8f + this.getHeavyPunchStrength(entity);
        if (this.chargedFinal >= maxSuperHitTime) {
            punchD *= 0.5f;
        }
        if (this.getReducedDamage(entity)) {
            return (float)this.chargedFinal / (float)maxSuperHitTime * punchD;
        }
        return (float)this.chargedFinal / (float)maxSuperHitTime * punchD + 1.0f;
    }

    public void kickAttackImpact(Entity entity) {
        SoundEvent SE;
        this.setAttackTimeDuring(-20);
        if (entity != null) {
            StandUser SE2;
            Player PE;
            LivingEntity LE;
            if (this.chargedFinal < maxSuperHitTime) {
                this.hitParticlesCenter(entity);
            }
            float pow = this.getKickAttackStrength(entity);
            float knockbackStrength = this.getKickAttackKnockback();
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (Entity)this.self)) {
                if (entity instanceof LivingEntity) {
                    LE = (LivingEntity)entity;
                    if (this.chargedFinal >= maxSuperHitTime) {
                        this.addEXP(5, LE);
                    } else {
                        this.addEXP(1, LE);
                    }
                }
                this.takeDeterminedKnockbackWithY(this.self, entity, knockbackStrength);
            } else if (this.chargedFinal >= maxSuperHitTime) {
                this.knockShield2(entity, this.getKickAttackKnockShieldTime());
            }
            if (!(!(entity instanceof LivingEntity) || (LE = (LivingEntity)entity) instanceof Player && (PE = (Player)LE).m_7500_() || this.chargedFinal < maxSuperHitTime || (SE2 = (StandUser)LE).roundabout$isLaunchBubbleEncased())) {
                float xRot = this.self.m_146909_();
                SE2.roundabout$setStoredVelocity(this.self.m_20156_().m_82541_().m_82490_(0.13).m_82520_(0.0, (double)0.033f, 0.0));
                if (LE.m_6084_()) {
                    SE2.roundabout$setBubbleLaunchEncased();
                }
                if (!this.self.m_9236_().m_5776_()) {
                    Vec3 $$2 = LE.m_20184_();
                    float $$4 = Mth.m_14107_((double)LE.m_20186_());
                    int $$8 = 0;
                    while ((float)$$8 < 1.0f + LE.m_20205_() * 20.0f) {
                        double $$9 = (LE.m_9236_().f_46441_.m_188500_() * 2.0 - 1.0) * (double)LE.m_20205_();
                        double $$10 = (LE.m_9236_().f_46441_.m_188500_() * 2.0 - 1.0) * (double)LE.m_20205_();
                        Vec3 vec3 = new Vec3($$9, 1.0, $$10);
                        Direction direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
                        if (direction != Direction.DOWN) {
                            vec3 = RotationUtil.vecPlayerToWorld(vec3, direction);
                        }
                        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123769_, LE.m_20185_() + vec3.f_82479_, (double)$$4 + vec3.f_82480_, LE.m_20189_() + vec3.f_82481_, 30, $$2.f_82479_, $$2.f_82480_, $$2.f_82481_, 0.4);
                        ++$$8;
                    }
                }
                if (SE2 instanceof Player && !this.self.m_9236_().f_46443_) {
                    ((ServerPlayer)SE2).m_5661_((Component)Component.m_237115_((String)"text.roundabout.launch_bubble_encased"), true);
                }
                Vec3 storedVec = SE2.roundabout$getStoredVelocity();
                MainUtil.takeLiteralUnresistableKnockbackWithY((Entity)LE, storedVec.f_82479_, storedVec.f_82480_, storedVec.f_82481_);
            }
            int fireCount = 50;
            float firespeed = 0.05f;
            if (this.chargedFinal >= maxSuperHitTime) {
                fireCount = 100;
                firespeed = 0.1f;
            }
        } else {
            float distMax = this.getDistanceOut(this.self, this.getReach(), false);
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
            if (!this.self.m_9236_().f_46443_) {
                ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.PUNCH_MISS, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
        float pitch = 1.0f;
        if (entity != null) {
            SE = this.getKickAttackSound();
            pitch = 1.2f;
        } else {
            SE = ModSounds.PUNCH_2_SOUND_EVENT;
        }
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), SE, SoundSource.PLAYERS, 0.95f, pitch);
            if (this.chargedFinal >= maxSuperHitTime && entity instanceof LivingEntity) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.WATER_ENCASE_EVENT, SoundSource.PLAYERS, 1.0f, pitch);
            }
        }
    }

    @Override
    public void handleStandAttack(Player player, Entity target) {
        if (this.getActivePower() == 2) {
            this.kickAttackImpact(target);
        }
    }

    public SoundEvent getKickAttackSound() {
        return ModSounds.SOFT_AND_WET_KICK_EVENT;
    }

    public int getKickAttackKnockShieldTime() {
        return 40;
    }

    public void encasementKick() {
        if (this.chargedFinal >= maxSuperHitTime) {
            this.setAttackTimeMax((int)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.kickMinimumCooldown.intValue() + (double)this.chargedFinal * 1.5));
        } else {
            this.setAttackTimeMax(ClientNetworking.getAppropriateConfig().softAndWetSettings.kickMinimumCooldown + this.chargedFinal);
        }
        this.setAttackTime(0);
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        if (this.self instanceof Player) {
            if (this.isPacketPlayer()) {
                this.attackTimeDuring = -10;
                C2SPacketUtil.intToServerPacket((byte)4, this.getTargetEntityId());
            }
        } else {
            Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
            this.kickAttackImpact(targetEntity);
        }
    }

    public void updateKickAttackCharge() {
        if (this.attackTimeDuring > -1 && this.attackTimeDuring >= maxSuperHitTime && (!(this.getSelf() instanceof Player) || this.self.m_9236_().m_5776_() && this.isPacketPlayer())) {
            int atd = this.getAttackTimeDuring();
            ((StandUser)this.getSelf()).roundabout$tryIntPower(2, true, maxSuperHitTime);
            if (this.self.m_9236_().m_5776_()) {
                this.tryIntPowerPacket((byte)2, atd);
            }
        }
    }

    public void updateBubbleScaffold() {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            if (this.self.m_9236_().m_5776_() && this.isPacketPlayer() && this.attackTimeDuring % 6 == 2) {
                this.tryPowerPacket((byte)31);
                ++this.bubbleScaffoldCount;
                this.setCooldown((byte)2, ClientNetworking.getAppropriateConfig().softAndWetSettings.bubbleScaffoldingCooldown);
                if (this.bubbleScaffoldCount >= 10) {
                    this.tryPower(0, true);
                    this.tryPowerPacket((byte)0);
                }
            }
        }
    }

    public void updateBubbleCluster() {
        if (this.self instanceof Player) {
            if (this.isPacketPlayer()) {
                this.bubbleCheck(true);
            }
        } else {
            this.bubbleCheck(false);
        }
    }

    public void bubbleCheck(boolean packetPlayer) {
        if (this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > 37) {
                this.tryPower(0, true);
                if (packetPlayer) {
                    this.tryPowerPacket((byte)0);
                }
            } else if (this.attackTimeDuring % 3 == 0) {
                if (packetPlayer) {
                    this.tryPowerPacket((byte)21);
                } else {
                    this.spawnRandomBubble();
                }
            }
        }
    }

    public boolean spawnRandomBubble() {
        SoftAndWetPlunderBubbleEntity bubble = this.getPlunderBubble();
        if (bubble != null) {
            bubble.setPlunderType(this.bubbleType);
            bubble.setSingular(false);
            this.shootBubbleRandomly(bubble, this.getBubbleSpeed());
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().m_9236_().m_7967_((Entity)bubble);
            if (this.bubbleType != PlunderTypes.SOUND.id) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.BUBBLE_CREATE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
            }
        }
        return true;
    }

    public void unloadBubbles() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                if (!value.m_213877_() && value.m_6084_() && (!this.self.m_9236_().m_5776_() || this.self.m_9236_().m_6815_(value.m_19879_()) != null)) continue;
                this.bubbleList.remove(value);
            }
        }
    }

    public int getLowerTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.heatTickDownRate;
    }

    public int getLowerGoBeyondTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveSpinMeterTickDownRate;
    }

    public int getLowerExplosiveSpinTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveSpinModeTickDownRate;
    }

    @Override
    public void tickPower() {
        Player PE;
        IPlayerEntity ipe;
        int pt;
        LivingEntity livingEntity;
        this.unloadBubbles();
        this.tickWaterShield();
        if (this.self.m_9236_().m_5776_() && (livingEntity = this.self) instanceof Player && (pt = (ipe = (IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getBubbleShotAimPoints()) > 0) {
            ipe.roundabout$setBubbleShotAimPoints(--pt);
        }
        if ((livingEntity = this.self) instanceof Player && (PE = (Player)livingEntity).m_7500_()) {
            this.setShootTicks(0);
        } else if (this.getPauseGrowthTicks() > 0) {
            --this.pauseGrowthTicks;
        } else if (this.getShootTicks() > 0) {
            this.setShootTicks(this.getShootTicks() - this.getLowerTicks());
        }
        livingEntity = this.self;
        if (livingEntity instanceof Player && (PE = (Player)livingEntity).m_7500_()) {
            if (this.getGoBeyondCharge() > 0) {
                this.setGoBeyondChargeTicks(0);
            }
        } else if (this.getGoBeyondCharge() > 0) {
            if (this.getInExplosiveSpinMode()) {
                this.setGoBeyondChargeTicks(this.getGoBeyondCharge() - this.getLowerExplosiveSpinTicks());
            } else {
                this.setGoBeyondChargeTicks(this.getGoBeyondCharge() - this.getLowerGoBeyondTicks());
            }
        }
        super.tickPower();
    }

    public Vec3 BubbleRandomPos() {
        float r1 = (float)(Math.random() * 1.0 - 0.5);
        float r2 = (float)(Math.random() * 0.4 - (double)0.2f);
        float r3 = (float)(Math.random() * 1.0 - 0.5);
        return this.self.m_146892_().m_82520_((double)r1, (double)r2, (double)r3);
    }

    @Override
    public boolean dealWithProjectile(Entity ent, HitResult res) {
        if (!ent.m_9236_().m_5776_() && this.hasWaterShield()) {
            SoftAndWetItemLaunchingBubbleEntity bubble;
            ThrownPotion TP;
            ItemStack ii;
            boolean success = false;
            if (ent instanceof AbstractArrow) {
                SoftAndWetItemLaunchingBubbleEntity bubble2;
                AbstractArrow AA = (AbstractArrow)ent;
                ItemStack ii2 = ((IAbstractArrowAccess)ent).roundabout$GetPickupItem();
                if (!ii2.m_41619_() && !ii2.m_41763_() && (bubble2 = this.getItemLaunchingBubble()) != null) {
                    success = true;
                    if (!AA.f_36705_.equals((Object)AbstractArrow.Pickup.ALLOWED)) {
                        bubble2.canGiveYouItem = false;
                    }
                    bubble2.setHeldItem(ii2.m_278832_());
                    bubble2.m_146884_(this.BubbleRandomPos());
                    this.bubbleListInit();
                    this.bubbleList.add(bubble2);
                    this.getSelf().m_9236_().m_7967_((Entity)bubble2);
                }
            } else if (ent instanceof ThrownObjectEntity) {
                SoftAndWetItemLaunchingBubbleEntity bubble3;
                ThrownObjectEntity TO = (ThrownObjectEntity)ent;
                ItemStack ii3 = TO.m_7846_();
                if (!ii3.m_41619_() && (bubble3 = this.getItemLaunchingBubble()) != null) {
                    success = true;
                    if (!TO.places) {
                        bubble3.canGiveYouItem = false;
                    }
                    bubble3.setHeldItem(ii3.m_278832_());
                    bubble3.m_146884_(this.BubbleRandomPos());
                    this.bubbleListInit();
                    this.bubbleList.add(bubble3);
                    this.getSelf().m_9236_().m_7967_((Entity)bubble3);
                }
            } else if (ent instanceof ThrownPotion && !(ii = (TP = (ThrownPotion)ent).m_7846_()).m_41619_() && (bubble = this.getItemLaunchingBubble()) != null) {
                success = true;
                if (TP.m_19749_() != null && !(TP.m_19749_() instanceof Player)) {
                    bubble.canGiveYouItem = false;
                }
                bubble.setHeldItem(ii.m_278832_());
                bubble.m_146884_(this.BubbleRandomPos());
                this.bubbleListInit();
                this.bubbleList.add(bubble);
                this.getSelf().m_9236_().m_7967_((Entity)bubble);
            }
            if (success) {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_PLUNDER_EVENT, SoundSource.PLAYERS, 1.7f, 1.8f);
                return true;
            }
        }
        return false;
    }

    public boolean waterShieldBlockProjectile(Projectile projectile) {
        return true;
    }

    public boolean canDoBubbleItemLaunch() {
        ItemStack stack = this.getSelf().m_21205_();
        return !stack.m_41619_();
    }

    @Override
    public void playFallBraceImpactParticles() {
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, this.getSelf().m_20185_(), (double)this.getSelf().m_20097_().m_123342_() + 1.1, this.getSelf().m_20189_(), 50, 1.1, 0.05, 1.1, 0.4);
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, this.getSelf().m_20185_(), (double)this.getSelf().m_20097_().m_123342_() + 1.1, this.getSelf().m_20189_(), 30, 1.0, 0.05, 1.0, 0.4);
    }

    @Override
    public void playFallBraceInitSound() {
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.SUMMON_SOFT_AND_WET_EVENT, SoundSource.PLAYERS, 2.3f, (float)(0.78 + Math.random() * 0.04));
    }

    @Override
    public void playFallBraceImpactSounds() {
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
    }

    public boolean canBridge() {
        Player PE;
        LivingEntity livingEntity;
        return this.self.m_20096_() && !this.self.m_20069_() || this.self.m_6147_() || (livingEntity = this.self) instanceof Player && (PE = (Player)livingEntity).m_7500_();
    }

    public boolean canBigBubble() {
        Player PE;
        LivingEntity livingEntity;
        return this.self.m_20096_() || this.self.m_20069_() || this.self.m_6147_() || (livingEntity = this.self) instanceof Player && (PE = (Player)livingEntity).m_7500_();
    }

    @Override
    public Component getSkinName(byte skinId) {
        return switch (skinId) {
            case 1 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.base");
            case 4 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.beta");
            case 3 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.king");
            case 5 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.drowned");
            case 6 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.drowned_2");
            case 7 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.figure");
            case 8 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.striped");
            case 9 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.debut");
            case 11 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.colors");
            case 10 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.kira");
            case 12 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.green");
            case 13 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.knight");
            case 17 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.melon");
            case 14 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.morioh");
            case 15 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.art");
            case 16 -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.nature");
            default -> Component.m_237115_((String)"skins.roundabout.soft_and_wet.light");
        };
    }
}

