/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IAbstractFurnaceBlockEntity;
import net.hydra.jojomod.access.IAbstractFurnaceMenu;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.IPlayerEntityServer;
import net.hydra.jojomod.block.BarbedWireBundleBlock;
import net.hydra.jojomod.block.FleshBlock;
import net.hydra.jojomod.block.GasolineBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.block.StereoBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.gui.FogInventoryMenu;
import net.hydra.jojomod.client.gui.PowerInventoryMenu;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.corpses.FallenPhantom;
import net.hydra.jojomod.entity.npcs.Aesthetician;
import net.hydra.jojomod.entity.projectile.GasolineCanEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetPlunderBubbleEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.stand.StarPlatinumEntity;
import net.hydra.jojomod.entity.substand.EncasementBubbleEntity;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.VisageStoreEntry;
import net.hydra.jojomod.item.FogBlockItem;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandArrowItem;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersJustice;
import net.hydra.jojomod.stand.powers.PowersWalkingHeart;
import net.hydra.jojomod.util.Networking;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.FrogspawnBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.zetalasis.networking.message.api.ModMessageEvents;

public class MainUtil {
    public static boolean isClient = false;
    public static ArrayList<String> walkableBlocks = Lists.newArrayList();
    public static ArrayList<String> standBlockGrabBlacklist = Lists.newArrayList();
    public static ArrayList<String> naturalStandUserMobBlacklist = Lists.newArrayList();
    public static final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(20.0);
    public static final TargetingConditions followTargetting = TargetingConditions.m_148352_().m_26883_(50.0);
    public static final TargetingConditions plsWorkTargetting = TargetingConditions.m_148352_().m_26883_(20.0).m_26893_();
    public static final TargetingConditions OFFER_TARGER_CONTEXT = TargetingConditions.m_148353_().m_26883_(64.0);

    public static boolean isClient() {
        return isClient;
    }

    public static void setClient() {
        isClient = true;
    }

    public static boolean isMeleeDamage(DamageSource di) {
        return di.m_276093_(DamageTypes.f_268464_) || di.m_276093_(DamageTypes.f_268566_);
    }

    public static boolean isZapper(LivingEntity ent1, Entity ent2) {
        Entity ent;
        StandUser standComp;
        int zappedId;
        return ent1 != null && ent2 != null && (zappedId = (standComp = (StandUser)ent1).roundabout$getZappedToID()) > -1 && (ent = ent2.m_9236_().m_6815_(zappedId)) != null && ent.m_7306_(ent2);
    }

    public static boolean isBlockBlacklisted(BlockState bs) {
        ResourceLocation rl = BuiltInRegistries.f_256975_.m_7981_((Object)bs.m_60734_());
        return standBlockGrabBlacklist != null && !standBlockGrabBlacklist.isEmpty() && rl != null && standBlockGrabBlacklist.contains(rl.toString());
    }

    public static boolean isMobStandUserBlacklisted(Entity ent) {
        ResourceLocation rl = BuiltInRegistries.f_256780_.m_7981_((Object)ent.m_6095_());
        return naturalStandUserMobBlacklist != null && !naturalStandUserMobBlacklist.isEmpty() && rl != null && naturalStandUserMobBlacklist.contains(rl.toString());
    }

    public static boolean isBlockWalkable(BlockState bs) {
        if (!bs.m_280296_()) {
            return false;
        }
        ResourceLocation rl = BuiltInRegistries.f_256975_.m_7981_((Object)bs.m_60734_());
        return walkableBlocks == null || walkableBlocks.isEmpty() || rl == null || !walkableBlocks.contains(rl.toString());
    }

    public static boolean isBlockWalkableSimplified(BlockState bs) {
        ResourceLocation rl = BuiltInRegistries.f_256975_.m_7981_((Object)bs.m_60734_());
        return walkableBlocks == null || walkableBlocks.isEmpty() || rl == null || !walkableBlocks.contains(rl.toString());
    }

    public static boolean isKnockbackImmune(Entity ent) {
        Mob mb;
        PowersWalkingHeart PW;
        LivingEntity LE;
        StandUser SU;
        StandPowers standPowers;
        return ent instanceof LivingEntity && (standPowers = (SU = (StandUser)(LE = (LivingEntity)ent)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && ((PW = (PowersWalkingHeart)standPowers).hasExtendedHeelsForWalking() || SU.roundabout$getActive() && ent instanceof Mob && (mb = (Mob)ent).m_20096_());
    }

    public static Direction getDirectionFromByte(byte bt) {
        switch (bt) {
            case 1: {
                return Direction.NORTH;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.EAST;
            }
            case 4: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.UP;
            }
        }
        return Direction.DOWN;
    }

    public static byte getByteFromDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case UP: {
                return 5;
            }
        }
        return 0;
    }

    public static int maxGasTicks() {
        return 200;
    }

    public static int maxBucketGasTicks() {
        return 200;
    }

    public static int maxLeapTicks() {
        return 60;
    }

    public static float controlledLerp(float delta, float start, float end, float multiplier) {
        delta = Math.min(delta, 1.0f);
        return start + delta * (end - start) * multiplier;
    }

    public static List<Entity> getEntitiesInRange(Level level, BlockPos center, double range) {
        return MainUtil.getEntitiesInRange(level, center, range, null);
    }

    public static List<Entity> getEntitiesInRange(Level level, BlockPos center, double range, @Nullable Entity exception) {
        AABB area = new AABB((double)center.m_123341_() - range, (double)center.m_123342_() - range, (double)center.m_123343_() - range, (double)center.m_123341_() + range, (double)center.m_123342_() + range, (double)center.m_123343_() + range);
        return level.m_45933_(exception, area);
    }

    public static final void spreadRadialClientPacket(Entity entity, double range, boolean skipSelf, String packet, Object ... vargs) {
        if (!entity.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)entity.m_9236_();
            Vec3 userLocation = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)entity.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || skipSelf && entity.m_7306_((Entity)serverPlayerEntity) || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                ModMessageEvents.sendToPlayer(serverPlayerEntity, packet, vargs);
            }
        }
    }

    public static final void spreadRadialClientPacket(Level level, BlockPos pos, double range, String packet, Object ... vargs) {
        if (!level.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 userLocation = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)level).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                ModMessageEvents.sendToPlayer(serverPlayerEntity, packet, vargs);
            }
        }
    }

    public static boolean isCreativeOrInvincible(Entity ent) {
        Player PL;
        return ent != null && (ent.m_20147_() || ent instanceof Player && (PL = (Player)ent).m_7500_());
    }

    public static boolean getEntityIsTrulyInvisible(Entity ent) {
        if (ent != null) {
            IEntityAndData entityAndData = (IEntityAndData)ent;
            return entityAndData.roundabout$getTrueInvisibility() > -1;
        }
        return false;
    }

    public static int getEntityTrulyInvisibleTicks(Entity ent) {
        if (ent != null) {
            IEntityAndData entityAndData = (IEntityAndData)ent;
            return entityAndData.roundabout$getTrueInvisibility();
        }
        return -1;
    }

    public static boolean isMobOrItsMounts(Entity ent, Entity checkAgaist) {
        if (ent != null && checkAgaist != null) {
            LivingEntity LE;
            StandUser user;
            StandEntity st;
            if (ent.m_7306_(checkAgaist)) {
                return true;
            }
            if (ent.m_20363_(checkAgaist)) {
                return true;
            }
            if (checkAgaist.m_20363_(ent)) {
                return true;
            }
            if (checkAgaist instanceof LivingEntity && (st = (user = (StandUser)(LE = (LivingEntity)checkAgaist)).roundabout$getStand()) != null && st.m_7306_(ent)) {
                return true;
            }
            if (ent instanceof LivingEntity && (st = (user = (StandUser)(LE = (LivingEntity)ent)).roundabout$getStand()) != null && st.m_7306_(checkAgaist)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDreadBook(ItemStack stack) {
        Component name;
        String str;
        return stack != null && !stack.m_41619_() && stack.m_150930_(Items.f_42517_) && ("cha'garoth".equals(str = (name = stack.m_41786_()).getString().toLowerCase()) || "chagaroth".equals(str) || "dreadbeast".equals(str));
    }

    public static float controlledLerpAngleDegrees(float delta, float start, float end, float multiplier) {
        delta = Math.min(delta, 1.0f);
        return start + delta * Mth.m_14177_((float)(end - start)) * multiplier;
    }

    public static float controlledLerpRadianDegrees(float delta, float start, float end, float multiplier) {
        delta = Math.min(delta, 1.0f);
        return start + delta * MainUtil.wrapRadians(end - start) * multiplier;
    }

    public static double getWorthyOdds(Mob mob) {
        if (MainUtil.isBossMob((LivingEntity)mob) && !ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.bossMobsCanNaturallyHaveStands.booleanValue() || mob instanceof JojoNPC || MainUtil.isMobStandUserBlacklisted((Entity)mob)) {
            return 0.0;
        }
        return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.worthyMobOdds.floatValue();
    }

    public static boolean getIfMobIsAttacking(Mob mb) {
        for (WrappedGoal wrappedGoal : ((IMob)mb).roundabout$getGoalSelector().m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof PanicGoal) || !wrappedGoal.m_7620_()) continue;
            return false;
        }
        return true;
    }

    public static double getStandUserOdds(Mob mob) {
        if (MainUtil.isBossMob((LivingEntity)mob) && !ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.bossMobsCanNaturallyHaveStands.booleanValue() || mob instanceof JojoNPC || MainUtil.isMobStandUserBlacklisted((Entity)mob)) {
            return 0.0;
        }
        if (mob instanceof AbstractVillager) {
            return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.standUserVillagerOdds.floatValue();
        }
        return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.standUserOdds.floatValue();
    }

    public static double getWorthyBreedBonus(Mob mob) {
        if (mob instanceof AbstractVillager) {
            return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.userAndWorthyBreedingOddsBonus.floatValue() * (float)ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.multiplyAboveForVillagerBreeding.intValue();
        }
        return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.userAndWorthyBreedingOddsBonus.floatValue();
    }

    public static double getStandUserBreedBonus(Mob mob) {
        if (mob instanceof AbstractVillager) {
            return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.userAndWorthyBreedingOddsBonus.floatValue() * (float)ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.multiplyAboveForVillagerBreeding.intValue();
        }
        return ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.userAndWorthyBreedingOddsBonus.floatValue();
    }

    public static boolean isHumanoid(LivingEntity LE) {
        return LE instanceof Zombie || LE instanceof AbstractSkeleton || LE instanceof Player || LE instanceof Piglin || LE instanceof JojoNPC;
    }

    public static LivingEntity homeOnWorthy(Level level, Vec3 vec3, double range) {
        List<Entity> EntitiesInRange = MainUtil.genHitbox(level, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, range, range, range);
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(EntitiesInRange){};
        LivingEntity mm = null;
        double distance = -1.0;
        for (Entity value : hitEntities) {
            LivingEntity mb;
            if (!(value instanceof LivingEntity) || !MainUtil.canGrantStand((Entity)(mb = (LivingEntity)value)) || distance != -1.0 && !(mb.m_20238_(vec3) < distance)) continue;
            mm = mb;
            distance = mb.m_20238_(vec3);
        }
        return mm;
    }

    public static ItemStack saveToDiscData(LivingEntity ent, ItemStack stack) {
        if (ent instanceof Player) {
            Player PE = (Player)ent;
            if (!(stack.m_41720_() instanceof MaxStandDiscItem)) {
                IPlayerEntity IPE = (IPlayerEntity)PE;
                Item item = stack.m_41720_();
                if (item instanceof StandDiscItem) {
                    StandDiscItem SD = (StandDiscItem)item;
                    if (!SD.standPowers.isSecondaryStand()) {
                        stack.m_41698_("Memory").m_128344_("Level", (byte)Math.max(IPE.roundabout$getStandLevel() - 1, 0));
                        stack.m_41698_("Memory").m_128405_("Experience", IPE.roundabout$getStandExp());
                        stack.m_41698_("Memory").m_128379_("BonusSkin", IPE.roundabout$getUnlockedBonusSkin());
                    }
                }
            }
        }
        stack.m_41698_("Memory").m_128344_("Skin", ((StandUser)ent).roundabout$getStandSkin());
        stack.m_41698_("Memory").m_128344_("Pose", ((StandUser)ent).roundabout$getIdlePos());
        return stack;
    }

    public static void handleChangeItem(Player player, byte context, ItemStack stack) {
        if (context == 4 || context == 5) {
            boolean offh = ItemStack.m_150942_((ItemStack)player.m_21206_(), (ItemStack)stack);
            if ((player.m_150109_().m_36063_(stack) || offh) && stack.m_41720_() instanceof StandArrowItem) {
                StandArrowItem.rerollStand(player, offh, stack, context);
            }
        }
    }

    public static void handleSetCreativeModeSlot(Player player, int integer, ItemStack stack, byte context) {
        if (context == 1 && ClientNetworking.getAppropriateConfig().justiceSettings.enableFogBlockInventory.booleanValue()) {
            boolean flag2;
            StandUser user = (StandUser)player;
            ServerPlayer sp = (ServerPlayer)player;
            boolean flag = integer < 0;
            ItemStack itemstack = stack;
            if (!itemstack.m_246617_(player.m_9236_().m_246046_())) {
                return;
            }
            if (stack == null || stack.m_41619_() || stack.m_41720_() instanceof AirItem) {
                return;
            }
            if (!(stack.m_41720_() instanceof FogBlockItem)) {
                Roundabout.LOGGER.warn("Attempted to give player {} item {}, but they failed the check! Justice User: {}", new Object[]{player.m_7755_().getString(), BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()), user.roundabout$getStandPowers() instanceof PowersJustice});
                return;
            }
            CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)itemstack);
            if (!itemstack.m_41619_() && compoundtag != null && compoundtag.m_128441_("x") && compoundtag.m_128441_("y") && compoundtag.m_128441_("z")) {
                BlockEntity blockentity;
                BlockPos blockpos = BlockEntity.m_187472_((CompoundTag)compoundtag);
                if (player.m_9236_().m_46749_(blockpos) && (blockentity = player.m_9236_().m_7702_(blockpos)) != null) {
                    blockentity.m_187476_(itemstack);
                }
            }
            boolean flag1 = integer >= 1 && integer <= 45;
            boolean bl = flag2 = itemstack.m_41619_() || itemstack.m_41773_() >= 0 && itemstack.m_41613_() <= 64 && !itemstack.m_41619_();
            if (flag1 && flag2) {
                player.f_36095_.m_38853_(integer).m_269060_(itemstack);
                player.f_36095_.m_38946_();
            } else if (flag && flag2) {
                player.m_36176_(itemstack, true);
            }
        }
    }

    public static boolean isWearingStoneMask(Entity ent) {
        LivingEntity LE;
        ItemStack stack;
        if (ent instanceof LivingEntity && (stack = (LE = (LivingEntity)ent).m_6844_(EquipmentSlot.HEAD)) != null && !stack.m_41619_()) {
            return stack.m_150930_(ModBlocks.EQUIPPABLE_STONE_MASK_BLOCK.m_5456_());
        }
        return false;
    }

    public static boolean confirmIsOre(BlockState state) {
        return state.m_204336_(ModPacketHandler.PLATFORM_ACCESS.getOreTag()) || state.m_60713_(Blocks.f_50722_);
    }

    public static void extractDiscData(LivingEntity ent, StandDiscItem SD, ItemStack stack) {
        StandUser user = (StandUser)ent;
        CompoundTag $$4 = stack.m_41737_("Memory");
        if ($$4 != null) {
            if (SD instanceof MaxStandDiscItem) {
                if (ent instanceof Player) {
                    PE = (Player)ent;
                    IPlayerEntity IPE = (IPlayerEntity)PE;
                    IPE.roundabout$setStandLevel(SD.standPowers.getMaxLevel());
                }
            } else if (ent instanceof Player) {
                PE = (Player)ent;
                IPlayerEntity IPE = (IPlayerEntity)PE;
                if ($$4.m_128441_("Level")) {
                    byte lvl = (byte)($$4.m_128445_("Level") + 1);
                    lvl = (byte)Mth.m_14045_((int)lvl, (int)1, (int)SD.standPowers.getMaxLevel());
                    IPE.roundabout$setStandLevel(lvl);
                    if ($$4.m_128441_("Experience")) {
                        int exp = $$4.m_128451_("Experience");
                        exp = Mth.m_14045_((int)exp, (int)0, (int)SD.standPowers.getExpForLevelUp(lvl));
                        IPE.roundabout$setStandExp(exp);
                    } else {
                        IPE.roundabout$setStandExp(0);
                    }
                } else {
                    IPE.roundabout$setStandLevel((byte)1);
                    IPE.roundabout$setStandExp(0);
                }
                if ($$4.m_128441_("BonusSkin")) {
                    IPE.roundabout$setUnlockedBonusSkin($$4.m_128471_("BonusSkin"));
                } else {
                    IPE.roundabout$setUnlockedBonusSkin(false);
                }
            }
            if ($$4.m_128441_("Skin")) {
                byte skn = $$4.m_128445_("Skin");
                user.roundabout$setStandSkin(skn);
            } else {
                user.roundabout$setStandSkin((byte)0);
            }
            if ($$4.m_128441_("Pose")) {
                byte skn = $$4.m_128445_("Pose");
                user.roundabout$setIdlePosX(skn);
            } else {
                user.roundabout$setIdlePosX((byte)0);
            }
        } else {
            if (ent instanceof Player) {
                Player PE = (Player)ent;
                IPlayerEntity IPE = (IPlayerEntity)PE;
                IPE.roundabout$setStandLevel((byte)1);
                IPE.roundabout$setStandExp(0);
                IPE.roundabout$setUnlockedBonusSkin(false);
            }
            user.roundabout$setStandSkin((byte)0);
            user.roundabout$setIdlePosX((byte)0);
        }
    }

    public static LivingEntity homeOnFlier(Level level, Vec3 vec3, double range, Entity owner) {
        List<Entity> EntitiesInRange = MainUtil.genHitbox(level, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, range, range, range);
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(EntitiesInRange){};
        for (Entity value : hitEntities) {
            LivingEntity mb;
            if (!(value instanceof LivingEntity) || !(mb = (LivingEntity)value).m_21255_() && !(mb instanceof Phantom) && !(mb instanceof FallenPhantom) || mb instanceof StandEntity || owner != null && owner.m_20148_() == mb.m_20148_()) continue;
            return mb;
        }
        return null;
    }

    public static boolean getMobBleed(Entity Mob2) {
        if (ClientNetworking.getAppropriateConfig().miscellaneousSettings.disableBleedingAndBloodSplatters.booleanValue()) {
            return false;
        }
        if (Mob2 instanceof LivingEntity) {
            return Mob2 instanceof Zombie || Mob2 instanceof Animal && !(Mob2 instanceof SkeletonHorse) && !(Mob2 instanceof ZombieHorse) || Mob2 instanceof Villager || Mob2 instanceof WaterAnimal || Mob2 instanceof WanderingTrader || Mob2 instanceof Witch || Mob2 instanceof AbstractIllager || Mob2 instanceof Creeper || Mob2 instanceof Player || Mob2 instanceof AbstractPiglin || Mob2 instanceof JojoNPC || Mob2 instanceof Zoglin || Mob2 instanceof Ravager || Mob2 instanceof Spider || Mob2 instanceof EnderDragon || Mob2 instanceof EnderMan;
        }
        return false;
    }

    public static void makeFaceless(Entity entity, int ticks, int power, Entity user) {
        if (entity instanceof LivingEntity) {
            MobEffectInstance mf;
            LivingEntity LE = (LivingEntity)entity;
            if (((LivingEntity)entity).m_21023_(ModEffects.FACELESS) && (mf = ((LivingEntity)entity).m_21124_(ModEffects.FACELESS)) != null && mf.m_19564_() <= power && mf.m_19557_() > ticks) {
                return;
            }
            ((StandUser)entity).roundabout$setGlow((byte)1);
            ((LivingEntity)entity).m_147207_(new MobEffectInstance(ModEffects.FACELESS, ticks, power), user);
        }
    }

    public static void makeMobBleed(Entity target) {
        int variety = (int)Math.round(Math.random() * 4.0);
        Block modBlock = ModBlocks.BLOOD_SPLATTER;
        if (MainUtil.hasBlueBlood(target)) {
            modBlock = ModBlocks.BLUE_BLOOD_SPLATTER;
        } else if (MainUtil.hasEnderBlood(target)) {
            modBlock = ModBlocks.ENDER_BLOOD_SPLATTER;
        }
        if (variety != 1) {
            MainUtil.setSplatter(target.m_9236_(), target.m_20097_(), (int)Math.floor(Math.random() * 3.0) - 1, 0, (BlockState)modBlock.m_49966_().m_61124_((Property)ModBlocks.BLOOD_LEVEL, (Comparable)Integer.valueOf((int)Math.round(Math.random() * 3.0))));
        }
        if (variety != 2) {
            MainUtil.setSplatter(target.m_9236_(), target.m_20097_(), (int)Math.floor(Math.random() * 3.0) - 1, -1, (BlockState)modBlock.m_49966_().m_61124_((Property)ModBlocks.BLOOD_LEVEL, (Comparable)Integer.valueOf((int)Math.round(Math.random() * 3.0))));
        }
        if (variety != 3) {
            MainUtil.setSplatter(target.m_9236_(), target.m_20097_(), (int)Math.floor(Math.random() * 3.0) - 1, 1, (BlockState)modBlock.m_49966_().m_61124_((Property)ModBlocks.BLOOD_LEVEL, (Comparable)Integer.valueOf((int)Math.round(Math.random() * 3.0))));
        }
    }

    public static boolean hasBlueBlood(Entity target) {
        return target instanceof Spider || target instanceof Bee || target instanceof Silverfish || target instanceof Squid;
    }

    public static boolean hasEnderBlood(Entity target) {
        return target instanceof EnderMan || target instanceof Endermite || target instanceof EnderDragon;
    }

    private static boolean containsInvalidValues(double $$0, double $$1, double $$2, float $$3, float $$4) {
        return Double.isNaN($$0) || Double.isNaN($$1) || Double.isNaN($$2) || !Floats.isFinite((float)$$4) || !Floats.isFinite((float)$$3);
    }

    private static double clampHorizontal(double $$0) {
        return Mth.m_14008_((double)$$0, (double)-3.0E7, (double)3.0E7);
    }

    private static double clampVertical(double $$0) {
        return Mth.m_14008_((double)$$0, (double)-2.0E7, (double)2.0E7);
    }

    public static void handleMovePilot(double getX, double getY, double getZ, float getYRot, float getXRot, Player player, int entityInt) {
        Entity entity = player.m_9236_().m_6815_(entityInt);
        if (entity != null && !MainUtil.containsInvalidValues(getX, getY, getZ, getYRot, getXRot) && entity != player) {
            LivingEntity livingentity;
            ServerLevel serverlevel = (ServerLevel)player.m_9236_();
            double d0 = entity.m_20185_();
            double d1 = entity.m_20186_();
            double d2 = entity.m_20189_();
            double d3 = MainUtil.clampHorizontal(getX);
            double d4 = MainUtil.clampVertical(getY);
            double d5 = MainUtil.clampHorizontal(getZ);
            float f = Mth.m_14177_((float)getYRot);
            float f1 = Mth.m_14177_((float)getXRot);
            boolean flag = serverlevel.m_45756_(entity, entity.m_20191_().m_82406_(0.0625));
            boolean flag1 = entity.f_201939_;
            if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).m_6147_()) {
                livingentity.m_183634_();
            }
            entity.m_19890_(d3, d4, d5, f, f1);
            entity.m_7678_(d3, d4, d5, f, f1);
        }
    }

    public static boolean canCauseRejection(Entity ent) {
        if (ent instanceof Mob) {
            Mob ME = (Mob)ent;
            if (!(ME instanceof WitherBoss) && !(ME instanceof EnderDragon) && !(ME instanceof Warden) && ((StandUser)ME).roundabout$getStandDisc().m_41619_()) {
                return true;
            }
        } else if (ent instanceof Player) {
            Player PE = (Player)ent;
            if (PE.f_36078_ < ClientNetworking.getAppropriateConfig().itemSettings.levelsToGetStand && ((StandUser)PE).roundabout$getStandDisc().m_41619_()) {
                return true;
            }
        }
        return false;
    }

    public static boolean canGrantStand(Entity ent) {
        if (ent instanceof Mob) {
            Mob ME = (Mob)ent;
            if (!(ME instanceof StandEntity) && ((StandUser)ME).roundabout$getStandDisc().m_41619_()) {
                return ((IMob)ME).roundabout$isWorthy();
            }
        } else if (ent instanceof Player) {
            Player PL = (Player)ent;
            if (ClientNetworking.getAppropriateConfig().itemSettings.canAwakenOtherPlayersWithArrows.booleanValue() && ((StandUser)PL).roundabout$getStandDisc().m_41619_()) {
                return PL.f_36078_ >= ClientNetworking.getAppropriateConfig().itemSettings.levelsToGetStand;
            }
        }
        return false;
    }

    public static float gasDamageMultiplier() {
        return (float)((double)0.78f * ((double)ClientNetworking.getAppropriateConfig().itemSettings.gasolineExplosionDamage.intValue() * 0.01));
    }

    public static void makeBleed(Entity entity, int level, int ticks, Entity source) {
        if (ClientNetworking.getAppropriateConfig().miscellaneousSettings.disableBleedingAndBloodSplatters.booleanValue()) {
            return;
        }
        if (MainUtil.getMobBleed(entity)) {
            ((StandUser)entity).roundabout$setBleedLevel(level);
            ((LivingEntity)entity).m_147207_(new MobEffectInstance(ModEffects.BLEED, ticks, level), source);
        }
    }

    public static void randomChorusTeleport(LivingEntity entity) {
        Level $$1 = entity.m_9236_();
        if (!$$1.f_46443_) {
            double $$4 = entity.m_20185_();
            double $$5 = entity.m_20186_();
            double $$6 = entity.m_20189_();
            for (int $$7 = 0; $$7 < 16; ++$$7) {
                double $$8 = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * 16.0;
                double $$9 = Mth.m_14008_((double)(entity.m_20186_() + (double)(entity.m_217043_().m_188503_(16) - 8)), (double)$$1.m_141937_(), (double)($$1.m_141937_() + ((ServerLevel)$$1).m_143344_() - 1));
                double $$10 = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * 16.0;
                if (entity.m_20159_()) {
                    entity.m_8127_();
                }
                Vec3 $$11 = entity.m_20182_();
                if (!MainUtil.randomTeleport(entity, $$8, $$9, $$10, true)) continue;
                entity.f_19864_ = true;
                entity.f_19812_ = true;
                $$1.m_214171_(GameEvent.f_238175_, $$11, GameEvent.Context.m_223717_((Entity)entity));
                SoundEvent $$12 = entity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                $$1.m_6263_(null, $$4, $$5, $$6, $$12, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.m_5496_($$12, 1.0f, 1.0f);
                break;
            }
        }
    }

    public static boolean randomTeleport(LivingEntity ent, double $$0, double $$1, double $$2, boolean $$3) {
        double $$4 = ent.m_20185_();
        double $$5 = ent.m_20186_();
        double $$6 = ent.m_20189_();
        double $$7 = $$1;
        boolean $$8 = false;
        BlockPos $$9 = BlockPos.m_274561_((double)$$0, (double)$$1, (double)$$2);
        Level $$10 = ent.m_9236_();
        if ($$10.m_46805_($$9)) {
            boolean $$11 = false;
            while (!$$11 && $$9.m_123342_() > $$10.m_141937_()) {
                BlockPos $$12 = $$9.m_7495_();
                BlockState $$13 = $$10.m_8055_($$12);
                if ($$13.m_280555_()) {
                    $$11 = true;
                    continue;
                }
                $$7 -= 1.0;
                $$9 = $$12;
            }
            if ($$11) {
                ent.m_6021_($$0, $$7, $$2);
                if (ent instanceof Player) {
                    ((IEntityAndData)ent).roundabout$setQVec2Params(new Vec3($$0, $$7, $$2));
                }
                if ($$10.m_45786_((Entity)ent) && !$$10.m_46855_(ent.m_20191_())) {
                    $$8 = true;
                }
            }
        }
        if (!$$8) {
            ent.m_6021_($$4, $$5, $$6);
            if (ent instanceof Player) {
                ((IEntityAndData)ent).roundabout$setQVec2Params(new Vec3($$0, $$7, $$2));
            }
            return false;
        }
        if ($$3) {
            $$10.m_7605_((Entity)ent, (byte)46);
        }
        if (ent instanceof PathfinderMob) {
            ((PathfinderMob)ent).m_21573_().m_26573_();
        }
        return true;
    }

    public static List<Entity> genHitbox(Level level, double startX, double startY, double startZ, double radiusX, double radiusY, double radiusZ) {
        double k = Mth.m_14107_((double)(startX - radiusX));
        double l = Mth.m_14107_((double)(startX + radiusX));
        double r = startY - radiusY;
        double s = startY + radiusY;
        double t = startZ - radiusZ;
        double u = startZ + radiusZ;
        return level.m_45933_(null, new AABB(k, r, t, l, s, u));
    }

    public static List<Entity> hitbox(List<Entity> entities) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            if (value.m_20152_() && !value.m_20147_() && value.m_6084_() && !(value instanceof StandEntity)) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public static List<Entity> hitboxGas(List<Entity> entities) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            if ((value.m_20152_() || value instanceof GasolineCanEntity) && !value.m_20147_() && value.m_6084_()) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public static float wrapRadians(float radians) {
        float f = (radians *= 57.295776f) % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f * ((float)Math.PI / 180);
    }

    public static Vec3 getMoveRelative(float $$0, Vec3 $$1, Entity ett) {
        return MainUtil.getInputVector($$1, $$0, ett.m_146908_());
    }

    private static Vec3 getInputVector(Vec3 $$0, float $$1, float $$2) {
        double $$3 = $$0.m_82556_();
        if ($$3 < 1.0E-7) {
            return Vec3.f_82478_;
        }
        Vec3 $$4 = ($$3 > 1.0 ? $$0.m_82541_() : $$0).m_82490_((double)$$1);
        float $$5 = Mth.m_14031_((float)($$2 * ((float)Math.PI / 180)));
        float $$6 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180)));
        return new Vec3($$4.f_82479_ * (double)$$6 - $$4.f_82481_ * (double)$$5, $$4.f_82480_, $$4.f_82481_ * (double)$$6 + $$4.f_82479_ * (double)$$5);
    }

    public static double fixAngle(float angle) {
        return Math.abs(angle) % 360.0f;
    }

    public static void takeKnockbackWithY(Entity entity, double strength, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            double d;
            strength *= (double)((float)(1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_)));
            if (d <= 0.0) {
                return;
            }
        }
        if (MainUtil.isKnockbackImmune(entity)) {
            return;
        }
        MainUtil.takeUnresistableKnockbackWithY(entity, strength, x, y, z);
    }

    public static void takeUnresistableKnockbackWithY(Entity entity, double strength, double x, double y, double z) {
        entity.f_19864_ = true;
        Vec3 vec3d2 = new Vec3(x, y, z).m_82541_().m_82490_(strength);
        entity.m_20334_(-vec3d2.f_82479_, -vec3d2.f_82480_, -vec3d2.f_82481_);
        entity.f_19812_ = true;
    }

    public static void takeLiteralUnresistableKnockbackWithY(Entity entity, double x, double y, double z) {
        entity.f_19864_ = true;
        entity.m_20334_(x, y, z);
        entity.f_19812_ = true;
    }

    public static void takeUnresistableKnockbackWithYBias(Entity entity, double strength, double x, double y, double z, float yBias) {
        entity.f_19864_ = true;
        Vec3 vec3d2 = new Vec3(x, y, z).m_82541_().m_82490_(strength);
        Vec3 vec3d3 = vec3d2.m_82542_((double)yBias, 1.0, (double)yBias);
        entity.m_20334_(-vec3d3.f_82479_, -vec3d3.f_82480_, -vec3d3.f_82481_);
        entity.f_19812_ = true;
    }

    public static void takeUnresistableKnockbackWithY2(Entity entity, double x, double y, double z) {
        entity.f_19864_ = true;
        entity.m_20334_(x, y, z);
        entity.f_19812_ = true;
    }

    public static void ejectInFront(StandEntity stand) {
        if (stand.m_146895_() != null && stand.getUser() != null) {
            Entity entity = stand.m_146895_();
            stand.m_20153_();
            if (entity.m_9236_().m_220362_() == stand.getUser().m_9236_().m_220362_()) {
                if (entity instanceof Player) {
                    Player ent = (Player)entity;
                    ((IEntityAndData)ent).roundabout$setQVec2Params(new Vec3(stand.getUser().m_20185_(), stand.getUser().m_20186_(), stand.getUser().m_20189_()));
                } else {
                    entity.m_142098_(stand.getUser().m_20185_(), stand.getUser().m_20186_(), stand.getUser().m_20189_());
                }
            }
        }
    }

    public static void knockback(Entity entity, double d, double e, double f) {
        if (entity instanceof LivingEntity) {
            double d2;
            LivingEntity le = (LivingEntity)entity;
            d *= 1.0 - le.m_21133_(Attributes.f_22278_);
            if (d2 <= 0.0) {
                return;
            }
        }
        if (MainUtil.isKnockbackImmune(entity)) {
            return;
        }
        entity.f_19812_ = true;
        Vec3 vec3 = entity.m_20184_();
        Vec3 vec32 = new Vec3(e, 0.0, f).m_82541_().m_82490_(d);
        entity.m_20334_(vec3.f_82479_ / 2.0 - vec32.f_82479_, entity.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + d) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec32.f_82481_);
        entity.f_19864_ = true;
    }

    public static void knockbackWithoutBumpUp(Entity entity, double d, double e, double f) {
        if (entity instanceof LivingEntity) {
            double d2;
            LivingEntity le = (LivingEntity)entity;
            d *= 1.0 - le.m_21133_(Attributes.f_22278_);
            if (d2 <= 0.0) {
                return;
            }
        }
        if (MainUtil.isKnockbackImmune(entity)) {
            return;
        }
        entity.f_19812_ = true;
        Vec3 vec3 = entity.m_20184_();
        Vec3 vec32 = new Vec3(e, 0.0, f).m_82541_().m_82490_(d);
        entity.m_20334_(vec3.f_82479_ / 2.0 - vec32.f_82479_, vec3.f_82480_, vec3.f_82481_ / 2.0 - vec32.f_82481_);
        entity.f_19864_ = true;
    }

    public static double lengthdir_x(double length, double angle) {
        return length * Math.cos(MainUtil.toRadians(angle)) * -1.0;
    }

    public static double lengthdir_z(double length, double angle) {
        return length * Math.sin(MainUtil.toRadians(angle));
    }

    public static double toRadians(double angle) {
        return angle * (Math.PI / 180);
    }

    public static double cheapDistanceTo(double x, double y, double z, double x2, double y2, double z2) {
        double mdist = 0.0;
        double cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(y - y2)) > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static double cheapDistanceTo2(double x, double z, double x2, double z2) {
        double mdist = 0.0;
        double cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static int cheapDistanceTo2(int x, int z, int x2, int z2) {
        int mdist = 0;
        int cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static double cheapDistanceTo(int x, int y, int z, int x2, int y2, int z2) {
        double mdist = 0.0;
        double cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = (double)Math.abs(y - y2)) > mdist) {
            mdist = cdist;
        }
        if ((cdist = (double)Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static boolean isPlayerNearby(Vec3 pos, Level level, double range, int exemptID) {
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)serverWorld.m_6907_().get(j);
                if (serverPlayerEntity.m_9236_() != serverWorld) continue;
                BlockPos blockPos = serverPlayerEntity.m_20183_();
                if (serverPlayerEntity.m_19879_() == exemptID || !blockPos.m_203195_((Position)pos, range)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canPlaceOnClaim(Player player, BlockHitResult blockHit) {
        if (!ClientNetworking.getAppropriateConfig().griefSettings.doExtraGriefChecksForClaims.booleanValue() || !MainUtil.getIsGamemodeApproriateForGrief((Entity)player)) {
            return true;
        }
        boolean isLiquid = !player.m_9236_().m_8055_(blockHit.m_82425_()).m_280296_() && !player.m_9236_().m_8055_(blockHit.m_82425_()).m_60795_();
        BlockState replace = player.m_9236_().m_8055_(blockHit.m_82425_());
        Item item = Blocks.f_50375_.m_5456_();
        if (item instanceof BlockItem) {
            BlockItem barrier = (BlockItem)item;
            barrier.m_40576_(new BlockPlaceContext(player, player.m_7655_(), barrier.m_7968_(), blockHit));
            BlockPos placedBPos = blockHit.m_82425_().m_121945_(blockHit.m_82434_());
            player.m_9236_().m_46953_(placedBPos, false, (Entity)player);
            if (!player.m_9236_().m_8055_(placedBPos).m_60795_()) {
                player.m_9236_().m_7471_(placedBPos, false);
                if (isLiquid) {
                    player.m_9236_().m_7731_(blockHit.m_82425_(), replace, 0);
                }
                return false;
            }
            if (isLiquid) {
                player.m_9236_().m_7731_(blockHit.m_82425_(), replace, 0);
            }
        }
        return true;
    }

    public static void gasExplode(BlockState blk, ServerLevel level, BlockPos blkPos, int iteration, int hitRadius, int blockRadius, float power) {
        if (!level.f_46443_) {
            List<Entity> entities;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)blkPos.m_123341_() + 0.5, (double)blkPos.m_123342_(), (double)blkPos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.4);
            if (iteration == 0) {
                SoundEvent $$6 = ModSounds.GASOLINE_EXPLOSION_EVENT;
                level.m_5594_(null, blkPos, $$6, SoundSource.BLOCKS, 10.0f, 1.0f);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)((float)blkPos.m_123341_() + 0.5f), (double)((float)blkPos.m_123342_() + 0.5f), (double)((float)blkPos.m_123343_() + 0.5f), 1, 0.1, 0.1, 0.1, 0.2);
            }
            if (!(entities = MainUtil.hitboxGas(MainUtil.genHitbox((Level)level, blkPos.m_123341_(), blkPos.m_123342_(), blkPos.m_123343_(), hitRadius, hitRadius + 1, hitRadius))).isEmpty()) {
                DamageSource $$5 = ModDamageTypes.of((Level)level, ModDamageTypes.GASOLINE_EXPLOSION);
                for (Entity value : entities) {
                    if (value instanceof GasolineCanEntity) {
                        value.m_142687_(Entity.RemovalReason.DISCARDED);
                        MainUtil.gasExplode(null, level, value.m_20097_(), iteration + 1, 1, blockRadius, power);
                        break;
                    }
                    if (value.m_5825_()) continue;
                    value.m_20254_(15);
                    float np = power;
                    if (value instanceof LivingEntity) {
                        ((StandUser)value).roundabout$setGasolineTime(-1);
                        if (value instanceof Player) {
                            np *= 0.31f;
                        }
                        int f = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44966_, (LivingEntity)((LivingEntity)value));
                        np = (float)((double)np * (1.0 - (double)f * 0.045));
                    }
                    if (value instanceof LivingEntity && ((LivingEntity)value).m_21023_(MobEffects.f_19607_)) {
                        MobEffectInstance instance = ((LivingEntity)value).m_21124_(MobEffects.f_19607_);
                        ((LivingEntity)value).m_21195_(MobEffects.f_19607_);
                        value.m_6469_($$5, np);
                        ((LivingEntity)value).m_7292_(instance);
                        continue;
                    }
                    value.m_6469_($$5, np);
                }
            }
        }
        if (blk != null) {
            level.m_7471_(blkPos, false);
        }
        HashSet gasList = Sets.newHashSet();
        if (!level.f_46443_ && iteration < 8) {
            for (int x = -blockRadius; x < blockRadius; ++x) {
                for (int y = -blockRadius; y < blockRadius; ++y) {
                    for (int z = -blockRadius; z < blockRadius; ++z) {
                        boolean ignited;
                        BlockPos blkPo2 = new BlockPos(blkPos.m_123341_() + x, blkPos.m_123342_() + y, blkPos.m_123343_() + z);
                        BlockState state = level.m_8055_(blkPo2);
                        Block block = state.m_60734_();
                        if (!(block instanceof GasolineBlock) || (ignited = ((Boolean)state.m_61143_((Property)GasolineBlock.IGNITED)).booleanValue())) continue;
                        state = (BlockState)state.m_61124_((Property)GasolineBlock.IGNITED, (Comparable)Boolean.valueOf(true));
                        level.m_7731_(blkPo2, state, 1);
                        gasList.add(blkPo2);
                    }
                }
            }
            if (!gasList.isEmpty()) {
                for (BlockPos gasPuddle : gasList) {
                    BlockState state = level.m_8055_(gasPuddle);
                    MainUtil.gasExplode(state, level, gasPuddle, iteration + 1, hitRadius, blockRadius, power);
                }
            }
        }
    }

    public static LivingEntity getStoneTarget(Level $$0, LivingEntity $$1) {
        List<Entity> entities = MainUtil.hitbox(MainUtil.genHitbox($$0, $$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), 5.0, 5.0, 5.0));
        double maxDistance = 5.0;
        LivingEntity target = null;
        if (!entities.isEmpty()) {
            for (Entity value : entities) {
                double distance;
                if (!(value instanceof LivingEntity) || value.m_20148_() == $$1.m_20148_() || value instanceof StandEntity || value instanceof FallenMob || !((distance = value.m_20182_().m_82554_($$1.m_20182_())) <= maxDistance) || ((StandUser)value).roundabout$getLocacacaCurse() >= 0) continue;
                target = (LivingEntity)value;
                maxDistance = distance;
            }
        }
        return target;
    }

    public static Entity getTargetEntity(LivingEntity User, float distance) {
        return MainUtil.getTargetEntity(User, distance, 25);
    }

    public static Entity getTargetEntity(LivingEntity User, float distance, int angle) {
        MainUtil.getDistanceOut(User, distance, false);
        Entity targetEntity = MainUtil.rayCastEntity((Entity)User, distance);
        if (targetEntity == null) {
            float halfReach = (float)((double)distance * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = MainUtil.AttackHitboxNear((Entity)User, MainUtil.GrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distance, angle), distance);
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        return targetEntity;
    }

    public static float getDistanceOut(LivingEntity entity, float range, boolean offset) {
        float distanceFront = MainUtil.getRayDistance(entity, range);
        if (offset) {
            Entity targetEntity = MainUtil.rayCastEntity((Entity)entity, range);
            if (targetEntity != null && targetEntity.m_20270_((Entity)entity) < distanceFront) {
                distanceFront = targetEntity.m_20270_((Entity)entity);
            }
            distanceFront -= 1.0f;
            distanceFront = Math.max(Math.min(distanceFront, 1.7f), 0.4f);
        }
        return distanceFront;
    }

    public static float getRayDistance(LivingEntity entity, float range) {
        Vec3 vec3d = entity.m_20299_(0.0f);
        Vec3 vec3d2 = entity.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            return Mth.m_14116_((float)((float)entity.m_20238_(blockHit.m_82450_())));
        }
        return range;
    }

    public static boolean isThrownBlockItem(Item item) {
        if (item instanceof BlockItem) {
            Block blk = ((BlockItem)item).m_40614_();
            return !(item instanceof ItemNameBlockItem) && !(blk instanceof BushBlock) && !(blk instanceof WebBlock) && !(blk instanceof BarbedWireBundleBlock) && !(blk instanceof TorchBlock) && !(blk instanceof FrogspawnBlock) && !(blk instanceof CauldronBlock) && !(blk instanceof BellBlock) && !(blk instanceof SnowLayerBlock) && !(blk instanceof TurtleEggBlock) && !(blk instanceof CarpetBlock) && !(blk instanceof SugarCaneBlock) && !(blk instanceof GrowingPlantHeadBlock) && !(blk instanceof StereoBlock) && !(blk instanceof FlowerPotBlock) && !(blk instanceof DaylightDetectorBlock) && !(blk instanceof VineBlock) && !(blk instanceof SnifferEggBlock) && !(blk instanceof BasePressurePlateBlock) && !(blk instanceof PowderSnowBlock) && !(blk instanceof SkullBlock) && !(blk instanceof RodBlock) && !(blk instanceof HorizontalDirectionalBlock) && !(blk instanceof FleshBlock) && (!(blk instanceof SimpleWaterloggedBlock) || blk instanceof LeavesBlock);
        }
        return false;
    }

    public static boolean tryPlaceBlock(Entity ent, BlockPos pos) {
        return MainUtil.tryPlaceBlock(ent, pos, false);
    }

    public static boolean tryPlaceBlock(Entity ent, BlockPos pos, boolean liquid) {
        Player PL;
        BlockState state;
        return !(ent == null || ent.m_9236_().m_5776_() || !(state = ent.m_9236_().m_8055_(pos)).m_60795_() && (!state.m_247087_() || !MainUtil.getIsGamemodeApproriateForGrief(ent) || state.m_278721_() && !liquid || !ent.m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING) || ent instanceof Player && (PL = (Player)ent).m_36187_(ent.m_9236_(), pos, ((ServerPlayer)ent).f_8941_.m_9290_()) || ent instanceof Player && !ent.m_9236_().m_7966_((Player)ent, pos)));
    }

    public static List<Entity> GrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance, int angle) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            StandEntity SE;
            if (!value.m_20152_() || value.m_20147_() || !value.m_6084_() || User.m_20159_() && User.m_20202_().m_20148_() == value.m_20148_() || User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_20159_() && SE.getUser().m_20202_().m_20148_() == value.m_20148_()) {
                hitEntities.remove(value);
                continue;
            }
            if (MainUtil.angleDistance(MainUtil.getLookAtEntityYaw((Entity)User, value), User.m_6080_() % 360.0f) <= (float)angle && MainUtil.angleDistance(MainUtil.getLookAtEntityPitch((Entity)User, value), User.m_146909_()) <= (float)angle) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public static int getTargetEntityId(LivingEntity User, float distance) {
        return MainUtil.getTargetEntityId(User, distance, 25);
    }

    public static int getTargetEntityId(LivingEntity User, float distance, int angle) {
        Entity targetEntity = MainUtil.getTargetEntity(User, distance, angle);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public static boolean isStandDamage(DamageSource sauce) {
        return sauce.m_276093_(ModDamageTypes.STAND) || sauce.m_276093_(ModDamageTypes.PENETRATING_STAND) || sauce.m_276093_(ModDamageTypes.STAR_FINGER) || sauce.m_276093_(ModDamageTypes.STAND_RUSH) || sauce.m_276093_(ModDamageTypes.CROSSFIRE) || sauce.m_276093_(ModDamageTypes.EXPLOSIVE_STAND) || sauce.m_276093_(ModDamageTypes.GO_BEYOND) || sauce.m_276093_(ModDamageTypes.CORPSE) || sauce.m_276093_(ModDamageTypes.CORPSE_EXPLOSION) || sauce.m_276093_(ModDamageTypes.CORPSE_ARROW) || sauce.m_276093_(ModDamageTypes.MELTING) || sauce.m_276093_(ModDamageTypes.HEEL_SPIKE);
    }

    public static boolean isCorpseDamage(DamageSource sauce) {
        return sauce.m_276093_(ModDamageTypes.CORPSE) || sauce.m_276093_(ModDamageTypes.CORPSE_EXPLOSION) || sauce.m_276093_(ModDamageTypes.CORPSE_ARROW);
    }

    public static boolean isArmorBypassingButNotShieldBypassing(DamageSource sauce) {
        return sauce.m_276093_(ModDamageTypes.STAND) || sauce.m_276093_(ModDamageTypes.CORPSE) || sauce.m_276093_(ModDamageTypes.EXPLOSIVE_STAND) || sauce.m_276093_(ModDamageTypes.HEEL_SPIKE) || sauce.m_276093_(ModDamageTypes.CORPSE_ARROW) || sauce.m_276093_(ModDamageTypes.STAND_RUSH) || sauce.m_276093_(ModDamageTypes.CROSSFIRE) || sauce.m_276093_(ModDamageTypes.CORPSE_EXPLOSION);
    }

    public static float getLookAtEntityPitch(Entity user, Entity targetEntity) {
        double f;
        double d = targetEntity.m_146892_().f_82479_ - user.m_146892_().f_82479_;
        double e = targetEntity.m_146892_().f_82481_ - user.m_146892_().f_82481_;
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)targetEntity;
            f = livingEntity.m_146892_().f_82480_ - user.m_146892_().f_82480_;
        } else {
            f = (targetEntity.m_20191_().f_82289_ + targetEntity.m_20191_().f_82292_) / 2.0 - user.m_146892_().f_82480_;
        }
        double g = Math.sqrt(d * d + e * e);
        return (float)(-(Mth.m_14136_((double)f, (double)g) * 57.2957763671875));
    }

    public static Vec2 getRotationsBetween(Vec3 from, Vec3 to) {
        Vec3 delta = to.m_82546_(from);
        double dx = delta.f_82479_;
        double dy = delta.f_82480_;
        double dz = delta.f_82481_;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float yRot = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float xRot = (float)Math.toDegrees(-Math.atan2(dy, horizontalDistance));
        return new Vec2(xRot, yRot);
    }

    public static float getLookAtEntityYaw(Entity user, Entity targetEntity) {
        double d = targetEntity.m_20185_() - user.m_20185_();
        double e = targetEntity.m_20189_() - user.m_20189_();
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public static float getLookAtEntityYawWithAngle(Vec3 user, Entity targetEntity) {
        double d = targetEntity.m_20185_() - user.m_7096_();
        double e = targetEntity.m_20189_() - user.m_7094_();
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public static float getLookAtEntityYawWithAngles(Vec3 user, Vec3 target) {
        double d = target.m_7096_() - user.m_7096_();
        double e = target.m_7094_() - user.m_7094_();
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public static float getLookAtEntityEyeYawWithAngle(Vec3 user, Entity targetEntity) {
        double d = targetEntity.m_146892_().m_7096_() - user.m_7096_();
        double e = targetEntity.m_146892_().m_7094_() - user.m_7094_();
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public static float angleDistance(float alpha, float beta) {
        float phi = Math.abs(beta - alpha) % 360.0f;
        float distance = phi > 180.0f ? 360.0f - phi : phi;
        return distance;
    }

    public static boolean canRewindInTime(Entity ent, Entity rewinder) {
        if (!ent.m_213877_() && ent.m_6084_()) {
            Player PE;
            return !(ent instanceof Player) || !(PE = (Player)ent).m_7500_() || rewinder == null || rewinder.m_7306_(ent);
        }
        return false;
    }

    public static boolean canHaveSightTaken(LivingEntity LE) {
        Mob mb;
        if (LE instanceof Sniffer || LE instanceof Bat || LE instanceof Dolphin) {
            return false;
        }
        if (LE instanceof Mob && ((IMob)(mb = (Mob)LE)).roundabout$getSightProtectionTicks() > 0) {
            return false;
        }
        return !MainUtil.isBossMob(LE) || ClientNetworking.getAppropriateConfig().softAndWetSettings.bossesCannotLoseSight == false;
    }

    public static boolean isSpecialEffect(MobEffectInstance value) {
        return value.m_19544_().equals(ModEffects.BLEED) || value.m_19544_().equals(ModEffects.FACELESS) || value.m_19544_().equals(ModEffects.CAPTURING_LOVE);
    }

    public static boolean isSpecialEffect(MobEffect value) {
        return value.equals(ModEffects.BLEED) || value.equals(ModEffects.FACELESS) || value.equals(ModEffects.CAPTURING_LOVE);
    }

    public static boolean canHaveFrictionTaken(LivingEntity LE) {
        PowersWalkingHeart PW;
        if (LE.m_6147_()) {
            return false;
        }
        StandPowers standPowers = ((StandUser)LE).roundabout$getStandPowers();
        if (standPowers instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)standPowers).hasExtendedHeelsForWalking()) {
            return false;
        }
        return !MainUtil.isBossMob(LE) || ClientNetworking.getAppropriateConfig().softAndWetSettings.bossesCannotLoseFriction == false;
    }

    public static boolean canBeScoopedUpInBubble(LivingEntity LE) {
        return !MainUtil.isBossMob(LE) && LE.m_20205_() < ClientNetworking.getAppropriateConfig().softAndWetSettings.widthOfMobBubbleMobsStolen.floatValue() && LE.m_20206_() < ClientNetworking.getAppropriateConfig().softAndWetSettings.sizeOfMobBubbleMobsStolen.floatValue() && !(LE.m_20202_() instanceof SoftAndWetPlunderBubbleEntity);
    }

    public static boolean isActuallyALivingEntityNoCap(Entity LE) {
        return LE instanceof Mob || LE instanceof Player;
    }

    public static HitResult getHitResultOnMoveVector(Entity $$0, Predicate<Entity> $$1) {
        Vec3 $$2 = $$0.m_20184_();
        Level $$3 = $$0.m_9236_();
        Vec3 $$4 = $$0.m_20182_();
        return MainUtil.getHitResult($$4, $$0, $$1, $$2, $$3);
    }

    public static BlockHitResult getAheadVec(Entity entity, float distOut) {
        Vec3 vec3d = entity.m_20299_(1.0f);
        Vec3 vec3d2 = entity.m_20252_(1.0f);
        return entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d.m_82520_(vec3d2.f_82479_ * (double)distOut, vec3d2.f_82480_ * (double)distOut, vec3d2.f_82481_ * (double)distOut), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static BlockHitResult getAheadVecRender(Entity entity, float distOut, float rendertick) {
        Vec3 vec3d = entity.m_20299_(rendertick);
        Vec3 vec3d2 = entity.m_20252_(1.0f);
        return entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d.m_82520_(vec3d2.f_82479_ * (double)distOut, vec3d2.f_82480_ * (double)distOut, vec3d2.f_82481_ * (double)distOut), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static Vec3 getRaytracePointOnMobOrBlock(Entity source, float range) {
        EntityHitResult targetEntity = MainUtil.rayCastEntityHitResult(source, range);
        if (targetEntity != null && targetEntity.m_82443_() != null && MainUtil.canActuallyHit(source, targetEntity.m_82443_())) {
            return targetEntity.m_82450_();
        }
        Vec3 vec3d = source.m_20299_(0.0f);
        Vec3 vec3d2 = source.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = source.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source));
        return blockHit.m_82450_();
    }

    public static Vec3 getRaytracePointOnMobOrBlock(Entity source, float range, float distance) {
        EntityHitResult targetEntity = MainUtil.rayCastEntityHitResult(source, range);
        if (targetEntity != null && targetEntity.m_82443_() != null && MainUtil.canActuallyHit(source, targetEntity.m_82443_())) {
            return targetEntity.m_82450_();
        }
        Vec3 vec3d = source.m_20299_(0.0f);
        Vec3 vec3d2 = source.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = source.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source));
        return blockHit.m_82450_().m_231075_(blockHit.m_82434_(), (double)distance);
    }

    public static Vec3 getRaytracePointOnMobOrBlockIfNotUp(Entity source, float range, float distance) {
        EntityHitResult targetEntity = MainUtil.rayCastEntityHitResult(source, range);
        if (targetEntity != null && targetEntity.m_82443_() != null && MainUtil.canActuallyHit(source, targetEntity.m_82443_())) {
            return targetEntity.m_82450_();
        }
        Vec3 vec3d = source.m_20299_(0.0f);
        Vec3 vec3d2 = source.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = source.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source));
        if (blockHit.m_6662_().equals((Object)HitResult.Type.MISS)) {
            return null;
        }
        if (blockHit.m_82434_().equals((Object)Direction.UP)) {
            return blockHit.m_82450_();
        }
        Vec3 vec = new Vec3((double)blockHit.m_82425_().m_123341_(), (double)blockHit.m_82425_().m_123342_(), (double)blockHit.m_82425_().m_123343_());
        vec = vec.m_82520_(0.5, 0.5, 0.5).m_231075_(blockHit.m_82434_(), 0.5).m_231075_(blockHit.m_82434_(), (double)distance);
        return vec;
    }

    public static float hasModifiedPartialVisibility(Entity entity) {
        float basis = 1.0f;
        if (MainUtil.getEntityIsTrulyInvisible(entity)) {
            basis *= 0.4f;
        }
        return basis;
    }

    public static boolean canActuallyHitInvolved(Entity self, Entity entity) {
        if (entity instanceof SoftAndWetPlunderBubbleEntity) {
            return false;
        }
        if (ClientNetworking.getAppropriateConfig().miscellaneousSettings.generalDetectionGoThroughDoorsAndCorners.booleanValue()) {
            return true;
        }
        Vec3 from = new Vec3(self.m_20185_(), self.m_20186_(), self.m_20189_());
        Vec3 to = entity.m_20299_(1.0f);
        BlockHitResult result = self.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, self));
        boolean isBlocked = result.m_6662_() != HitResult.Type.MISS && result.m_82450_().m_82554_(from) < to.m_82554_(from);
        Vec3 from2 = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 to2 = self.m_20299_(1.0f);
        BlockHitResult result2 = self.m_9236_().m_45547_(new ClipContext(from2, to2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, self));
        boolean isBlocked2 = result2.m_6662_() != HitResult.Type.MISS && result2.m_82450_().m_82554_(from2) < to2.m_82554_(from2);
        Vec3 from3 = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 to3 = self.m_20299_(1.0f);
        BlockHitResult result3 = self.m_9236_().m_45547_(new ClipContext(from3, to2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, self));
        boolean isBlocked3 = result3.m_6662_() != HitResult.Type.MISS && result3.m_82450_().m_82554_(from3) < to3.m_82554_(from3);
        return !isBlocked || !isBlocked2 || !isBlocked3;
    }

    public static boolean canActuallyHit(Entity self, Entity entity) {
        return MainUtil.canActuallyHitInvolved(self, entity);
    }

    public static boolean isStandPickable(Entity entity) {
        if (entity instanceof SoftAndWetPlunderBubbleEntity) {
            SoftAndWetPlunderBubbleEntity sbe = (SoftAndWetPlunderBubbleEntity)entity;
            if (entity.m_9236_().m_5776_() && ClientUtil.getPlayer() != null && ClientUtil.getPlayer().m_19879_() == sbe.getUserID()) {
                return false;
            }
            return false;
        }
        if (entity instanceof EncasementBubbleEntity) {
            EncasementBubbleEntity sbe = (EncasementBubbleEntity)entity;
            return false;
        }
        return entity.m_6087_();
    }

    private static HitResult getHitResult(Vec3 $$0, Entity $$1, Predicate<Entity> $$2, Vec3 $$3, Level $$4) {
        EntityHitResult $$7;
        Vec3 $$5 = $$0.m_82549_($$3);
        BlockHitResult $$6 = $$4.m_45547_(new ClipContext($$0, $$5, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, $$1));
        if ($$6.m_6662_() != HitResult.Type.MISS) {
            $$5 = $$6.m_82450_();
        }
        if (($$7 = MainUtil.getEntityHitResult($$4, $$1, $$0, $$5, $$1.m_20191_().m_82369_($$3).m_82400_(1.5), $$2)) != null) {
            $$6 = $$7;
        }
        return $$6;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level $$0, Entity $$1, Vec3 $$2, Vec3 $$3, AABB $$4, Predicate<Entity> $$5, float $$6) {
        double $$7 = Double.MAX_VALUE;
        Entity $$8 = null;
        for (Entity $$9 : $$0.m_6249_($$1, $$4, $$5)) {
            double $$12;
            AABB $$10 = $$9.m_20191_().m_82400_((double)$$6);
            Optional $$11 = $$10.m_82371_($$2, $$3);
            if (!$$11.isPresent() || !(($$12 = $$2.m_82557_((Vec3)$$11.get())) < $$7)) continue;
            $$8 = $$9;
            $$7 = $$12;
        }
        return $$8 == null ? null : new EntityHitResult($$8);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level $$0, Entity $$1, Vec3 $$2, Vec3 $$3, AABB $$4, Predicate<Entity> $$5) {
        return MainUtil.getEntityHitResult($$0, $$1, $$2, $$3, $$4, $$5, 0.3f);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity $$0, Vec3 $$1, Vec3 $$2, AABB $$3, Predicate<Entity> $$4, double $$5) {
        Level $$6 = $$0.m_9236_();
        double $$7 = $$5;
        Entity $$8 = null;
        Vec3 $$9 = null;
        for (Entity $$10 : $$6.m_6249_($$0, $$3, $$4)) {
            Vec3 $$13;
            double $$14;
            AABB $$11 = $$10.m_20191_().m_82400_((double)$$10.m_6143_());
            Optional $$12 = $$11.m_82371_($$1, $$2);
            if ($$11.m_82390_($$1)) {
                if (!($$7 >= 0.0)) continue;
                $$8 = $$10;
                $$9 = $$12.orElse($$1);
                $$7 = 0.0;
                continue;
            }
            if (!$$12.isPresent() || !(($$14 = $$1.m_82557_($$13 = (Vec3)$$12.get())) < $$7) && $$7 != 0.0) continue;
            if ($$10.m_20201_() == $$0.m_20201_()) {
                if ($$7 != 0.0) continue;
                $$8 = $$10;
                $$9 = $$13;
                continue;
            }
            $$8 = $$10;
            $$9 = $$13;
            $$7 = $$14;
        }
        return $$8 == null ? null : new EntityHitResult($$8, $$9);
    }

    public static boolean isBossMob(LivingEntity LE) {
        return LE instanceof Warden || LE instanceof EnderDragon || LE instanceof WitherBoss;
    }

    public static Entity AttackHitboxNear(Entity User, List<Entity> entities, float distance) {
        float nearestDistance = -1.0f;
        Entity nearestMob = null;
        if (entities != null) {
            for (Entity value : entities) {
                if (value.m_20147_() || !value.m_6084_() || value.m_20148_() == User.m_20148_()) continue;
                float distanceTo = value.m_20270_(User);
                if (!(nearestDistance < 0.0f) && !(distanceTo < nearestDistance) || !(distanceTo <= distance) || !MainUtil.canActuallyHit(value, User)) continue;
                nearestDistance = distanceTo;
                nearestMob = value;
            }
        }
        return nearestMob;
    }

    public static Entity rayCastEntity(Entity entityX, float reach) {
        Entity hitResult;
        float tickDelta = 0.0f;
        if (entityX.m_9236_().m_5776_()) {
            tickDelta = ClientUtil.getDelta();
        }
        Vec3 vec3d = entityX.m_20299_(tickDelta);
        Vec3 vec3d2 = entityX.m_20252_(1.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)reach, vec3d2.f_82480_ * (double)reach, vec3d2.f_82481_ * (double)reach);
        float f = 1.0f;
        AABB box = new AABB(vec3d.f_82479_ + (double)reach, vec3d.f_82480_ + (double)reach, vec3d.f_82481_ + (double)reach, vec3d.f_82479_ - (double)reach, vec3d.f_82480_ - (double)reach, vec3d.f_82481_ - (double)reach);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)entityX, (Vec3)vec3d, (Vec3)vec3d3, (AABB)box, entity -> !entity.m_5833_() && entity.m_6087_() && !entity.m_20147_(), (double)(reach * reach));
        if (entityHitResult != null && (hitResult = entityHitResult.m_82443_()).m_6084_() && !hitResult.m_213877_() && MainUtil.canActuallyHit(entityX, hitResult)) {
            return hitResult;
        }
        return null;
    }

    public static EntityHitResult rayCastEntityHitResult(Entity entityX, float reach) {
        Entity hitResult;
        float tickDelta = 0.0f;
        if (entityX.m_9236_().m_5776_()) {
            tickDelta = ClientUtil.getDelta();
        }
        Vec3 vec3d = entityX.m_20299_(tickDelta);
        Vec3 vec3d2 = entityX.m_20252_(1.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)reach, vec3d2.f_82480_ * (double)reach, vec3d2.f_82481_ * (double)reach);
        float f = 1.0f;
        AABB box = new AABB(vec3d.f_82479_ + (double)reach, vec3d.f_82480_ + (double)reach, vec3d.f_82481_ + (double)reach, vec3d.f_82479_ - (double)reach, vec3d.f_82480_ - (double)reach, vec3d.f_82481_ - (double)reach);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)entityX, (Vec3)vec3d, (Vec3)vec3d3, (AABB)box, entity -> !entity.m_5833_() && entity.m_6087_() && !entity.m_20147_() && !(entityX instanceof SoftAndWetBubbleEntity), (double)(reach * reach));
        if (entityHitResult != null && (hitResult = entityHitResult.m_82443_()).m_6084_() && !hitResult.m_213877_()) {
            return entityHitResult;
        }
        return null;
    }

    public static StandUser getUserData(LivingEntity User) {
        return (StandUser)User;
    }

    public static boolean knockShield(Entity entity, int duration) {
        if (entity != null && entity.m_6084_() && !entity.m_213877_() && entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
            StandUser standUser = MainUtil.getUserData((LivingEntity)entity);
            if (!standUser.roundabout$isGuarding() && entity instanceof Player) {
                ItemStack itemStack = ((LivingEntity)entity).m_21211_();
                Item item = itemStack.m_41720_();
                if (item.m_6164_(itemStack) == UseAnim.BLOCK) {
                    ((LivingEntity)entity).m_21253_();
                    ((Player)entity).m_5810_();
                }
                ((Player)entity).m_36335_().m_41524_(Items.f_42740_, duration);
                entity.m_9236_().m_7605_(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public static boolean forceAggression(LivingEntity LE) {
        if (LE != null) {
            StandUser user = (StandUser)LE;
            return user.roundabout$hasAStand() || user.roundabout$getZappedToID() > -1;
        }
        return false;
    }

    public static boolean knockShieldPlusStand(Entity entity, int duration) {
        if (entity != null && entity.m_6084_() && !entity.m_213877_() && entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
            StandUser standUser = MainUtil.getUserData((LivingEntity)entity);
            if (standUser.roundabout$isGuarding() && !standUser.roundabout$getGuardBroken()) {
                standUser.roundabout$breakGuard();
            }
            if (entity instanceof Player) {
                ItemStack itemStack = ((LivingEntity)entity).m_21211_();
                Item item = itemStack.m_41720_();
                if (item.m_6164_(itemStack) == UseAnim.BLOCK) {
                    ((LivingEntity)entity).m_21253_();
                    ((Player)entity).m_5810_();
                }
                ((Player)entity).m_36335_().m_41524_(Items.f_42740_, duration);
                entity.m_9236_().m_7605_(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public static boolean canPlaceSplatter(Level level, BlockPos pos, int offsetX, int offsetY, int offsetZ) {
        BlockPos $$8;
        BlockPos blk = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + offsetY, pos.m_123343_() + offsetZ);
        return level.m_46859_(blk) && level.m_8055_($$8 = blk.m_7495_()).m_60783_((BlockGetter)level, $$8, Direction.UP);
    }

    public static void setSplatter(Level level, BlockPos pos, int offsetX, int offsetZ, BlockState state) {
        BlockPos blockPos = null;
        if (MainUtil.canPlaceSplatter(level, pos, offsetX, 1, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + 1, pos.m_123343_() + offsetZ);
        } else if (MainUtil.canPlaceSplatter(level, pos, offsetX, 2, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + 2, pos.m_123343_() + offsetZ);
        } else if (MainUtil.canPlaceSplatter(level, pos, offsetX, 0, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_(), pos.m_123343_() + offsetZ);
        } else if (MainUtil.canPlaceSplatter(level, pos, offsetX, -1, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() - 1, pos.m_123343_() + offsetZ);
        }
        if (blockPos != null) {
            level.m_46597_(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), state);
        }
    }

    public static void handShake(ServerPlayer player) {
        Networking.sendConfigToPlayer(player);
    }

    public static void handleBytePacketC2S(Player player, byte data, byte context) {
        if (context == 8) {
            ((StandUser)player).roundabout$getStandPowers().setCooldown(data, -1);
        } else if (context == 7) {
            ((IPlayerEntity)player).roundabout$SetPoseEmote(data);
        } else if (context == 10) {
            StandPowers standPowers = ((StandUser)player).roundabout$getStandPowers();
            if (standPowers instanceof PowersJustice) {
                PowersJustice PJ = (PowersJustice)standPowers;
                PJ.justiceTacticsUse(data);
            }
        } else if (context == 6) {
            StandPowers sp = ((StandUser)player).roundabout$getStandPowers();
            ShapeShifts shift = ShapeShifts.getShiftFromByte(data);
            if (sp instanceof PowersJustice) {
                PowersJustice pj = (PowersJustice)sp;
                if (ShapeShifts.isVillager(shift) && !sp.canExecuteMoveWithLevel(pj.getVillagerMorphLevel())) {
                    return;
                }
                if (ShapeShifts.isZombie(shift) && !sp.canExecuteMoveWithLevel(pj.getZombieMorphLevel())) {
                    return;
                }
                if (ShapeShifts.isSkeleton(shift) && !sp.canExecuteMoveWithLevel(pj.getSkeletonMorphLevel())) {
                    return;
                }
                if (shift == ShapeShifts.VILLAGER) {
                    byte totalMorph = 0;
                    Villager ent = (Villager)player.m_9236_().m_45963_(Villager.class, OFFER_TARGER_CONTEXT, (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20191_().m_82377_(12.0, 2.0, 12.0));
                    if (ent != null) {
                        VillagerType VT = ent.m_7141_().m_35560_();
                        VillagerProfession VP = ent.m_7141_().m_35571_();
                        totalMorph = (byte)(ShapeShifts.getByteFromType(VT) + ShapeShifts.getByteFromProfession(VP));
                    } else {
                        VillagerType VT = VillagerType.m_204073_((Holder)player.m_9236_().m_204166_(player.m_20183_()));
                        totalMorph = (byte)(ShapeShifts.getByteFromType(VT) + 1);
                    }
                    ((IPlayerEntity)player).roundabout$setShapeShiftExtraData(totalMorph);
                }
                ((IPlayerEntity)player).roundabout$shapeShift();
                ((IPlayerEntity)player).roundabout$setShapeShift(data);
            }
        }
    }

    public static void handleSingleBytePacketC2S(Player player, byte context) {
        StandUser user;
        if (context == 7) {
            ((StandUser)player).roundabout$summonStand(player.m_9236_(), false, false);
        } else if (context == 10) {
            StandUser user2 = (StandUser)player;
            user2.roundabout$getStandPowers().getSkinInDirection(false, false);
        } else if (context == 11) {
            StandUser user3 = (StandUser)player;
            user3.roundabout$getStandPowers().getSkinInDirection(true, false);
        } else if (context == 30) {
            StandUser user4 = (StandUser)player;
            user4.roundabout$getStandPowers().getSkinInDirection(false, true);
        } else if (context == 31) {
            StandUser user5 = (StandUser)player;
            user5.roundabout$getStandPowers().getSkinInDirection(true, true);
        } else if (context == 12) {
            StandUser user6 = (StandUser)player;
            user6.roundabout$getStandPowers().getPoseInDirection(false);
        } else if (context == 13) {
            StandUser user7 = (StandUser)player;
            user7.roundabout$getStandPowers().getPoseInDirection(true);
        } else if (context == 9) {
            StandUser standUser = (StandUser)player;
            standUser.roundabout$getStandPowers().setCooldown(context, -1);
            IPlayerEntity iplay = (IPlayerEntity)player;
            byte unlocked = 0;
            if (iplay.roundabout$getUnlockedBonusSkin()) {
                unlocked = 1;
            }
            S2CPacketUtil.sendByteBundleToClientPacket((Player)((ServerPlayer)player), (byte)1, standUser.roundabout$getStandSkin(), unlocked);
            if (player.f_36096_ != player.f_36095_) {
                player.f_36096_ = player.f_36095_;
            }
            ((IPlayerEntityServer)player).roundabout$nextContainerCounter();
            int cid = ((IPlayerEntityServer)player).roundabout$getCounter();
            S2CPacketUtil.sendGenericIntToClientPacket((Player)((ServerPlayer)player), (byte)6, cid);
            player.f_36096_ = new PowerInventoryMenu(player.m_150109_(), true, player, cid);
            ((IPlayerEntityServer)player).roundabout$initMenu(player.f_36096_);
        } else if (context == 14) {
            player.f_36096_ = new FogInventoryMenu(player.m_150109_(), !player.m_9236_().f_46443_, player);
            ((IPlayerEntityServer)player).roundabout$initMenu(player.f_36096_);
        } else if (context == 1) {
            ((StandUser)player).roundabout$getStandPowers().playSoundsIfNearby((byte)-2, 10.0, false);
        } else if (context == 2) {
            ((StandUser)player).roundabout$getStandPowers().stopSoundsIfNearby((byte)104, 30.0, false);
        } else if (context == 3) {
            ((StandUser)player).roundabout$getStandPowers().playSoundsIfNearby((byte)-3, 10.0, false);
        } else if (context == 4) {
            StandEntity iplay;
            if (player != null && (iplay = ((StandUser)player).roundabout$getStand()) instanceof StarPlatinumEntity) {
                StarPlatinumEntity SE = (StarPlatinumEntity)iplay;
                SE.setScoping(true);
                if (ClientNetworking.getAppropriateConfig().starPlatinumSettings.starPlatinumScopeUsesPotionEffectForNightVision.booleanValue()) {
                    player.m_147207_(new MobEffectInstance(MobEffects.f_19611_, 1000000, 21, false, false), null);
                }
            }
        } else if (context == 5) {
            StandEntity iplay;
            if (player != null && (iplay = ((StandUser)player).roundabout$getStand()) instanceof StarPlatinumEntity) {
                MobEffectInstance ME;
                StarPlatinumEntity SE = (StarPlatinumEntity)iplay;
                SE.setScoping(false);
                if (ClientNetworking.getAppropriateConfig().starPlatinumSettings.starPlatinumScopeUsesPotionEffectForNightVision.booleanValue() && (ME = player.m_21124_(MobEffects.f_19611_)) != null && ME.m_19557_() >= 100000 && ME.m_19557_() >= 100000 && ME.m_19564_() > 20) {
                    player.m_21195_(MobEffects.f_19611_);
                }
            }
        } else if (context == 6) {
            if (player != null) {
                ((StandUser)player).roundabout$getStandPowers().forwardBarrage = true;
                ((StandUser)player).roundabout$getStandPowers().moveStarted = true;
                ((StandUser)player).roundabout$getStandPowers().poseStand((byte)3);
                StandEntity SE = ((StandUser)player).roundabout$getStand();
                if (SE != null) {
                    SE.m_146884_(player.m_20318_(1.0f).m_82549_(player.m_20156_().m_82490_(2.0)).m_82520_(0.0, (double)0.2f, 0.0));
                    SE.m_146922_(player.m_6080_() % 360.0f);
                }
            }
        } else if (context == 15) {
            AbstractFurnaceMenu fm;
            Container ct;
            AbstractContainerMenu ME;
            if (player != null && (ME = player.f_36096_) instanceof AbstractFurnaceMenu && (ct = ((IAbstractFurnaceMenu)(fm = (AbstractFurnaceMenu)ME)).roundabout$getContainer()) instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity fbe = (AbstractFurnaceBlockEntity)ct;
                int it = ClientNetworking.getAppropriateConfig().magiciansRedSettings.magiciansRedFurnaceTicks;
                if (it > 0) {
                    ((IAbstractFurnaceBlockEntity)fbe).roundabout$setFurnaceHeatingTime(it);
                }
            }
        } else if (context == 16 && player != null && (user = (StandUser)player).roundabout$getActive()) {
            user.roundabout$summonStand(player.m_9236_(), false, false);
        }
    }

    public static boolean getIsGamemodeApproriateForGrief(Entity Li) {
        return Li != null && !Li.m_9236_().m_5776_() && (!(Li instanceof Player) || ((ServerPlayer)Li).f_8941_.m_9290_() != GameType.SPECTATOR && ((ServerPlayer)Li).f_8941_.m_9290_() != GameType.ADVENTURE) && Li.m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING);
    }

    public static boolean isVampireBurnTick(LivingEntity ent) {
        if (ent.m_9236_().m_46461_() && !ent.m_9236_().f_46443_) {
            float $$0 = ent.m_213856_();
            BlockPos $$1 = BlockPos.m_274561_((double)ent.m_146892_().f_82479_, (double)ent.m_146892_().f_82480_, (double)ent.m_146892_().f_82481_);
            if ($$0 > 0.5f && ent.m_9236_().f_46441_.m_188501_() * 30.0f < ($$0 - 0.4f) * 2.0f && ent.m_9236_().m_45527_($$1)) {
                return true;
            }
        }
        return false;
    }

    public static void handleFloatPacketC2S(Player player, float data, byte context) {
        if (context == 1) {
            if (player.m_20202_() != null) {
                if (player.m_20202_().m_6469_(ModDamageTypes.of(player.m_9236_(), ModDamageTypes.BARBED_WIRE), data)) {
                    MainUtil.makeBleed(player.m_20202_(), 0, 200, null);
                }
            } else if (player.m_6469_(ModDamageTypes.of(player.m_9236_(), ModDamageTypes.BARBED_WIRE), data)) {
                MainUtil.makeBleed((Entity)player, 0, 200, null);
            }
        } else if (context == 2) {
            StandEntity standEntity = ((StandUser)player).roundabout$getStand();
            if (standEntity instanceof StarPlatinumEntity) {
                StarPlatinumEntity SP = (StarPlatinumEntity)standEntity;
                SP.setFingerLength(data);
            }
        } else if (context == 3) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setDistanceOut(data);
        } else if (context == 4) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setSizePercent(data);
        } else if (context == 5) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setIdleRotation(data);
        } else if (context == 6) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setIdleYOffset(data);
        } else if (context == 7) {
            ((StandUser)player).roundabout$getStandPowers().updateMove(data);
        } else if (context == 8) {
            ((StandUser)player).roundabout$setBigJump(true);
            ((StandUser)player).roundabout$setBigJumpCurrentProgress(data);
        } else if (context == 9) {
            ((StandUser)player).roundabout$setBigJump(false);
            ((StandUser)player).roundabout$setBigJumpCurrentProgress(data);
        }
    }

    public static void handleIntPacketC2S(Player player, int data, byte context) {
        Entity target;
        if (context == 1) {
            Entity target2 = player.m_9236_().m_6815_(data);
            target2.m_6469_(ModDamageTypes.of(player.m_9236_(), ModDamageTypes.GLAIVE), (float)data);
        } else if (context == 2) {
            if (((StandUser)player).roundabout$getStandPowers().getChargedTSTicks() > data) {
                ((StandUser)player).roundabout$getStandPowers().setChargedTSTicks(data);
            }
        } else if (context == 3) {
            ((StandUser)player).roundabout$setRestrainedTicks(data);
        } else if (context == 4) {
            Entity target3 = player.m_9236_().m_6815_(data);
            ((StandUser)player).roundabout$getStandPowers().handleStandAttack(player, target3);
        } else if (context == 5) {
            Entity target4 = player.m_9236_().m_6815_(data);
            ((StandUser)player).roundabout$getStandPowers().handleStandAttack2(player, target4);
        } else if (context == 6) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setAnchorPlace(data);
        } else if (context == 9) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setAnchorPlaceAttack(data);
        } else if (context == 7) {
            ((StandUser)player).roundabout$getStandPowers().updateIntMove(data);
        } else if (context == 8) {
            StandEntity SE = ((StandUser)player).roundabout$getStand();
            if (SE != null) {
                BlockPos veci3 = BlockPos.m_274446_((Position)new Vec3(SE.m_146892_().f_82479_, SE.m_146892_().f_82480_, SE.m_146892_().f_82481_));
                BlockState bl3 = SE.m_9236_().m_8055_(veci3);
                if (!bl3.m_280296_() || !bl3.m_60734_().m_180643_(bl3, (BlockGetter)player.m_9236_(), veci3) && !(bl3.m_60734_() instanceof SlabBlock) && !(bl3.m_60734_() instanceof StairBlock)) {
                    ((StandUser)player).roundabout$getStandPowers().setPiloting(data);
                }
            } else {
                ((StandUser)player).roundabout$getStandPowers().setPiloting(data);
            }
        } else if (context == 10) {
            if (ModItems.getVisageStore().size() >= data) {
                VisageStoreEntry entry = ModItems.getVisageStore().get(data);
                if (player.f_36078_ >= entry.costL) {
                    MainUtil.addItem(player, entry.stack.m_41777_());
                    player.m_6749_(-entry.costL);
                    SoundEvent $$6 = ModSounds.CINDERELLA_SPARKLE_EVENT;
                    player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20182_()), $$6, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        } else if (context == 11) {
            if (ModItems.getVisageStore().size() >= data) {
                VisageStoreEntry entry = ModItems.getVisageStore().get(data);
                int i = 0;
                for (int $$5 = 0; $$5 < player.m_150109_().m_6643_(); ++$$5) {
                    ItemStack $$6 = player.m_150109_().m_8020_($$5);
                    if (!$$6.m_41720_().equals(Items.f_42616_)) continue;
                    i += $$6.m_41613_();
                }
                if (i >= entry.costE) {
                    MainUtil.addItem(player, entry.stack.m_41777_());
                    int j = 0;
                    for (int $$5 = 0; $$5 < player.m_150109_().m_6643_(); ++$$5) {
                        ItemStack $$6 = player.m_150109_().m_8020_($$5);
                        if ($$6.m_41720_().equals(Items.f_42616_)) {
                            int ct = $$6.m_41613_();
                            if (j + ct > entry.costE) {
                                $$6.m_41774_(entry.costE);
                                j += entry.costE;
                            } else {
                                $$6.m_41774_(ct);
                                j += ct;
                            }
                        }
                        if (j >= entry.costE) break;
                    }
                    SoundEvent $$6 = ModSounds.CINDERELLA_SPARKLE_EVENT;
                    player.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)player.m_20182_()), $$6, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        } else if (context == 12) {
            Entity target5 = player.m_9236_().m_6815_(data);
            if (target5 instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)target5;
                aes.addPlayerToList(player);
            }
        } else if (context == 13 && (target = player.m_9236_().m_6815_(data)) instanceof Aesthetician) {
            Aesthetician aes = (Aesthetician)target;
            aes.removePlayerFromList(player);
        }
    }

    public static void addItem(Player player, ItemStack stack) {
        ItemEntity $$4 = new ItemEntity(player.m_9236_(), player.m_146892_().f_82479_, player.m_146892_().f_82480_, player.m_146892_().f_82481_, stack);
        $$4.m_32010_(0);
        $$4.m_32052_(player.m_20148_());
        player.m_9236_().m_7967_((Entity)$$4);
    }

    public static void syncActivePower(Player pl, byte activePower) {
        StandPowers powers = ((StandUser)pl).roundabout$getStandPowers();
        if (powers.activePower != activePower) {
            if (activePower == 0) {
                powers.setAttackTimeDuring(-1);
            } else {
                powers.setAttackTimeDuring(0);
            }
        }
        powers.updateMovesFromPacket(activePower);
        powers.setActivePower(activePower);
        powers.kickStartClient();
    }

    public static void syncCooldownsForAttacks(int attackTime, int attackTimeMax, int attackTimeDuring, byte activePower, byte activePowerPhase, Player pl) {
        StandPowers powers = ((StandUser)pl).roundabout$getStandPowers();
        if (powers.activePower != activePower) {
            if (activePower == 0) {
                powers.setAttackTimeDuring(-1);
            } else {
                powers.setAttackTimeDuring(0);
            }
        }
        powers.updateMovesFromPacket(activePower);
        powers.setActivePower(activePower);
        powers.kickStartClient();
    }

    public static Entity raytraceEntity(Level world, LivingEntity player, double maxDistance) {
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos = player.m_20299_(1.0f);
        ClipContext blockContext = new ClipContext(eyePos, reachVec = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(maxDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult blockHit = world.m_45547_(blockContext);
        double blockHitDistance = blockHit != null ? blockHit.m_82450_().m_82554_(eyePos) : maxDistance;
        AABB box = player.m_20191_().m_82369_(lookVec.m_82490_(maxDistance)).m_82400_(1.0);
        List candidates = world.m_6249_((Entity)player, box, e -> e instanceof LivingEntity && e.m_6087_() && e.m_6084_());
        Entity closest = null;
        double closestDistance = blockHitDistance;
        for (Entity entity : candidates) {
            double hitDistance;
            AABB aabb = entity.m_20191_().m_82400_(0.3);
            Optional hitOptional = aabb.m_82371_(eyePos, reachVec);
            if (!hitOptional.isPresent() || !((hitDistance = eyePos.m_82554_((Vec3)hitOptional.get())) < closestDistance)) continue;
            closestDistance = hitDistance;
            closest = entity;
        }
        return closest;
    }

    public static Entity raytraceEntityStand(Level world, LivingEntity player, double maxDistance) {
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos = player.m_20299_(1.0f);
        ClipContext blockContext = new ClipContext(eyePos, reachVec = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(maxDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult blockHit = world.m_45547_(blockContext);
        double blockHitDistance = blockHit != null ? blockHit.m_82450_().m_82554_(eyePos) : maxDistance;
        AABB box = player.m_20191_().m_82369_(lookVec.m_82490_(maxDistance)).m_82400_(1.0);
        List candidates = world.m_6249_((Entity)player, box, e -> e instanceof Entity && e.m_6087_() && e.m_6084_());
        Entity closest = null;
        double closestDistance = blockHitDistance;
        for (Entity entity : candidates) {
            double hitDistance;
            AABB aabb = entity.m_20191_().m_82400_(0.3);
            Optional hitOptional = aabb.m_82371_(eyePos, reachVec);
            if (!hitOptional.isPresent() || !((hitDistance = eyePos.m_82554_((Vec3)hitOptional.get())) < closestDistance) || entity.m_5833_() || !MainUtil.isStandPickable(entity) || entity.m_20147_() || entity.m_20363_((Entity)player)) continue;
            closestDistance = hitDistance;
            closest = entity;
        }
        return closest;
    }

    public static Entity raytraceEntityStandThroughWalls(Level world, LivingEntity player, double maxDistance) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 reachVec = eyePos.m_82549_(lookVec.m_82490_(maxDistance));
        ClipContext blockContext = new ClipContext(eyePos, reachVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult blockHit = world.m_45547_(blockContext);
        double blockHitDistance = maxDistance;
        AABB box = player.m_20191_().m_82369_(lookVec.m_82490_(maxDistance)).m_82400_(1.0);
        List candidates = world.m_6249_((Entity)player, box, e -> e instanceof Entity && e.m_6087_() && e.m_6084_());
        Entity closest = null;
        double closestDistance = blockHitDistance;
        for (Entity entity : candidates) {
            double hitDistance;
            AABB aabb = entity.m_20191_().m_82400_(0.3);
            Optional hitOptional = aabb.m_82371_(eyePos, reachVec);
            if (!hitOptional.isPresent() || !((hitDistance = eyePos.m_82554_((Vec3)hitOptional.get())) < closestDistance) || entity.m_5833_() || !MainUtil.isStandPickable(entity) || entity.m_20147_() || entity.m_20363_((Entity)player)) continue;
            closestDistance = hitDistance;
            closest = entity;
        }
        return closest;
    }
}

