/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FollowingStandEntity
extends StandEntity {
    protected static final EntityDataAccessor<Integer> ANCHOR_PLACE = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ANCHOR_PLACE_ATTACK = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> OFFSET_TYPE = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Float> DISTANCE_OUT = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> SIZE_PERCENT = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> IDLE_ROTATION = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> IDLE_Y_OFFSET = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public byte lastOffsetType = 0;
    @Nullable
    public LivingEntity Following;
    protected static final EntityDataAccessor<Integer> FOLLOWING_ID = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> MOVE_FORWARD = SynchedEntityData.m_135353_(FollowingStandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    protected FollowingStandEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public final void setAnchorPlace(Integer degrees) {
        this.f_19804_.m_135381_(ANCHOR_PLACE, (Object)degrees);
    }

    public final void setAnchorPlaceAttack(Integer degrees) {
        this.f_19804_.m_135381_(ANCHOR_PLACE_ATTACK, (Object)degrees);
    }

    public final void setDistanceOut(float blocks) {
        this.f_19804_.m_135381_(DISTANCE_OUT, (Object)Float.valueOf(blocks));
    }

    public final float getDistanceOut() {
        return ((Float)this.f_19804_.m_135370_(DISTANCE_OUT)).floatValue();
    }

    public final void setSizePercent(float blocks) {
        this.f_19804_.m_135381_(SIZE_PERCENT, (Object)Float.valueOf(blocks));
    }

    public final float getSizePercent() {
        return ((Float)this.f_19804_.m_135370_(SIZE_PERCENT)).floatValue();
    }

    public final void setIdleRotation(float blocks) {
        this.f_19804_.m_135381_(IDLE_ROTATION, (Object)Float.valueOf(blocks));
    }

    public final float getIdleRotation() {
        return ((Float)this.f_19804_.m_135370_(IDLE_ROTATION)).floatValue();
    }

    public final void setIdleYOffset(float blocks) {
        this.f_19804_.m_135381_(IDLE_Y_OFFSET, (Object)Float.valueOf(blocks));
    }

    public final float getIdleYOffset() {
        return ((Float)this.f_19804_.m_135370_(IDLE_Y_OFFSET)).floatValue();
    }

    public final int getAnchorPlace() {
        return (Integer)this.f_19804_.m_135370_(ANCHOR_PLACE);
    }

    public final int getAnchorPlaceAttack() {
        return (Integer)this.f_19804_.m_135370_(ANCHOR_PLACE_ATTACK);
    }

    public final byte getOffsetType() {
        if (this.m_9236_().m_5776_() && ClientUtil.getScreenFreeze()) {
            return this.lastOffsetType;
        }
        return (Byte)this.f_19804_.m_135370_(OFFSET_TYPE);
    }

    @Override
    public boolean redirectKnockbackToUser() {
        return true;
    }

    public final void setOffsetType(byte oft) {
        this.f_19804_.m_135381_(OFFSET_TYPE, (Object)oft);
    }

    @Override
    public void m_8119_() {
        this.validateUUID();
        float pitch = this.m_146909_();
        float yaw = this.m_146908_();
        byte ot = this.getOffsetType();
        if (this.lastOffsetType != ot) {
            this.lastOffsetType = ot;
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && !this.forceVisible && OffsetIndex.OffsetStyle(ot) == 2) {
            this.m_146926_(pitch);
            this.m_146922_(yaw);
            this.m_5618_(yaw);
            this.f_19860_ = pitch;
            this.f_19859_ = yaw;
        }
    }

    public Vec3 getStandOffsetVector(LivingEntity standUser) {
        byte ot = this.getOffsetType();
        if (OffsetIndex.OffsetStyle(ot) == 0) {
            return this.getIdleOffset(standUser);
        }
        if (OffsetIndex.OffsetStyle(ot) == 1) {
            Direction direction = ((IGravityEntity)standUser).roundabout$getGravityDirection();
            Vec3 finalized = this.getAttackOffset(standUser, ot);
            if (direction != Direction.DOWN) {
                finalized = RotationUtil.vecPlayerToWorld(finalized.m_82546_(standUser.m_20182_()), direction).m_82549_(standUser.m_20182_());
            }
            return finalized;
        }
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public Vec3 getAttackOffset(LivingEntity standUser, byte ot) {
        float distanceFront;
        if (ot == 6) {
            Vec3 frontVectors = this.FrontVectors((Entity)standUser, 180.0, 0.0f);
            return new Vec3(frontVectors.f_82479_, frontVectors.f_82480_ - 1.1, frontVectors.f_82481_);
        }
        float standrotDir2 = 0.0f;
        float standrotDir = (float)this.getPunchYaw(this.getAnchorPlaceAttack(), 1.0);
        if (standrotDir > 0.0f) {
            standrotDir2 = 90.0f;
        } else if (standrotDir < 0.0f) {
            standrotDir2 = -90.0f;
        }
        float addY = 0.3f;
        float addXYZ = 0.3f;
        float addXZ = 0.7f;
        if (ot == 2 || ot == 8) {
            addXZ -= 0.015f;
            distanceFront = 1.05f;
        } else if (ot == 9) {
            addXZ += 0.15f;
            distanceFront = 1.05f;
        } else {
            distanceFront = ((StandUser)standUser).roundabout$getStandPowers().getDistanceOutAccurate((Entity)standUser, ((StandUser)standUser).roundabout$getStandReach(), true);
        }
        Vec3 frontVectors = this.FrontVectors((Entity)standUser, 0.0, distanceFront);
        Vec3 vec3d2 = DamageHandler.getRotationVector(0.0f, standUser.m_6080_() + standrotDir2);
        frontVectors = frontVectors.m_82520_(vec3d2.f_82479_ * (double)addXZ, 0.0, vec3d2.f_82481_ * (double)addXZ);
        return new Vec3(frontVectors.f_82479_, frontVectors.f_82480_ + (double)standUser.m_20236_(standUser.m_20089_()) + (double)addY - 1.6, frontVectors.f_82481_);
    }

    public Vec3 getIdleOffset(LivingEntity standUser) {
        int vis = this.getFadeOut();
        double r = (double)vis / 8.0 * (double)(standUser.m_20205_() / 2.0f + this.getDistanceOut());
        if (r < 0.5) {
            r = 0.5;
        }
        double yawfix = standUser.m_146908_();
        if ((yawfix += (double)this.getAnchorPlace()) > 360.0) {
            yawfix -= 360.0;
        } else if (yawfix < 0.0) {
            yawfix += 360.0;
        }
        double ang = (yawfix - 180.0) * Math.PI;
        double mcap = 0.3;
        Vec3 xyz = standUser.m_20184_();
        double yy = xyz.m_7098_() * 0.3;
        if (yy > mcap) {
            yy = mcap;
        } else if (yy < -mcap) {
            yy = -mcap;
        }
        if (this.m_6069_() || this.m_20143_() || this.m_21255_()) {
            yy += 1.0;
        }
        Direction dir = ((IGravityEntity)standUser).roundabout$getGravityDirection();
        Vec3 offset = new Vec3(-(-1.0 * (r * Math.sin(ang / 180.0))), (double)this.getIdleYOffset() - yy, -(r * Math.cos(ang / 180.0)));
        if (dir != Direction.DOWN) {
            offset = RotationUtil.vecPlayerToWorld(offset, dir);
        }
        double x1 = standUser.m_20185_() + offset.f_82479_;
        double y1 = standUser.m_20186_() + offset.f_82480_;
        double z1 = standUser.m_20189_() + offset.f_82481_;
        return new Vec3(x1, y1, z1);
    }

    public LivingEntity getFollowing() {
        if (this.m_9236_().f_46443_) {
            return (LivingEntity)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(FOLLOWING_ID)).intValue());
        }
        if (this.Following != null && this.Following.m_213877_()) {
            this.setFollowing(null);
        }
        return this.Following;
    }

    public LivingEntity getFollowingAggressive() {
        return (LivingEntity)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(FOLLOWING_ID)).intValue());
    }

    @Override
    public boolean canBeHitByStands() {
        return this.isRemoteControlled() || this.getFollowing() != this.getUser() || this.getFollowing() == null && this.getUser() == null;
    }

    @Override
    public void setFollowing(LivingEntity StandSet) {
        this.Following = StandSet;
        int standSetId = -1;
        if (StandSet != null) {
            standSetId = StandSet.m_19879_();
        }
        this.f_19804_.m_135381_(FOLLOWING_ID, (Object)standSetId);
    }

    @Override
    protected void m_8097_() {
        if (!this.f_19804_.m_285897_(FOLLOWING_ID)) {
            super.m_8097_();
            this.f_19804_.m_135372_(FOLLOWING_ID, (Object)-1);
            this.f_19804_.m_135372_(OFFSET_TYPE, (Object)0);
            this.f_19804_.m_135372_(ANCHOR_PLACE, (Object)55);
            this.f_19804_.m_135372_(ANCHOR_PLACE_ATTACK, (Object)55);
            this.f_19804_.m_135372_(DISTANCE_OUT, (Object)Float.valueOf(1.07f));
            this.f_19804_.m_135372_(MOVE_FORWARD, (Object)0);
            this.f_19804_.m_135372_(SIZE_PERCENT, (Object)Float.valueOf(1.0f));
            this.f_19804_.m_135372_(IDLE_ROTATION, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(IDLE_Y_OFFSET, (Object)Float.valueOf(0.1f));
        }
    }

    public final void setMoveForward(Byte MF) {
        this.f_19804_.m_135381_(MOVE_FORWARD, (Object)MF);
    }

    public final byte getMoveForward() {
        return (Byte)this.f_19804_.m_135370_(MOVE_FORWARD);
    }

    public void tickStandOut() {
        byte ot = this.getOffsetType();
        if (this.lockPos()) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_8119_();
        if (this.getFollowing() == null) {
            return;
        }
        if (OffsetIndex.OffsetStyle(ot) != 2 || this.m_6109_()) {
            ((StandUser)this.getFollowing()).roundabout$updateStandOutPosition(this);
        }
    }
}

