/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.fates.powers;

import net.hydra.jojomod.access.AccessFateFoodData;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.fates.FatePowers;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class VampiricFate
extends FatePowers {
    public static final byte BLOOD_SUCK = 27;
    public Entity bloodSuckingTarget = null;

    public VampiricFate(LivingEntity self) {
        super(self);
    }

    public VampiricFate() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void tickPower() {
        this.tickBloodSuck();
        super.tickPower();
    }

    public void tickBloodSuck() {
        if (!this.self.m_9236_().m_5776_()) {
            Entity TE;
            if (this.self.m_6117_() && (this.bloodSuckingTarget != null || this.getActivePower() == 27)) {
                this.bloodSuckingTarget = null;
                this.xTryPower((byte)0, true);
            }
            if (this.bloodSuckingTarget != null && (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && this.self.f_20916_ <= 0 && this.bloodSuckingTarget.m_7306_(TE)) {
                if (TE instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)TE;
                    ((StandUser)LE).roundabout$setDazed((byte)3);
                    LE.m_20334_(0.0, (double)-0.1f, 0.0);
                }
                if (this.self.f_19797_ % 2 == 0) {
                    double random = Math.random() * 0.8 - 0.4;
                    double random2 = Math.random() * 0.8 - 0.4;
                    double random3 = Math.random() * 0.8 - 0.4;
                    SimpleParticleType particle = ModParticles.BLOOD;
                    if (MainUtil.hasBlueBlood(TE)) {
                        particle = ModParticles.BLUE_BLOOD;
                    }
                    ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)particle, TE.m_20185_() + random, TE.m_20186_() + (double)TE.m_20192_() + random2, TE.m_20189_() + random3, 0, this.self.m_20185_() - TE.m_20185_(), this.self.m_20186_() - TE.m_20186_() + (double)TE.m_20192_(), this.self.m_20189_() - TE.m_20189_(), 0.08);
                }
            }
            if (this.getActivePower() == 27) {
                if (this.attackTimeDuring == 0 || this.attackTimeDuring == 5) {
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SUCK_EVENT, SoundSource.PLAYERS, 1.0f, 0.95f + (float)(Math.random() * 0.1));
                }
                if (this.attackTimeDuring >= 20) {
                    this.finishSucking();
                    this.bloodSuckingTarget = null;
                }
            }
        } else {
            Entity TE;
            if (!(this.bloodSuckingTarget == null || (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && this.self.f_20916_ <= 0 && this.bloodSuckingTarget.m_7306_(TE))) {
                this.xTryPower((byte)0, true);
                C2SPacketUtil.cancelSuckingPacket();
                this.bloodSuckingTarget = null;
            }
            if (this.getActivePower() == 27 && this.attackTimeDuring >= 20 && this.isPacketPlayer() && this.attackTimeDuring == 20) {
                C2SPacketUtil.finishSuckingPacket();
            }
        }
    }

    public void packetFinish() {
        if (this.getActivePower() == 27) {
            this.finishSucking();
        }
    }

    public void packetCancel() {
        if (this.getActivePower() == 27) {
            this.xTryPower((byte)0, true);
        }
        this.bloodSuckingTarget = null;
    }

    public void finishSucking() {
        LivingEntity livingEntity;
        if (this.bloodSuckingTarget != null && (livingEntity = this.self) instanceof Player) {
            Entity entity;
            Player pl = (Player)livingEntity;
            boolean canDrainGood = MainUtil.canDrinkBloodCrit(this.bloodSuckingTarget, (Entity)this.self);
            DamageSource sauce = ModDamageTypes.of(this.self.m_9236_(), ModDamageTypes.BLOOD_DRAIN);
            if (this.bloodSuckingTarget.m_6469_(sauce, 4.0f) && (entity = this.bloodSuckingTarget) instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)entity;
                if (canDrainGood) {
                    if (pl.m_36391_(false)) {
                        pl.m_36324_().m_38707_(6, 1.0f);
                    } else if (((AccessFateFoodData)pl.m_36324_()).rdbt$getRealSaturation() < 7.0f) {
                        pl.m_36324_().m_38707_(6, 0.5f);
                    } else {
                        pl.m_36324_().m_38707_(6, 0.0f);
                    }
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SUCK_DRAIN_EVENT, SoundSource.PLAYERS, 1.0f, 1.4f + (float)(Math.random() * 0.1));
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(Math.random() * 0.1));
                    boolean $$23 = true;
                    ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.bloodSuckingTarget.m_146892_().f_82479_, this.bloodSuckingTarget.m_146892_().f_82480_, this.bloodSuckingTarget.m_146892_().f_82481_, 15, 0.2, 0.2, 0.2, 0.0);
                } else {
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SUCK_DRAIN_EVENT, SoundSource.PLAYERS, 1.0f, 1.4f + (float)(Math.random() * 0.1));
                    pl.m_36324_().m_38707_(2, 0.0f);
                }
                MainUtil.makeBleed(this.bloodSuckingTarget, 0, 200, null);
            }
            this.bloodSuckingTarget = null;
            this.xTryPower((byte)0, true);
        }
    }

    public void suckBlood() {
        Entity TE;
        if (!this.onCooldown((byte)11) && (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self)) {
            this.setActivePower((byte)27);
            this.self.m_6858_(false);
            this.tryIntPowerPacket((byte)27, TE.m_19879_());
            this.bloodSuckingTarget = TE;
            this.attackTimeDuring = 0;
            this.setCooldown((byte)11, 60);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (this.activePower == 27 && move != 27 && !this.self.m_9236_().m_5776_()) {
            super.setPlayerPos2((byte)0);
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 27) {
            this.bloodSuckingTarget = this.self.m_9236_().m_6815_(chargeTime);
            this.setActivePower((byte)27);
            this.self.m_6858_(false);
            if (!this.self.m_9236_().m_5776_()) {
                super.setPlayerPos2((byte)1);
            }
            this.attackTimeDuring = 0;
            if (this.bloodSuckingTarget != null) {
                this.bloodSuckingTarget.m_20256_(Vec3.f_82478_);
            }
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.getActivePower() == 27) {
            basis *= 0.2f;
        }
        return basis;
    }

    @Override
    public float zoomMod() {
        if (this.getActivePower() == 27) {
            return 0.6f;
        }
        return 1.0f;
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        Entity TE;
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8 - 1;
        if (!standOn && (TE = this.getTargetEntity((LivingEntity)playerEntity, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self)) {
            if (this.getActivePower() == 27) {
                int test = (int)(0.85f * (float)Mth.m_14045_((int)this.attackTimeDuring, (int)0, (int)20));
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 36, 17, 8);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 44, 17 - test, 8);
            } else {
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 44, 17, 8);
            }
        }
    }

    @Override
    public boolean cancelSprintJump() {
        return this.getActivePower() == 27;
    }

    @Override
    public boolean cancelSprint() {
        return this.getActivePower() == 27;
    }

    @Override
    public boolean cancelSprintParticles() {
        return this.getActivePower() == 27;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        Entity TE = this.getUserData(this.self).roundabout$getStandPowers().getTargetEntity(this.self, 3.0f, 15.0f);
        if (slot == 2 && !MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && !this.isHoldingSneak()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    public boolean isVisionOn() {
        return true;
    }

    @Override
    public ResourceLocation getIconYes(int slot) {
        if ((slot == 2 || slot == 3) && this.isHoldingSneak()) {
            return StandIcons.SQUARE_ICON_BLOOD;
        }
        return StandIcons.SQUARE_ICON;
    }
}

