/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers.visages;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.IPlayerModel;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.ModStrayModels;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.npcs.ZombieAesthetician;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.visagedata.VisageData;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.stand.powers.PowersWalkingHeart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VisagePartLayer<T extends LivingEntity, A extends HumanoidModel<T>>
extends RenderLayer<T, A> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final EntityRenderDispatcher dispatcher;
    float scale = 1.0f;
    private static final ResourceLocation TEXTURE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/large_bubble.png");

    public VisagePartLayer(EntityRendererProvider.Context context, LivingEntityRenderer<T, A> livingEntityRenderer) {
        super(livingEntityRenderer);
        this.dispatcher = context.m_174022_();
    }

    protected boolean getRenderT(T $$0, boolean $$1, boolean $$2, boolean $$3) {
        ResourceLocation $$4 = this.m_117347_((Entity)$$0);
        if ($$2 || $$1) {
            return true;
        }
        return $$3;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float var9, float var10) {
        boolean $$20;
        boolean $$19;
        boolean $$18;
        boolean $$21;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && ($$21 = this.getRenderT(entity, $$18 = !entity.m_20145_(), $$19 = !$$18 && !entity.m_20177_((Player)minecraft.f_91074_), $$20 = minecraft.m_91314_(entity)))) {
            Item alpha2;
            PowersWalkingHeart PW;
            ItemStack visage = null;
            if (entity instanceof Player) {
                Player play = (Player)entity;
                IPlayerEntity pl = (IPlayerEntity)play;
                visage = pl.roundabout$getMaskSlot();
                ShapeShifts shift = ShapeShifts.getShiftFromByte(pl.roundabout$getShapeShift());
                if (shift == ShapeShifts.OVA) {
                    visage = ModItems.ENYA_OVA_MASK.m_7968_();
                }
            } else if (entity instanceof JojoNPC) {
                JojoNPC jnpc = (JojoNPC)((Object)entity);
                visage = jnpc.getBasis();
            } else if (entity instanceof ZombieAesthetician) {
                ZombieAesthetician znpc = (ZombieAesthetician)((Object)entity);
                visage = znpc.getBasis();
            }
            boolean isHurt = ((LivingEntity)entity).f_20916_ > 0;
            float r = isHurt ? 1.0f : 1.0f;
            float g = isHurt ? 0.6f : 1.0f;
            float b = isHurt ? 0.6f : 1.0f;
            StandUser user = (StandUser)entity;
            StandPowers standPowers = user.roundabout$getStandPowers();
            if (standPowers instanceof PowersWalkingHeart && ((PW = (PowersWalkingHeart)standPowers).inCombatMode() || PW.hasExtendedHeelsForWalking()) && user instanceof AbstractClientPlayer) {
                AbstractClientPlayer PE = (AbstractClientPlayer)user;
                this.renderRightHeelPart(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, PE.m_108560_(), r, g, b);
                this.renderLeftHeelPart(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, PE.m_108560_(), r, g, b);
            }
            byte curse = user.roundabout$getLocacacaCurse();
            int muscle = user.roundabout$getZappedToID();
            if (muscle > -1) {
                float scale = 1.055f;
                float alpha2 = 0.6f;
                float oscillation = Math.abs((float)(((LivingEntity)entity).f_19797_ % 10) + partialTicks % 1.0f - 5.0f) * 0.04f;
                alpha2 += oscillation;
                if (entity.m_5737_() == HumanoidArm.RIGHT) {
                    if (curse != 4) {
                        PlayerModel PM;
                        EntityModel entityModel = this.m_117386_();
                        if (entityModel instanceof PlayerModel && ((IPlayerModel)(PM = (PlayerModel)entityModel)).roundabout$getSlim()) {
                            this.renderRightArmSlim(poseStack, bufferSource, packedLight, entity, scale, scale, scale, partialTicks, r, g, b, StandIcons.MUSCLE_SLIM, 0.01f, 0.0f, 0.0f, alpha2);
                        } else {
                            this.renderRightArm(poseStack, bufferSource, packedLight, entity, scale, scale, scale, partialTicks, r, g, b, StandIcons.MUSCLE, 0.01f, 0.0f, 0.0f, alpha2);
                        }
                    }
                    if (curse != 2) {
                        this.renderRightLeg(poseStack, bufferSource, packedLight, entity, scale, scale, scale, partialTicks, r, g, b, StandIcons.MUSCLE, 0.01f, 0.0f, 0.0f, alpha2);
                    }
                } else {
                    if (curse != 3) {
                        PlayerModel PM;
                        EntityModel entityModel = this.m_117386_();
                        if (entityModel instanceof PlayerModel && ((IPlayerModel)(PM = (PlayerModel)entityModel)).roundabout$getSlim()) {
                            this.renderLeftArmSlim(poseStack, bufferSource, packedLight, entity, scale, scale, scale, partialTicks, r, g, b, StandIcons.MUSCLE_SLIM, -0.01f, 0.0f, 0.0f, alpha2);
                        } else {
                            this.renderLeftArm(poseStack, bufferSource, packedLight, entity, scale, scale, scale, partialTicks, r, g, b, StandIcons.MUSCLE, -0.01f, 0.0f, 0.0f, alpha2);
                        }
                    }
                    if (curse != 1) {
                        this.renderLeftLeg(poseStack, bufferSource, packedLight, entity, scale, scale, scale, partialTicks, r, g, b, StandIcons.MUSCLE, -0.01f, 0.0f, 0.0f, alpha2);
                    }
                }
            }
            if (visage != null && !visage.m_41619_() && (alpha2 = visage.m_41720_()) instanceof MaskItem) {
                MaskItem MI = (MaskItem)alpha2;
                VisageData vd = MI.visageData.generateVisageData((LivingEntity)entity);
                String path = MI.visageData.getSkinPath();
                if (vd.rendersBreast()) {
                    this.renderNormalBreast(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersSmallBreast()) {
                    this.renderSmallBreast(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersPonytail()) {
                    this.renderPonytail(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersBigHair()) {
                    this.renderBigHair(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersDiegoHat()) {
                    this.renderDiegoHat(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersBasicHat()) {
                    this.renderBasicHat(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersSpikeyHair()) {
                    this.renderSpikeyHair(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersJosukeDecals()) {
                    this.renderJosukeDecals(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersTasselHat()) {
                    this.renderTasselHat(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersLegCloakPart()) {
                    this.renderLegCloakPart(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersAvdolHairPart()) {
                    this.renderAvdolHair(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, path, r, g, b);
                }
                if (vd.rendersPlayerBreastPart()) {
                    this.renderPlayerBreastPart(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, r, g, b);
                }
                if (vd.rendersPlayerSmallBreastPart()) {
                    this.renderSmallPlayerBreastPart(poseStack, bufferSource, packedLight, entity, xx, yy, zz, partialTicks, r, g, b);
                }
            }
        }
    }

    public void renderRightLeg(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b, ResourceLocation RL, float xtrans, float ytrans, float ztrans, float alpha) {
        if (((HumanoidModel)this.m_117386_()).f_102813_.f_104207_) {
            ClientUtil.pushPoseAndCooperate(poseStack, 46);
            ((HumanoidModel)this.m_117386_()).f_102813_.m_104299_(poseStack);
            ModStrayModels.RightLeg.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, alpha, RL, xx, yy, zz, xtrans, ytrans, ztrans);
            ClientUtil.popPoseAndCooperate(poseStack, 46);
        }
    }

    public void renderLeftLeg(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b, ResourceLocation RL, float xtrans, float ytrans, float ztrans, float alpha) {
        if (((HumanoidModel)this.m_117386_()).f_102814_.f_104207_) {
            ClientUtil.pushPoseAndCooperate(poseStack, 45);
            ((HumanoidModel)this.m_117386_()).f_102814_.m_104299_(poseStack);
            ModStrayModels.LeftLeg.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, alpha, RL, xx, yy, zz, xtrans, ytrans, ztrans);
            ClientUtil.popPoseAndCooperate(poseStack, 45);
        }
    }

    public void renderRightArm(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b, ResourceLocation RL, float xtrans, float ytrans, float ztrans, float alpha) {
        if (((HumanoidModel)this.m_117386_()).f_102811_.f_104207_) {
            ClientUtil.pushPoseAndCooperate(poseStack, 27);
            ((HumanoidModel)this.m_117386_()).f_102811_.m_104299_(poseStack);
            ModStrayModels.RightArm.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, alpha, RL, xx, yy, zz, xtrans, ytrans, ztrans);
            ClientUtil.popPoseAndCooperate(poseStack, 28);
        }
    }

    public void renderRightArmSlim(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b, ResourceLocation RL, float xtrans, float ytrans, float ztrans, float alpha) {
        if (((HumanoidModel)this.m_117386_()).f_102811_.f_104207_) {
            ClientUtil.pushPoseAndCooperate(poseStack, 29);
            ((HumanoidModel)this.m_117386_()).f_102811_.m_104299_(poseStack);
            ModStrayModels.RightArmSlim.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, alpha, RL, xx, yy, zz, xtrans, ytrans, ztrans);
            ClientUtil.popPoseAndCooperate(poseStack, 29);
        }
    }

    public void renderLeftArm(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b, ResourceLocation RL, float xtrans, float ytrans, float ztrans, float alpha) {
        if (((HumanoidModel)this.m_117386_()).f_102812_.f_104207_) {
            ClientUtil.pushPoseAndCooperate(poseStack, 30);
            ((HumanoidModel)this.m_117386_()).f_102812_.m_104299_(poseStack);
            ModStrayModels.LeftArm.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, alpha, RL, xx, yy, zz, xtrans, ytrans, ztrans);
            ClientUtil.popPoseAndCooperate(poseStack, 30);
        }
    }

    public void renderLeftArmSlim(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b, ResourceLocation RL, float xtrans, float ytrans, float ztrans, float alpha) {
        if (((HumanoidModel)this.m_117386_()).f_102812_.f_104207_) {
            ClientUtil.pushPoseAndCooperate(poseStack, 31);
            ((HumanoidModel)this.m_117386_()).f_102812_.m_104299_(poseStack);
            ModStrayModels.LeftArmSlim.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, alpha, RL, xx, yy, zz, xtrans, ytrans, ztrans);
            ClientUtil.popPoseAndCooperate(poseStack, 31);
        }
    }

    public void renderNormalBreast(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 32);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.ChestPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 32);
    }

    public void renderSmallBreast(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 33);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.SmallChestPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 33);
    }

    public void renderPonytail(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 34);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.PonytailPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 34);
    }

    public void renderBigHair(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 35);
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        ModStrayModels.BigHairPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 35);
    }

    public void renderDiegoHat(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 36);
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        ModStrayModels.DiegoHatPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 36);
    }

    public void renderBasicHat(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 37);
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        ModStrayModels.BasicHatPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 37);
    }

    public void renderSpikeyHair(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 38);
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        ModStrayModels.SpikeyHairPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 38);
    }

    public void renderAvdolHair(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 39);
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        ModStrayModels.AvdolHairPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 39);
    }

    public void renderJosukeDecals(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 40);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.JosukeDecalsPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 40);
    }

    public void renderTasselHat(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 41);
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        ModStrayModels.TasselHatPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 41);
    }

    public void renderLegCloakPart(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, String path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 42);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.LegCloakPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path, -1.0f * Math.min(((HumanoidModel)this.m_117386_()).f_102814_.f_104203_, ((HumanoidModel)this.m_117386_()).f_102813_.f_104203_));
        ClientUtil.popPoseAndCooperate(poseStack, 42);
    }

    public void renderRightHeelPart(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, ResourceLocation path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 45);
        ((HumanoidModel)this.m_117386_()).f_102814_.m_104299_(poseStack);
        ModStrayModels.LeftHeel.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 45);
    }

    public void renderLeftHeelPart(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, ResourceLocation path, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 45);
        ((HumanoidModel)this.m_117386_()).f_102813_.m_104299_(poseStack);
        ModStrayModels.RightHeel.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, path);
        ClientUtil.popPoseAndCooperate(poseStack, 45);
    }

    public void renderPlayerBreastPart(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 43);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.PlayerChestPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f);
        ClientUtil.popPoseAndCooperate(poseStack, 43);
    }

    public void renderSmallPlayerBreastPart(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float xx, float yy, float zz, float partialTicks, float r, float g, float b) {
        ClientUtil.pushPoseAndCooperate(poseStack, 44);
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        ModStrayModels.PlayerSmallChestPart.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f);
        ClientUtil.popPoseAndCooperate(poseStack, 44);
    }
}

