/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.stand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.client.models.layers.ModEntityRendererClient;
import net.hydra.jojomod.client.models.stand.DiverDownModel;
import net.hydra.jojomod.client.models.stand.renderers.StandRenderer;
import net.hydra.jojomod.entity.stand.DiverDownEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DiverDownRenderer
extends StandRenderer<DiverDownEntity> {
    private static final ResourceLocation PART_6 = new ResourceLocation("roundabout", "textures/stand/diver_down/base.png");
    private static final ResourceLocation LAVA_DIVER = new ResourceLocation("roundabout", "textures/stand/diver_down/lavadiver.png");
    private static final ResourceLocation RED_DIVER = new ResourceLocation("roundabout", "textures/stand/diver_down/reddiver.png");
    private static final ResourceLocation ORANGE_DIVER = new ResourceLocation("roundabout", "textures/stand/diver_down/orangediver.png");
    private static final ResourceLocation TREASURE_DIVER = new ResourceLocation("roundabout", "textures/stand/diver_down/treasurediver.png");
    private static final ResourceLocation BIRTHDAY_DIVER = new ResourceLocation("roundabout", "textures/stand/diver_down/birthdaydiver.png");

    public DiverDownRenderer(EntityRendererProvider.Context context) {
        super(context, new DiverDownModel(context.m_174023_(ModEntityRendererClient.DIVER_DOWN_LAYER)), 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(DiverDownEntity entity) {
        byte BT = entity.getSkin();
        switch (BT) {
            case 0: {
                return PART_6;
            }
            case 1: {
                return LAVA_DIVER;
            }
            case 2: {
                return RED_DIVER;
            }
            case 3: {
                return ORANGE_DIVER;
            }
            case 4: {
                return TREASURE_DIVER;
            }
            case 5: {
                return BIRTHDAY_DIVER;
            }
        }
        return PART_6;
    }

    @Override
    public void render(DiverDownEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.m_6162_()) {
            matrixStack.m_85841_(0.5f * factor, 0.5f * factor, 0.5f * factor);
        } else {
            matrixStack.m_85841_(0.87f * factor, 0.87f * factor, 0.87f * factor);
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    @Nullable
    protected RenderType getRenderType(DiverDownEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.getRenderType(entity, showBody, true, showOutline);
    }
}

