/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.corpses;

import javax.annotation.Nullable;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.goals.CorpseMeleeAttackGoal;
import net.hydra.jojomod.event.powers.StandUser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FallenSpider
extends FallenMob
implements PlayerRideableJumping {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(FallenSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float SPIDER_SPECIAL_EFFECT_CHANCE = 0.1f;
    protected boolean isJumping;
    protected float playerJumpPendingScale;

    public FallenSpider(EntityType<? extends PathfinderMob> $$0, Level $$1) {
        super($$0, $$1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    public String getData() {
        return "spider";
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_20197_().isEmpty() && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity && this.getActivated() && this.getController() == entity.m_19879_()) {
            return (LivingEntity)entity;
        }
        return null;
    }

    @Override
    public float modX() {
        return 2.0f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new CorpseMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected float m_6431_(Pose $$0, EntityDimensions $$1) {
        return 0.65f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6109_()) {
            this.setClimbing(this.f_19862_);
        }
    }

    protected float m_245547_(Player $$0) {
        return (float)((double)((float)this.m_21133_(Attributes.f_22279_)) * 0.4);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean $$0) {
        this.isJumping = $$0;
    }

    public double getCustomJump() {
        return 0.5;
    }

    protected void executeRidersJump(float $$0, Vec3 $$1) {
        double $$2 = this.getCustomJump() * (double)$$0 * (double)this.m_20098_();
        double $$3 = $$2 + (double)this.m_285755_();
        Vec3 $$4 = this.m_20184_();
        this.m_20334_($$4.f_82479_, $$3, $$4.f_82481_);
        this.setIsJumping(true);
        this.f_19812_ = true;
        if ($$1.f_82481_ > 0.0) {
            float $$5 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float $$6 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * $$5 * $$0), 0.0, (double)(0.4f * $$6 * $$0)));
        }
    }

    protected void m_274498_(Player $$0, Vec3 $$1) {
        super.m_274498_($$0, $$1);
        Vec2 $$2 = this.getRiddenRotation((LivingEntity)$$0);
        this.m_19915_($$2.f_82471_, $$2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_() && this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, $$1);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    public double m_6048_() {
        return this.m_20206_() * 0.5f;
    }

    protected PathNavigation m_6037_(Level $$0) {
        return new WallClimberNavigation((Mob)this, $$0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public boolean m_142535_(float $$0, float $$1, DamageSource $$2) {
        int $$3;
        if ($$0 > 1.0f) {
            // empty if block
        }
        if (($$3 = this.m_5639_($$0, $$1)) <= 0) {
            return false;
        }
        this.m_6469_($$2, $$3);
        this.m_21229_();
        return true;
    }

    protected SoundEvent m_7515_() {
        if (this.getActivated()) {
            return SoundEvents.f_12432_;
        }
        return super.m_7515_();
    }

    protected SoundEvent m_7975_(DamageSource $$0) {
        if (this.getActivated()) {
            return SoundEvents.f_12434_;
        }
        return super.m_7975_($$0);
    }

    protected SoundEvent m_5592_() {
        if (this.getActivated()) {
            return SoundEvents.f_12433_;
        }
        return super.m_5592_();
    }

    protected void m_7355_(BlockPos $$0, BlockState $$1) {
        if (this.getActivated()) {
            LivingEntity livingEntity;
            if (this.getController() > 0 && (livingEntity = this.m_6688_()) instanceof Player) {
                Player PE = (Player)livingEntity;
                if (this.getController() == PE.m_19879_() && ((StandUser)PE).roundabout$getStandPowers().isPiloting()) {
                    return;
                }
            }
            this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState $$0, Vec3 $$1) {
        if (!$$0.m_60713_(Blocks.f_50033_)) {
            super.m_7601_($$0, $$1);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance $$0) {
        return $$0.m_19544_() == MobEffects.f_19614_ ? false : super.m_7301_($$0);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean $$0) {
        byte $$1 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        $$1 = $$0 ? (byte)($$1 | 1) : (byte)($$1 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)$$1);
    }

    public void m_7888_(int var1) {
        if (var1 < 0) {
            var1 = 0;
        }
        this.playerJumpPendingScale = var1 >= 90 ? 1.0f : 0.4f + 0.4f * (float)var1 / 90.0f;
    }

    public boolean m_7132_() {
        return false;
    }

    public void m_7199_(int $$0) {
    }

    public void m_8012_() {
    }

    protected Vec2 getRiddenRotation(LivingEntity $$0) {
        return new Vec2($$0.m_146909_() * 0.5f, $$0.m_146908_());
    }

    protected Vec3 m_274312_(Player $$0, Vec3 $$1) {
        float $$2 = $$0.f_20900_ * 0.5f;
        float $$3 = $$0.f_20902_;
        if ($$3 <= 0.0f) {
            $$3 *= 0.25f;
        }
        return new Vec3((double)$$2, 0.0, (double)$$3);
    }

    protected void doPlayerRide(Player $$0) {
        if (!this.m_9236_().f_46443_) {
            $$0.m_146922_(this.m_146908_());
            $$0.m_146926_(this.m_146909_());
            $$0.m_20329_((Entity)this);
        }
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 $$0, LivingEntity $$1) {
        double $$2 = this.m_20185_() + $$0.f_82479_;
        double $$3 = this.m_20191_().f_82289_;
        double $$4 = this.m_20189_() + $$0.f_82481_;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        block0: for (Pose $$6 : $$1.m_7431_()) {
            $$5.m_122169_($$2, $$3, $$4);
            double $$7 = this.m_20191_().f_82292_ + 0.75;
            do {
                double $$8 = this.m_9236_().m_45573_((BlockPos)$$5);
                if ((double)$$5.m_123342_() + $$8 > $$7) continue block0;
                if (DismountHelper.m_38439_((double)$$8)) {
                    AABB $$9 = $$1.m_21270_($$6);
                    Vec3 $$10 = new Vec3($$2, (double)$$5.m_123342_() + $$8, $$4);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)$$1, (AABB)$$9.m_82383_($$10))) {
                        $$1.m_20124_($$6);
                        return $$10;
                    }
                }
                $$5.m_122173_(Direction.UP);
            } while (!((double)$$5.m_123342_() < $$7));
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity $$0) {
        Vec3 $$1 = FallenSpider.m_19903_((double)this.m_20205_(), (double)$$0.m_20205_(), (float)(this.m_146908_() + ($$0.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 $$2 = this.getDismountLocationInDirection($$1, $$0);
        if ($$2 != null) {
            return $$2;
        }
        Vec3 $$3 = FallenSpider.m_19903_((double)this.m_20205_(), (double)$$0.m_20205_(), (float)(this.m_146908_() + ($$0.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 $$4 = this.getDismountLocationInDirection($$3, $$0);
        return $$4 != null ? $$4 : this.m_20182_();
    }

    public InteractionResult m_6071_(Player $$0, InteractionHand $$1) {
        if (this.m_20160_() || !this.getActivated() || this.getController() != $$0.m_19879_()) {
            return super.m_6071_($$0, $$1);
        }
        this.doPlayerRide($$0);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }
}

