/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.List;
import java.util.UUID;
import net.hydra.jojomod.access.IPermaCasting;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.FireProjectile;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.UnburnableProjectile;
import net.hydra.jojomod.entity.stand.MagiciansRedEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersMagiciansRed;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CrossfireHurricaneEntity
extends AbstractHurtingProjectile
implements UnburnableProjectile,
FireProjectile {
    private static final EntityDataAccessor<Integer> USER_ID = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CROSS_NUMBER = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_SIZE = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity standUser;
    public UUID standUserUUID;
    public boolean fireStormCreated = false;
    public double renderRotation = 0.0;
    public double lastRenderRotation = 0.0;
    public Vec3 storeVec;
    public boolean initialized = false;
    public float renderSize = 0.0f;
    public float lastRenderSize = 0.0f;
    public boolean isBundle = false;
    public boolean isTickable = false;
    public int saneAgeTicking;
    public Vec3 forcedDeltaMovement = null;
    public boolean markCharged = false;
    public int inWaterTicks = 0;

    public CrossfireHurricaneEntity(EntityType<? extends CrossfireHurricaneEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected CrossfireHurricaneEntity(EntityType<? extends CrossfireHurricaneEntity> $$0, double $$1, double $$2, double $$3, Level $$4) {
        this($$0, $$4);
        this.m_6034_($$1, $$2, $$3);
    }

    public CrossfireHurricaneEntity(LivingEntity $$1, Level $$2) {
        this(ModEntities.CROSSFIRE_HURRICANE, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public boolean m_271807_() {
        return false;
    }

    public int getUserID() {
        return (Integer)this.m_20088_().m_135370_(USER_ID);
    }

    public void setUserID(int idd) {
        this.m_20088_().m_135381_(USER_ID, (Object)idd);
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE;
            this.standUser = LE = (LivingEntity)entity;
            if (!this.m_9236_().m_5776_()) {
                this.standUserUUID = LE.m_20148_();
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean isEffectivelyInWater() {
        return this.f_19798_;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    public boolean m_6109_() {
        return super.m_6109_();
    }

    public boolean m_6087_() {
        return false;
    }

    public void setOldPosAndRot2() {
        if (this.storeVec != null) {
            double $$0 = this.storeVec.m_7096_();
            double $$1 = this.storeVec.m_7098_();
            double $$2 = this.storeVec.m_7094_();
            this.f_19854_ = $$0;
            this.f_19855_ = $$1;
            this.f_19856_ = $$2;
            this.f_19790_ = $$0;
            this.f_19791_ = $$1;
            this.f_19792_ = $$2;
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void setRenderRotation(double rotation) {
        this.lastRenderRotation = this.renderRotation;
        this.renderRotation = rotation;
    }

    public void setUser(LivingEntity User) {
        this.standUser = User;
        this.m_20088_().m_135381_(USER_ID, (Object)User.m_19879_());
        if (!this.m_9236_().m_5776_()) {
            this.standUserUUID = User.m_20148_();
        }
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(SIZE);
    }

    public void setSize(int idd) {
        this.m_20088_().m_135381_(SIZE, (Object)idd);
    }

    public int getMaxSize() {
        return (Integer)this.m_20088_().m_135370_(MAX_SIZE);
    }

    public void setMaxSize(int idd) {
        this.m_20088_().m_135381_(MAX_SIZE, (Object)idd);
    }

    public float getRenderSize() {
        return this.renderSize;
    }

    public void setRenderSize(float renderSize) {
        this.renderSize = renderSize;
    }

    public float getLastRenderSize() {
        return this.lastRenderSize;
    }

    public void setLastRenderSize(float renderSize) {
        this.lastRenderSize = renderSize;
    }

    public int getCrossNumber() {
        return (Integer)this.m_20088_().m_135370_(CROSS_NUMBER);
    }

    public void setCrossNumber(int idd) {
        this.m_20088_().m_135381_(CROSS_NUMBER, (Object)idd);
    }

    protected CrossfireHurricaneEntity(EntityType<? extends CrossfireHurricaneEntity> $$0, LivingEntity $$1, Level $$2) {
        this($$0, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public void actuallyTick() {
        this.isTickable = true;
        this.m_8119_();
        this.isTickable = false;
    }

    public void m_142687_(Entity.RemovalReason $$0) {
        StandPowers standPowers;
        LivingEntity le;
        int crossnum = this.getCrossNumber();
        if (crossnum == 7 && !this.m_9236_().m_5776_() && (le = this.getStandUser()) != null && (standPowers = ((StandUser)this.getStandUser()).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            PMR.sealFromKamikaze();
            StandEntity stand = ((StandUser)le).roundabout$getStand();
            if (stand != null) {
                stand.m_146870_();
            }
        }
        super.m_142687_($$0);
    }

    public void m_8119_() {
        StandPowers lv2;
        StandEntity stand;
        PowersMagiciansRed PMR;
        LivingEntity le;
        boolean client = this.m_9236_().m_5776_();
        if (!client) {
            if (this.isEffectivelyInWater()) {
                this.tickWater();
            }
            if (this.getStandUser() != null) {
                if (MainUtil.cheapDistanceTo2(this.m_20185_(), this.m_20189_(), this.standUser.m_20185_(), this.standUser.m_20189_()) > 80.0 || !this.getStandUser().m_6084_() || this.getStandUser().m_213877_()) {
                    this.m_146870_();
                }
            } else {
                this.m_146870_();
            }
        }
        if ((le = this.getStandUser()) != null) {
            StandPowers standPowers = ((StandUser)this.getStandUser()).roundabout$getStandPowers();
            if (standPowers instanceof PowersMagiciansRed) {
                PMR = (PowersMagiciansRed)standPowers;
                int crossnum = this.getCrossNumber();
                if (crossnum > 0 && crossnum < 6) {
                    this.m_20256_(Vec3.f_82478_);
                    if (client && !this.initialized) {
                        if (crossnum < 5) {
                            this.initialized = true;
                            PMR.addHurricaneSpecial(this);
                        } else {
                            PMR.hurricane = this;
                        }
                    }
                    if (!this.isTickable && this.getCrossNumber() < 6) {
                        return;
                    }
                } else if (crossnum == 6) {
                    IPermaCasting icast = (IPermaCasting)le.m_9236_();
                    if (!icast.roundabout$isPermaCastingEntity(le)) {
                        this.m_146870_();
                        return;
                    }
                    if (!client) {
                        if (this.getSize() < this.getMaxSize()) {
                            this.m_20334_(0.0, 0.2, 0.0);
                        } else {
                            this.m_20334_(0.0, 0.0, 0.0);
                        }
                    }
                } else if (crossnum == 7 && (stand = ((StandUser)le).roundabout$getStand()) == null) {
                    this.m_146870_();
                    return;
                }
            } else if (!client) {
                this.m_146870_();
                return;
            }
        }
        if (client && this.saneAgeTicking != this.f_19797_) {
            StandPowers standPowers;
            LivingEntity lv2;
            int ticks;
            this.lastRenderSize = this.lastRenderSize < (float)this.getMaxSize() ? (this.lastRenderSize += this.getAccrualRate()) : (float)this.getMaxSize();
            if (!ClientUtil.checkIfGamePaused() && (ticks = ConfigManager.getClientConfig().particleSettings.cfhTicksPerFlameParticle.intValue()) > -1 && this.f_19797_ % ticks == 0 && (lv2 = this.getUser()) != null && (standPowers = ((StandUser)lv2).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                PowersMagiciansRed MR = (PowersMagiciansRed)standPowers;
                this.m_9236_().m_7106_((ParticleOptions)MR.getFlameParticle(), this.m_20208_(0.26), this.getRandomY(0.26) + (double)this.m_20206_() * 0.55, this.m_20262_(0.26), 0.0, 0.0, 0.0);
            }
        }
        this.saneAgeTicking = this.f_19797_;
        if (this.forcedDeltaMovement != null) {
            this.m_20256_(this.forcedDeltaMovement);
        }
        super.m_8119_();
        if (!client && this.isEffectivelyInWater()) {
            this.tickWater();
        }
        if (le != null && (lv2 = ((StandUser)this.getStandUser()).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PMR = (PowersMagiciansRed)lv2;
            int crossnum = this.getCrossNumber();
            if (crossnum == 7) {
                stand = ((StandUser)le).roundabout$getStand();
                if (stand == null) {
                    this.m_146870_();
                    return;
                }
                stand.m_20248_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                stand.m_146926_(this.m_146909_());
            }
        }
    }

    public LivingEntity getUser() {
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            return LE;
        }
        return null;
    }

    public double getRandomY(double $$0) {
        return this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * $$0);
    }

    protected void m_8060_(BlockHitResult $$0) {
        int crossno = this.getCrossNumber();
        if (crossno <= 0 || crossno == 7) {
            this.radialExplosion(null);
            if (!this.m_9236_().m_5776_()) {
                StandPowers standPowers;
                LivingEntity user = this.getStandUser();
                int size = this.getSize();
                if (user != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                    PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
                    BlockPos pos = $$0.m_82425_().m_121945_($$0.m_82434_());
                    PMR.createStandFire2(pos);
                    if (size >= PowersMagiciansRed.getChargingCrossfireSize()) {
                        PMR.createStandFire2(pos.m_122024_().m_122024_());
                        PMR.createStandFire2(pos.m_122024_().m_122012_());
                        PMR.createStandFire2(pos.m_122024_().m_122019_());
                        PMR.createStandFire2(pos.m_122029_().m_122029_());
                        PMR.createStandFire2(pos.m_122029_().m_122012_());
                        PMR.createStandFire2(pos.m_122029_().m_122019_());
                        PMR.createStandFire2(pos.m_122012_().m_122012_());
                        PMR.createStandFire2(pos.m_122019_().m_122019_());
                        PMR.createStandFire2(pos.m_7494_().m_7494_());
                        PMR.createStandFire2(pos.m_7495_().m_7495_());
                        PMR.createStandFire2(pos.m_122024_().m_7494_());
                        PMR.createStandFire2(pos.m_122012_().m_7494_());
                        PMR.createStandFire2(pos.m_122019_().m_7494_());
                        PMR.createStandFire2(pos.m_122029_().m_7494_());
                        PMR.createStandFire2(pos.m_122024_().m_7495_());
                        PMR.createStandFire2(pos.m_122012_().m_7495_());
                        PMR.createStandFire2(pos.m_122019_().m_7495_());
                        PMR.createStandFire2(pos.m_122029_().m_7495_());
                    }
                    if (size >= PowersMagiciansRed.getChargingCrossfireSpecialSize()) {
                        PMR.createStandFire2(pos.m_122024_());
                        PMR.createStandFire2(pos.m_122012_());
                        PMR.createStandFire2(pos.m_122019_());
                        PMR.createStandFire2(pos.m_122029_());
                        PMR.createStandFire2(pos.m_7494_());
                        PMR.createStandFire2(pos.m_7495_());
                    }
                }
            }
            this.m_146870_();
        }
    }

    public void shootFromRotationDeltaAgnostic(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        Vec3 force;
        Direction gravityDirection = GravityAPI.getGravityDirection($$0);
        if (gravityDirection != Direction.DOWN) {
            Vec2 vecMagic = RotationUtil.rotPlayerToWorld($$0.m_146908_(), $$0.m_146909_(), gravityDirection);
            $$1 = vecMagic.f_82471_;
            $$2 = vecMagic.f_82470_;
        }
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.m_6686_($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
        this.forcedDeltaMovement = force = new Vec3((double)$$6, (double)$$7, (double)$$8).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)$$4)).m_82490_((double)$$3);
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity $$1;
        int crossno = this.getCrossNumber();
        if (!(crossno > 0 && crossno != 7 || MainUtil.isMobOrItsMounts($$1 = $$0.m_82443_(), (Entity)this.getUser()) || $$1 instanceof MagiciansRedEntity || $$1 instanceof Projectile)) {
            if ($$1 instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)$$1;
                this.radialExplosion(LE);
            } else {
                this.radialExplosion(null);
            }
            this.m_146870_();
        }
    }

    public void radialExplosion(LivingEntity mainTarget) {
        StandPowers standPowers;
        LivingEntity user;
        if (!this.m_9236_().m_5776_() && (user = this.getStandUser()) != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            List<Entity> entityList;
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            PMR.addEXP(2);
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.CROSSFIRE_EXPLODE_EVENT, SoundSource.PLAYERS, 2.0f, 1.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 200, 0.01, 0.01, 0.01, 0.1);
            if (mainTarget != null) {
                this.getEntity((Entity)mainTarget, true, PMR);
            }
            if (!(entityList = DamageHandler.genHitbox(user, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0, 2.0, 2.0)).isEmpty()) {
                for (Entity value : entityList) {
                    if (mainTarget != null && value.m_7306_((Entity)mainTarget) || !value.m_6087_()) continue;
                    this.getEntity(value, false, PMR);
                }
            }
        }
    }

    public static void blastEntity(Entity gotten, Entity proj, int size, LivingEntity user, boolean direct, PowersMagiciansRed PMR, boolean fireStorm) {
        LivingEntity LE;
        Mob mb;
        if (!(user instanceof Player || user instanceof Monster || gotten instanceof Monster || user instanceof Mob && (mb = (Mob)user).m_5448_() != null && mb.m_5448_().m_7306_(gotten))) {
            return;
        }
        float dmg = 1.0f;
        float strength = 0.85f;
        if (direct) {
            dmg = PMR.getHurricaneDirectDamage(gotten, size, fireStorm);
            strength *= 2.0f;
        } else {
            dmg = PMR.getHurricaneDamage(gotten, size, fireStorm);
        }
        if (gotten.m_6469_(ModDamageTypes.of(gotten.m_9236_(), ModDamageTypes.CROSSFIRE, (Entity)user), dmg)) {
            if (gotten instanceof LivingEntity) {
                LivingEntity LE2 = (LivingEntity)gotten;
                PMR.addEXP(2, LE2);
                StandUser userLE = (StandUser)LE2;
                int ticks = 21;
                ticks += size * 2;
                if (userLE.roundabout$getRemainingFireTicks() > -1) {
                    ticks += userLE.roundabout$getRemainingFireTicks();
                }
                userLE.roundabout$setOnStandFire(PMR.getFireColor(), user);
                userLE.roundabout$setRemainingStandFireTicks(ticks);
            }
        } else if (gotten instanceof LivingEntity && (LE = (LivingEntity)gotten).m_21254_()) {
            int breakShield = 0;
            if (size >= PowersMagiciansRed.getChargingCrossfireSize()) {
                breakShield = 120;
            } else if (size >= PowersMagiciansRed.getChargingCrossfireSpecialSize()) {
                // empty if block
            }
            if (breakShield > 0) {
                MainUtil.knockShieldPlusStand((Entity)LE, breakShield);
            }
        }
        float degrees = MainUtil.getLookAtEntityYaw(proj, gotten);
        MainUtil.takeKnockbackWithY(gotten, strength, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
    }

    public void getEntity(Entity gotten, boolean direct, PowersMagiciansRed PMR) {
        if (gotten != null && !MainUtil.isMobOrItsMounts(gotten, (Entity)this.getUser())) {
            int size = this.getSize();
            CrossfireHurricaneEntity.blastEntity(gotten, (Entity)this, size, this.standUser, direct, PMR, this.fireStormCreated);
        }
    }

    protected ParticleOptions m_5967_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50016_.m_49966_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USER_ID, (Object)-1);
        this.f_19804_.m_135372_(SIZE, (Object)0);
        this.f_19804_.m_135372_(CROSS_NUMBER, (Object)0);
        this.f_19804_.m_135372_(MAX_SIZE, (Object)0);
    }

    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
    }

    public LivingEntity getStandUser() {
        if (this.standUser != null) {
            return this.standUser;
        }
        if (this.standUserUUID != null && !this.m_9236_().m_5776_()) {
            Entity ett = ((ServerLevel)this.m_9236_()).m_8791_(this.standUserUUID);
            if (ett instanceof LivingEntity) {
                LivingEntity lett;
                this.standUser = lett = (LivingEntity)ett;
                this.setUserID(lett.m_19879_());
            }
        } else {
            Entity entity = this.m_9236_().m_6815_(this.getUserID());
            if (entity instanceof LivingEntity) {
                LivingEntity LE;
                this.standUser = LE = (LivingEntity)entity;
            }
        }
        return this.standUser;
    }

    public void tickWater() {
        ++this.inWaterTicks;
        if (this.inWaterTicks > 40) {
            this.m_146870_();
        }
    }

    public float getAccrualRate() {
        if (this.getCrossNumber() == 6) {
            return 10.0f;
        }
        return 1.0f;
    }

    protected boolean m_5931_() {
        return false;
    }
}

