/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.ISuperThrownAbstractArrow;
import net.hydra.jojomod.block.BarbedWireBlock;
import net.hydra.jojomod.block.BarbedWireBundleBlock;
import net.hydra.jojomod.block.SafePlaceContext;
import net.hydra.jojomod.block.StereoBlockEntity;
import net.hydra.jojomod.block.StreetSignBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.GasolineCanEntity;
import net.hydra.jojomod.entity.projectile.HarpoonEntity;
import net.hydra.jojomod.entity.projectile.KnifeEntity;
import net.hydra.jojomod.entity.projectile.MatchEntity;
import net.hydra.jojomod.entity.projectile.StandArrowEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.GlaiveItem;
import net.hydra.jojomod.item.HarpoonItem;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.RoundaboutArrowItem;
import net.hydra.jojomod.item.ScissorItem;
import net.hydra.jojomod.item.StandArrowItem;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.item.WorthyArrowItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class ThrownObjectEntity
extends ThrowableItemProjectile {
    public boolean places;
    private static final EntityDataAccessor<Boolean> ROUNDABOUT$SUPER_THROWN = SynchedEntityData.m_135353_(ThrownObjectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> ROUNDABOUT$STYLE = SynchedEntityData.m_135353_(ThrownObjectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int superThrowTicks = -1;
    public static final byte SPTHROW = 1;
    public static final byte TWTHROW = 2;
    public static final byte SOFTTHROW = 3;
    Direction tempDirection = Direction.UP;

    private void initDataTrackerRoundabout(CallbackInfo ci) {
    }

    public ThrownObjectEntity(EntityType<? extends ThrowableItemProjectile> $$0, Level $$1) {
        super($$0, $$1);
        this.places = false;
    }

    public ThrownObjectEntity(LivingEntity living, Level $$1) {
        super(ModEntities.THROWN_OBJECT, living, $$1);
        this.places = false;
    }

    public ThrownObjectEntity(LivingEntity living, Level $$1, ItemStack itemStack, boolean places) {
        super(ModEntities.THROWN_OBJECT, living, $$1);
        this.m_37446_(itemStack);
        this.places = places;
    }

    public void starThrowInit() {
        this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)true);
        this.superThrowTicks = 50;
    }

    public ThrownObjectEntity(Level world, double p_36862_, double p_36863_, double p_36864_, ItemStack itemStack, boolean places) {
        super(ModEntities.THROWN_OBJECT, p_36862_, p_36863_, p_36864_, world);
        this.m_37446_(itemStack);
        this.places = places;
    }

    public void m_8119_() {
        Vec3 delta = this.m_20184_();
        if (this.m_9236_().m_5776_() || ((Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN)).booleanValue()) {
            // empty if block
        }
        super.m_8119_();
        if (((Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN)).booleanValue()) {
            this.m_20256_(delta);
        }
        if (!this.m_9236_().m_5776_() && this.superThrowTicks > -1) {
            --this.superThrowTicks;
            if (this.superThrowTicks <= -1) {
                this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)false);
            } else if ((this.f_19797_ + 2) % 4 == 0) {
                if (this.m_7846_().m_41720_() instanceof BlockItem) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.AIR_CRACKLE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                } else {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.AIR_CRACKLE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static boolean throwAnObject(LivingEntity thrower, boolean canSnipe, ItemStack item, float getShotAccuracy, float getBundleAccuracy, float getThrowAngle1, float getThrowAngle2, float getThrowAngle3, boolean getCanPlace, byte styleType, float xRot, float yRot, Vec3 pos, boolean playSounds, float mult, boolean canGiveYouItem) {
        if (item.m_41720_() instanceof ThrowablePotionItem) {
            ThrownPotion $$4 = new ThrownPotion(thrower.m_9236_(), thrower);
            $$4.m_146884_(pos);
            $$4.m_37446_(item);
            $$4.m_37251_((Entity)thrower, xRot, yRot, -3.0f, 1.4f * mult, getShotAccuracy);
            thrower.m_9236_().m_7967_((Entity)$$4);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$4, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_41720_() instanceof SnowballItem) {
            Snowball $$4 = new Snowball(thrower.m_9236_(), thrower);
            $$4.m_146884_(pos);
            $$4.m_37446_(item);
            $$4.m_37251_((Entity)thrower, xRot, yRot, -3.0f, 2.0f * mult, getShotAccuracy);
            thrower.m_9236_().m_7967_((Entity)$$4);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$4, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_150930_(ModItems.KNIFE)) {
            KnifeEntity $$7 = new KnifeEntity(thrower.m_9236_(), thrower, item);
            $$7.m_146884_(pos);
            $$7.m_37251_((Entity)thrower, xRot, yRot, getThrowAngle3, 2.4f * mult, getShotAccuracy);
            if (canSnipe) {
                ((ISuperThrownAbstractArrow)((Object)$$7)).roundabout$starThrowInit();
            }
            thrower.m_9236_().m_7967_((Entity)$$7);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_150930_(ModItems.KNIFE_BUNDLE)) {
            for (int i = 0; i < 4; ++i) {
                KnifeEntity $$7 = new KnifeEntity(thrower.m_9236_(), thrower, item);
                $$7.shootFromRotationWithVariance((Entity)thrower, xRot, yRot, -3.0f, 2.4f * mult, getBundleAccuracy);
                $$7.m_146884_(pos);
                thrower.m_9236_().m_7967_((Entity)$$7);
                if (i != 0 || !playSounds) continue;
                thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_150930_(ModItems.GASOLINE_CAN)) {
            if (thrower instanceof Player) {
                Player PE = (Player)thrower;
                if (((Player)thrower).m_36335_().m_41519_(item.m_41720_())) {
                    return false;
                }
            }
            GasolineCanEntity $$7 = new GasolineCanEntity(thrower, thrower.m_9236_());
            $$7.m_37251_((Entity)thrower, xRot, yRot, -3.0f, 1.5f * mult, getShotAccuracy);
            $$7.m_146884_(pos);
            if (canSnipe) {
                $$7.starThrowInit();
            }
            thrower.m_9236_().m_7967_((Entity)$$7);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_150930_(ModItems.MATCH)) {
            MatchEntity $$7 = new MatchEntity(thrower, thrower.m_9236_());
            $$7.m_37251_((Entity)thrower, xRot, yRot, getThrowAngle3, 2.5f * mult, getShotAccuracy);
            $$7.m_146884_(pos);
            if (canSnipe) {
                $$7.starThrowInit();
            }
            thrower.m_9236_().m_7967_((Entity)$$7);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_150930_(ModItems.MATCH_BUNDLE)) {
            for (int i = 0; i < 4; ++i) {
                MatchEntity $$7 = new MatchEntity(thrower, thrower.m_9236_());
                $$7.shootFromRotationWithVariance((Entity)thrower, xRot, yRot, -3.0f, 2.5f * mult, getBundleAccuracy);
                $$7.m_146884_(pos);
                thrower.m_9236_().m_7967_((Entity)$$7);
                if (i != 0 || !playSounds) continue;
                thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_41720_() instanceof StandArrowItem && item.m_41773_() < item.m_41776_() || item.m_41720_() instanceof WorthyArrowItem) {
            StandArrowEntity $$4 = new StandArrowEntity(thrower.m_9236_(), thrower, item);
            $$4.m_146884_(pos);
            $$4.m_37251_((Entity)thrower, xRot, yRot, 0.0f, 3.0f * mult, getShotAccuracy);
            thrower.m_9236_().m_7967_((Entity)$$4);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$4, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_41720_() instanceof EggItem) {
            ThrownEgg $$4 = new ThrownEgg(thrower.m_9236_(), thrower);
            $$4.m_146884_(pos);
            $$4.m_37446_(item);
            $$4.m_37251_((Entity)thrower, xRot, yRot, -3.0f, 2.0f * mult, getShotAccuracy);
            thrower.m_9236_().m_7967_((Entity)$$4);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$4, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_41720_() instanceof ExperienceBottleItem) {
            ThrownExperienceBottle $$4 = new ThrownExperienceBottle(thrower.m_9236_(), thrower);
            $$4.m_146884_(pos);
            $$4.m_37446_(item);
            $$4.m_37251_((Entity)thrower, xRot, yRot, -3.0f, 2.0f * mult, getShotAccuracy);
            thrower.m_9236_().m_7967_((Entity)$$4);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$4, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_41720_() instanceof EnderpearlItem) {
            ThrownEnderpearl $$4 = new ThrownEnderpearl(thrower.m_9236_(), thrower);
            $$4.m_146884_(pos);
            if (thrower instanceof Player) {
                Player PE = (Player)thrower;
                if (((Player)thrower).m_36335_().m_41519_(item.m_41720_())) {
                    return false;
                }
            }
            if (thrower instanceof Player) {
                Player PE = (Player)thrower;
                PE.m_36335_().m_41524_(item.m_41720_(), 20);
            }
            $$4.m_37251_((Entity)thrower, xRot, yRot, -0.0f, 1.8f * mult, getShotAccuracy);
            thrower.m_9236_().m_7967_((Entity)$$4);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$4, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_41720_() instanceof ArrowItem && !(item.m_41720_() instanceof RoundaboutArrowItem)) {
            ArrowItem $$10 = (ArrowItem)item.m_41720_();
            AbstractArrow $$11 = $$10.m_6394_(thrower.m_9236_(), item, thrower);
            $$11.m_146884_(pos);
            $$11.m_37251_((Entity)thrower, xRot, yRot, 0.0f, 3.0f * mult, getShotAccuracy);
            $$11.m_36762_(true);
            StandEntity standEntity = ((StandUser)thrower).roundabout$getStand();
            if (!(standEntity == null || styleType != 1 && styleType != 2 || standEntity.canAcquireHeldItem)) {
                $$11.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
            if (!canGiveYouItem) {
                $$11.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
            if (canSnipe) {
                ((ISuperThrownAbstractArrow)$$11).roundabout$starThrowInit();
            }
            thrower.m_9236_().m_7967_((Entity)$$11);
            if (playSounds) {
                thrower.m_9236_().m_6269_(null, (Entity)$$11, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        } else if (item.m_150930_(Items.f_42713_)) {
            if (!item.m_220157_(1, thrower.m_9236_().m_213780_(), null)) {
                ThrownTrident $$7 = new ThrownTrident(thrower.m_9236_(), thrower, item);
                $$7.m_146884_(pos);
                $$7.m_37251_((Entity)thrower, xRot, yRot, 0.0f, 3.0f * mult, getShotAccuracy);
                if (canSnipe) {
                    ((ISuperThrownAbstractArrow)$$7).roundabout$starThrowInit2();
                }
                thrower.m_9236_().m_7967_((Entity)$$7);
                if (playSounds) {
                    thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
                }
            }
        } else if (item.m_41720_() instanceof HarpoonItem) {
            if (!item.m_220157_(1, thrower.m_9236_().m_213780_(), null)) {
                HarpoonEntity $$7 = new HarpoonEntity(thrower.m_9236_(), thrower, item);
                $$7.m_146884_(pos);
                $$7.m_37251_((Entity)thrower, xRot, yRot, 0.0f, 3.0f * mult, getShotAccuracy);
                if (canSnipe) {
                    ((ISuperThrownAbstractArrow)((Object)$$7)).roundabout$starThrowInit2();
                }
                if (styleType == 1 || styleType == 2) {
                    $$7.isThrown = true;
                }
                thrower.m_9236_().m_7967_((Entity)$$7);
                if (playSounds) {
                    thrower.m_9236_().m_6269_(null, (Entity)$$7, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
                }
            }
        } else {
            boolean canPlace = getCanPlace;
            ThrownObjectEntity thrownBlockOrItem = new ThrownObjectEntity(thrower, thrower.m_9236_(), item, canPlace);
            thrownBlockOrItem.m_146884_(pos);
            thrownBlockOrItem.m_37251_((Entity)thrower, xRot, yRot, getThrowAngle1, 1.7f * mult, getThrowAngle2);
            if (canSnipe) {
                thrownBlockOrItem.starThrowInit();
            }
            thrownBlockOrItem.setStyle(styleType);
            thrower.m_9236_().m_7967_((Entity)thrownBlockOrItem);
            if (playSounds) {
                if (item.m_150930_(Items.f_42749_) || item.m_150930_(Items.f_42587_) || item.m_150930_(Items.f_42415_) || item.m_150930_(Items.f_42484_)) {
                    thrower.m_9236_().m_6269_(null, (Entity)thrownBlockOrItem, ModSounds.BALL_BEARING_SHOT_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    thrower.m_9236_().m_6269_(null, (Entity)thrownBlockOrItem, ModSounds.BLOCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.3f);
                }
            }
        }
        return true;
    }

    public void m_7380_(CompoundTag $$0) {
        $$0.m_128379_("roundabout.AcquireHeldItem", this.places);
        $$0.m_128344_("roundabout.style", this.getStyle());
        CompoundTag compoundtag = new CompoundTag();
        $$0.m_128365_("roundabout.HeldItem", (Tag)this.m_7846_().m_41739_(compoundtag));
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        this.places = $$0.m_128471_("roundabout.AcquireHeldItem");
        this.setStyle($$0.m_128445_("roundabout.style"));
        CompoundTag compoundtag = $$0.m_128469_("roundabout.HeldItem");
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
        this.m_37446_(itemstack);
        super.m_7378_($$0);
    }

    protected void m_8097_() {
        super.m_8097_();
        if (!this.m_20088_().m_285897_(ROUNDABOUT$SUPER_THROWN)) {
            this.m_20088_().m_135372_(ROUNDABOUT$SUPER_THROWN, (Object)false);
            this.m_20088_().m_135372_(ROUNDABOUT$STYLE, (Object)0);
        }
    }

    public boolean getSuperThrow() {
        return (Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN);
    }

    public byte getStyle() {
        return (Byte)this.m_20088_().m_135370_(ROUNDABOUT$STYLE);
    }

    public void setStyle(byte style) {
        this.m_20088_().m_135381_(ROUNDABOUT$STYLE, (Object)style);
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    protected float m_7139_() {
        if (this.getSuperThrow()) {
            return 0.0f;
        }
        return 0.03f;
    }

    public boolean tryHitBlock(BlockHitResult $$0, BlockPos pos, BlockState state) {
        block11: {
            try {
                BlockItem BE;
                Item item = this.m_7846_().m_41720_();
                if (item instanceof BlockItem && (BE = (BlockItem)item).m_40614_() instanceof SnowLayerBlock) {
                    return false;
                }
                if (!state.m_60795_() && !state.m_247087_() || this.m_19749_() == null || this.m_19749_() instanceof Player && ((Player)this.m_19749_()).m_36187_(this.m_19749_().m_9236_(), pos, ((ServerPlayer)this.m_19749_()).f_8941_.m_9290_()) || !this.m_19749_().m_9236_().m_7966_((Player)this.m_19749_(), pos) || !(this.m_7846_().m_41720_() instanceof BlockItem)) break block11;
                Direction direction = this.m_6350_();
                if (direction.m_122434_() == Direction.Axis.X) {
                    direction = direction.m_122424_();
                }
                if (((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof RotatedPillarBlock) {
                    direction = $$0.m_82434_();
                }
                try {
                    Entity entity = this.m_19749_();
                    if (entity instanceof Player) {
                        Player PE = (Player)entity;
                        if (MainUtil.canPlaceOnClaim(PE, $$0) && ((BlockItem)this.m_7846_().m_41720_()).m_40576_((BlockPlaceContext)new SafePlaceContext(this.m_9236_(), PE, pos, direction, this.m_7846_(), direction)) != InteractionResult.FAIL) {
                            this.tempDirection = direction;
                            return true;
                        }
                    } else if (((BlockItem)this.m_7846_().m_41720_()).m_40576_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), pos, direction, this.m_7846_(), direction)) != InteractionResult.FAIL) {
                        this.tempDirection = direction;
                        return true;
                    }
                }
                catch (Exception e) {
                    Roundabout.LOGGER.info("Mod does not make a safe null check for players, report to devs who made blocks");
                }
            }
            catch (Exception e) {
                Roundabout.LOGGER.info("Mod does not make a safe null check for players, report to devs who made blocks");
            }
        }
        return false;
    }

    protected void m_8060_(BlockHitResult $$0) {
        super.m_8060_($$0);
        if (!this.m_9236_().f_46443_ && !this.m_7846_().m_41619_()) {
            BlockPos pos = $$0.m_82425_().m_121945_($$0.m_82434_());
            BlockState state = this.m_9236_().m_8055_(pos);
            if (this.m_7846_().m_41720_() instanceof BlockItem) {
                if (this.places) {
                    if (!(this.tryHitBlock($$0, pos, state) || this.tryHitBlock($$0, pos.m_121945_(this.tempDirection), state) || this.tryHitBlock($$0, pos.m_7494_(), state))) {
                        this.dropItem(pos);
                    }
                } else if (this.m_7846_().m_41720_() instanceof BlockItem) {
                    Block blkk = ((BlockItem)this.m_7846_().m_41720_()).m_40614_();
                    this.m_5496_(blkk.m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                    this.blockBreakParticles(blkk, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                }
            } else if (this.m_7846_().m_150930_(Items.f_42460_) || this.m_7846_().m_150930_(Items.f_42691_)) {
                Block blkk = this.m_9236_().m_8055_($$0.m_82425_()).m_60734_();
                if (this.places && blkk instanceof AbstractGlassBlock || blkk instanceof StainedGlassPaneBlock || blkk.m_49966_().m_60713_(Blocks.f_50185_)) {
                    if (this.m_9236_().m_7471_($$0.m_82425_(), false)) {
                        this.blockBreakParticles(blkk, new Vec3((double)$$0.m_82425_().m_123341_() + 0.5, (double)$$0.m_82425_().m_123342_() + 0.5, (double)$$0.m_82425_().m_123343_() + 0.5));
                        this.m_5496_(blkk.m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                        return;
                    }
                } else {
                    this.dropItem(pos);
                }
            } else if (this.m_7846_().m_41720_() instanceof BoneMealItem) {
                if (!this.places || !this.useBonemeal(this.m_7846_(), $$0)) {
                    this.dropItem(pos);
                }
            } else {
                Item blkk = this.m_7846_().m_41720_();
                if (blkk instanceof HangingEntityItem) {
                    HangingEntityItem he = (HangingEntityItem)blkk;
                    if (!this.places || !$$0.m_82434_().m_122434_().m_122479_() || he.m_6225_((UseOnContext)new DirectionalPlaceContext(this.m_9236_(), $$0.m_82425_(), $$0.m_82434_(), this.m_7846_(), $$0.m_82434_())) == InteractionResult.FAIL) {
                        this.dropItem(pos);
                    }
                } else {
                    blkk = this.m_7846_().m_41720_();
                    if (blkk instanceof SpawnEggItem) {
                        SpawnEggItem se = (SpawnEggItem)blkk;
                        if (!this.places || se.m_6225_((UseOnContext)new DirectionalPlaceContext(this.m_9236_(), $$0.m_82425_(), $$0.m_82434_(), this.m_7846_(), $$0.m_82434_())) == InteractionResult.FAIL) {
                            this.dropItem(pos);
                        }
                    } else {
                        blkk = this.m_7846_().m_41720_();
                        if (blkk instanceof RecordItem) {
                            StereoBlockEntity je;
                            JukeboxBlockEntity je2;
                            RecordItem se = (RecordItem)blkk;
                            BlockEntity blke = this.m_9236_().m_7702_($$0.m_82425_());
                            if (blke instanceof JukeboxBlockEntity && (je2 = (JukeboxBlockEntity)blke).m_272036_().m_41619_()) {
                                je2.m_6836_(0, this.m_7846_());
                            } else if (blke instanceof StereoBlockEntity && (je = (StereoBlockEntity)blke).m_272036_().m_41619_()) {
                                je.m_6836_(0, this.m_7846_());
                            } else {
                                this.dropItem(pos);
                            }
                        } else {
                            this.dropItem(pos);
                        }
                    }
                }
            }
        }
        if (!this.m_9236_().m_5776_() || !this.m_7846_().m_150930_(Items.f_42460_) && !this.m_7846_().m_150930_(Items.f_42691_)) {
            this.m_146870_();
        }
    }

    public void dropItem(BlockPos pos) {
        ItemEntity $$4 = new ItemEntity(this.m_9236_(), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.25f), (double)((float)pos.m_123343_() + 0.5f), this.m_7846_());
        $$4.m_32010_(40);
        $$4.m_32052_(this.m_20148_());
        $$4.m_20334_(Math.random() * (double)0.1f - (double)0.05f, (double)0.2f, Math.random() * (double)0.18f - (double)0.05f);
        this.m_9236_().m_7967_((Entity)$$4);
    }

    public float getDamage(Entity ent) {
        float damage = 1.0f;
        if (this.m_7846_().m_41720_() instanceof BlockItem) {
            float DT = ((BlockItem)this.m_7846_().m_41720_()).m_40614_().m_155943_();
            damage = ((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof AbstractGlassBlock || ((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof StainedGlassPaneBlock || this.m_7846_().m_150930_(Items.f_42027_) ? 12.0f : (((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof CactusBlock ? 10.0f : (((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof AnvilBlock ? 20.5f : (((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof WebBlock ? 1.0f : (((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof StreetSignBlock ? 18.0f : ((double)DT <= 0.4 ? 1.0f : (DT <= 1.0f ? 4.0f : ((double)DT <= 1.5 ? 8.0f : (DT <= 2.0f ? 10.0f : (DT <= 3.0f ? 11.0f : (DT <= 5.0f ? 12.0f : (DT <= 10.0f ? 14.0f : (DT <= 25.0f ? 15.0f : 17.0f))))))))))));
        } else {
            boolean enchant = false;
            if (this.m_7846_().m_41720_() instanceof SwordItem) {
                damage = (float)(5.0 + (double)((SwordItem)this.m_7846_().m_41720_()).m_43299_() * 1.5);
                enchant = true;
            } else if (this.m_7846_().m_41720_() instanceof DiggerItem) {
                damage = (float)(5.0 + (double)((DiggerItem)this.m_7846_().m_41720_()).m_41008_() * 1.5);
                enchant = true;
            } else if (this.m_7846_().m_41720_() instanceof GlaiveItem) {
                damage = (float)(5.0 + (double)((GlaiveItem)this.m_7846_().m_41720_()).m_43299_() * 1.5);
                enchant = true;
            } else if (this.m_7846_().m_150930_(Items.f_42749_)) {
                damage = 10.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42695_)) {
                damage = 7.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42460_)) {
                damage = 6.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42416_)) {
                damage = 10.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42415_)) {
                damage = 11.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42587_)) {
                damage = 6.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42417_)) {
                damage = 6.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42413_)) {
                damage = 3.0f;
            } else if (this.m_7846_().m_150930_(Items.f_42484_)) {
                damage = 5.0f;
            } else if (this.m_7846_().m_150930_(Items.f_151052_)) {
                damage = 5.0f;
            } else if (this.m_7846_().m_150930_(Items.f_151049_)) {
                damage = 7.0f;
            }
            if (enchant) {
                damage = ent instanceof LivingEntity ? (damage += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)((LivingEntity)ent).m_6336_())) : (damage += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)MobType.f_21640_));
            }
        }
        if (this.getStyle() == 3) {
            damage *= (float)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.bubbleLaunchedObjectMultiplier.intValue() * 0.01);
            damage *= 0.75f;
        } else if (this.getStyle() == 1) {
            damage *= (float)((double)ClientNetworking.getAppropriateConfig().generalStandSettings.standThrownObjectMultiplier.intValue() * 0.01);
            damage *= 1.05f;
        } else if (this.getStyle() == 2) {
            damage *= (float)((double)ClientNetworking.getAppropriateConfig().generalStandSettings.standThrownObjectMultiplier.intValue() * 0.01);
            damage *= 0.9f;
        } else {
            damage *= (float)((double)ClientNetworking.getAppropriateConfig().generalStandSettings.standThrownObjectMultiplier.intValue() * 0.01);
        }
        return damage;
    }

    public void blockBreakParticles(Block block, Vec3 pos) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100, 0.0, 0.0, 0.0, 0.5);
        }
    }

    protected void m_5790_(EntityHitResult $$0) {
        LivingEntity LE;
        Entity $$1 = $$0.m_82443_();
        if ($$1 instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)$$1)).roundabout$getStandPowers().dealWithProjectile((Entity)this, (HitResult)$$0)) {
            this.m_146870_();
            return;
        }
        Entity $$4 = this.m_19749_();
        DamageSource $$5 = ModDamageTypes.of($$1.m_9236_(), ModDamageTypes.THROWN_OBJECT, $$4);
        Vec3 DM = $$1.m_20184_();
        boolean fire = false;
        boolean onFire = $$1.m_6060_();
        if (!this.m_7846_().m_41619_()) {
            int ench = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.m_7846_());
            if (ench >= 1) {
                $$1.m_20254_(ench * 4);
                fire = true;
            } else if (this.m_7846_().m_41720_() instanceof FlintAndSteelItem || this.m_7846_().m_150930_(Items.f_42258_) || this.m_7846_().m_150930_(Items.f_42781_) || this.m_7846_().m_41720_() instanceof FireChargeItem) {
                $$1.m_20254_(4);
                fire = true;
            } else if (this.m_7846_().m_150930_(Items.f_42448_)) {
                $$1.m_20254_(8);
                fire = true;
            }
        }
        if (this.m_7846_().m_41720_() instanceof NameTagItem) {
            if ($$1 instanceof LivingEntity && !this.useNametag(this.m_7846_(), (LivingEntity)$$1)) {
                this.dropItem($$1.m_20097_());
            }
        } else {
            Item item = this.m_7846_().m_41720_();
            if (item instanceof StandDiscItem) {
                LivingEntity LE2;
                StandDiscItem SD = (StandDiscItem)item;
                if (this.places && $$1 instanceof LivingEntity && MainUtil.canGrantStand((Entity)(LE2 = (LivingEntity)$$1)) && SD.standPowers.isWorthinessType(LE2)) {
                    ((StandUser)LE2).roundabout$setStandDisc(this.m_7846_());
                    SD.generateStandPowers(LE2);
                    ((StandUser)LE2).roundabout$summonStand($$1.m_9236_(), true, true);
                } else {
                    this.dropItem($$1.m_20097_());
                }
            } else if (this.m_7846_().m_41720_() instanceof DyeItem && $$1 instanceof LivingEntity) {
                if (!this.useDye(this.m_7846_(), (LivingEntity)$$1)) {
                    this.dropItem($$1.m_20097_());
                }
            } else if (this.m_7846_().m_41720_() instanceof MaskItem && $$1 instanceof Player) {
                Player pe = (Player)$$1;
                if (ClientNetworking.getAppropriateConfig().itemSettings.canThrowVisagesOntoOtherPlayers.booleanValue() && ((IPlayerEntity)pe).roundabout$getMaskInventory().m_8020_(0).m_41619_()) {
                    ((IPlayerEntity)pe).roundabout$getMaskInventory().m_6836_(0, this.m_7846_().m_41777_());
                } else if (ClientNetworking.getAppropriateConfig().itemSettings.canThrowVisagesOntoOtherPlayers.booleanValue() && ((IPlayerEntity)pe).roundabout$getMaskInventory().m_8020_(1).m_41619_()) {
                    ((IPlayerEntity)pe).roundabout$getMaskInventory().m_6836_(1, this.m_7846_().m_41777_());
                } else {
                    this.dropItem($$1.m_20097_());
                }
            } else if (this.m_7846_().m_41720_() instanceof SaddleItem && $$1 instanceof LivingEntity) {
                if (!this.useSaddle(this.m_7846_(), (LivingEntity)$$1)) {
                    this.dropItem($$1.m_20097_());
                }
            } else if (this.m_7846_().m_41720_() instanceof LeadItem && $$1 instanceof Mob) {
                if (!this.useLeash(this.m_7846_(), (Mob)$$1)) {
                    this.dropItem($$1.m_20097_());
                }
            } else if ($$1.m_6469_($$5, this.getDamage($$1))) {
                if ($$1.m_6095_() == EntityType.f_20566_) {
                    return;
                }
                if (!this.m_7846_().m_41619_()) {
                    if ($$1 instanceof LivingEntity) {
                        LivingEntity L = (LivingEntity)$$1;
                        Entity entity = this.m_19749_();
                        if (entity instanceof Player) {
                            Player PE = (Player)entity;
                            ((StandUser)PE).roundabout$getStandPowers().addEXP(1);
                        }
                        if (this.m_7846_().m_150930_(Items.f_41863_)) {
                            L.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 100, 0), (Entity)this);
                        }
                        if (this.m_7846_().m_150930_(Items.f_42529_)) {
                            L.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 200, 0), (Entity)this);
                        }
                        if (this.m_7846_().m_150930_(Items.f_41951_)) {
                            L.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200, 0), (Entity)this);
                        }
                        if (this.m_7846_().m_150930_(ModItems.GASOLINE_BUCKET)) {
                            ((StandUser)L).roundabout$setGasolineTime(((StandUser)L).roundabout$getMaxBucketGasolineTime());
                        }
                    }
                    if (this.m_7846_().m_41720_() instanceof GlaiveItem || this.m_7846_().m_41720_() instanceof ScissorItem) {
                        MainUtil.makeBleed($$1, 0, 300, (Entity)this);
                    } else if (this.m_7846_().m_150930_(Items.f_42695_) || this.m_7846_().m_150930_(Items.f_42590_)) {
                        MainUtil.makeBleed($$1, 0, 200, (Entity)this);
                    }
                    if (this.m_7846_().m_41720_() instanceof BlockItem && MainUtil.isThrownBlockItem(this.m_7846_().m_41720_())) {
                        Block blk = ((BlockItem)this.m_7846_().m_41720_()).m_40614_();
                        if (blk instanceof CactusBlock || blk instanceof AbstractGlassBlock || blk instanceof StainedGlassPaneBlock || blk instanceof BarbedWireBlock || blk instanceof BarbedWireBundleBlock || this.m_7846_().m_150930_(Items.f_42027_)) {
                            MainUtil.makeBleed($$1, 0, 300, (Entity)this);
                        }
                        SoundEvent SE = blk.m_49966_().m_60827_().m_56775_();
                        this.m_5496_(SE, 1.0f, 0.9f);
                        if ($$1 instanceof LivingEntity) {
                            LivingEntity $$7 = (LivingEntity)$$1;
                            float kb = 0.3f;
                            if (((BlockItem)this.m_7846_().m_41720_()).m_40614_() instanceof SlimeBlock) {
                                kb = 0.8f;
                            }
                            $$7.m_147240_((double)kb, this.m_20185_() - $$7.m_20185_(), this.m_20189_() - $$7.m_20189_());
                        }
                    } else if ($$1 instanceof LivingEntity) {
                        LivingEntity $$7 = (LivingEntity)$$1;
                        $$7.m_147240_((double)0.15f, this.m_20185_() - $$7.m_20185_(), this.m_20189_() - $$7.m_20189_());
                    }
                    if (this.m_7846_().m_41763_()) {
                        if (!this.m_7846_().m_220157_(1, this.m_9236_().m_213780_(), null)) {
                            this.dropItem($$1.m_20097_());
                        }
                    } else if (this.m_7846_().m_41720_() instanceof BlockItem) {
                        this.blockBreakParticles(((BlockItem)this.m_7846_().m_41720_()).m_40614_(), $$0.m_82443_().m_20318_(0.0f).m_82520_(0.0, (double)$$0.m_82443_().m_20192_(), 0.0));
                    }
                }
            } else {
                Player PE;
                if (fire && !onFire) {
                    $$1.m_20095_();
                }
                if (!this.m_7846_().m_41619_() && (this.m_7846_().m_41720_() instanceof GlaiveItem || this.m_7846_().m_41720_() instanceof AxeItem) && $$1 instanceof Player && (PE = (Player)$$1).m_21254_() && !((StandUser)PE).roundabout$isGuarding()) {
                    PE.m_36335_().m_41524_(Items.f_42740_, 100);
                    PE.m_5810_();
                    PE.m_9236_().m_7605_((Entity)this, (byte)30);
                }
                if (this.m_7846_().m_41720_() instanceof BlockItem) {
                    if (this.places) {
                        this.dropItem($$1.m_20097_());
                    }
                } else {
                    this.dropItem($$1.m_20097_());
                }
            }
        }
        this.m_146870_();
    }

    public boolean useBonemeal(ItemStack item, BlockHitResult pos) {
        Level $$1 = this.m_9236_();
        BlockPos $$2 = pos.m_82425_();
        if (!this.m_9236_().m_8055_($$2.m_7494_()).m_60795_()) {
            $$2 = $$2.m_7494_();
        }
        BlockPos $$3 = $$2.m_121945_(pos.m_82434_());
        if (BoneMealItem.m_40627_((ItemStack)item, (Level)$$1, (BlockPos)$$2)) {
            if (!$$1.f_46443_) {
                $$1.m_46796_(1505, $$2, 0);
            }
            return true;
        }
        BlockState $$4 = $$1.m_8055_($$2);
        boolean $$5 = $$4.m_60783_((BlockGetter)$$1, $$2, pos.m_82434_());
        if ($$5 && BoneMealItem.m_40631_((ItemStack)item, (Level)$$1, (BlockPos)$$3, (Direction)pos.m_82434_())) {
            if (!$$1.f_46443_) {
                $$1.m_46796_(1505, $$3, 0);
            }
            return true;
        }
        return false;
    }

    public boolean useLeash(ItemStack stack, Mob entity) {
        Player player;
        Entity entity2;
        if (this.m_19749_() != null && (entity2 = this.m_19749_()) instanceof Player && entity.m_6573_(player = (Player)entity2)) {
            entity.m_21463_((Entity)player, true);
            return true;
        }
        return false;
    }

    public boolean useSaddle(ItemStack $$0, LivingEntity $$2) {
        Saddleable $$4;
        if ($$2 instanceof Saddleable && $$2.m_6084_() && !($$4 = (Saddleable)$$2).m_6254_() && $$4.m_6741_() && !this.m_9236_().f_46443_) {
            $$4.m_5853_(SoundSource.NEUTRAL);
            $$2.m_9236_().m_220400_((Entity)$$2, GameEvent.f_157811_, $$2.m_20182_());
            return true;
        }
        return false;
    }

    public boolean useDye(ItemStack stack, LivingEntity entity) {
        Sheep $$4;
        if (entity instanceof Sheep && ($$4 = (Sheep)entity).m_6084_() && !$$4.m_29875_() && $$4.m_29874_() != ((DyeItem)stack.m_41720_()).m_41089_()) {
            $$4.m_9236_().m_6269_(null, (Entity)$$4, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!this.m_9236_().m_5776_()) {
                $$4.m_29855_(((DyeItem)stack.m_41720_()).m_41089_());
                return true;
            }
        }
        return false;
    }

    public boolean useNametag(ItemStack stack, LivingEntity entity) {
        if (stack.m_41788_() && !(entity instanceof Player) && !this.m_9236_().m_5776_() && entity.m_6084_()) {
            entity.m_6593_(stack.m_41786_());
            if (entity instanceof Mob) {
                ((Mob)entity).m_21530_();
            }
            return true;
        }
        return false;
    }

    public void shootWithVariance(double $$0, double $$1, double $$2, float $$3, float $$4) {
        Vec3 $$5 = new Vec3($$0, $$1, $$2).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4)).m_82490_((double)$$3);
        this.m_20256_($$5);
        double $$6 = $$5.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)$$5.f_82479_, (double)$$5.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)$$5.f_82480_, (double)$$6) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotationWithVariance(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.shootWithVariance($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_($$9.f_82479_, $$0.m_20096_() ? 0.0 : $$9.f_82480_, $$9.f_82481_));
    }
}

