/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import java.util.List;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.stand.MultipleTypeStand;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersSurvivor;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SurvivorEntity
extends MultipleTypeStand {
    protected static final EntityDataAccessor<Float> RANDOM_SIZE = SynchedEntityData.m_135353_(SurvivorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.m_135353_(SurvivorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int dryUpInNetherTicks = 0;
    public int shockCountUpTicks = 0;

    public SurvivorEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public final void setRandomSize(float randSize) {
        this.f_19804_.m_135381_(RANDOM_SIZE, (Object)Float.valueOf(randSize));
    }

    public final void setActivated(boolean active) {
        this.f_19804_.m_135381_(ACTIVATED, (Object)active);
    }

    public final float getRandomSize() {
        return ((Float)this.f_19804_.m_135370_(RANDOM_SIZE)).floatValue();
    }

    public final boolean getActivated() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATED);
    }

    @Override
    public boolean validatePowers(LivingEntity user) {
        return ((StandUser)user).roundabout$getStandPowers() instanceof PowersSurvivor;
    }

    @Override
    public boolean hasNoPhysics() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getUser() != null && MainUtil.isStandDamage(source) && !this.forceDespawnSet) {
            this.forceDespawn(true);
            return this.getUser().m_6469_(source, amount * 0.5f);
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (!this.getActivated() && this.m_20071_()) {
                this.setActivated(true);
            }
            if (this.m_9236_().m_46472_() == Level.f_46429_) {
                int dryTickMax = ClientNetworking.getAppropriateConfig().survivorSettings.dryUpInNetherTicks;
                if (this.getActivated()) {
                    ++this.dryUpInNetherTicks;
                    if (this.dryUpInNetherTicks > dryTickMax) {
                        this.setActivated(false);
                        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.015);
                    }
                } else {
                    --this.dryUpInNetherTicks;
                }
                this.dryUpInNetherTicks = Mth.m_14045_((int)this.dryUpInNetherTicks, (int)0, (int)dryTickMax);
            }
            if (this.getActivated()) {
                ++this.shockCountUpTicks;
                if (this.shockCountUpTicks > 15) {
                    this.attemptShock();
                    this.shockCountUpTicks = 0;
                }
            } else {
                --this.shockCountUpTicks;
            }
            this.shockCountUpTicks = Mth.m_14045_((int)this.shockCountUpTicks, (int)0, (int)15);
        }
    }

    public static void drawParticleLine(Entity from, Entity to, int particleCount) {
        Level level = from.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 start = from.m_20182_();
        Vec3 end = to.m_20182_();
        Vec3 diff = end.m_82546_(start);
        for (int i = 0; i <= particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            Vec3 point = start.m_82549_(diff.m_82490_(progress));
            serverLevel.m_8767_((ParticleOptions)ModParticles.ZAP, point.f_82479_, point.f_82480_, point.f_82481_, 1, 0.0, (double)0.2f, 0.0, 0.0);
        }
    }

    public void matchEntities(LivingEntity one, LivingEntity two) {
        ((StandUser)one).roundabout$setZappedToID(two.m_19879_());
        ((StandUser)one).roundabout$aggressivelyEnforceZapAggro();
        ((StandUser)two).roundabout$setZappedToID(one.m_19879_());
        ((StandUser)two).roundabout$aggressivelyEnforceZapAggro();
        SurvivorEntity.drawParticleLine((Entity)this, (Entity)one, 10);
        SurvivorEntity.drawParticleLine((Entity)this, (Entity)two, 10);
        SurvivorEntity.drawParticleLine((Entity)one, (Entity)two, 10);
        this.sendMessageTo(one, two);
        this.sendMessageTo(two, one);
        this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.SURVIVOR_SHOCK_EVENT, SoundSource.NEUTRAL, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
    }

    public void sendMessageTo(LivingEntity LE, LivingEntity LE2) {
        if (LE instanceof ServerPlayer) {
            ServerPlayer PE = (ServerPlayer)LE;
            PE.m_5661_((Component)Component.m_237110_((String)"text.roundabout.survivor.match", (Object[])new Object[]{LE2.m_5446_()}).m_130940_(ChatFormatting.RED), true);
        }
    }

    public static boolean canZapEntity(Entity ent) {
        LivingEntity LE;
        Player PL;
        return !(ent == null || !ent.m_6084_() || ent.m_213877_() || !(ent instanceof Mob) && !(ent instanceof Player) || ent instanceof StandEntity || ent instanceof FallenMob || !ent.m_6087_() || ent.m_20147_() || ent instanceof Player && (PL = (Player)ent).m_7500_() || !(ent instanceof LivingEntity) || ((StandUser)(LE = (LivingEntity)ent)).roundabout$isBubbleEncased());
    }

    public void attemptShock() {
        LivingEntity user = this.getUser();
        if (user != null && !((StandUser)user).roundabout$getUniqueStandModeToggle()) {
            List<Entity> mobsInRange = MainUtil.getEntitiesInRange(this.m_9236_(), this.m_20183_(), ClientNetworking.getAppropriateConfig().survivorSettings.survivorRange.intValue(), (Entity)this);
            LivingEntity firstTarget = null;
            if (!mobsInRange.isEmpty()) {
                for (Entity ent : mobsInRange) {
                    Player PE;
                    LivingEntity livingEntity;
                    LivingEntity LE;
                    if (!SurvivorEntity.canZapEntity(ent) || !(ent instanceof LivingEntity) || ((StandUser)(LE = (LivingEntity)ent)).roundabout$getZappedToID() > -1 || MainUtil.isBossMob(LE) && !ClientNetworking.getAppropriateConfig().survivorSettings.canUseSurvivorOnBossesInSurvival.booleanValue() && (!((livingEntity = this.getUser()) instanceof Player) || !(PE = (Player)livingEntity).m_7500_())) continue;
                    if (firstTarget == null) {
                        firstTarget = LE;
                        continue;
                    }
                    if (!MainUtil.canActuallyHit((Entity)firstTarget, (Entity)LE)) continue;
                    this.matchEntities(firstTarget, LE);
                    return;
                }
            }
        }
    }

    @Override
    public boolean m_6087_() {
        if (this.m_9236_().m_5776_()) {
            return ClientUtil.isPlayer((Entity)this.getUser());
        }
        return false;
    }

    public InteractionResult m_7111_(Player player, Vec3 location, InteractionHand intHand) {
        if (!player.m_9236_().m_5776_()) {
            Item item;
            ItemStack plrItem;
            if (player.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            if (!this.getActivated() && !(plrItem = player.m_21120_(intHand)).m_41619_() && (item = plrItem.m_41720_()) instanceof PotionItem) {
                PotionItem PI = (PotionItem)item;
                if (PotionUtils.m_43579_((ItemStack)plrItem) == Potions.f_43599_ && !(PI instanceof SplashPotionItem)) {
                    if (!player.m_150110_().f_35937_) {
                        plrItem.m_41774_(1);
                        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                    }
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 0.9f);
                    this.setActivated(true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean needsActive() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RANDOM_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACTIVATED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag $$0) {
        $$0.m_128350_("roundabout.randomSize", this.getRandomSize());
        $$0.m_128379_("roundabout.activated", this.getActivated());
        super.m_7380_($$0);
    }

    @Override
    public void m_7378_(CompoundTag $$0) {
        this.setRandomSize($$0.m_128457_("roundabout.randomSize"));
        this.setActivated($$0.m_128471_("roundabout.activated"));
        super.m_7378_($$0);
    }
}

