/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.goals;

import java.util.EnumSet;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;

public class CorpseBuildBreakGoal
extends Goal {
    private final FallenMob fallenMob;
    private Player owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private final BlockPos useOn;
    private float oldWaterCost;
    private BlockHitResult blockHit;
    private final boolean canFly;
    private int diggingTime = -1;

    public CorpseBuildBreakGoal(FallenMob $$0, double $$1, BlockPos $$2, BlockHitResult $$3, boolean $$4) {
        this.fallenMob = $$0;
        this.level = $$0.m_9236_();
        this.speedModifier = $$1;
        this.navigation = $$0.m_21573_();
        this.useOn = $$2;
        this.blockHit = $$3;
        this.canFly = $$4;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!($$0.m_21573_() instanceof GroundPathNavigation) && !($$0.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
        Entity entity = $$0.controller;
        if (entity instanceof Player) {
            Player plr;
            this.owner = plr = (Player)entity;
        } else {
            Roundabout.LOGGER.info("A corpse is not being controlled by a player???");
        }
    }

    public boolean m_8036_() {
        LivingEntity $$0 = null;
        Entity entity = this.fallenMob.controller;
        if (entity instanceof LivingEntity) {
            LivingEntity LE;
            $$0 = LE = (LivingEntity)entity;
        }
        if ($$0 == null) {
            return false;
        }
        if ($$0.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return this.fallenMob.controller instanceof Player;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        return !this.unableToMove();
    }

    private boolean unableToMove() {
        return this.fallenMob.m_20159_() || this.fallenMob.m_21523_();
    }

    public void m_8056_() {
        Vec3i direction = this.blockHit.m_82434_().m_122436_();
        BlockPos mineBlock = new BlockPos(this.useOn.m_123341_() + direction.m_123341_() * -1, this.useOn.m_123342_() + direction.m_123342_() * -1, this.useOn.m_123343_() + direction.m_123343_() * -1);
        BlockState bstate = this.fallenMob.m_9236_().m_8055_(mineBlock);
        this.oldWaterCost = this.fallenMob.m_21439_(BlockPathTypes.WATER);
        this.fallenMob.m_21441_(BlockPathTypes.WATER, 0.0f);
        if (!this.fallenMob.m_21205_().m_41735_(bstate) && !(this.fallenMob.m_21205_().m_41720_() instanceof BlockItem)) {
            this.m_8041_();
            this.fallenMob.removeBuildBreakGoal();
        }
    }

    public void m_8041_() {
        this.fallenMob.m_21573_().m_26573_();
        this.fallenMob.m_21573_().m_5624_((Entity)this.fallenMob, 1.0);
        this.fallenMob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public int getEnchLevel(String enchTags) {
        if (this.fallenMob.m_21205_().m_41785_().m_7916_().indexOf(enchTags) == -1) {
            return -1;
        }
        int enchtagsInd = this.fallenMob.m_21205_().m_41785_().m_7916_().indexOf(enchTags) + 6 + enchTags.length();
        return this.fallenMob.m_21205_().m_41785_().m_7916_().charAt(enchtagsInd);
    }

    public void m_8037_() {
        try {
            double distance = Math.sqrt(Math.pow(this.fallenMob.m_146903_() - this.useOn.m_123341_(), 2.0) + Math.pow(this.fallenMob.m_146904_() - this.useOn.m_123342_(), 2.0) + Math.pow(this.fallenMob.m_146907_() - this.useOn.m_123343_(), 2.0));
            if (distance <= 5.0 && this.fallenMob.hasPlaced <= -1) {
                this.fallenMob.m_21573_().m_26573_();
                this.fallenMob.m_21573_().m_5624_((Entity)this.fallenMob, 1.0);
                Item item = this.fallenMob.m_21205_().m_41720_();
                if (item instanceof BlockItem) {
                    BlockItem block = (BlockItem)item;
                    if (block.m_40576_(new BlockPlaceContext(this.owner, this.fallenMob.f_20912_, this.fallenMob.m_21205_(), this.blockHit)).m_19077_()) {
                        this.fallenMob.m_9236_().m_46953_(this.useOn, false, (Entity)this.owner);
                        if (!this.fallenMob.m_9236_().m_8055_(this.useOn).m_60795_()) {
                            this.fallenMob.m_9236_().m_7471_(this.useOn, false);
                        } else {
                            InteractionResult result = block.m_40576_(new BlockPlaceContext(this.owner, this.fallenMob.f_20912_, this.fallenMob.m_21205_(), this.blockHit));
                            if (result.m_19077_()) {
                                this.fallenMob.m_21205_().m_41764_(this.fallenMob.m_21205_().m_41613_() - 1);
                                this.fallenMob.m_21011_(InteractionHand.MAIN_HAND, true);
                                this.fallenMob.hasPlaced = 2;
                            }
                        }
                    }
                    this.m_8041_();
                    this.fallenMob.removeBuildBreakGoal();
                } else if (this.diggingTime > 0) {
                    --this.diggingTime;
                    direction = this.blockHit.m_82434_().m_122436_();
                    BlockPos mineBlock = new BlockPos(this.useOn.m_123341_() + direction.m_123341_() * -1, this.useOn.m_123342_() + direction.m_123342_() * -1, this.useOn.m_123343_() + direction.m_123343_() * -1);
                    BlockState bstate = this.fallenMob.m_9236_().m_8055_(mineBlock);
                    this.fallenMob.m_9236_().m_247517_(null, mineBlock, bstate.m_60827_().m_56776_(), this.fallenMob.m_5720_());
                    if (this.diggingTime == 0) {
                        bstate.m_60734_().m_6786_((LevelAccessor)this.fallenMob.m_9236_(), mineBlock, bstate);
                        this.fallenMob.m_9236_().m_46953_(mineBlock, true, (Entity)this.owner);
                        if (this.fallenMob.m_21205_().m_41763_()) {
                            if (this.getEnchLevel("minecraft:unbreaking") != -1) {
                                if (this.fallenMob.m_217043_().m_216332_(1, 100) <= 100 / (this.getEnchLevel("minecraft:unbreaking") + 1)) {
                                    this.fallenMob.m_21205_().m_41721_(this.fallenMob.m_21205_().m_41773_() + 1);
                                }
                            } else {
                                this.fallenMob.m_21205_().m_41721_(this.fallenMob.m_21205_().m_41773_() + 1);
                            }
                        }
                        this.m_8041_();
                        this.fallenMob.removeBuildBreakGoal();
                    }
                } else {
                    Item mineBlock = this.fallenMob.m_21205_().m_41720_();
                    if (mineBlock instanceof BlockItem) {
                        InteractionResult result;
                        BlockItem block = (BlockItem)mineBlock;
                        if (MainUtil.canPlaceOnClaim(this.owner, this.blockHit) && (result = block.m_40576_(new BlockPlaceContext(this.owner, this.fallenMob.f_20912_, this.fallenMob.m_21205_(), this.blockHit))).m_19077_()) {
                            this.fallenMob.m_21205_().m_41764_(this.fallenMob.m_21205_().m_41613_() - 1);
                            this.fallenMob.m_21011_(InteractionHand.MAIN_HAND, true);
                            this.fallenMob.hasPlaced = 2;
                        }
                        this.m_8041_();
                        this.fallenMob.removeBuildBreakGoal();
                    }
                    direction = this.blockHit.m_82434_().m_122436_();
                    mineBlock = new BlockPos(this.useOn.m_123341_() + direction.m_123341_() * -1, this.useOn.m_123342_() + direction.m_123342_() * -1, this.useOn.m_123343_() + direction.m_123343_() * -1);
                    BlockState bstate = this.fallenMob.m_9236_().m_8055_((BlockPos)mineBlock);
                    if (bstate.m_60734_().m_155943_() == -1.0f) {
                        this.m_8041_();
                        this.fallenMob.removeBuildBreakGoal();
                    } else {
                        double digTimebuilder = this.fallenMob.m_21205_().m_41691_(bstate);
                        if (this.fallenMob.m_21124_(MobEffects.f_19598_) != null) {
                            digTimebuilder *= 0.2 * (double)this.fallenMob.m_21124_(MobEffects.f_19598_).m_19564_() + 1.0;
                        }
                        if (this.fallenMob.m_21124_(MobEffects.f_19599_) != null) {
                            digTimebuilder *= Math.pow(0.3, Math.min(this.fallenMob.m_21124_(MobEffects.f_19599_).m_19564_() + 1, 4));
                        }
                        digTimebuilder = digTimebuilder / (double)bstate.m_60734_().m_155943_() / 30.0;
                        this.fallenMob.m_21011_(InteractionHand.MAIN_HAND, true);
                        if (digTimebuilder > 1.0) {
                            bstate.m_60734_().m_6786_((LevelAccessor)this.fallenMob.m_9236_(), (BlockPos)mineBlock, bstate);
                            this.fallenMob.m_9236_().m_46961_((BlockPos)mineBlock, true);
                            if (this.fallenMob.m_21205_().m_41763_()) {
                                if (this.getEnchLevel("minecraft:unbreaking") != -1) {
                                    if (this.fallenMob.m_217043_().m_216332_(1, 100) <= 100 / (this.getEnchLevel("minecraft:unbreaking") + 1)) {
                                        this.fallenMob.m_21205_().m_41721_(this.fallenMob.m_21205_().m_41773_() + 1);
                                    }
                                } else {
                                    this.fallenMob.m_21205_().m_41721_(this.fallenMob.m_21205_().m_41773_() + 1);
                                }
                            }
                            this.m_8041_();
                            this.fallenMob.removeBuildBreakGoal();
                        } else {
                            this.diggingTime = (int)(1.0 / digTimebuilder);
                        }
                    }
                }
            } else {
                this.fallenMob.m_21573_().m_26536_(this.fallenMob.m_21573_().m_7864_(this.useOn, 0), 1.0);
            }
        }
        catch (Exception e) {
            Roundabout.LOGGER.info("Something might be amiss, report if a vanilla block caused this with corpse breaking or placing");
            this.m_8041_();
            this.fallenMob.removeBuildBreakGoal();
        }
    }
}

