/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import net.hydra.jojomod.access.IGravityLivingEntity;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersWalkingHeart;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=104)
public abstract class GravityLivingEntityMixin
extends Entity
implements IGravityLivingEntity {
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;
    @Shadow
    private boolean f_20948_;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> f_20962_;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> f_20963_;
    @Shadow
    protected boolean f_20899_;
    @Unique
    public boolean roundabout$knockbackGravityAugmentation = false;
    @Unique
    public Entity roundabout$augmentSource = null;

    @Override
    @Unique
    public void roundabout$augmentKB(Entity knockback) {
        this.roundabout$knockbackGravityAugmentation = true;
        this.roundabout$augmentSource = knockback;
    }

    public GravityLivingEntityMixin(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract float m_5675_(float var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    protected abstract boolean m_6129_();

    @Shadow
    public abstract boolean m_203441_(FluidState var1);

    @Shadow
    protected abstract float m_6108_();

    @Shadow
    public abstract float m_6113_();

    @Shadow
    public abstract boolean m_6147_();

    @Shadow
    public abstract Vec3 m_20994_(double var1, boolean var3, Vec3 var4);

    @Shadow
    public abstract boolean m_21255_();

    @Shadow
    protected abstract SoundEvent m_5896_(int var1);

    @Shadow
    public abstract Vec3 m_21074_(Vec3 var1, float var2);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    public abstract boolean m_147223_();

    @Shadow
    public abstract void m_267651_(boolean var1);

    @Shadow
    public abstract void m_147240_(double var1, double var3, double var5);

    @Shadow
    public abstract boolean m_21254_();

    @Shadow
    protected abstract void m_141973_(MobEffectInstance var1, boolean var2, @Nullable Entity var3);

    @Shadow
    protected abstract void m_7285_(MobEffectInstance var1);

    @Shadow
    protected abstract void m_8034_();

    @Shadow
    protected abstract void m_147239_();

    @Shadow
    protected abstract void m_267689_(float var1);

    @Shadow
    protected float m_6118_() {
        return 0.0f;
    }

    public LivingEntity rdbt$this() {
        return (LivingEntity)this;
    }

    @Inject(method={"calculateEntityAnimation(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$calculateEntityAnimation(boolean $$0, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this.rdbt$this());
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 myPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 myPoso = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
        myPos = myPos.m_82546_(myPoso);
        float $$1 = gravityDirection == Direction.UP ? (float)Mth.m_184648_((double)myPos.f_82479_, (double)($$0 ? myPos.f_82480_ : 0.0), (double)myPos.f_82481_) : (gravityDirection == Direction.EAST || gravityDirection == Direction.WEST ? (float)Mth.m_184648_((double)($$0 ? myPos.f_82479_ : 0.0), (double)myPos.f_82480_, (double)myPos.f_82481_) : (float)Mth.m_184648_((double)myPos.f_82479_, (double)myPos.f_82480_, (double)($$0 ? myPos.f_82481_ : 0.0)));
        this.m_267689_($$1);
    }

    @Unique
    public double rdbt$assertDazed(double initial) {
        if (((StandUser)((Object)this)).roundabout$isDazed()) {
            return 0.0;
        }
        return initial;
    }

    @Unique
    private double rdbt$TravelGravity(double $$1) {
        if (((StandUser)((Object)this)).roundabout$isDazed()) {
            return 0.0;
        }
        return ((StandUser)((Object)this)).roundabout$getGravity($$1);
    }

    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$travelWithGravity(Vec3 $$0, CallbackInfo ci) {
        PowersWalkingHeart PW;
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this.rdbt$this());
        boolean changeContext = false;
        StandPowers standPowers = ((StandUser)((Object)this)).roundabout$getStandPowers();
        if (standPowers instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)standPowers).hasExtendedHeelsForWalking()) {
            changeContext = true;
        }
        if (gravityDirection == Direction.DOWN && !changeContext) {
            return;
        }
        ci.cancel();
        ((StandUser)((Object)this)).rdbt$adjGravTrav();
        if (this.m_6109_()) {
            boolean $$2;
            double $$1 = ((StandUser)((Object)this)).rdbt$modelTravel(this.rdbt$TravelGravity(this.rdbt$assertDazed(0.08)));
            boolean bl = $$2 = this.m_20184_().f_82480_ <= 0.0;
            if ($$2 && this.m_21023_(MobEffects.f_19591_)) {
                $$1 = ((StandUser)((Object)this)).rdbt$modelTravel(this.rdbt$TravelGravity(this.rdbt$assertDazed(0.01)));
            }
            FluidState $$3 = this.m_9236_().m_6425_(this.m_20183_());
            if (this.m_20069_() && this.m_6129_() && !this.m_203441_($$3)) {
                double $$4 = this.rdbt$assertDazed(RotationUtil.vecWorldToPlayer((Vec3)this.m_20182_(), (Direction)gravityDirection).f_82480_);
                float $$5 = this.m_20142_() ? 0.9f : this.m_6108_();
                float $$6 = 0.02f;
                float $$7 = EnchantmentHelper.m_44922_((LivingEntity)this.rdbt$this());
                if ($$7 > 3.0f) {
                    $$7 = 3.0f;
                }
                if (!this.m_20096_()) {
                    $$7 *= 0.5f;
                }
                if ($$7 > 0.0f) {
                    $$5 += (0.54600006f - $$5) * $$7 / 3.0f;
                    $$6 += (this.m_6113_() - $$6) * $$7 / 3.0f;
                }
                if (this.m_21023_(MobEffects.f_19593_)) {
                    $$5 = 0.96f;
                }
                this.m_19920_($$6, $$0);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 $$8 = this.m_20184_();
                if (this.f_19862_ && this.m_6147_()) {
                    $$8 = new Vec3($$8.f_82479_, 0.2, $$8.f_82481_);
                }
                this.m_20256_($$8.m_82542_((double)$$5, (double)0.8f, (double)$$5));
                Vec3 $$9 = this.m_20994_($$1, $$2, this.m_20184_());
                this.m_20256_($$9);
                if (this.f_19862_ && this.m_20229_($$9.f_82479_, $$9.f_82480_ + (double)0.6f - RotationUtil.vecWorldToPlayer((Vec3)this.m_20182_(), (Direction)gravityDirection).f_82480_ + $$4, $$9.f_82481_)) {
                    this.m_20334_($$9.f_82479_, 0.3f, $$9.f_82481_);
                }
            } else if (this.m_20077_() && this.m_6129_() && !this.m_203441_($$3)) {
                double $$10 = this.rdbt$assertDazed(RotationUtil.vecWorldToPlayer((Vec3)this.m_20182_(), (Direction)gravityDirection).f_82480_);
                this.m_19920_(0.02f, $$0);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                    Vec3 $$11 = this.m_20994_($$1, $$2, this.m_20184_());
                    this.m_20256_($$11);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -$$1 / 4.0, 0.0));
                }
                Vec3 $$12 = this.m_20184_();
                if (this.f_19862_ && this.m_20229_($$12.f_82479_, $$12.f_82480_ + (double)0.6f - RotationUtil.vecWorldToPlayer((Vec3)this.m_20182_(), (Direction)gravityDirection).f_82480_ + $$10, $$12.f_82481_)) {
                    this.m_20334_($$12.f_82479_, 0.3f, $$12.f_82481_);
                }
            } else if (this.m_21255_()) {
                double $$22;
                double $$23;
                float $$24;
                this.m_245125_();
                Vec3 $$13 = this.m_20184_();
                Vec3 $$14 = RotationUtil.vecWorldToPlayer(this.m_20154_(), gravityDirection);
                float $$15 = this.m_146909_() * ((float)Math.PI / 180);
                double $$16 = this.rdbt$assertDazed(Math.sqrt($$14.f_82479_ * $$14.f_82479_ + $$14.f_82481_ * $$14.f_82481_));
                double $$17 = this.rdbt$assertDazed($$13.m_165924_());
                double $$18 = this.rdbt$assertDazed($$14.m_82553_());
                double $$19 = this.rdbt$assertDazed(Math.cos($$15));
                $$19 = this.rdbt$assertDazed($$19 * $$19 * Math.min(1.0, $$18 / 0.4));
                $$13 = this.m_20184_().m_82520_(0.0, $$1 * (-1.0 + $$19 * 0.75), 0.0);
                if ($$13.f_82480_ < 0.0 && $$16 > 0.0) {
                    double $$20 = this.rdbt$assertDazed($$13.f_82480_ * -0.1 * $$19);
                    $$13 = $$13.m_82520_($$14.f_82479_ * $$20 / $$16, $$20, $$14.f_82481_ * $$20 / $$16);
                }
                if ($$15 < 0.0f && $$16 > 0.0) {
                    double $$21 = this.rdbt$assertDazed($$17 * (double)(-Mth.m_14031_((float)$$15)) * 0.04);
                    $$13 = $$13.m_82520_(-$$14.f_82479_ * $$21 / $$16, $$21 * 3.2, -$$14.f_82481_ * $$21 / $$16);
                }
                if ($$16 > 0.0) {
                    $$13 = $$13.m_82520_(($$14.f_82479_ / $$16 * $$17 - $$13.f_82479_) * 0.1, 0.0, ($$14.f_82481_ / $$16 * $$17 - $$13.f_82481_) * 0.1);
                }
                this.m_20256_($$13.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.m_9236_().f_46443_ && ($$24 = (float)(($$23 = this.rdbt$assertDazed($$17 - ($$22 = this.rdbt$assertDazed(this.m_20184_().m_165924_())))) * 10.0 - 3.0)) > 0.0f) {
                    this.m_5496_(this.m_5896_((int)$$24), 1.0f, 1.0f);
                    this.m_6469_(this.m_269291_().m_269515_(), $$24);
                }
                if (this.m_20096_() && !this.m_9236_().f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos $$25 = this.m_20099_();
                float $$26 = this.m_9236_().m_8055_($$25).m_60734_().m_49958_();
                if (changeContext) {
                    $$26 = 0.6f;
                }
                float $$27 = this.m_20096_() ? $$26 * 0.91f : 0.91f;
                Vec3 $$28 = this.m_21074_($$0, $$26);
                double $$29 = $$28.f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    $$29 += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - $$28.f_82480_) * 0.2;
                } else if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_($$25)) {
                    $$29 = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    $$29 -= $$1;
                }
                if (this.m_147223_()) {
                    this.m_20334_($$28.f_82479_, $$29, $$28.f_82481_);
                } else {
                    this.m_20334_($$28.f_82479_ * (double)$$27, $$29 * (double)0.98f, $$28.f_82481_ * (double)$$27);
                }
            }
        }
        this.m_267651_(this instanceof FlyingAnimal);
        ((StandUser)((Object)this)).rdbt$doMoldDetection($$0);
    }

    @Inject(method={"playBlockFallSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$modify_playBlockFallSound_getBlockState_0(CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        if (!this.m_20067_()) {
            BlockPos flipPos = BlockPos.m_274446_((Position)this.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld(0.0, (double)-0.2f, 0.0, gravityDirection)));
            BlockState $$3 = this.m_9236_().m_8055_(new BlockPos(flipPos.m_123341_(), flipPos.m_123342_(), flipPos.m_123343_()));
            if (!$$3.m_60795_()) {
                SoundType $$4 = $$3.m_60827_();
                this.m_5496_($$4.m_56779_(), $$4.m_56773_() * 0.5f, $$4.m_56774_() * 0.75f);
            }
        }
    }

    @Inject(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="NEW", target="(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=0)}, cancellable=true)
    private void roundabout$redirect_canSee_new_0(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        Direction gravityDirectioEent = GravityAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN && gravityDirectioEent == Direction.DOWN) {
            return;
        }
        if (entity.m_9236_() != this.m_9236_()) {
            cir.setReturnValue((Object)false);
        } else {
            Vec3 $$1 = this.m_146892_();
            Vec3 $$2 = entity.m_146892_();
            cir.setReturnValue((Object)($$2.m_82554_($$1) > 128.0 ? false : this.m_9236_().m_45547_(new ClipContext($$1, $$2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS));
        }
    }

    @Inject(method={"getLocalBoundsForPose(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")}, cancellable=true)
    private void roundabout$inject_getBoundingBox(Pose pose, CallbackInfoReturnable<AABB> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = (AABB)cir.getReturnValue();
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection));
    }

    @ModifyVariable(method={"tick"}, at=@At(value="STORE"), ordinal=0)
    private double roundabout$tickGravity(double $$1) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return $$1;
        }
        return RotationUtil.vecWorldToPlayer((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_), (Direction)gravityDirection).f_82479_;
    }

    @ModifyVariable(method={"tick"}, at=@At(value="STORE"), ordinal=1)
    private double roundabout$tickGravity2(double $$1) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return $$1;
        }
        return RotationUtil.vecWorldToPlayer((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_), (Direction)gravityDirection).f_82481_;
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void roundabout$augmentHurt(DamageSource $$0, float $$1, CallbackInfoReturnable<Boolean> cir) {
        this.roundabout$knockbackGravityAugmentation = true;
        this.roundabout$augmentSource = $$0.m_7639_();
    }

    @Inject(method={"knockback(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$augmentHurtKnockaback(double $$0, double $$1, double $$2, CallbackInfo ci) {
        if (MainUtil.isKnockbackImmune((Entity)this.rdbt$this())) {
            ci.cancel();
            return;
        }
        if (this.roundabout$knockbackGravityAugmentation) {
            this.roundabout$knockbackGravityAugmentation = false;
            if (this.roundabout$augmentSource != null) {
                Direction gravityDirection = GravityAPI.getGravityDirection(this);
                if (gravityDirection == Direction.DOWN) {
                    return;
                }
                double $$13 = this.roundabout$redirect_damage_getX_0(this.roundabout$augmentSource) - this.roundabout$redirect_damage_getX_1(this.rdbt$this());
                double $$14 = this.roundabout$redirect_damage_getZ_0(this.roundabout$augmentSource) - this.roundabout$redirect_damage_getZ_1(this.rdbt$this());
                while ($$13 * $$13 + $$14 * $$14 < 1.0E-4) {
                    $$13 = (Math.random() - Math.random()) * 0.01;
                    $$14 = (Math.random() - Math.random()) * 0.01;
                }
                this.m_147240_(0.4f, $$13, $$14);
                ci.cancel();
            }
        }
    }

    @Unique
    private double roundabout$redirect_damage_getX_0(Entity attacker) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            if (GravityAPI.getGravityDirection(attacker) == Direction.DOWN) {
                return attacker.m_20185_();
            }
            return attacker.m_146892_().f_82479_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82479_;
    }

    @Unique
    private double roundabout$redirect_damage_getZ_0(Entity attacker) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            if (GravityAPI.getGravityDirection(attacker) == Direction.DOWN) {
                return attacker.m_20189_();
            }
            return attacker.m_146892_().f_82481_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82481_;
    }

    @Unique
    private double roundabout$redirect_damage_getX_1(LivingEntity target) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20185_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82479_;
    }

    @Unique
    private double roundabout$redirect_damage_getZ_1(LivingEntity target) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20189_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82481_;
    }

    @Inject(method={"blockedByShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$blocked(LivingEntity target, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)target);
        Direction gravityDirection2 = GravityAPI.getGravityDirection((Entity)this.rdbt$this());
        if (gravityDirection == Direction.DOWN && gravityDirection2 == Direction.DOWN) {
            return;
        }
        ci.cancel();
        target.m_147240_(0.5, RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82479_ - this.roundabout$redirect_knockback_getX_1(this.rdbt$this(), target), RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82481_ - this.roundabout$redirect_knockback_getZ_1(this.rdbt$this(), target));
    }

    @Unique
    private double roundabout$redirect_knockback_getX_1(LivingEntity attacker, LivingEntity target) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            if (GravityAPI.getGravityDirection((Entity)attacker) == Direction.DOWN) {
                return attacker.m_20185_();
            }
            return attacker.m_146892_().f_82479_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82479_;
    }

    @Unique
    private double roundabout$redirect_knockback_getZ_1(LivingEntity attacker, LivingEntity target) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            if (GravityAPI.getGravityDirection((Entity)attacker) == Direction.DOWN) {
                return attacker.m_20189_();
            }
            return attacker.m_146892_().f_82481_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82481_;
    }

    @Inject(method={"spawnItemParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$spawnItemParticles(ItemStack $$0, int $$1, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        for (int $$2 = 0; $$2 < $$1; ++$$2) {
            Vec3 $$3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            $$3 = $$3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            $$3 = RotationUtil.vecPlayerToWorld($$3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180)), gravityDirection);
            double $$4 = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
            Vec3 $$5 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.3, $$4, 0.6);
            $$5 = $$5.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            $$5 = $$5.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 rotated = RotationUtil.vecPlayerToWorld($$5, gravityDirection);
            $$5 = this.m_146892_().m_82520_(rotated.f_82479_, rotated.f_82480_, rotated.f_82481_);
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, $$0), $$5.f_82479_, $$5.f_82480_, $$5.f_82481_, $$3.f_82479_, $$3.f_82480_ + 0.05, $$3.f_82481_);
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$tickEffects(CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        ((StandUser)this.rdbt$this()).rdbt$setRemoveLoveSafety(false);
        Iterator<MobEffect> $$0 = this.f_20945_.keySet().iterator();
        try {
            while ($$0.hasNext()) {
                MobEffect $$1 = $$0.next();
                MobEffectInstance $$2 = this.f_20945_.get($$1);
                if (!$$2.m_19552_(this.rdbt$this(), () -> this.m_141973_($$2, true, null))) {
                    if (this.m_9236_().f_46443_) continue;
                    $$0.remove();
                    this.m_7285_($$2);
                    continue;
                }
                if ($$2.m_19557_() % 600 != 0) continue;
                this.m_141973_($$2, false, null);
            }
        }
        catch (ConcurrentModificationException $$1) {
            // empty catch block
        }
        if (this.f_20948_) {
            if (!this.m_9236_().f_46443_) {
                this.m_8034_();
                this.m_147239_();
            }
            this.f_20948_ = false;
        }
        int $$3 = (Integer)this.f_19804_.m_135370_(f_20962_);
        if (((StandUser)this.rdbt$this()).rdbt$tickEffectsBleedEdition(true)) {
            ((StandUser)this.rdbt$this()).rdbt$setRemoveLoveSafety(true);
            return;
        }
        boolean $$4 = (Boolean)this.f_19804_.m_135370_(f_20963_);
        if ($$3 > 0) {
            boolean $$5 = this.m_20145_() ? this.f_19796_.m_188503_(15) == 0 : this.f_19796_.m_188499_();
            if ($$4) {
                $$5 &= this.f_19796_.m_188503_(5) == 0;
            }
            if ($$5 && $$3 > 0) {
                double $$7 = (double)($$3 >> 16 & 0xFF) / 255.0;
                double $$8 = (double)($$3 >> 8 & 0xFF) / 255.0;
                double $$9 = (double)($$3 >> 0 & 0xFF) / 255.0;
                Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5)), gravityDirection));
                this.m_9236_().m_7106_((ParticleOptions)($$4 ? ParticleTypes.f_123770_ : ParticleTypes.f_123811_), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, $$7, $$8, $$9);
            }
        }
        ((StandUser)this.rdbt$this()).rdbt$setRemoveLoveSafety(true);
    }

    @Inject(method={"makePoofParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$modify_addDeathParticless_addParticle_0(CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        for (int $$0 = 0; $$0 < 20; ++$$0) {
            double $$1 = this.f_19796_.m_188583_() * 0.02;
            double $$2 = this.f_19796_.m_188583_() * 0.02;
            double $$3 = this.f_19796_.m_188583_() * 0.02;
            Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), gravityDirection));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, $$1, $$2, $$3);
        }
        ci.cancel();
    }

    @Inject(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isDamageSourceBlocked(DamageSource $$0, CallbackInfoReturnable<Boolean> cir) {
        Vec3 $$4;
        AbstractArrow $$3;
        Direction gravityDirection = GravityAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Entity $$1 = $$0.m_7640_();
        boolean $$2 = false;
        if ($$1 instanceof AbstractArrow && ($$3 = (AbstractArrow)$$1).m_36796_() > 0) {
            $$2 = true;
        }
        if (!$$0.m_269533_(DamageTypeTags.f_276146_) && this.m_21254_() && !$$2 && ($$4 = $$0.m_7270_()) != null) {
            Vec2 rah = RotationUtil.rotPlayerToWorld(this.m_5675_(1.0f), this.m_5686_(1.0f), gravityDirection);
            Vec3 $$5 = RotationUtil.vecWorldToPlayer(this.m_20171_(rah.f_82471_, rah.f_82470_), gravityDirection);
            Vec3 $$6 = $$4.m_82505_(this.m_20182_()).m_82541_();
            $$6 = new Vec3($$6.f_82479_, 0.0, $$6.f_82481_);
            if (gravityDirection == Direction.NORTH || gravityDirection == Direction.SOUTH) {
                $$6 = new Vec3($$6.f_82479_, $$6.f_82480_, 0.0);
            }
            if (gravityDirection == Direction.EAST || gravityDirection == Direction.WEST) {
                $$6 = new Vec3(0.0, $$6.f_82480_, $$6.f_82481_);
            }
            if ($$6.m_82526_($$5) < 0.0) {
                cir.setReturnValue((Object)true);
                return;
            }
        }
        cir.setReturnValue((Object)false);
    }

    @ModifyVariable(method={"calculateFallDamage(FF)I"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float roundabout$diminishFallDamage(float value) {
        return value * (float)Math.sqrt(GravityAPI.getGravityStrength(this));
    }
}

