/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity.client;

import net.hydra.jojomod.access.ICamera;
import net.hydra.jojomod.util.RotationAnimation;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class}, priority=1001)
public abstract class GravityCameraMixin {
    @Shadow
    private Entity f_90551_;
    @Shadow
    @Final
    private Quaternionf f_90559_;
    @Shadow
    private float f_90563_;
    @Shadow
    private float f_90562_;
    @Shadow
    private boolean f_90549_;
    @Shadow
    private BlockGetter f_90550_;
    @Shadow
    private boolean f_90560_;
    @Shadow
    private float f_90558_;
    @Shadow
    private float f_90557_;

    @Shadow
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90572_(float var1, float var2);

    @Shadow
    protected abstract double m_90566_(double var1);

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Inject(method={"setup"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$setup(BlockGetter $$0, Entity focusedEntity, boolean $$2, boolean $$3, float tickDelta, CallbackInfo ci) {
        if (focusedEntity != null) {
            Direction gravityDirection = GravityAPI.getGravityDirection(focusedEntity);
            RotationAnimation animation = GravityAPI.getRotationAnimation(focusedEntity);
            if (animation == null) {
                return;
            }
            float partialTick = Minecraft.m_91087_().m_91296_();
            long timeMs = focusedEntity.m_9236_().m_46467_() * 50L + (long)(partialTick * 50.0f);
            animation.update(timeMs);
            if (gravityDirection == Direction.DOWN && !animation.isInAnimation()) {
                return;
            }
            ci.cancel();
            this.f_90549_ = true;
            this.f_90550_ = $$0;
            this.f_90551_ = focusedEntity;
            this.f_90560_ = $$2;
            this.m_90572_(focusedEntity.m_5675_(tickDelta), focusedEntity.m_5686_(tickDelta));
            Quaternionf gravityRotation = animation.getCurrentGravityRotation(gravityDirection, timeMs);
            double entityX = Mth.m_14139_((double)tickDelta, (double)focusedEntity.f_19854_, (double)focusedEntity.m_20185_());
            double entityY = Mth.m_14139_((double)tickDelta, (double)focusedEntity.f_19855_, (double)focusedEntity.m_20186_());
            double entityZ = Mth.m_14139_((double)tickDelta, (double)focusedEntity.f_19856_, (double)focusedEntity.m_20189_());
            double currentCameraY = Mth.m_14179_((float)tickDelta, (float)this.f_90563_, (float)this.f_90562_);
            Vec3 eyeOffset = animation.getEyeOffset(gravityRotation, new Vec3(0.0, currentCameraY, 0.0), gravityDirection);
            this.m_90584_(entityX + eyeOffset.m_7096_(), entityY + eyeOffset.m_7098_(), entityZ + eyeOffset.m_7094_());
            if ($$2) {
                if ($$3) {
                    this.m_90572_(this.f_90558_ + 180.0f, -this.f_90557_);
                }
                this.m_90568_(-this.m_90566_(4.0), 0.0, 0.0);
            } else if (focusedEntity instanceof LivingEntity && ((LivingEntity)focusedEntity).m_5803_()) {
                Direction $$5 = ((LivingEntity)focusedEntity).m_21259_();
                this.m_90572_($$5 != null ? $$5.m_122435_() - 180.0f : 0.0f, 0.0f);
                this.m_90568_(0.0, 0.3, 0.0);
            }
        }
    }

    @Inject(method={"setRotation(FF)V"}, at={@At(value="INVOKE", target="Lorg/joml/Quaternionf;rotationYXZ(FFF)Lorg/joml/Quaternionf;", shift=At.Shift.AFTER)})
    private void rdbt$setRotation(CallbackInfo ci) {
        if (this.f_90551_ != null) {
            Entity entity2 = this.f_90551_;
            Entity pov = ((ICamera)((Object)this)).roundabout$getPovSwitch();
            if (pov != null && this.f_90551_ != null && !pov.m_7306_(this.f_90551_) && pov.m_6084_() && !pov.m_213877_()) {
                entity2 = pov;
            }
            Direction gravityDirection = GravityAPI.getGravityDirection(entity2);
            RotationAnimation animation = GravityAPI.getRotationAnimation(entity2);
            if (animation == null) {
                return;
            }
            if (gravityDirection == Direction.DOWN && !animation.isInAnimation()) {
                return;
            }
            float partialTick = Minecraft.m_91087_().m_91296_();
            long timeMs = this.f_90551_.m_9236_().m_46467_() * 50L + (long)(partialTick * 50.0f);
            Quaternionf rotation = new Quaternionf((Quaternionfc)animation.getCurrentGravityRotation(gravityDirection, timeMs));
            rotation.conjugate();
            rotation.mul((Quaternionfc)this.f_90559_);
            this.f_90559_.set(rotation.x(), rotation.y(), rotation.z(), rotation.w());
        }
    }
}

