/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.KnifeEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.visages.mobs.DIONPC;
import net.hydra.jojomod.entity.visages.mobs.DiegoNPC;
import net.hydra.jojomod.entity.visages.mobs.JotaroNPC;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.event.powers.visagedata.voicedata.DIOVoice;
import net.hydra.jojomod.event.powers.visagedata.voicedata.DiegoVoice;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.TWAndSPSharedPowers;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PowersTheWorld
extends TWAndSPSharedPowers {
    public Vec3 assultVec = Vec3.f_82478_;
    public static final byte ASSAULT_NOISE = 80;
    public int teleportTime = 0;
    public int postTPStall = 0;
    public int currentAir = this.getMaxAirAmount();
    public static final byte DODGE_NOISE = 19;
    public static final byte LAST_HIT_1_NOISE = 120;
    public static final byte LAST_HIT_2_NOISE = 121;
    public static final byte LAST_HIT_3_NOISE = 122;
    public static final byte LAST_HIT_4_NOISE = 123;
    public static final byte LAST_HIT_5_NOISE = 124;
    public static final byte LAST_HIT_6_NOISE = 125;
    public static final byte LAST_HIT_7_NOISE = 126;
    public static final byte LAST_HIT_8_NOISE = 127;
    public static final byte LAST_HIT_10_NOISE = 119;
    public static final byte LAST_HIT_11_NOISE = 118;
    public static final byte LAST_HIT_12_NOISE = 117;

    public PowersTheWorld(LivingEntity self) {
        super(self);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().theWorldSettings.enableTheWorld;
    }

    @Override
    public void playSummonSound() {
        Player pe;
        if (this.self.m_6047_()) {
            return;
        }
        Object object = this.self;
        if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
            DIOVoice DV = (DIOVoice)object;
            DV.playSummon();
        } else {
            Player pe2;
            object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe2 = (Player)object)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                DiegoVoice DV = (DiegoVoice)object;
                DV.playSummon();
            }
        }
        this.playStandUserOnlySoundsIfNearby(this.getSummonSound(), 10.0, false, false);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersTheWorld(entity);
    }

    @Override
    public StandEntity getNewStandEntity() {
        byte sk = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (sk == 16 || sk == 17) {
            return (StandEntity)ModEntities.THE_WORLD_ULTIMATE.m_20615_(this.getSelf().m_9236_());
        }
        return (StandEntity)ModEntities.THE_WORLD.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public int getMaxGuardPoints() {
        return ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldGuardPoints;
    }

    @Override
    public void playTheLastHitSound() {
        Player pe;
        Byte LastHitSound = this.getLastHitSound();
        Object object = this.self;
        if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
            DIOVoice DV = (DIOVoice)object;
            DV.playSoundIfPossible(this.getSoundFromByte(LastHitSound), 20, 1.0f, 2.0f);
        } else {
            Player pe2;
            object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe2 = (Player)object)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                DiegoVoice DV = (DiegoVoice)object;
                DV.playSoundIfPossible(this.getSoundFromByte(LastHitSound), 20, 1.0f, 2.0f);
            } else {
                this.playStandUserOnlySoundsIfNearby(LastHitSound, 15.0, false, true);
            }
        }
    }

    @Override
    public void playImpaleConnectSoundExtra() {
        if (!this.self.m_9236_().m_5776_()) {
            Player pe;
            Object object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
                DIOVoice DV = (DIOVoice)object;
                DV.playSoundIfPossible(ModSounds.DIO_SHINE_EVENT, 22, 1.0f, 2.0f);
            } else {
                Player pe2;
                object = this.self;
                if (object instanceof Player && (object = ((IPlayerEntity)(pe2 = (Player)object)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                    DiegoVoice DV = (DiegoVoice)object;
                    DV.playSoundIfPossible(ModSounds.DIEGO_SHINE_EVENT, 22, 1.0f, 2.0f);
                }
            }
        }
    }

    @Override
    public void playBarrageCrySound() {
        if (!this.self.m_9236_().m_5776_()) {
            Player pe;
            Object object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
                DIOVoice DV = (DIOVoice)object;
                if (!DV.inTheMiddleOfTalking()) {
                    DV.forceTalkingTicks(70);
                    byte barrageCrySound = this.chooseBarrageSound();
                    if (barrageCrySound != -1) {
                        this.playSoundsIfNearby(barrageCrySound, 27.0, false, true);
                    }
                }
            } else {
                Player pe2;
                Object barrageCrySound = this.self;
                if (barrageCrySound instanceof Player && (barrageCrySound = ((IPlayerEntity)(pe2 = (Player)barrageCrySound)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                    DiegoVoice DV = (DiegoVoice)barrageCrySound;
                    if (!DV.inTheMiddleOfTalking()) {
                        DV.forceTalkingTicks(70);
                        byte barrageCrySound2 = this.chooseBarrageSound();
                        if (barrageCrySound2 != -1) {
                            this.playSoundsIfNearby(barrageCrySound2, 27.0, false, true);
                        }
                    }
                } else {
                    byte barrageCrySound3 = this.chooseBarrageSound();
                    if (barrageCrySound3 != -1) {
                        this.playStandUserOnlySoundsIfNearby(barrageCrySound3, 27.0, false, true);
                    }
                }
            }
        }
    }

    @Override
    public Byte getLastHitSound() {
        double rand = Math.random();
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 4) {
            if (rand > 0.5) {
                return (byte)126;
            }
            return (byte)127;
        }
        if (skn == 11 || skn == 14) {
            if (rand > 0.66) {
                return (byte)119;
            }
            if (rand > 0.33) {
                return (byte)118;
            }
            return (byte)117;
        }
        if (skn == 6 || skn == 8) {
            if (rand > 0.66) {
                return (byte)123;
            }
            if (rand > 0.33) {
                return (byte)124;
            }
            return (byte)125;
        }
        if (rand > 0.66) {
            return (byte)120;
        }
        if (rand > 0.33) {
            return (byte)121;
        }
        return (byte)122;
    }

    @Override
    public SoundEvent getLastRejectionHitSound() {
        return ModSounds.STAND_THEWORLD_MUDA3_SOUND_EVENT;
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        return super.inputSpeedModifiers(basis);
    }

    public boolean isUsingAssault() {
        return this.activePower == 21;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (this.getActivePower() == 21 && this.getAttackTimeDuring() >= 0 && slot != 2 && slot != 1) {
            return true;
        }
        if (this.getActivePower() == 34 && this.getAttackTimeDuring() >= 0 && slot != 1) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public void playBarrageClashSound() {
        if (!this.self.m_9236_().m_5776_()) {
            Player pe;
            byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
            Object object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
                DIOVoice DV = (DIOVoice)object;
                DV.forceTalkingTicks(70);
                if (skn == 11 || skn == 14) {
                    this.playSoundsIfNearby((byte)28, 27.0, false);
                    return;
                }
                if (skn == 4) {
                    this.playSoundsIfNearby((byte)24, 27.0, false);
                    return;
                }
                if (skn == 6 || skn == 8) {
                    this.playSoundsIfNearby((byte)22, 27.0, false);
                    return;
                }
                this.playSoundsIfNearby((byte)21, 27.0, false);
            } else {
                Player pe2;
                object = this.self;
                if (object instanceof Player && (object = ((IPlayerEntity)(pe2 = (Player)object)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                    DiegoVoice DV = (DiegoVoice)object;
                    DV.forceTalkingTicks(70);
                    if (skn == 11 || skn == 14) {
                        this.playSoundsIfNearby((byte)28, 27.0, false);
                        return;
                    }
                    if (skn == 4) {
                        this.playSoundsIfNearby((byte)24, 27.0, false);
                        return;
                    }
                    if (skn == 6 || skn == 8) {
                        this.playSoundsIfNearby((byte)22, 27.0, false);
                        return;
                    }
                    this.playSoundsIfNearby((byte)21, 27.0, false);
                } else {
                    if (skn == 11 || skn == 14) {
                        this.playStandUserOnlySoundsIfNearby((byte)28, 27.0, false, true);
                        return;
                    }
                    if (skn == 4) {
                        this.playStandUserOnlySoundsIfNearby((byte)24, 27.0, false, true);
                        return;
                    }
                    if (skn == 6 || skn == 8) {
                        this.playStandUserOnlySoundsIfNearby((byte)22, 27.0, false, true);
                        return;
                    }
                    this.playStandUserOnlySoundsIfNearby((byte)21, 27.0, false, true);
                }
            }
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if ((this.getActivePower() == 21 || this.getActivePower() == 34) && move != 34) {
            this.stopSoundsIfNearby((byte)80, 100.0, false);
        }
        return super.tryPower(move, forced);
    }

    @Override
    public int getImpulseTSLevel() {
        return 2;
    }

    @Override
    public int getTSLevel() {
        return 3;
    }

    public int getAssaultLevel() {
        return 0;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        $$1.add((byte)2);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 > 1 || bypass) {
                $$1.add((byte)5);
                $$1.add((byte)4);
            }
            if (Level2 > 2 || bypass) {
                $$1.add((byte)3);
                $$1.add((byte)11);
                $$1.add((byte)14);
            }
            if (Level2 > 3 || bypass) {
                $$1.add((byte)9);
                $$1.add((byte)20);
                $$1.add((byte)15);
            }
            if (Level2 > 4 || bypass) {
                $$1.add((byte)12);
                $$1.add((byte)18);
            }
            if (Level2 > 5 || bypass) {
                $$1.add((byte)6);
                $$1.add((byte)8);
                $$1.add((byte)19);
            }
            if (Level2 > 6 || bypass) {
                $$1.add((byte)10);
                $$1.add((byte)13);
                $$1.add((byte)16);
                $$1.add((byte)17);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)7);
            }
        }
        return $$1;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.punch", "instruction.roundabout.press_attack", StandIcons.THE_WORLD_PUNCH, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.guard", "instruction.roundabout.hold_block", StandIcons.THE_WORLD_GUARD, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.final_kick", "instruction.roundabout.hold_attack_crouch", StandIcons.THE_WORLD_FINAL_KICK, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.barrage", "instruction.roundabout.barrage", StandIcons.THE_WORLD_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.kick_barrage", "instruction.roundabout.kick_barrage", StandIcons.THE_WORLD_KICK_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.forward_barrage", "instruction.roundabout.forward_barrage", StandIcons.THE_WORLD_TRAVEL_BARRAGE, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, this.getAssaultLevel(), "ability.roundabout.assault", "instruction.roundabout.press_skill", StandIcons.THE_WORLD_ASSAULT, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, this.getImpaleLevel(), "ability.roundabout.impale", "instruction.roundabout.press_skill_crouch", StandIcons.THE_WORLD_IMPALE, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, 0, "ability.roundabout.air_tanks", "instruction.roundabout.passive", StandIcons.THE_WORLD_AIR_TANKS, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 80, 0, "ability.roundabout.block_grab", "instruction.roundabout.press_skill", StandIcons.THE_WORLD_GRAB_BLOCK, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 99, 0, "ability.roundabout.item_grab", "instruction.roundabout.press_skill_crouch", StandIcons.THE_WORLD_GRAB_ITEM, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 118, 0, "ability.roundabout.mob_grab", "instruction.roundabout.press_skill_near_mob", StandIcons.THE_WORLD_GRAB_MOB, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 80, 0, "ability.roundabout.phase_grab", "instruction.roundabout.press_skill_block", StandIcons.THE_WORLD_PHASE_GRAB, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 99, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 118, 0, "ability.roundabout.fall_brace", "instruction.roundabout.press_skill_falling", StandIcons.THE_WORLD_FALL_CATCH, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 80, 0, "ability.roundabout.vault", "instruction.roundabout.press_skill_air", StandIcons.THE_WORLD_LEDGE_GRAB, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 99, this.getLeapLevel(), "ability.roundabout.stand_leap", "instruction.roundabout.press_skill_crouch", StandIcons.STAND_LEAP_WORLD, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 118, this.getLeapLevel(), "ability.roundabout.stand_leap_rebound", "instruction.roundabout.press_skill_rebound", StandIcons.STAND_LEAP_REBOUND_WORLD, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 80, this.getTSLevel(), "ability.roundabout.time_stop", "instruction.roundabout.press_skill", StandIcons.THE_WORLD_TIME_STOP, 4, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 99, this.getImpulseTSLevel(), "ability.roundabout.time_stop_impulse", "instruction.roundabout.press_skill_crouch", StandIcons.THE_WORLD_TIME_STOP_IMPULSE, 4, level, bypas));
        return $$1;
    }

    @Override
    public void setChargeTicksMult() {
        this.setChargedTSTicks(this.getChargedTSTicks() * (1 + (ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld - 100) / 100));
    }

    @Override
    public int getMiningLevel() {
        return ClientNetworking.getAppropriateConfig().theWorldSettings.getMiningTierTheWorld;
    }

    @Override
    public float getMiningMultiplier() {
        return (float)(1.0 * ((double)ClientNetworking.getAppropriateConfig().theWorldSettings.miningSpeedMultiplierTheWorld.intValue() * 0.01));
    }

    @Override
    public boolean fullTSChargeBonus() {
        if (this.canExecuteMoveWithLevel(this.getMaxTSFactorLevel()) && ClientNetworking.getAppropriateConfig().timeStopSettings.maxTWBypassesReduction.booleanValue()) {
            return this.maxChargedTSTicks >= ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld;
        }
        return false;
    }

    @Override
    public int setCurrentMaxTSTime(int chargedTSSeconds) {
        if (chargedTSSeconds >= ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld) {
            if (this.canExecuteMoveWithLevel(this.getMaxTSFactorLevel()) && this.getSelf() instanceof Player) {
                this.maxChargeTSTime = ClientNetworking.getAppropriateConfig().timeStopSettings.maxTWChargeBonusTicks + ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld;
                this.setChargedTSTicks(this.maxChargeTSTime);
                return ClientNetworking.getAppropriateConfig().timeStopSettings.maxTWChargeBonusTicks;
            }
            this.maxChargeTSTime = ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld;
            this.setChargedTSTicks(this.maxChargeTSTime);
        } else {
            this.maxChargeTSTime = chargedTSSeconds == ClientNetworking.getAppropriateConfig().timeStopSettings.impulseTimeStopLength ? ClientNetworking.getAppropriateConfig().timeStopSettings.impulseTimeStopLength : ((double)chargedTSSeconds == Math.min((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.2, (double)ClientNetworking.getAppropriateConfig().timeStopSettings.impulseTimeStopLength.intValue()) ? (int)Math.min((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.2, (double)ClientNetworking.getAppropriateConfig().timeStopSettings.impulseTimeStopLength.intValue()) : ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld);
        }
        if (!this.canExecuteMoveWithLevel(4)) {
            if ((double)this.maxChargeTSTime > (double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.4) {
                this.maxChargeTSTime = (int)((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.4);
            }
        } else if (!this.canExecuteMoveWithLevel(5)) {
            if ((double)this.maxChargeTSTime > (double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.6) {
                this.maxChargeTSTime = (int)((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.6);
            }
        } else if (!this.canExecuteMoveWithLevel(6) && (double)this.maxChargeTSTime > (double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.8) {
            this.maxChargeTSTime = (int)((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.8);
        }
        return 0;
    }

    @Override
    public int getMobTSTime() {
        return ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld - 1;
    }

    @Override
    public int getMaxTSTime() {
        if (this.canExecuteMoveWithLevel(6)) {
            return ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld;
        }
        if (this.canExecuteMoveWithLevel(5)) {
            return (int)((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.8);
        }
        if (this.canExecuteMoveWithLevel(4)) {
            return (int)((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.6);
        }
        return (int)((double)ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld.intValue() * 0.4);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 21) {
            return this.assault();
        }
        if (move == 34 && this.getActivePower() == 21) {
            return this.assaultGrab();
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public boolean canSeeThroughFog() {
        return this.scopeLevel > 0;
    }

    public boolean assaultGrab() {
        StandEntity stand;
        if (this.attackTimeDuring >= 0 && Objects.nonNull(stand = this.getStandEntity(this.self))) {
            this.setActivePower((byte)34);
            if (!this.getSelf().m_9236_().f_46443_) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.95f, 1.3f);
                ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, stand.m_20185_(), stand.m_20186_() + 0.3, stand.m_20189_(), 30, 0.4, 0.4, 0.4, 0.4);
            }
            return true;
        }
        return false;
    }

    public boolean assault() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)21);
            this.playSoundsIfNearby((byte)80, 27.0, false);
            this.animateStand((byte)39);
            this.poseStand((byte)3);
            Vec2 twoVec = new Vec2(this.getSelf().m_6080_() % 360.0f, this.getSelf().m_146909_());
            Direction gdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            Vec2 twoVecGrav = RotationUtil.rotPlayerToWorld(twoVec, gdir);
            Vec3 threeVec = new Vec3(0.0, 0.25, 0.0);
            threeVec = RotationUtil.vecPlayerToWorld(threeVec, gdir);
            stand.m_146922_(twoVec.f_82470_);
            stand.m_146926_(twoVec.f_82471_);
            this.assultVec = DamageHandler.getRotationVector(twoVecGrav.f_82471_, twoVecGrav.f_82470_).m_82490_(1.8).m_82520_(threeVec.f_82479_, threeVec.f_82480_, threeVec.f_82481_);
            stand.m_146884_(this.getSelf().m_20182_().m_82549_(this.assultVec));
            return true;
        }
        return false;
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public float getSoundPitchFromByte(byte soundChoice) {
        return super.getSoundPitchFromByte(soundChoice);
    }

    @Override
    public SoundEvent getFinalAttackSound() {
        return ModSounds.FINAL_KICK_EVENT;
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
    }

    @Override
    public void levelUp() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 7) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.max.skins").m_130940_(ChatFormatting.AQUA), true);
            } else if (level == 4) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.skins").m_130940_(ChatFormatting.AQUA), true);
            } else if (level == 2 || level == 3 || level == 6 || level == 5) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.both").m_130940_(ChatFormatting.AQUA), true);
            }
        }
        super.levelUp();
    }

    @Override
    public void tickPowerEnd() {
        super.tickPowerEnd();
        if (!(!this.getSelf().m_6084_() || this.getSelf().m_213877_() || this.getActivePower() != 21 && this.getActivePower() != 34 || this.getSelf().m_9236_().m_5776_())) {
            StandEntity stand;
            if (this.attackTimeDuring == 108) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else if (this.attackTimeDuring >= 0 && Objects.nonNull(stand = this.getStandEntity(this.self))) {
                AABB BB1 = stand.m_20191_();
                Vec3 vec3d = this.getSelf().m_20299_(0.0f);
                Vec3 vec3d2 = this.getSelf().m_20252_(0.0f);
                Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 15.0, vec3d2.f_82480_ * 15.0, vec3d2.f_82481_ * 15.0);
                double mag = 0.05f;
                if (this.attackTimeDuring > 10) {
                    mag += Math.pow(this.attackTimeDuring - 10, 1.4) / 1000.0;
                }
                BlockHitResult blockHit = this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
                Vec3 blockCenterPlus = blockHit.m_82425_().m_252807_();
                this.assultVec = this.assultVec.m_82549_(blockCenterPlus.m_82546_(this.getSelf().m_20182_().m_82549_(this.assultVec)).m_82541_().m_82490_(mag));
                Vec3 yes = this.getSelf().m_20182_().m_82549_(this.assultVec);
                double post = stand.m_20182_().m_82554_(blockHit.m_82425_().m_252807_());
                if (post < 1.5) {
                    stand.m_146922_(this.getSelf().m_6080_() % 360.0f);
                    stand.m_146926_(this.getSelf().m_146909_());
                } else {
                    Direction gdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
                    Vec2 grot = new Vec2(this.getLookAtPlaceYaw((Entity)stand, blockCenterPlus), this.getLookAtPlacePitch((Entity)stand, blockCenterPlus));
                    grot = RotationUtil.rotWorldToPlayer(grot, gdir);
                    stand.m_146922_(grot.f_82470_);
                    stand.m_146926_(grot.f_82471_);
                }
                if (post < 0.4) {
                    stand.m_146884_(blockHit.m_82425_().m_252807_());
                } else {
                    stand.m_146884_(yes);
                }
                if (this.getActivePower() == 34 && post <= 2.0) {
                    ((StandUser)this.getSelf()).roundabout$tryBlockPosPower(23, true, blockHit.m_82425_());
                    return;
                }
                if (stand.isTechnicallyInWall() && this.getActivePower() != 34 || stand.m_20182_().m_82554_(this.getSelf().m_20182_()) > 10.0) {
                    this.stopSoundsIfNearby((byte)80, 32.0, false);
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                }
                AABB BB2 = stand.m_20191_();
                if (this.attackTimeDuring > 11 && this.getActivePower() != 34) {
                    this.tryAssaultHit(stand, BB1, BB2);
                }
            }
        }
    }

    @Override
    public void rollSkin() {
        StandUser user = this.getUserData(this.self);
        if (this.self instanceof WitherSkeleton || this.self instanceof WitherBoss) {
            user.roundabout$setStandSkin((byte)5);
        } else if (this.self instanceof Drowned || this.self instanceof WaterAnimal || this.self instanceof Guardian) {
            user.roundabout$setStandSkin((byte)10);
        } else if (this.self instanceof IronGolem) {
            user.roundabout$setStandSkin((byte)9);
        } else if (this.self instanceof Zombie) {
            user.roundabout$setStandSkin((byte)2);
        } else if (this.self instanceof WanderingTrader) {
            user.roundabout$setStandSkin((byte)11);
        } else if (this.self instanceof EnderMan || this.self instanceof Endermite) {
            user.roundabout$setStandSkin((byte)3);
        } else if (this.self instanceof EnderDragon || this.self instanceof Warden) {
            user.roundabout$setStandSkin((byte)7);
        } else if (this.self instanceof Witch) {
            user.roundabout$setStandSkin((byte)8);
        } else if (this.self instanceof Raider) {
            user.roundabout$setStandSkin((byte)4);
        } else if (this.self instanceof Skeleton) {
            user.roundabout$setStandSkin((byte)6);
        }
    }

    @Override
    public float getFloatOutRange() {
        return 10.0f;
    }

    @Override
    public float getFinalAttackKnockback() {
        return (float)this.chargedFinal / (float)maxSuperHitTime * 2.0f;
    }

    @Override
    public float getFinalPunchStrength(Entity entity) {
        float ret;
        float punchD = this.getPunchStrength(entity) * 2.0f + this.getHeavyPunchStrength(entity);
        if (this.getReducedDamage(entity)) {
            ret = (float)this.chargedFinal / (float)maxSuperHitTime * punchD;
            if (this.chargedFinal >= maxSuperHitTime) {
                ret += 1.0f;
            }
        } else {
            ret = (float)this.chargedFinal / (float)maxSuperHitTime * punchD + 3.0f;
            if (this.chargedFinal >= maxSuperHitTime) {
                ret += 2.0f;
            }
        }
        return ret;
    }

    @Override
    public double getGrabRange() {
        if (this.getActivePower() == 34) {
            return 121.0;
        }
        return super.getGrabRange();
    }

    @Override
    public byte getSoundCancelingGroupByte(byte soundChoice) {
        if (soundChoice == 80) {
            return 80;
        }
        return super.getSoundCancelingGroupByte(soundChoice);
    }

    @Override
    public float multiplyPowerByStandConfigPlayers(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnPlayers.intValue() * 0.01));
    }

    @Override
    public float multiplyPowerByStandConfigMobs(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnMobs.intValue() * 0.01));
    }

    @Override
    public float getPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(1.75f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(5.0f));
    }

    @Override
    public float getHeavyPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(2.5f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(6.0f));
    }

    @Override
    public float getBarrageFinisherStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(3.0f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(8.0f));
    }

    @Override
    public float getBarrageHitStrength(Entity entity) {
        float str = super.getBarrageHitStrength(entity);
        if (str > 0.005f) {
            str = this.getReducedDamage(entity) ? (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnPlayers.intValue() * 0.01))) : (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnMobs.intValue() * 0.01)));
        }
        if (entity instanceof LivingEntity && str >= ((LivingEntity)entity).m_21223_() && ClientNetworking.getAppropriateConfig().generalStandSettings.barragesOnlyKillOnLastHit.booleanValue()) {
            str = entity instanceof Player ? 1.0E-5f : 0.0f;
        }
        return str;
    }

    @Override
    public float getKickBarrageFinisherStrength(Entity entity) {
        float str = super.getKickBarrageFinisherStrength(entity);
        if (this.getReducedDamage(entity)) {
            return str * this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnPlayers.intValue() * 0.01));
        }
        return str * this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnMobs.intValue() * 0.01));
    }

    @Override
    public float getKickBarrageHitStrength(Entity entity) {
        float str = super.getKickBarrageHitStrength(entity);
        if (str > 0.005f) {
            str = this.getReducedDamage(entity) ? (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnPlayers.intValue() * 0.01))) : (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().theWorldSettings.theWorldAttackMultOnMobs.intValue() * 0.01)));
        }
        return str;
    }

    @Override
    public float getImpalePunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().generalStandSettings.generalImpaleAttackMultiplier.intValue() * 0.01))));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs((float)(17.0 * ((double)ClientNetworking.getAppropriateConfig().generalStandSettings.generalImpaleAttackMultiplier.intValue() * 0.01))));
    }

    public boolean tryAssaultHit(StandEntity stand, AABB bb1, AABB bb2) {
        bb1 = bb1.m_82400_((double)1.6f);
        bb2 = bb2.m_82400_((double)1.6f);
        AABB $$2 = bb1.m_82367_(bb2);
        List $$3 = stand.m_9236_().m_45933_((Entity)stand, $$2);
        if (!$$3.isEmpty()) {
            for (int $$4 = 0; $$4 < $$3.size(); ++$$4) {
                Entity $$5 = (Entity)$$3.get($$4);
                if (!($$5 instanceof LivingEntity)) continue;
                LivingEntity LE = (LivingEntity)$$5;
                if ($$5.m_7306_((Entity)this.getSelf()) || !$$5.m_20152_() || $$5.m_20147_() || !$$5.m_6084_() || this.self.m_20159_() && this.self.m_20202_().m_20148_() == $$5.m_20148_() || !stand.m_21574_().m_148306_($$5)) continue;
                this.hitParticlesCenter((Entity)LE);
                if (this.StandDamageEntityAttack($$5, this.getAssaultStrength($$5), 0.4f, (Entity)this.self)) {
                    this.addEXP(3, LE);
                    if (!this.getAssaultEarlyTime()) {
                        MainUtil.makeBleed($$5, 0, 100, null);
                    } else {
                        MainUtil.makeBleed($$5, 0, 50, null);
                    }
                } else if (((LivingEntity)$$5).m_21254_()) {
                    if (!this.getAssaultEarlyTime()) {
                        MainUtil.knockShieldPlusStand($$5, 40);
                    } else {
                        MainUtil.knockShieldPlusStand($$5, 30);
                    }
                }
                this.stopSoundsIfNearby((byte)80, 100.0, false);
                stand.m_146922_(this.getLookAtEntityYaw((Entity)stand, $$5));
                stand.m_146926_(this.getLookAtEntityPitch((Entity)stand, $$5));
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.PUNCH_4_SOUND_EVENT, SoundSource.PLAYERS, 0.95f, 1.3f);
                int cdr = ClientNetworking.getAppropriateConfig().theWorldSettings.assaultCooldown;
                if (this.getSelf() instanceof ServerPlayer) {
                    S2CPacketUtil.sendCooldownSyncPacket((Player)((ServerPlayer)this.getSelf()), (byte)0, cdr);
                }
                this.setCooldown((byte)0, cdr);
                this.setAttackTimeDuring(-12);
                this.animateStand((byte)40);
                return true;
            }
        }
        return false;
    }

    public boolean getAssaultEarlyTime() {
        return this.getAttackTimeDuring() < 20;
    }

    public float getAssaultStrength(Entity entity) {
        float mult = 1.0f;
        boolean isReduced = this.getReducedDamage(entity);
        if (this.getAttackTimeDuring() > 95) {
            mult = 1.7f;
        } else if (this.getAttackTimeDuring() > 70) {
            mult = 1.4f;
        } else if (this.getAttackTimeDuring() > 45) {
            mult = 1.2f;
        } else if (this.getAssaultEarlyTime() && isReduced) {
            mult = 0.75f;
        }
        if (isReduced) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(1.7f * mult));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(7.0f * mult));
    }

    @Override
    public float getGrabThrowStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(1.1f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(6.0f));
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                this.assaultOrFBarrageClient();
                break;
            }
            case SKILL_1_CROUCH: {
                this.impaleOrFBarrageClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.blockAndEntityGrabClient();
                break;
            }
            case SKILL_2_GUARD: 
            case SKILL_2_CROUCH_GUARD: {
                this.phaseGrabClient();
                break;
            }
            case SKILL_2_CROUCH: {
                this.itemGrabClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.tryToDashClient();
                break;
            }
            case SKILL_3_CROUCH: {
                this.tryToStandLeapClient();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: 
            case SKILL_4_GUARD: 
            case SKILL_4_CROUCH_GUARD: {
                this.doTSClient();
            }
        }
    }

    @Override
    public void tryToDashClient() {
        if (this.isUsingAssault()) {
            return;
        }
        super.tryToDashClient();
    }

    @Override
    public void tryToStandLeapClient() {
        if (this.isUsingAssault()) {
            return;
        }
        super.tryToStandLeapClient();
    }

    @Override
    public void blockAndEntityGrabClient() {
        if (this.doAssaultGrabClient()) {
            return;
        }
        super.blockAndEntityGrabClient();
    }

    @Override
    public void itemGrabClient() {
        if (this.doAssaultGrabClient()) {
            return;
        }
        super.itemGrabClient();
    }

    public void assaultOrFBarrageClient() {
        if (this.clientForwardBarrage()) {
            return;
        }
        if (this.hasBlock() || this.hasEntity()) {
            return;
        }
        if (!this.onCooldown((byte)0) && !this.isGuarding() && this.canExecuteMoveWithLevel(this.getAssaultLevel()) && !this.isBarrageCharging() && this.getActivePower() != 41) {
            if (this.activePower == 21 || this.activePower == 34) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            } else {
                ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                this.tryPowerPacket((byte)21);
            }
            return;
        }
    }

    @Override
    public void tickPower() {
        super.tickPower();
        if (!(!this.getSelf().m_6084_() || this.getSelf().m_213877_() || this.getSelf().m_20146_() < this.getSelf().m_6062_() && ((StandUser)this.getSelf()).roundabout$getActive() || this.getSelf().m_204029_(FluidTags.f_13131_) && !this.getSelf().m_9236_().m_8055_(BlockPos.m_274561_((double)this.getSelf().m_20185_(), (double)this.getSelf().m_20188_(), (double)this.getSelf().m_20189_())).m_60713_(Blocks.f_50628_) || !((StandUser)this.getSelf()).roundabout$getActive())) {
            this.setAirAmount(Math.min(this.getAirAmount() + 4, this.getMaxAirAmount()));
        }
        if (((StandUser)this.getSelf()).roundabout$getActive() && this.getAirAmount() > 0 && this.getSelf().m_20146_() < this.getSelf().m_6062_()) {
            this.getSelf().m_20301_(Math.max(0, Math.min(this.getSelf().m_20146_() + 4, this.getSelf().m_6062_())));
            this.setAirAmount(Math.max(0, Math.min(this.getAirAmount() - 4, this.getMaxAirAmount())));
        }
    }

    public boolean doAssaultGrabClient() {
        if (this.getActivePower() == 21 && this.attackTimeDuring >= 0 && !this.onCooldown((byte)1)) {
            ((StandUser)this.getSelf()).roundabout$tryPower(34, true);
            this.tryPowerPacket((byte)34);
            return true;
        }
        return false;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return PowersTheWorld.getSkinNameT(skinId);
    }

    public static Component getSkinNameT(byte skinId) {
        if (skinId == 1) {
            return Component.m_237115_((String)"skins.roundabout.the_world.base");
        }
        if (skinId == 2) {
            return Component.m_237115_((String)"skins.roundabout.the_world.manga");
        }
        if (skinId == 3) {
            return Component.m_237115_((String)"skins.roundabout.the_world.heritage");
        }
        if (skinId == 4) {
            return Component.m_237115_((String)"skins.roundabout.the_world.ova");
        }
        if (skinId == 6) {
            return Component.m_237115_((String)"skins.roundabout.the_world.part_7");
        }
        if (skinId == 5) {
            return Component.m_237115_((String)"skins.roundabout.the_world.black");
        }
        if (skinId == 8) {
            return Component.m_237115_((String)"skins.roundabout.the_world.blue_part_7");
        }
        if (skinId == 7) {
            return Component.m_237115_((String)"skins.roundabout.the_world.over_heaven");
        }
        if (skinId == 9) {
            return Component.m_237115_((String)"skins.roundabout.the_world.dark");
        }
        if (skinId == 10) {
            return Component.m_237115_((String)"skins.roundabout.the_world.aqua");
        }
        if (skinId == 11) {
            return Component.m_237115_((String)"skins.roundabout.the_world.arcade");
        }
        if (skinId == 12) {
            return Component.m_237115_((String)"skins.roundabout.the_world.agogo");
        }
        if (skinId == 13) {
            return Component.m_237115_((String)"skins.roundabout.the_world.beta");
        }
        if (skinId == 14) {
            return Component.m_237115_((String)"skins.roundabout.the_world.arcade_2");
        }
        if (skinId == 15) {
            return Component.m_237115_((String)"skins.roundabout.the_world.four_dee");
        }
        if (skinId == 16) {
            return Component.m_237115_((String)"skins.roundabout.the_world.ultimate");
        }
        if (skinId == 17) {
            return Component.m_237115_((String)"skins.roundabout.the_world.ultimate_kars");
        }
        if (skinId == 18) {
            return Component.m_237115_((String)"skins.roundabout.the_world.scarlet");
        }
        if (skinId == 19) {
            return Component.m_237115_((String)"skins.roundabout.the_world.the_nether");
        }
        if (skinId == 20) {
            return Component.m_237115_((String)"skins.roundabout.the_world.bronze");
        }
        return Component.m_237115_((String)"skins.roundabout.the_world.base");
    }

    @Override
    public boolean canInterruptPower() {
        if (this.getActivePower() == 21 || this.getActivePower() == 34) {
            int cdr = ClientNetworking.getAppropriateConfig().theWorldSettings.assaultInterruptCooldown;
            if (this.getSelf() instanceof Player) {
                S2CPacketUtil.sendCooldownSyncPacket((Player)((ServerPlayer)this.getSelf()), (byte)0, cdr);
            }
            this.setCooldown((byte)0, cdr);
            return true;
        }
        return super.canInterruptPower();
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 100 : 100 + (currentLevel - 1) * 50;
        amt = (int)((float)amt * this.getLevelMultiplier());
        return amt;
    }

    @Override
    public boolean canChangePower(int move, boolean forced) {
        return !(this.isClashing() && move != 14 || this.getActivePower() != 0 && !forced || this.isDazed(this.getSelf()) && move != 6);
    }

    @Override
    public byte chooseBarrageSound() {
        double rand = Math.random();
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 11 || skn == 14) {
            return 28;
        }
        if (skn == 4) {
            if (rand > 0.5) {
                return 24;
            }
            return 25;
        }
        if (skn == 6 || skn == 8) {
            if (rand > 0.5) {
                return 22;
            }
            return 23;
        }
        if (rand > 0.5) {
            return 20;
        }
        return 21;
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (!(this.attackTimeDuring > -1 || !(this.getSelf().f_19789_ > 4.0f) || this.getSelf() instanceof FlyingMob || this.getSelf().m_20068_() || this.getSelf().f_19794_ || this.self instanceof EnderDragon || this.self instanceof WitherBoss)) {
            ((StandUser)this.getSelf()).roundabout$summonStand(this.getSelf().m_9236_(), true, false);
            LivingEntity livingEntity = this.getSelf();
            if (livingEntity instanceof Mob) {
                Mob MB = (Mob)livingEntity;
                ((IMob)MB).roundabout$setRetractTicks(140);
            }
            ((StandUser)this.getSelf()).roundabout$tryPower(15, true);
            return;
        }
        boolean check = attackTarget != null && attackTarget.m_6084_() && !this.isDazed(this.getSelf());
        double dist = 0.0;
        if (check) {
            if (ClientNetworking.getAppropriateConfig().timeStopSettings.mobsTeleportInsteadOfStoppingTime.booleanValue()) {
                dist = attackTarget.m_20270_((Entity)this.getSelf());
                TPTYPE tptype = TPTYPE.GROUND;
                if (this.getSelf() instanceof WaterAnimal || this.getSelf() instanceof Guardian) {
                    tptype = TPTYPE.WATER;
                } else if (this.getSelf() instanceof FlyingMob) {
                    tptype = TPTYPE.AIR;
                }
                if (this.attackTimeDuring <= -1 && !this.getSelf().m_20159_()) {
                    Creeper CREEP;
                    LivingEntity livingEntity;
                    this.teleportTime = Math.max(0, this.teleportTime - 1);
                    if (!(this.teleportTime != 0 || (livingEntity = this.getSelf()) instanceof Creeper && (CREEP = (Creeper)livingEntity).m_32311_())) {
                        if (dist <= 8.0 && !(this.getSelf() instanceof Creeper)) {
                            Vec3 pos = this.getSelf().m_20182_().m_82520_(0.0, (double)this.getSelf().m_20192_(), 0.0);
                            float p = 0.0f;
                            float y = 0.0f;
                            if (this.getSelf() instanceof Villager || this.getSelf() instanceof Skeleton) {
                                p = this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget);
                                y = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                            }
                            if (this.teleport(tptype)) {
                                if (this.getSelf() instanceof Villager) {
                                    for (int i = 0; i < 4; ++i) {
                                        KnifeEntity $$7 = new KnifeEntity(this.getSelf().m_9236_(), this.getSelf(), ModItems.KNIFE.m_7968_(), pos);
                                        $$7.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                                        $$7.shootFromRotationWithVariance((Entity)this.getSelf(), p, y, -0.5f, 1.5f, 1.0f);
                                        this.getSelf().m_9236_().m_7967_((Entity)$$7);
                                    }
                                } else if (this.getSelf() instanceof Skeleton) {
                                    Arrow $$7 = new Arrow(this.getSelf().m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
                                    $$7.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                                    $$7.m_37251_((Entity)this.getSelf(), p, y, 0.0f, 3.0f, 1.0f);
                                    $$7.m_5602_((Entity)this.getSelf());
                                    this.getSelf().m_9236_().m_7967_((Entity)$$7);
                                }
                                this.teleportTime = 200;
                                this.postTPStall = 8;
                            }
                        } else if (dist < 40.0 && this.teleportTowards((Entity)attackTarget, tptype)) {
                            this.teleportTime = this.getSelf() instanceof Creeper ? 100 : 200;
                            this.postTPStall = 8;
                        }
                    }
                }
            } else if (!this.onCooldown((byte)3) && this.getActivePower() == 0 && !this.isStoppingTime()) {
                this.setMaxChargeTSTime(ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld);
                this.setChargedTSTicks(Math.min(ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksTheWorld, 20));
                ((StandUser)this.getSelf()).roundabout$tryPower(7, true);
            }
        }
        this.postTPStall = Math.max(0, this.postTPStall - 1);
        if (this.postTPStall == 0 && !(this.getSelf() instanceof Creeper) && check) {
            if (this.getActivePower() != 0 || dist <= 5.0) {
                this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                this.getSelf().m_146922_(yrot);
                this.getSelf().m_5616_(yrot);
            }
            if (this.attackTimeDuring == -1 || this.attackTimeDuring < -1 && this.activePower == 1) {
                Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
                if (targetEntity != null && targetEntity.m_7306_((Entity)attackTarget)) {
                    double RNG = Math.random();
                    if (RNG < 0.4 && targetEntity instanceof Player && this.activePowerPhase <= 0 && !this.wentForCharge) {
                        this.wentForCharge = true;
                        if (RNG < 0.1) {
                            ((StandUser)this.getSelf()).roundabout$tryPower(41, true);
                        } else {
                            ((StandUser)this.getSelf()).roundabout$tryPower(4, true);
                        }
                    } else {
                        Objects.requireNonNull(this);
                        if (this.activePowerPhase < 3 || this.attackTime >= this.attackTimeMax) {
                            if (RNG < 0.85 && (this.getSelf() instanceof Hoglin || this.getSelf() instanceof Ravager) || this.self instanceof JotaroNPC && RNG < 0.47) {
                                ((StandUser)this.getSelf()).roundabout$tryPower(43, true);
                                this.wentForCharge = false;
                            } else if (!this.onCooldown((byte)4) && RNG >= 0.85 && dist <= 3.0 && !this.wentForCharge) {
                                ((StandUser)this.getSelf()).roundabout$tryPower(22, true);
                                this.wentForCharge = true;
                            } else {
                                ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                                this.wentForCharge = false;
                            }
                        }
                    }
                } else if ((this.getSelf().m_21223_() > 20.0f || this.getSelf() instanceof Piglin || this.getSelf() instanceof DIONPC || this.getSelf() instanceof DiegoNPC || this.getSelf() instanceof AbstractVillager) && dist <= 8.0 && dist >= 5.0) {
                    if (!this.onCooldown((byte)0)) {
                        ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                    }
                } else if ((this.getSelf() instanceof Spider || this.getSelf() instanceof Slime || this.getSelf() instanceof DIONPC || this.getSelf() instanceof DiegoNPC || this.getSelf() instanceof Rabbit || this.getSelf() instanceof AbstractVillager || this.getSelf() instanceof Piglin || this.getSelf() instanceof Vindicator) && this.getSelf().m_20096_() && dist <= 19.0 && dist >= 5.0 && !this.onCooldown((byte)6) && !this.onCooldown((byte)6)) {
                    this.setCooldown((byte)6, 300);
                    this.bonusLeapCount = 3;
                    this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                    float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                    this.getSelf().m_146922_(yrot);
                    this.getSelf().m_146922_(yrot);
                    this.getSelf().m_5616_(yrot);
                    this.bigLeap(this.getSelf(), 20.0f, 1.0f);
                    ((StandUser)this.getSelf()).roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
                    ((StandUser)this.getSelf()).roundabout$tryPower(13, true);
                }
            }
        }
    }

    protected boolean teleport(TPTYPE tptype) {
        if (!this.getSelf().m_9236_().m_5776_() && this.getSelf().m_6084_()) {
            double $$0 = this.getSelf().m_20185_() + (this.getSelf().m_217043_().m_188500_() - 0.5) * 19.0;
            double $$1 = this.getSelf().m_20186_() + (double)(this.getSelf().m_217043_().m_188503_(16) - 8);
            double $$2 = this.getSelf().m_20189_() + (this.getSelf().m_217043_().m_188500_() - 0.5) * 19.0;
            return this.teleport($$0, $$1, $$2, tptype);
        }
        return false;
    }

    boolean teleportTowards(Entity $$0, TPTYPE tptype) {
        Vec3 $$1 = new Vec3(this.getSelf().m_20185_() - $$0.m_20185_(), this.getSelf().m_20227_(0.5) - $$0.m_20188_(), this.getSelf().m_20189_() - $$0.m_20189_());
        $$1 = $$1.m_82541_();
        double $$2 = 16.0;
        double $$3 = this.getSelf().m_20185_() + (this.getSelf().m_217043_().m_188500_() - 0.5) * 8.0 - $$1.f_82479_ * 16.0;
        double $$4 = this.getSelf().m_20186_() + (double)(this.getSelf().m_217043_().m_188503_(16) - 8) - $$1.f_82480_ * 16.0;
        double $$5 = this.getSelf().m_20189_() + (this.getSelf().m_217043_().m_188500_() - 0.5) * 8.0 - $$1.f_82481_ * 16.0;
        return this.teleport($$3, $$4, $$5, tptype);
    }

    private boolean teleport(double $$0, double $$1, double $$2, TPTYPE tptype) {
        BlockPos.MutableBlockPos $$3 = new BlockPos.MutableBlockPos($$0, $$1, $$2);
        while ($$3.m_123342_() > this.getSelf().m_9236_().m_141937_() && !this.getSelf().m_9236_().m_8055_((BlockPos)$$3).m_280555_()) {
            $$3.m_122173_(Direction.DOWN);
        }
        BlockState $$4 = this.getSelf().m_9236_().m_8055_((BlockPos)$$3);
        boolean $$5 = $$4.m_280555_();
        boolean $$6 = $$4.m_60819_().m_205070_(FluidTags.f_13131_);
        if (($$5 || tptype.equals((Object)TPTYPE.AIR)) && !$$6) {
            Vec3 $$7 = this.getSelf().m_20182_();
            boolean $$8 = this.randomTeleport($$0, $$1, $$2, true, tptype);
            if ($$8 && !this.getSelf().m_20067_()) {
                this.getSelf().m_9236_().m_6263_(null, this.getSelf().f_19854_, this.getSelf().f_19855_, this.getSelf().f_19856_, ModSounds.TIME_SNAP_EVENT, this.getSelf().m_5720_(), 2.0f, 1.0f);
                this.getSelf().m_5496_(ModSounds.TIME_SNAP_EVENT, 2.0f, 1.0f);
            }
            return $$8;
        }
        return false;
    }

    public boolean randomTeleport(double $$0, double $$1, double $$2, boolean $$3, TPTYPE tptype) {
        double $$4 = this.getSelf().m_20185_();
        double $$5 = this.getSelf().m_20186_();
        double $$6 = this.getSelf().m_20189_();
        double $$7 = $$1;
        boolean $$8 = false;
        BlockPos $$9 = BlockPos.m_274561_((double)$$0, (double)$$1, (double)$$2);
        Level $$10 = this.getSelf().m_9236_();
        if ($$10.m_46805_($$9)) {
            AABB bb2;
            boolean $$11 = false;
            while (!$$11 && $$9.m_123342_() > $$10.m_141937_()) {
                BlockPos $$12 = $$9.m_7495_();
                BlockState $$13 = $$10.m_8055_($$12);
                if ($$13.m_280555_() || tptype.equals((Object)TPTYPE.AIR)) {
                    $$11 = true;
                    continue;
                }
                $$7 -= 1.0;
                $$9 = $$12;
            }
            if ($$11 && $$10.m_45756_(null, bb2 = this.getSelf().m_6972_(this.getSelf().m_20089_()).m_20384_($$0, $$7, $$2)) && (!tptype.equals((Object)TPTYPE.WATER) && !$$10.m_46855_(bb2) || tptype.equals((Object)TPTYPE.WATER) && $$10.m_46855_(bb2))) {
                $$8 = true;
                this.packetNearby(new Vector3f((float)$$0, (float)$$7, (float)$$2));
                this.getSelf().m_6021_($$0, $$7, $$2);
                this.packetNearby(new Vector3f((float)$$0, (float)$$7, (float)$$2));
            }
        }
        if (!$$8) {
            this.getSelf().m_6021_($$4, $$5, $$6);
            return false;
        }
        if (this.getSelf() instanceof PathfinderMob) {
            ((PathfinderMob)this.getSelf()).m_21573_().m_26573_();
        }
        return true;
    }

    public final void packetNearby(Vector3f blip) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, 100.0)) continue;
                S2CPacketUtil.sendBlipPacket((Player)serverPlayerEntity, (byte)2, this.getSelf().m_19879_(), blip);
            }
        }
    }

    @Override
    public void playSPandTWTSSounds() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 4) {
            this.playSoundsIfNearby((byte)46, 100.0, true);
        } else if (bt == 11 || bt == 14) {
            this.playSoundsIfNearby((byte)50, 100.0, true);
        } else if (bt == 8 || bt == 6) {
            this.playSoundsIfNearby((byte)44, 100.0, true);
        } else {
            this.playSoundsIfNearby((byte)43, 100.0, true);
        }
    }

    @Override
    public byte getTimeStopShortNoise() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 4) {
            return 48;
        }
        if (bt == 11 || bt == 14) {
            return 49;
        }
        return 41;
    }

    @Override
    public byte getTimeResumeNoise() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 4) {
            return 61;
        }
        if (bt == 11 || bt == 14) {
            return 62;
        }
        return 60;
    }

    @Override
    public void playKickBarrageCrySound() {
        if (!this.self.m_9236_().m_5776_()) {
            Player pe;
            Object object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
                DIOVoice DV = (DIOVoice)object;
                if (!DV.inTheMiddleOfTalking()) {
                    DV.forceTalkingTicks(70);
                    byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
                    if (bt == 11 || bt == 14) {
                        this.playSoundsIfNearby((byte)27, 32.0, false, true);
                        return;
                    }
                    if (bt == 4) {
                        return;
                    }
                    if (bt == 8 || bt == 6) {
                        this.playSoundsIfNearby((byte)108, 32.0, false, true);
                    } else {
                        double rand = Math.random();
                        byte barrageCrySound = rand > 0.5 ? (byte)106 : 107;
                        this.playSoundsIfNearby(barrageCrySound, 32.0, false, true);
                    }
                }
            } else {
                Player pe2;
                Object bt = this.self;
                if (bt instanceof Player && (bt = ((IPlayerEntity)(pe2 = (Player)bt)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                    DiegoVoice DV = (DiegoVoice)bt;
                    if (!DV.inTheMiddleOfTalking()) {
                        DV.forceTalkingTicks(70);
                        byte bt2 = ((StandUser)this.getSelf()).roundabout$getStandSkin();
                        if (bt2 == 11 || bt2 == 14) {
                            this.playSoundsIfNearby((byte)27, 32.0, false, true);
                            return;
                        }
                        if (bt2 == 4) {
                            return;
                        }
                        if (bt2 == 8 || bt2 == 6) {
                            this.playSoundsIfNearby((byte)108, 32.0, false, true);
                        } else {
                            double rand = Math.random();
                            byte barrageCrySound = rand > 0.5 ? (byte)106 : 107;
                            this.playSoundsIfNearby(barrageCrySound, 32.0, false, true);
                        }
                    }
                } else {
                    byte bt3 = ((StandUser)this.getSelf()).roundabout$getStandSkin();
                    if (bt3 == 11 || bt3 == 14) {
                        this.playStandUserOnlySoundsIfNearby((byte)27, 32.0, false, true);
                        return;
                    }
                    if (bt3 == 4) {
                        return;
                    }
                    if (bt3 == 8 || bt3 == 6) {
                        this.playStandUserOnlySoundsIfNearby((byte)108, 32.0, false, true);
                    } else {
                        super.playKickBarrageCrySound();
                    }
                }
            }
        }
    }

    @Override
    public void playTSVoiceSound() {
        Player pe;
        Object object = this.self;
        if (object instanceof Player && (object = ((IPlayerEntity)(pe = (Player)object)).roundabout$getVoiceData()) instanceof DIOVoice) {
            DIOVoice DV = (DIOVoice)object;
            if (!DV.inTheMiddleOfTalking()) {
                DV.forceTalkingTicks(40);
                this.playSoundsIfNearby(this.getTSVoice(), 100.0, false, true);
            }
        } else {
            Player pe2;
            object = this.self;
            if (object instanceof Player && (object = ((IPlayerEntity)(pe2 = (Player)object)).roundabout$getVoiceData()) instanceof DiegoVoice) {
                DiegoVoice DV = (DiegoVoice)object;
                if (!DV.inTheMiddleOfTalking()) {
                    DV.forceTalkingTicks(40);
                    this.playSoundsIfNearby(this.getTSVoice(), 100.0, false, true);
                }
            } else {
                this.playStandUserOnlySoundsIfNearby(this.getTSVoice(), 100.0, false, true);
            }
        }
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 20) {
            return ModSounds.STAND_THEWORLD_MUDA5_SOUND_EVENT;
        }
        if (soundChoice == 22) {
            return ModSounds.TWAU_USHA_EVENT;
        }
        if (soundChoice == 23) {
            return ModSounds.TWAU_BARRAGE_2_EVENT;
        }
        if (soundChoice == 24) {
            return ModSounds.OVA_BARRAGE_EVENT;
        }
        if (soundChoice == 25) {
            return ModSounds.OVA_BARRAGE_2_EVENT;
        }
        if (soundChoice == 27) {
            return ModSounds.ARCADE_URI_EVENT;
        }
        if (soundChoice == 28) {
            return ModSounds.ARCADE_BARRAGE_EVENT;
        }
        if (soundChoice == 18) {
            if (bt == 4) {
                return ModSounds.OVA_SUMMON_THE_WORLD_EVENT;
            }
            return ModSounds.WORLD_SUMMON_SOUND_EVENT;
        }
        if (soundChoice == 120) {
            return ModSounds.STAND_THEWORLD_MUDA3_SOUND_EVENT;
        }
        if (soundChoice == 121) {
            return ModSounds.THE_WORLD_MUDA_EVENT;
        }
        if (soundChoice == 122) {
            return ModSounds.STAND_THEWORLD_MUDA2_SOUND_EVENT;
        }
        if (soundChoice == 123) {
            return ModSounds.TWAU_MUDA_EVENT;
        }
        if (soundChoice == 124) {
            return ModSounds.TWAU_MUDA_2_EVENT;
        }
        if (soundChoice == 125) {
            return ModSounds.TWAU_MUDA_3_EVENT;
        }
        if (soundChoice == 126) {
            return ModSounds.OVA_MUDA_EVENT;
        }
        if (soundChoice == 127) {
            return ModSounds.OVA_MUDA_2_EVENT;
        }
        if (soundChoice == 119) {
            return ModSounds.ARCADE_MUDA_EVENT;
        }
        if (soundChoice == 118) {
            return ModSounds.ARCADE_MUDA_2_EVENT;
        }
        if (soundChoice == 117) {
            return ModSounds.ARCADE_MUDA_3_EVENT;
        }
        if (soundChoice == 2) {
            return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
        }
        if (soundChoice == 106) {
            return ModSounds.STAND_THEWORLD_MUDA4_SOUND_EVENT;
        }
        if (soundChoice == 107) {
            return ModSounds.THE_WORLD_WRY_EVENT;
        }
        if (soundChoice == 108) {
            return ModSounds.TWAU_WRY_EVENT;
        }
        if (soundChoice == 21) {
            return ModSounds.STAND_THEWORLD_MUDA1_SOUND_EVENT;
        }
        if (soundChoice == 80) {
            return ModSounds.THE_WORLD_ASSAULT_EVENT;
        }
        if (soundChoice == 105) {
            return ModSounds.IMPALE_CHARGE_EVENT;
        }
        if (soundChoice == 30) {
            return ModSounds.TIME_STOP_CHARGE_THE_WORLD_EVENT;
        }
        if (soundChoice == 31) {
            if (bt == 4) {
                return ModSounds.OVA_THE_WORLD_EVENT;
            }
            if (bt == 11 || bt == 14) {
                return ModSounds.ARCADE_TIMESTOP_2_EVENT;
            }
            if (bt == 8 || bt == 6) {
                return ModSounds.TWAU_THE_WORLD_EVENT;
            }
            return ModSounds.TIME_STOP_VOICE_THE_WORLD_EVENT;
        }
        if (soundChoice == 32) {
            if (bt == 4) {
                return ModSounds.OVA_THE_WORLD_2_EVENT;
            }
            if (bt == 11 || bt == 14) {
                return ModSounds.ARCADE_TIMESTOP_2_EVENT;
            }
            if (bt == 7) {
                return ModSounds.THE_WORLD_OVER_HEAVEN_EVENT;
            }
            if (bt == 8 || bt == 6) {
                return ModSounds.TWAU_TIMESTOP_2_EVENT;
            }
            return ModSounds.TIME_STOP_VOICE_THE_WORLD2_EVENT;
        }
        if (soundChoice == 33) {
            return ModSounds.TIME_STOP_VOICE_THE_WORLD3_EVENT;
        }
        if (soundChoice == 54) {
            return ModSounds.TIME_STOP_RESUME_THE_WORLD_EVENT;
        }
        if (soundChoice == 53) {
            return ModSounds.TIME_STOP_RESUME_THE_WORLD2_EVENT;
        }
        if (soundChoice == 56) {
            return ModSounds.TIME_STOP_TICKING_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public SoundEvent getImpaleSound() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 11 || bt == 14) {
            return ModSounds.ARCADE_IMPALE_EVENT;
        }
        return super.getImpaleSound();
    }

    @Override
    public int getAirAmount() {
        return this.currentAir;
    }

    @Override
    public void setAirAmount(int airAmount) {
        this.currentAir = airAmount;
        if (this.getSelf() instanceof ServerPlayer) {
            S2CPacketUtil.sendGenericIntToClientPacket((Player)((ServerPlayer)this.getSelf()), (byte)3, this.currentAir);
        }
    }

    @Override
    public int getLeapLevel() {
        return 6;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.isHoldingSneak()) {
            if (this.isBarrageAttacking() || this.getActivePower() == 42) {
                this.setSkillIcon(context, x, y, 1, StandIcons.THE_WORLD_TRAVEL_BARRAGE, (byte)-1);
            } else if (this.canExecuteMoveWithLevel(this.getImpaleLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.THE_WORLD_IMPALE, (byte)4);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
            if (this.isGuarding()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.THE_WORLD_PHASE_GRAB, (byte)1);
            } else {
                this.setSkillIcon(context, x, y, 2, StandIcons.THE_WORLD_GRAB_ITEM, (byte)1);
            }
            boolean done = false;
            if (((StandUser)this.getSelf()).roundabout$getLeapTicks() > -1) {
                if (!this.getSelf().m_20096_() && this.canStandRebound()) {
                    done = true;
                    this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_REBOUND_WORLD, (byte)-1);
                }
            } else if (!this.getSelf().m_20096_()) {
                if (this.canVault()) {
                    done = true;
                    this.setSkillIcon(context, x, y, 3, StandIcons.THE_WORLD_LEDGE_GRAB, (byte)6);
                } else if (this.getSelf().f_19789_ > 3.0f) {
                    done = true;
                    this.setSkillIcon(context, x, y, 3, StandIcons.THE_WORLD_FALL_CATCH, (byte)8);
                }
            }
            if (!done) {
                if (this.canExecuteMoveWithLevel(this.getLeapLevel())) {
                    boolean jojoveinLikeKeys;
                    boolean bl = jojoveinLikeKeys = ClientNetworking.getAppropriateConfig().generalStandSettings.standJumpAndDashShareCooldown == false;
                    if (jojoveinLikeKeys) {
                        this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_WORLD, (byte)2);
                    } else {
                        this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_WORLD, (byte)6);
                    }
                } else {
                    this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
                }
            }
        } else {
            if (this.isBarrageAttacking() || this.getActivePower() == 42) {
                this.setSkillIcon(context, x, y, 1, StandIcons.THE_WORLD_TRAVEL_BARRAGE, (byte)-1);
            } else if (this.canExecuteMoveWithLevel(this.getAssaultLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.THE_WORLD_ASSAULT, (byte)0);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
            if (this.isGuarding()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.THE_WORLD_PHASE_GRAB, (byte)1);
            } else {
                Entity targetEntity = MainUtil.getTargetEntity(this.getSelf(), 2.1f);
                if (targetEntity != null && this.canGrab(targetEntity)) {
                    this.setSkillIcon(context, x, y, 2, StandIcons.THE_WORLD_GRAB_MOB, (byte)1);
                } else {
                    this.setSkillIcon(context, x, y, 2, StandIcons.THE_WORLD_GRAB_BLOCK, (byte)1);
                }
            }
            if (((StandUser)this.getSelf()).roundabout$getLeapTicks() > -1 && !this.getSelf().m_20096_() && this.canStandRebound()) {
                this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_REBOUND_WORLD, (byte)-1);
            } else if (((StandUser)this.getSelf()).roundabout$getLeapTicks() <= -1 && !this.getSelf().m_20096_() && this.canVault()) {
                this.setSkillIcon(context, x, y, 3, StandIcons.THE_WORLD_LEDGE_GRAB, (byte)6);
            } else if (!this.getSelf().m_20096_() && this.getSelf().f_19789_ > 3.0f) {
                this.setSkillIcon(context, x, y, 3, StandIcons.THE_WORLD_FALL_CATCH, (byte)8);
            } else {
                this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
            }
        }
        boolean exTS = this.canExecuteMoveWithLevel(this.getTSLevel());
        boolean exImpTS = this.canExecuteMoveWithLevel(this.getImpulseTSLevel());
        if (((TimeStop)this.getSelf().m_9236_()).isTimeStoppingEntity(this.getSelf())) {
            this.setSkillIcon(context, x, y, 4, StandIcons.THE_WORLD_TIME_STOP_RESUME, (byte)-1);
        } else if (this.isHoldingSneak() || !exTS && exImpTS) {
            if (exImpTS) {
                this.setSkillIcon(context, x, y, 4, StandIcons.THE_WORLD_TIME_STOP_IMPULSE, (byte)3);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (exTS) {
            this.setSkillIcon(context, x, y, 4, StandIcons.THE_WORLD_TIME_STOP, (byte)3);
        } else {
            this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
        }
    }

    protected void clampRotation(Entity $$0) {
        $$0.m_5618_(this.getSelf().m_146908_());
        float $$1 = Mth.m_14177_((float)($$0.m_146908_() - this.getSelf().m_146908_()));
        float $$2 = Mth.m_14036_((float)$$1, (float)-105.0f, (float)105.0f);
        $$0.f_19859_ += $$2 - $$1;
        $$0.m_146922_($$0.m_146908_() + $$2 - $$1);
        $$0.m_5616_($$0.m_146908_());
    }

    public static enum TPTYPE {
        GROUND,
        WATER,
        AIR;

    }
}

