/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.IFireBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.block.StandFireBlockEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.stand.PowersMagiciansRed;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StandFireBlock
extends BaseEntityBlock {
    private final float fireDamage;
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE;
    public static final IntegerProperty COLOR;
    public static final BooleanProperty NORTH;
    public static final BooleanProperty EAST;
    public static final BooleanProperty SOUTH;
    public static final BooleanProperty WEST;
    public static final BooleanProperty UP;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION;
    private static final VoxelShape UP_AABB;
    private static final VoxelShape WEST_AABB;
    private static final VoxelShape EAST_AABB;
    private static final VoxelShape NORTH_AABB;
    private static final VoxelShape SOUTH_AABB;
    private final Map<BlockState, VoxelShape> shapesCache;
    private static final int IGNITE_INSTANT = 60;
    private static final int IGNITE_EASY = 30;
    private static final int IGNITE_MEDIUM = 15;
    private static final int IGNITE_HARD = 5;
    private static final int BURN_INSTANT = 100;
    private static final int BURN_EASY = 60;
    private static final int BURN_MEDIUM = 20;
    private static final int BURN_HARD = 5;
    private final Object2IntMap<Block> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> burnOdds = new Object2IntOpenHashMap();
    private static final int SECONDS_ON_FIRE = 8;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape DOWN_AABB;

    public void m_6810_(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$0.m_60713_($$3.m_60734_())) {
            BlockEntity blockEntity = $$1.m_7702_($$2);
            if (blockEntity instanceof StandFireBlockEntity) {
                StandFireBlockEntity standFireBlockEntity = (StandFireBlockEntity)blockEntity;
            }
            super.m_6810_($$0, $$1, $$2, $$3, $$4);
        }
    }

    public BlockEntity m_142194_(BlockPos $$0, BlockState $$1) {
        return new StandFireBlockEntity($$0, $$1);
    }

    public StandFireBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.fireDamage = 1.0f;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(0)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().filter($$0x -> (Integer)$$0x.m_61143_((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), StandFireBlock::calculateShape)));
    }

    private boolean isFacingDown(BlockState s) {
        return (Boolean)s.m_61143_((Property)UP) == false && (Boolean)s.m_61143_((Property)NORTH) == false && (Boolean)s.m_61143_((Property)EAST) == false && (Boolean)s.m_61143_((Property)SOUTH) == false && (Boolean)s.m_61143_((Property)WEST) == false;
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape $$1 = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            $$1 = UP_AABB;
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            $$1 = Shapes.m_83110_((VoxelShape)$$1, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            $$1 = Shapes.m_83110_((VoxelShape)$$1, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            $$1 = Shapes.m_83110_((VoxelShape)$$1, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            $$1 = Shapes.m_83110_((VoxelShape)$$1, (VoxelShape)WEST_AABB);
        }
        return $$1.m_83281_() ? DOWN_AABB : $$1;
    }

    public BlockState m_7417_(BlockState $$0, Direction $$1, BlockState $$2, LevelAccessor $$3, BlockPos $$4, BlockPos $$5) {
        if ($$0.m_60713_(ModBlocks.STAND_FIRE)) {
            int color = (Integer)$$0.m_61143_((Property)COLOR);
            return this.m_7898_($$0, (LevelReader)$$3, $$4) ? (BlockState)this.getStateWithAge($$3, $$4, (Integer)$$0.m_61143_((Property)AGE)).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(color)) : Blocks.f_50016_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        return this.shapesCache.get($$0.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext $$0) {
        return this.getStateForPlacement((BlockGetter)$$0.m_43725_(), $$0.m_8083_());
    }

    public BlockState getStateForPlacement(BlockGetter getter, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = getter.m_8055_(belowPos);
        if (!this.canBurn(belowState) && !belowState.m_60783_(getter, belowPos, Direction.UP)) {
            Direction[] directions;
            BlockState finalizedState = this.m_49966_();
            for (Direction direction : directions = Direction.values()) {
                BooleanProperty property = PROPERTY_BY_DIRECTION.get(direction);
                if (property == null) continue;
                finalizedState = (BlockState)finalizedState.m_61124_((Property)property, (Comparable)Boolean.valueOf(this.canBurn(getter.m_8055_(pos.m_121945_(direction)))));
            }
            finalizedState = (BlockState)finalizedState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(false));
            return finalizedState;
        }
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState $$0, LevelReader $$1, BlockPos $$2) {
        BlockPos $$3 = $$2.m_7495_();
        return $$1.m_8055_($$3).m_60783_((BlockGetter)$$1, $$3, Direction.UP) || this.isValidFireLocation((BlockGetter)$$1, $$2);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level $$0, BlockState $$1, BlockEntityType<T> $$2) {
        return StandFireBlock.m_152132_($$2, ModBlocks.STAND_FIRE_BLOCK_ENTITY, StandFireBlockEntity::tickFire);
    }

    protected boolean isNearRain(Level $$0, BlockPos $$1) {
        return $$0.m_46758_($$1) || $$0.m_46758_($$1.m_122024_()) || $$0.m_46758_($$1.m_122029_()) || $$0.m_46758_($$1.m_122012_()) || $$0.m_46758_($$1.m_122019_());
    }

    private int getBurnOdds(BlockState $$0) {
        return ((IFireBlock)Blocks.f_50083_).roundabout$getBurnOdds($$0);
    }

    private int getIgniteOdds(BlockState $$0) {
        return ((IFireBlock)Blocks.f_50083_).roundabout$getIgniteOdds($$0);
    }

    public void checkBurnOut(Level $$0, BlockPos $$1, int $$2, RandomSource $$3, int $$4, StandFireBlockEntity sfb) {
        int $$5 = this.getBurnOdds($$0.m_8055_($$1));
        if ($$3.m_188503_($$2) < $$5) {
            BlockState $$6 = $$0.m_8055_($$1);
            if ($$3.m_188503_($$4 + 10) < 5 && !$$0.m_46758_($$1)) {
                StandPowers standPowers;
                if (sfb.standUser != null && (standPowers = ((StandUser)sfb.standUser).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                    PowersMagiciansRed PM = (PowersMagiciansRed)standPowers;
                    int $$7 = Math.min($$4 + $$3.m_188503_(5) / 4, 15);
                    if (sfb.m_58900_().m_60713_(ModBlocks.STAND_FIRE)) {
                        int color = (Integer)sfb.m_58900_().m_61143_((Property)COLOR);
                        BlockState bs = this.getStateWithAge((LevelAccessor)$$0, $$1, $$7);
                        if (bs.m_60713_(ModBlocks.STAND_FIRE)) {
                            bs = (BlockState)bs.m_61124_((Property)COLOR, (Comparable)Integer.valueOf(color));
                            $$0.m_46597_($$1, bs);
                            BlockEntity be = $$0.m_7702_($$1);
                            if (be instanceof StandFireBlockEntity) {
                                StandFireBlockEntity sfbe = (StandFireBlockEntity)be;
                                sfbe.snapNumber = sfb.snapNumber;
                                sfbe.standUser = sfb.standUser;
                                sfbe.fireColorType = sfb.fireColorType;
                                sfbe.fireIDNumber = PM.getNewFireId();
                            }
                        }
                    }
                }
            } else {
                $$0.m_7471_($$1, false);
            }
            Block $$8 = $$6.m_60734_();
            if ($$8 instanceof TntBlock) {
                TntBlock.m_57433_((Level)$$0, (BlockPos)$$1);
            }
        }
    }

    public BlockState getStateWithAge(LevelAccessor $$0, BlockPos $$1, int $$2) {
        BlockState $$3 = StandFireBlock.getState((BlockGetter)$$0, $$1);
        return $$3.m_60713_(ModBlocks.STAND_FIRE) ? (BlockState)$$3.m_61124_((Property)AGE, (Comparable)Integer.valueOf($$2)) : $$3;
    }

    public boolean isValidFireLocation(BlockGetter $$0, BlockPos $$1) {
        for (Direction $$2 : Direction.values()) {
            if (!this.canBurn($$0.m_8055_($$1.m_121945_($$2)))) continue;
            return true;
        }
        return false;
    }

    public int getIgniteOdds(LevelReader $$0, BlockPos $$1) {
        if (!$$0.m_46859_($$1)) {
            return 0;
        }
        int $$2 = 0;
        for (Direction $$3 : Direction.values()) {
            BlockState $$4 = $$0.m_8055_($$1.m_121945_($$3));
            $$2 = Math.max(this.getIgniteOdds($$4), $$2);
        }
        return $$2;
    }

    public static BlockState getState(BlockGetter $$0, BlockPos $$1) {
        BlockPos $$2 = $$1.m_7495_();
        BlockState $$3 = $$0.m_8055_($$2);
        return SoulFireBlock.m_154650_((BlockState)$$3) ? Blocks.f_50084_.m_49966_() : ((StandFireBlock)ModBlocks.STAND_FIRE).getStateForPlacement($$0, $$1);
    }

    public void m_214162_(BlockState $$0, Level $$1, BlockPos $$2, RandomSource $$3) {
        if ($$3.m_188503_(24) == 0) {
            $$1.m_7785_((double)$$2.m_123341_() + 0.5, (double)$$2.m_123342_() + 0.5, (double)$$2.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + $$3.m_188501_(), $$3.m_188501_() * 0.7f + 0.3f, false);
        }
    }

    protected boolean canBurn(BlockState $$0) {
        return this.getIgniteOdds($$0) > 0;
    }

    public void m_7892_(BlockState $$0, Level $$1, BlockPos $$2, Entity $$3) {
        BlockEntity blockEntity;
        if (!$$1.m_5776_() && (blockEntity = $$1.m_7702_($$2)) instanceof StandFireBlockEntity) {
            StandFireBlockEntity fb = (StandFireBlockEntity)blockEntity;
            if (fb.standUser != null && fb.standUser.m_7306_($$3)) {
                $$1.m_7471_($$2, false);
            } else if ($$3 instanceof LivingEntity) {
                BlockEntity blockEntity2;
                LivingEntity LE = (LivingEntity)$$3;
                StandUser user = (StandUser)$$3;
                user.roundabout$setRemainingStandFireTicks(user.roundabout$getRemainingFireTicks() + 1);
                if (user.roundabout$getRemainingFireTicks() == 0 && (blockEntity2 = $$1.m_7702_($$2)) instanceof StandFireBlockEntity) {
                    StandFireBlockEntity $$5 = (StandFireBlockEntity)blockEntity2;
                    user.roundabout$setSecondsOnStandFire(3);
                    if (fb.standUser != null) {
                        user.roundabout$setOnStandFire($$5.fireColorType, fb.standUser);
                    } else {
                        user.roundabout$setOnStandFire($$5.fireColorType);
                    }
                }
                float fd = 1.0f;
                fd = user.roundabout$getStandPowers().getReducedDamage((Entity)LE) ? (float)((double)fd * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.standFireOnPlayers.intValue() * 0.01)) : (float)((double)fd * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.standFireOnMobs.intValue() * 0.01));
                Vec3 prevVelocity = LE.m_20184_();
                LE.m_6469_(ModDamageTypes.of($$1, ModDamageTypes.STAND_FIRE, (Entity)fb.standUser), fd);
                LE.m_20256_(prevVelocity);
            }
        }
        super.m_7892_($$0, $$1, $$2, $$3);
    }

    private static boolean inPortalDimension(Level $$0) {
        return $$0.m_46472_() == Level.f_46428_ || $$0.m_46472_() == Level.f_46429_;
    }

    protected void m_142387_(Level $$0, Player $$1, BlockPos $$2, BlockState $$3) {
    }

    public void m_5707_(Level $$0, BlockPos $$1, BlockState $$2, Player $$3) {
        if (!$$0.m_5776_()) {
            $$0.m_5898_(null, 1009, $$1, 0);
        }
        super.m_5707_($$0, $$1, $$2, $$3);
    }

    public static boolean canBePlacedAt(Level $$0, BlockPos $$1, Direction $$2) {
        BlockState $$3 = $$0.m_8055_($$1);
        return !$$3.m_60795_() ? false : StandFireBlock.getState((BlockGetter)$$0, $$1).m_60710_((LevelReader)$$0, $$1) || StandFireBlock.isPortal($$0, $$1, $$2);
    }

    private static boolean isPortal(Level $$0, BlockPos $$1, Direction $$2) {
        if (!StandFireBlock.inPortalDimension($$0)) {
            return false;
        }
        BlockPos.MutableBlockPos $$3 = $$1.m_122032_();
        boolean $$4 = false;
        for (Direction $$5 : Direction.values()) {
            if (!$$0.m_8055_((BlockPos)$$3.m_122190_((Vec3i)$$1).m_122173_($$5)).m_60713_(Blocks.f_50080_)) continue;
            $$4 = true;
            break;
        }
        if (!$$4) {
            return false;
        }
        Direction.Axis $$6 = $$2.m_122434_().m_122479_() ? $$2.m_122428_().m_122434_() : Direction.Plane.HORIZONTAL.m_235692_($$0.f_46441_);
        return PortalShape.m_77708_((LevelAccessor)$$0, (BlockPos)$$1, (Direction.Axis)$$6).isPresent();
    }

    public void m_6807_(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.m_60713_($$0.m_60734_())) {
            Optional $$5;
            if (StandFireBlock.inPortalDimension($$1) && ($$5 = PortalShape.m_77708_((LevelAccessor)$$1, (BlockPos)$$2, (Direction.Axis)Direction.Axis.X)).isPresent()) {
                ((PortalShape)$$5.get()).m_77743_();
                return;
            }
            if (!$$0.m_60710_((LevelReader)$$1, $$2)) {
                $$1.m_7471_($$2, false);
            }
        }
    }

    private static int getFireTickDelay(RandomSource $$0) {
        return 30 + $$0.m_188503_(10);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP, COLOR});
    }

    private void setFlammable(Block $$0, int $$1, int $$2) {
        this.igniteOdds.put((Object)$$0, $$1);
        this.burnOdds.put((Object)$$0, $$2);
    }

    static {
        COLOR = ModBlocks.COLOR;
        DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        AGE = BlockStateProperties.f_61410_;
        NORTH = PipeBlock.f_55148_;
        EAST = PipeBlock.f_55149_;
        SOUTH = PipeBlock.f_55150_;
        WEST = PipeBlock.f_55151_;
        UP = PipeBlock.f_55152_;
        PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter($$0 -> $$0.getKey() != Direction.DOWN).collect(Util.m_137448_());
        UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

