/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.hydra.jojomod.access.IKeyMapping;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.stand.PowersJustice;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class JusticeMobSwitcherScreen
extends Screen {
    static final ResourceLocation MOB_SWITCHER_LOCATION = new ResourceLocation("roundabout", "textures/gui/mob_switcher.png");
    private static final int SPRITE_SHEET_WIDTH = 128;
    private static final int SPRITE_SHEET_HEIGHT = 128;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = MobIcon.VALUES.length * 31 - 5;
    private static final int ALL_SLOTS2_WIDTH = MobIcon.VALUES2.length * 31 - 5;
    private static final Component SELECT_KEY = Component.m_237110_((String)"justice.morph.select_next", (Object[])new Object[]{KeyInputRegistry.abilityOneKey.m_90863_(), KeyInputRegistry.abilityTwoKey.m_90863_()});
    private final MobIcon previousHovered;
    private MobIcon currentlyHovered;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    public boolean zHeld;
    public static boolean hasOVASkin = false;
    public static boolean hasWitherSkin = false;
    public static boolean hasStraySkin = false;
    private final List<MobSlot> slots = Lists.newArrayList();

    public JusticeMobSwitcherScreen() {
        super(GameNarrator.f_93310_);
        this.currentlyHovered = this.previousHovered = MobIcon.getFromGameType(this.getDefaultSelected());
    }

    private ShapeShifts getDefaultSelected() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (pl != null) {
            return ShapeShifts.getShiftFromByte(((IPlayerEntity)pl).roundabout$getShapeShift());
        }
        return ShapeShifts.PLAYER;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zHeld = true;
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (pl != null) {
            byte standSkin = ((IPlayerEntity)pl).roundabout$getStandSkin();
            hasOVASkin = standSkin == 4;
            hasWitherSkin = standSkin == 9;
            hasStraySkin = standSkin == 6;
        } else {
            hasOVASkin = false;
            hasWitherSkin = false;
            hasStraySkin = false;
        }
        this.currentlyHovered = this.previousHovered;
        if (hasOVASkin) {
            for (i = 0; i < MobIcon.VALUES2.length; ++i) {
                MobIcon MobIcon2 = MobIcon.VALUES2[i];
                this.slots.add(new MobSlot(MobIcon2, this.f_96543_ / 2 - ALL_SLOTS2_WIDTH / 2 + i * 31, this.f_96544_ / 2 - 31));
            }
        } else if (hasWitherSkin) {
            for (i = 0; i < MobIcon.VALUES3.length; ++i) {
                MobIcon MobIcon3 = MobIcon.VALUES3[i];
                this.slots.add(new MobSlot(MobIcon3, this.f_96543_ / 2 - ALL_SLOTS2_WIDTH / 2 + i * 31, this.f_96544_ / 2 - 31));
            }
        } else if (hasStraySkin) {
            for (i = 0; i < MobIcon.VALUES4.length; ++i) {
                MobIcon MobIcon4 = MobIcon.VALUES4[i];
                this.slots.add(new MobSlot(MobIcon4, this.f_96543_ / 2 - ALL_SLOTS2_WIDTH / 2 + i * 31, this.f_96544_ / 2 - 31));
            }
        } else {
            for (i = 0; i < MobIcon.VALUES.length; ++i) {
                MobIcon MobIcon5 = MobIcon.VALUES[i];
                this.slots.add(new MobSlot(MobIcon5, this.f_96543_ / 2 - ALL_SLOTS_WIDTH / 2 + i * 31, this.f_96544_ / 2 - 31));
            }
        }
    }

    public boolean m_6348_(double $$0, double $$1, int $$2) {
        this.switchToHoveredGameMode();
        this.f_96541_.m_91152_(null);
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.checkToClose()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        int k = this.f_96543_ / 2 - 62;
        int l = this.f_96544_ / 2 - 31 - 27;
        guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, k, l, 0.0f, 0.0f, 125, 75, 128, 128);
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280653_(this.f_96547_, this.currentlyHovered.getName(), this.f_96543_ / 2, this.f_96544_ / 2 - 31 - 20, -1);
        guiGraphics.m_280653_(this.f_96547_, SELECT_KEY, this.f_96543_ / 2, this.f_96544_ / 2 + 5, 0xFFFFFF);
        if (!this.setFirstMousePos) {
            this.firstMouseX = i;
            this.firstMouseY = j;
            this.setFirstMousePos = true;
        }
        boolean bl = this.firstMouseX == i && this.firstMouseY == j;
        for (MobSlot MobSlot2 : this.slots) {
            MobSlot2.m_88315_(guiGraphics, i, j, f);
            MobSlot2.setSelected(this.currentlyHovered == MobSlot2.icon);
            if (bl || !MobSlot2.m_198029_()) continue;
            this.currentlyHovered = MobSlot2.icon;
        }
    }

    private void switchToHoveredGameMode() {
        JusticeMobSwitcherScreen.switchToHoveredGameMode(this.f_96541_, this.currentlyHovered);
    }

    private static void switchToHoveredGameMode(Minecraft minecraft, MobIcon MobIcon2) {
        StandPowers sp;
        if (minecraft.f_91072_ == null || minecraft.f_91074_ == null) {
            return;
        }
        MobIcon MobIcon3 = MobIcon2;
        MobIcon MobIcon22 = MobIcon.getFromGameType(ShapeShifts.getShiftFromByte(((IPlayerEntity)minecraft.f_91074_).roundabout$getShapeShift()));
        if (MobIcon3 != MobIcon22 && (sp = ((StandUser)minecraft.f_91074_).roundabout$getStandPowers()) instanceof PowersJustice) {
            PowersJustice pj = (PowersJustice)sp;
            if (ShapeShifts.isVillager(ShapeShifts.getShiftFromByte(MobIcon3.id)) && !sp.canExecuteMoveWithLevel(pj.getVillagerMorphLevel())) {
                return;
            }
            if (ShapeShifts.isZombie(ShapeShifts.getShiftFromByte(MobIcon3.id)) && !sp.canExecuteMoveWithLevel(pj.getZombieMorphLevel())) {
                return;
            }
            if (ShapeShifts.isSkeleton(ShapeShifts.getShiftFromByte(MobIcon3.id)) && !sp.canExecuteMoveWithLevel(pj.getSkeletonMorphLevel())) {
                return;
            }
            ModPacketHandler.PACKET_ACCESS.byteToServerPacket(MobIcon3.id, (byte)6);
        }
    }

    public boolean sameKeyOne(KeyMapping key1, Options options) {
        return key1.m_90857_() || key1.m_90850_(options.f_92058_) && options.f_92058_.m_90857_() || key1.m_90850_(options.f_92057_) && options.f_92057_.m_90857_();
    }

    public boolean sameKeyOneX(KeyMapping key1, Options options) {
        return InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)key1).roundabout$justTellMeTheKey().m_84873_()) || key1.m_90850_(options.f_92058_) && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)options.f_92058_).roundabout$justTellMeTheKey().m_84873_()) || key1.m_90850_(options.f_92057_) && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)options.f_92057_).roundabout$justTellMeTheKey().m_84873_());
    }

    private boolean checkToClose() {
        if (this.f_96541_ != null) {
            if (!this.sameKeyOneX(KeyInputRegistry.abilityOneKey, this.f_96541_.f_91066_)) {
                this.zHeld = false;
            } else if (!this.zHeld) {
                this.setFirstMousePos = false;
                this.currentlyHovered = this.currentlyHovered.getNext();
                this.zHeld = true;
            }
            if (this.sameKeyOneX(KeyInputRegistry.abilityTwoKey, this.f_96541_.f_91066_)) {
                this.switchToHoveredGameMode();
                this.f_96541_.m_91152_(null);
                return true;
            }
        }
        Options options = Minecraft.m_91087_().f_91066_;
        return false;
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k);
    }

    public boolean m_7043_() {
        return false;
    }

    public static enum MobIcon {
        PLAYER((Component)Component.m_237115_((String)"justice.morph.player"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_1.png"), ShapeShifts.PLAYER.id),
        VILLAGER((Component)Component.m_237115_((String)"justice.morph.villager"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_2.png"), ShapeShifts.VILLAGER.id),
        OVA((Component)Component.m_237115_((String)"justice.morph.ova"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_ova.png"), ShapeShifts.OVA.id),
        ZOMBIE((Component)Component.m_237115_((String)"justice.morph.zombie"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_3.png"), ShapeShifts.ZOMBIE.id),
        SKELETON((Component)Component.m_237115_((String)"justice.morph.skeleton"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_4.png"), ShapeShifts.SKELETON.id),
        WITHER_SKELETON((Component)Component.m_237115_((String)"justice.morph.wither_skeleton"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_wither.png"), ShapeShifts.WITHER_SKELETON.id),
        STRAY((Component)Component.m_237115_((String)"justice.morph.stray"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_stray.png"), ShapeShifts.STRAY.id),
        EERIE((Component)Component.m_237115_((String)"justice.morph.eerie"), new ResourceLocation("roundabout", "textures/gui/icons/justice/disguise_eerie.png"), ShapeShifts.EERIE.id),
        LOCKED((Component)Component.m_237115_((String)"ability.roundabout.locked.ctrl"), StandIcons.LOCKED, ShapeShifts.PLAYER.id);

        protected static final MobIcon[] VALUES;
        protected static final MobIcon[] VALUES2;
        protected static final MobIcon[] VALUES3;
        protected static final MobIcon[] VALUES4;
        private static final int ICON_AREA = 16;
        protected static final int ICON_TOP_LEFT = 5;
        final Component name;
        final ResourceLocation rl;
        final byte id;

        private MobIcon(Component component, ResourceLocation rl, byte id) {
            this.name = component;
            this.rl = rl;
            this.id = id;
        }

        void drawIcon(GuiGraphics guiGraphics, int i, int j) {
            LocalPlayer pl = Minecraft.m_91087_().f_91074_;
            if (pl != null) {
                StandPowers sp = ((StandUser)pl).roundabout$getStandPowers();
                if (sp instanceof PowersJustice) {
                    PowersJustice pj = (PowersJustice)sp;
                    if (ShapeShifts.isVillager(ShapeShifts.getShiftFromByte(this.id)) && !sp.canExecuteMoveWithLevel(pj.getVillagerMorphLevel())) {
                        guiGraphics.m_280163_(MobIcon.LOCKED.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                        return;
                    }
                    if (ShapeShifts.isZombie(ShapeShifts.getShiftFromByte(this.id)) && !sp.canExecuteMoveWithLevel(pj.getZombieMorphLevel())) {
                        guiGraphics.m_280163_(MobIcon.LOCKED.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                        return;
                    }
                    if (ShapeShifts.isSkeleton(ShapeShifts.getShiftFromByte(this.id)) && !sp.canExecuteMoveWithLevel(pj.getSkeletonMorphLevel())) {
                        guiGraphics.m_280163_(MobIcon.LOCKED.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                        return;
                    }
                }
                guiGraphics.m_280163_(this.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }

        Component getName() {
            StandPowers sp;
            LocalPlayer pl = Minecraft.m_91087_().f_91074_;
            if (pl != null && (sp = ((StandUser)pl).roundabout$getStandPowers()) instanceof PowersJustice) {
                PowersJustice pj = (PowersJustice)sp;
                if (ShapeShifts.isVillager(ShapeShifts.getShiftFromByte(this.id)) && !sp.canExecuteMoveWithLevel(pj.getVillagerMorphLevel())) {
                    return MobIcon.LOCKED.name;
                }
                if (ShapeShifts.isZombie(ShapeShifts.getShiftFromByte(this.id)) && !sp.canExecuteMoveWithLevel(pj.getZombieMorphLevel())) {
                    return MobIcon.LOCKED.name;
                }
                if (ShapeShifts.isSkeleton(ShapeShifts.getShiftFromByte(this.id)) && !sp.canExecuteMoveWithLevel(pj.getSkeletonMorphLevel())) {
                    return MobIcon.LOCKED.name;
                }
            }
            return this.name;
        }

        MobIcon getNext() {
            if (hasOVASkin) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case PLAYER -> OVA;
                    case VILLAGER, OVA, EERIE -> ZOMBIE;
                    case ZOMBIE -> SKELETON;
                    case SKELETON, WITHER_SKELETON, STRAY -> PLAYER;
                };
            }
            if (hasWitherSkin) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case PLAYER -> VILLAGER;
                    case VILLAGER, OVA, EERIE -> ZOMBIE;
                    case ZOMBIE -> WITHER_SKELETON;
                    case SKELETON, WITHER_SKELETON, STRAY -> PLAYER;
                };
            }
            if (hasStraySkin) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case PLAYER -> VILLAGER;
                    case VILLAGER, OVA, EERIE -> ZOMBIE;
                    case ZOMBIE -> STRAY;
                    case SKELETON, WITHER_SKELETON, STRAY -> PLAYER;
                };
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PLAYER -> VILLAGER;
                case VILLAGER, OVA, EERIE -> ZOMBIE;
                case ZOMBIE -> SKELETON;
                case SKELETON, WITHER_SKELETON, STRAY -> PLAYER;
            };
        }

        static MobIcon getFromGameType(ShapeShifts shift) {
            return switch (shift) {
                default -> throw new IncompatibleClassChangeError();
                case ShapeShifts.PLAYER -> PLAYER;
                case ShapeShifts.VILLAGER -> VILLAGER;
                case ShapeShifts.OVA -> OVA;
                case ShapeShifts.ZOMBIE -> ZOMBIE;
                case ShapeShifts.SKELETON -> SKELETON;
                case ShapeShifts.WITHER_SKELETON -> WITHER_SKELETON;
                case ShapeShifts.STRAY -> STRAY;
                case ShapeShifts.EERIE -> EERIE;
            };
        }

        static {
            VALUES = new MobIcon[]{PLAYER, VILLAGER, ZOMBIE, SKELETON};
            VALUES2 = new MobIcon[]{PLAYER, OVA, ZOMBIE, SKELETON};
            VALUES3 = new MobIcon[]{PLAYER, VILLAGER, ZOMBIE, WITHER_SKELETON};
            VALUES4 = new MobIcon[]{PLAYER, EERIE, ZOMBIE, STRAY};
        }
    }

    public class MobSlot
    extends AbstractWidget {
        final MobIcon icon;
        private boolean isSelected;

        public MobSlot(MobIcon MobIcon2, int i, int j) {
            super(i, j, 26, 26, MobIcon2.getName());
            this.icon = MobIcon2;
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            this.drawSlot(guiGraphics);
            this.icon.drawIcon(guiGraphics, this.m_252754_() + 5, this.m_252907_() + 5);
            if (this.isSelected) {
                this.drawSelection(guiGraphics);
            }
        }

        public void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public boolean m_198029_() {
            return super.m_198029_() || this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        private void drawSlot(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 0.0f, 75.0f, 26, 26, 128, 128);
        }

        private void drawSelection(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 26.0f, 75.0f, 26, 26, 128, 128);
        }
    }
}

