/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.TimeStopInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class StandHudRender {
    private static final int guiSize = 174;
    private static float animated = 0.0f;

    public static void renderStandHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        if (playerEntity != null) {
            int x = 0;
            int y = 0;
            int width = scaledWidth;
            int height = scaledHeight;
            int textureWidth = 174;
            int textureHeight = 30;
            int iconHeight = 18;
            int iconWidth = 18;
            x = (int)(-194.0f + animated);
            y = 5;
            Minecraft mc = Minecraft.m_91087_();
            float tickDelta = mc.m_91297_();
            boolean standOn = ((StandUser)playerEntity).roundabout$getActive();
            if (standOn || (double)animated > 0.1) {
                if (!standOn) {
                    animated = Math.max(StandHudRender.controlledLerp(tickDelta, animated, 0.0f, 0.5f), 0.0f);
                } else if (animated < 174.0f) {
                    animated += 1.0f;
                    animated = Math.min(StandHudRender.controlledLerp(tickDelta, animated, 174.0f, 0.5f), 174.0f);
                }
                context.m_280246_(1.0f, 1.0f, 1.0f, 0.9f);
                RenderSystem.enableBlend();
                ((StandUser)playerEntity).roundabout$getStandPowers().renderIcons(context, x, y);
                RenderSystem.disableBlend();
                context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static Component fixKey(Component textIn) {
        String X = textIn.getString();
        if (X.length() > 1) {
            String[] split = X.split("\\s");
            if (split.length > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[1].charAt(0)));
            }
            if (split[0].length() > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[0].charAt(1)));
            }
            return Component.m_130674_((String)("" + split[0].charAt(0)));
        }
        return textIn;
    }

    public static float controlledLerp(float delta, float start, float end, float multiplier) {
        return start + delta * (end - start) * multiplier;
    }

    public static void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        if (playerEntity != null) {
            ((StandUser)playerEntity).roundabout$getStandPowers().renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
        }
    }

    private static int getFinalATimeInt(StandUser standUser) {
        int barrageWindup = standUser.roundabout$getStandPowers().getBarrageWindup();
        int barrageLength = standUser.roundabout$getStandPowers().getBarrageLength();
        float attackTimeDuring = standUser.roundabout$getAttackTimeDuring();
        int finalATimeInt = attackTimeDuring <= (float)barrageWindup ? Math.round(attackTimeDuring / (float)barrageWindup * 15.0f) : 15 - Math.round((attackTimeDuring - (float)barrageWindup) / (float)barrageLength * 15.0f);
        return finalATimeInt;
    }

    public static void renderGrabbedHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int k = (int)Math.floor(6.0666666f * (float)standUser.roundabout$getRestrainedTicks());
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 70, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 75, k, 5);
        }
        int u = 183;
        k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 50, 9, 9);
    }

    public static void renderSealedDiscHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int k = (int)Math.floor(182.0 / (double)standUser.roundabout$getMaxSealedTicks() * (double)(standUser.roundabout$getMaxSealedTicks() - standUser.roundabout$getSealedTicks()));
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 90, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 95, k, 5);
        }
        int u = 183;
        k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 60, 9, 9);
    }

    public static void renderExpHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        byte level = ((IPlayerEntity)playerEntity).roundabout$getStandLevel();
        int exp = ((IPlayerEntity)playerEntity).roundabout$getStandExp();
        int maxXP = standUser.roundabout$getStandPowers().getExpForLevelUp(level);
        if (level == standUser.roundabout$getStandPowers().getMaxLevel() || !standUser.roundabout$getStandDisc().m_41619_() && standUser.roundabout$getStandDisc().m_41720_() instanceof MaxStandDiscItem) {
            exp = maxXP;
        }
        int blt = (int)Math.floor(182.0 / (double)maxXP * (double)exp);
        int l = scaledHeight - 32 + 3;
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 100, 182, 5);
        if (blt > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 105, blt, 5);
        }
        int u = 183;
        int k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        int y = 6141337;
        Font renderer = client.f_91062_;
        String $$6 = "" + level;
        int $$7 = (scaledWidth - renderer.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(renderer, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8, y, false);
    }

    public static void renderDistanceHUDJustice(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, StandEntity stand) {
        StandUser standUser = (StandUser)playerEntity;
        StandPowers powers = standUser.roundabout$getStandPowers();
        int mode = powers.getPilotMode();
        int maxDistance = powers.getMaxPilotRange();
        int distance = 1;
        if (mode == 1) {
            distance = (int)stand.m_20182_().m_82554_(playerEntity.m_20182_());
        } else if (mode == 2) {
            distance = (int)MainUtil.cheapDistanceTo2(stand.m_20185_(), stand.m_20189_(), playerEntity.m_20185_(), playerEntity.m_20189_());
        }
        int blt = (int)Math.floor(182.0 / (double)maxDistance * (double)distance);
        int l = scaledHeight - 32 + 3;
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 131, 182, 5);
        if (blt > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 136, blt, 5);
        }
        int u = 183;
        int k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        int y = 16173823;
        Font renderer = client.f_91062_;
        String $$6 = "" + distance;
        int $$7 = (scaledWidth - renderer.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(renderer, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8, y, false);
    }

    public static void renderGuardHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int v = standUser.roundabout$getGuardBroken() || !standUser.roundabout$shieldNotDisabled() ? 10 : 0;
        int k = (int)Math.floor(182.0f / standUser.roundabout$getMaxGuardPoints() * standUser.roundabout$getGuardPoints());
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v + 5, k, 5);
        }
        int u = 183;
        k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, v, 9, 9);
    }

    public static void renderTSHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, boolean isTSEntity, Font font) {
        int y;
        int z;
        int k;
        int v;
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        if (isTSEntity || standUser.roundabout$getStandPowers().getIsTsCharging()) {
            v = 50;
            k = (int)Math.floor(182.0 / ((double)standUser.roundabout$getStandPowers().getMaxChargeTSTime() / 20.0) * ((double)standUser.roundabout$getStandPowers().getChargedTSTicks() / 20.0));
            z = (int)Math.min(Math.floor(((double)standUser.roundabout$getStandPowers().getChargedTSTicks() + 19.0) / 20.0), (double)standUser.roundabout$getStandPowers().getMaxChargeTSTime() / 20.0);
            y = 7654088;
        } else {
            v = 60;
            y = 7836819;
            TimeStopInstance tsi = ((TimeStop)playerEntity.m_9236_()).getTimeStopperInstanceClient(playerEntity.m_20182_());
            if (tsi != null) {
                k = (int)Math.floor(182.0 / ((double)tsi.maxDuration / 20.0) * ((double)tsi.duration / 20.0));
                z = (int)Math.min(Math.floor(((double)tsi.duration + 19.0) / 20.0), (double)tsi.maxDuration / 20.0);
            } else {
                k = 0;
                z = 0;
            }
        }
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v + 5, k, 5);
        }
        String $$6 = "" + z;
        int $$7 = (scaledWidth - font.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(font, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(font, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(font, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(font, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(font, $$6, $$7, $$8, y, false);
    }

    public static void renderClashHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, float c) {
        int d = (int)(c * 183.0f);
        int e = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        context.m_280218_(StandIcons.JOJO_ICONS, x, e, 0, 20, 182, 5);
        if (d > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, e, 0, 25, d, 5);
        }
        int f = scaledWidth / 2 - 5;
        int g = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, f, g, 183, 20, 9, 9);
        LivingEntity clashOp = ((StandUser)client.f_91074_).roundabout$getStandPowers().getClashOp();
        if (clashOp != null) {
            int i = context.m_280182_();
            int j = 12;
            int k = i / 2 - 91;
            int l = j;
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, 0, 40, 182, 5);
            float q = ((StandUser)client.f_91074_).roundabout$getStandPowers().getClashOpProgress();
            int r = (int)(q * 183.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, 0, 45, r, 5);
            Component text = clashOp.m_7755_();
            int m = client.f_91062_.m_92852_((FormattedText)text);
            int n = i / 2 - m / 2;
            int o = l - 9;
            context.m_280430_(client.f_91062_, text, n, o, 0xFFFFFF);
            context.m_280218_(StandIcons.JOJO_ICONS, f, l + 5, 183, 20, 9, 9);
        }
    }
}

