/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.entity.visages.PlayerLikeModel;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.util.ConfigManager;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class HumanoidLikeArmorLayer<T extends JojoNPC, M extends PlayerLikeModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;
    private final TextureAtlas armorTrimAtlas;
    @Unique
    public int roundabout$ArmorPhase;
    @Unique
    public boolean roundabout$ModifyEntity;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderChest;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderLegs;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderBoots;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderHead;

    public HumanoidLikeArmorLayer(RenderLayerParent<T, M> $$0, A $$1, A $$2, ModelManager $$3) {
        super($$0);
        this.innerModel = $$1;
        this.outerModel = $$2;
        this.armorTrimAtlas = $$3.m_119428_(Sheets.f_265912_);
    }

    public void render(PoseStack $$0, MultiBufferSource $$1, int $$2, T $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        this.roundabout$ArmorPhase = 0;
        if (((JojoNPC)((Object)$$3)).host != null) {
            IPlayerEntity ipe = (IPlayerEntity)((JojoNPC)((Object)$$3)).host;
            if (ShapeShifts.getShiftFromByte(ipe.roundabout$getShapeShift()) == ShapeShifts.EERIE) {
                return;
            }
            boolean bl = this.roundabout$ModifyEntity = ((TimeStop)$$3.m_9236_()).CanTimeStopEntity((Entity)$$3) || ClientUtil.getScreenFreeze();
            if (this.roundabout$ModifyEntity) {
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderChest() == null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderChest($$3.m_6844_(EquipmentSlot.CHEST).m_41777_());
                }
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderLegs() == null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderLegs($$3.m_6844_(EquipmentSlot.LEGS).m_41777_());
                }
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderBoots() == null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderBoots($$3.m_6844_(EquipmentSlot.FEET).m_41777_());
                }
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderHead() == null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderHead($$3.m_6844_(EquipmentSlot.HEAD).m_41777_());
                }
                this.roundabout$RenderChest = ((IEntityAndData)$$3).roundabout$getRoundaboutRenderChest();
                this.roundabout$RenderLegs = ((IEntityAndData)$$3).roundabout$getRoundaboutRenderLegs();
                this.roundabout$RenderBoots = ((IEntityAndData)$$3).roundabout$getRoundaboutRenderBoots();
                this.roundabout$RenderHead = ((IEntityAndData)$$3).roundabout$getRoundaboutRenderHead();
            } else {
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderChest() != null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderChest(null);
                }
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderLegs() != null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderLegs(null);
                }
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderBoots() != null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderBoots(null);
                }
                if (((IEntityAndData)$$3).roundabout$getRoundaboutRenderHead() != null) {
                    ((IEntityAndData)$$3).roundabout$setRoundaboutRenderHead(null);
                }
            }
            if (!((IPlayerEntity)((JojoNPC)((Object)$$3)).host).roundabout$getMaskSlot().m_41619_() && ((IPlayerEntity)((JojoNPC)((Object)$$3)).host).roundabout$getMaskSlot().m_41720_() instanceof MaskItem) {
                return;
            }
        } else {
            this.roundabout$ModifyEntity = false;
        }
        if (ConfigManager.getClientConfig().renderArmorOnFogClones.booleanValue()) {
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.CHEST, $$2, this.getArmorModel(EquipmentSlot.CHEST));
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.LEGS, $$2, this.getArmorModel(EquipmentSlot.LEGS));
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.FEET, $$2, this.getArmorModel(EquipmentSlot.FEET));
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.HEAD, $$2, this.getArmorModel(EquipmentSlot.HEAD));
        }
    }

    private void renderArmorPiece(PoseStack $$0, MultiBufferSource $$1, T $$2, EquipmentSlot $$3, int $$4, A $$5) {
        ArmorItem $$7;
        ItemStack $$6 = this.store($$2.m_6844_($$3));
        Item item = $$6.m_41720_();
        if (item instanceof ArmorItem && ($$7 = (ArmorItem)item).m_40402_() == $$3) {
            ((PlayerLikeModel)this.m_117386_()).copyPropertiesTo2($$5);
            this.setPartVisibility($$5, $$3);
            boolean $$9 = this.usesInnerModel($$3);
            if ($$7 instanceof DyeableArmorItem) {
                DyeableArmorItem $$10 = (DyeableArmorItem)$$7;
                int $$11 = $$10.m_41121_($$6);
                float $$12 = (float)($$11 >> 16 & 0xFF) / 255.0f;
                float $$13 = (float)($$11 >> 8 & 0xFF) / 255.0f;
                float $$14 = (float)($$11 & 0xFF) / 255.0f;
                this.renderModel($$0, $$1, $$4, $$7, $$5, $$9, $$12, $$13, $$14, null);
                this.renderModel($$0, $$1, $$4, $$7, $$5, $$9, 1.0f, 1.0f, 1.0f, "overlay");
            } else {
                this.renderModel($$0, $$1, $$4, $$7, $$5, $$9, 1.0f, 1.0f, 1.0f, null);
            }
            ArmorTrim.m_266285_((RegistryAccess)$$2.m_9236_().m_9598_(), (ItemStack)$$6).ifPresent($$6x -> this.renderTrim($$7.m_40401_(), $$0, $$1, $$4, (ArmorTrim)$$6x, $$5, $$9));
            if ($$6.m_41790_()) {
                this.renderGlint($$0, $$1, $$4, $$5);
            }
        }
    }

    public ItemStack store(ItemStack stack) {
        if (this.roundabout$ModifyEntity) {
            ++this.roundabout$ArmorPhase;
            if (this.roundabout$ArmorPhase == 1) {
                if (this.roundabout$RenderChest != null) {
                    return this.roundabout$RenderChest;
                }
            } else if (this.roundabout$ArmorPhase == 2) {
                if (this.roundabout$RenderLegs != null) {
                    return this.roundabout$RenderLegs;
                }
            } else if (this.roundabout$ArmorPhase == 3) {
                if (this.roundabout$RenderBoots != null) {
                    return this.roundabout$RenderBoots;
                }
            } else if (this.roundabout$RenderHead != null) {
                return this.roundabout$RenderHead;
            }
            return stack;
        }
        return stack;
    }

    protected void setPartVisibility(A $$0, EquipmentSlot $$1) {
        $$0.m_8009_(false);
        switch ($$1) {
            case HEAD: {
                ((HumanoidModel)$$0).f_102808_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)$$0).f_102810_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102811_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)$$0).f_102810_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102813_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)$$0).f_102813_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack $$0, MultiBufferSource $$1, int $$2, ArmorItem $$3, A $$4, boolean $$5, float $$6, float $$7, float $$8, @javax.annotation.Nullable String $$9) {
        VertexConsumer $$10 = $$1.m_6299_(RenderType.m_110431_((ResourceLocation)this.getArmorLocation($$3, $$5, $$9)));
        $$4.m_7695_($$0, $$10, $$2, OverlayTexture.f_118083_, $$6, $$7, $$8, 1.0f);
    }

    private void renderTrim(ArmorMaterial $$0, PoseStack $$1, MultiBufferSource $$2, int $$3, ArmorTrim $$4, A $$5, boolean $$6) {
        TextureAtlasSprite $$7 = this.armorTrimAtlas.m_118316_($$6 ? $$4.m_267774_($$0) : $$4.m_267606_($$0));
        VertexConsumer $$8 = $$7.m_118381_($$2.m_6299_(Sheets.m_266442_()));
        $$5.m_7695_($$1, $$8, $$3, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(PoseStack $$0, MultiBufferSource $$1, int $$2, A $$3) {
        $$3.m_7695_($$0, $$1.m_6299_(RenderType.m_110484_()), $$2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private A getArmorModel(EquipmentSlot $$0) {
        return this.usesInnerModel($$0) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot $$0) {
        return $$0 == EquipmentSlot.LEGS;
    }

    private ResourceLocation getArmorLocation(ArmorItem $$0, boolean $$1, @javax.annotation.Nullable String $$2) {
        String $$3 = "textures/models/armor/" + $$0.m_40401_().m_6082_() + "_layer_" + ($$1 ? 2 : 1) + (String)($$2 == null ? "" : "_" + $$2) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent($$3, ResourceLocation::new);
    }
}

