/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.pathfinding;

import java.util.UUID;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.CrossfireHurricaneEntity;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.stand.PowersMagiciansRed;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GroundHurricaneEntity
extends PathfinderMob {
    int lifeSpan = 300;
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(GroundHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> USER_ID = SynchedEntityData.m_135353_(GroundHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity standUser;
    public UUID standUserUUID;
    public boolean fireStormCreated = false;

    public GroundHurricaneEntity(EntityType<? extends PathfinderMob> $$0, Level $$1) {
        super($$0, $$1);
    }

    public GroundHurricaneEntity(EntityType<? extends PathfinderMob> $$0, Level $$1, LivingEntity user) {
        super($$0, $$1);
        this.setUser(user);
    }

    public GroundHurricaneEntity(Level $$1, LivingEntity user) {
        super(ModEntities.GROUND_HURRICANE, $$1);
        this.setUser(user);
    }

    public static AttributeSupplier.Builder createStandAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void setSize(int idd) {
        this.m_20088_().m_135381_(SIZE, (Object)idd);
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(SIZE);
    }

    public void setUser(LivingEntity User) {
        this.standUser = User;
        this.m_20088_().m_135381_(USER_ID, (Object)User.m_19879_());
        if (!this.m_9236_().m_5776_()) {
            this.standUserUUID = User.m_20148_();
        }
    }

    public LivingEntity getUser() {
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            return LE;
        }
        return null;
    }

    public int getUserID() {
        return (Integer)this.m_20088_().m_135370_(USER_ID);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean isEffectivelyInWater() {
        return this.f_19798_;
    }

    protected void m_8099_() {
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)0);
        this.f_19804_.m_135372_(USER_ID, (Object)-1);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void burst(PowersMagiciansRed PMR) {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.CROSSFIRE_EXPLODE_EVENT, SoundSource.PLAYERS, 2.0f, 1.0f);
            if (this.fireStormCreated) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 250, 0.01, 0.01, 0.01, 0.15);
            } else {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 200, 0.01, 0.01, 0.01, 0.1);
            }
        }
    }

    public boolean m_7327_(Entity $$0) {
        StandPowers standPowers;
        LivingEntity user = this.getUser();
        if (user != null && (standPowers = ((StandUser)this.getUser()).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            this.burst(PMR);
            CrossfireHurricaneEntity.blastEntity($$0, (Entity)this, this.getSize(), user, true, PMR, this.fireStormCreated);
        }
        this.m_146870_();
        return true;
    }

    public void m_8119_() {
        StandPowers hurt;
        boolean client = this.m_9236_().m_5776_();
        LivingEntity $$0 = this.getUser();
        if (!client) {
            if (this.isEffectivelyInWater()) {
                this.m_146870_();
            }
            if ($$0 != null) {
                if (MainUtil.cheapDistanceTo2(this.m_20185_(), this.m_20189_(), this.standUser.m_20185_(), this.standUser.m_20189_()) > 80.0 || !this.getUser().m_6084_() || this.getUser().m_213877_()) {
                    this.m_146870_();
                } else {
                    StandPowers ent = null;
                    hurt = $$0.m_21214_();
                    LivingEntity hurtBy = $$0.m_21188_();
                    if (hurt != null && !hurt.m_213877_() && hurt.m_6084_()) {
                        ent = hurt;
                    } else if (hurtBy != null && !hurtBy.m_213877_() && hurtBy.m_6084_()) {
                        ent = hurtBy;
                    }
                    this.m_6710_((LivingEntity)ent);
                    if (this.lifeSpan > 0) {
                        --this.lifeSpan;
                    } else {
                        this.m_146870_();
                    }
                }
            } else {
                this.m_146870_();
            }
        }
        super.m_8119_();
        if (!client && this.f_19797_ % 2 == 0 && $$0 != null && (hurt = ((StandUser)$$0).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)hurt;
            Vec3 $$2 = this.m_20184_();
            double $$3 = this.m_20185_() + $$2.f_82479_;
            double $$4 = this.m_20186_() + $$2.f_82480_;
            double $$5 = this.m_20189_() + $$2.f_82481_;
            float xrand = (float)(Math.random() * 1.0 - 0.5);
            float zrand = (float)(Math.random() * 1.0 - 0.5);
            this.m_9236_().m_7106_((ParticleOptions)PMR.getFlameParticle(), $$3, $$4 + 0.5, $$5, 0.0, 0.0, 0.0);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), $$3, $$4 + 0.1, $$5, 0, (double)xrand, 0.5, (double)zrand, 0.1);
        }
    }
}

