/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.hydra.jojomod.access.IPermaCasting;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.UnburnableProjectile;
import net.hydra.jojomod.entity.client.PreRenderEntity;
import net.hydra.jojomod.entity.stand.MagiciansRedEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.event.powers.stand.PowersMagiciansRed;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.ConfigManager;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CrossfireHurricaneEntity
extends AbstractHurtingProjectile
implements PreRenderEntity,
UnburnableProjectile {
    private static final EntityDataAccessor<Integer> USER_ID = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CROSS_NUMBER = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_SIZE = SynchedEntityData.m_135353_(CrossfireHurricaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity standUser;
    public UUID standUserUUID;
    public boolean fireStormCreated = false;
    public double renderRotation = 0.0;
    public double lastRenderRotation = 0.0;
    public Vec3 storeVec;
    public boolean initialized = false;
    public float renderSize = 0.0f;
    public float lastRenderSize = 0.0f;
    public boolean isBundle = false;
    public boolean isTickable = false;
    public int saneAgeTicking;

    public CrossfireHurricaneEntity(EntityType<? extends CrossfireHurricaneEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected CrossfireHurricaneEntity(EntityType<? extends CrossfireHurricaneEntity> $$0, double $$1, double $$2, double $$3, Level $$4) {
        this($$0, $$4);
        this.m_6034_($$1, $$2, $$3);
    }

    public CrossfireHurricaneEntity(LivingEntity $$1, Level $$2) {
        this(ModEntities.CROSSFIRE_HURRICANE, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public int getUserID() {
        return (Integer)this.m_20088_().m_135370_(USER_ID);
    }

    public void setUserID(int idd) {
        this.m_20088_().m_135381_(USER_ID, (Object)idd);
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE;
            this.standUser = LE = (LivingEntity)entity;
            if (!this.m_9236_().m_5776_()) {
                this.standUserUUID = LE.m_20148_();
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean isEffectivelyInWater() {
        return this.f_19798_;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    public boolean m_6109_() {
        return super.m_6109_();
    }

    public boolean m_6087_() {
        return false;
    }

    public void setOldPosAndRot2() {
        if (this.storeVec != null) {
            double $$0 = this.storeVec.m_7096_();
            double $$1 = this.storeVec.m_7098_();
            double $$2 = this.storeVec.m_7094_();
            this.f_19854_ = $$0;
            this.f_19855_ = $$1;
            this.f_19856_ = $$2;
            this.f_19790_ = $$0;
            this.f_19791_ = $$1;
            this.f_19792_ = $$2;
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void setRenderRotation(double rotation) {
        this.lastRenderRotation = this.renderRotation;
        this.renderRotation = rotation;
    }

    public void setUser(LivingEntity User) {
        this.standUser = User;
        this.m_20088_().m_135381_(USER_ID, (Object)User.m_19879_());
        if (!this.m_9236_().m_5776_()) {
            this.standUserUUID = User.m_20148_();
        }
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(SIZE);
    }

    public void setSize(int idd) {
        this.m_20088_().m_135381_(SIZE, (Object)idd);
    }

    public int getMaxSize() {
        return (Integer)this.m_20088_().m_135370_(MAX_SIZE);
    }

    public void setMaxSize(int idd) {
        this.m_20088_().m_135381_(MAX_SIZE, (Object)idd);
    }

    public float getRenderSize() {
        return this.renderSize;
    }

    public void setRenderSize(float renderSize) {
        this.renderSize = renderSize;
    }

    public float getLastRenderSize() {
        return this.lastRenderSize;
    }

    public void setLastRenderSize(float renderSize) {
        this.lastRenderSize = renderSize;
    }

    public int getCrossNumber() {
        return (Integer)this.m_20088_().m_135370_(CROSS_NUMBER);
    }

    public void setCrossNumber(int idd) {
        this.m_20088_().m_135381_(CROSS_NUMBER, (Object)idd);
    }

    protected CrossfireHurricaneEntity(EntityType<? extends CrossfireHurricaneEntity> $$0, LivingEntity $$1, Level $$2) {
        this($$0, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public void actuallyTick() {
        this.isTickable = true;
        this.m_8119_();
        this.isTickable = false;
    }

    public void m_142687_(Entity.RemovalReason $$0) {
        StandPowers standPowers;
        LivingEntity le;
        int crossnum = this.getCrossNumber();
        if (crossnum == 7 && !this.m_9236_().m_5776_() && (le = this.getStandUser()) != null && (standPowers = ((StandUser)this.getStandUser()).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            PMR.sealFromKamikaze();
            StandEntity stand = ((StandUser)le).roundabout$getStand();
            if (stand != null) {
                stand.m_146870_();
            }
        }
        super.m_142687_($$0);
    }

    public void m_8119_() {
        StandPowers lv2;
        StandEntity stand;
        PowersMagiciansRed PMR;
        LivingEntity le;
        boolean client = this.m_9236_().m_5776_();
        if (!client) {
            if (this.isEffectivelyInWater()) {
                this.m_146870_();
            }
            if (this.getStandUser() != null) {
                if (MainUtil.cheapDistanceTo2(this.m_20185_(), this.m_20189_(), this.standUser.m_20185_(), this.standUser.m_20189_()) > 80.0 || !this.getStandUser().m_6084_() || this.getStandUser().m_213877_()) {
                    this.m_146870_();
                }
            } else {
                this.m_146870_();
            }
        }
        if ((le = this.getStandUser()) != null) {
            StandPowers standPowers = ((StandUser)this.getStandUser()).roundabout$getStandPowers();
            if (standPowers instanceof PowersMagiciansRed) {
                PMR = (PowersMagiciansRed)standPowers;
                int crossnum = this.getCrossNumber();
                if (crossnum > 0 && crossnum < 6) {
                    this.m_20256_(Vec3.f_82478_);
                    if (client && !this.initialized) {
                        if (crossnum < 5) {
                            this.initialized = true;
                            PMR.addHurricaneSpecial(this);
                        } else {
                            PMR.hurricane = this;
                        }
                    }
                    if (!this.isTickable && this.getCrossNumber() < 6) {
                        return;
                    }
                } else if (crossnum == 6) {
                    IPermaCasting icast = (IPermaCasting)le.m_9236_();
                    if (!icast.roundabout$isPermaCastingEntity(le)) {
                        this.m_146870_();
                        return;
                    }
                    if (!client) {
                        if (this.getSize() < this.getMaxSize()) {
                            this.m_20334_(0.0, 0.2, 0.0);
                        } else {
                            this.m_20334_(0.0, 0.0, 0.0);
                        }
                    }
                } else if (crossnum == 7 && (stand = ((StandUser)le).roundabout$getStand()) == null) {
                    this.m_146870_();
                    return;
                }
            } else if (!client) {
                this.m_146870_();
                return;
            }
        }
        if (client && this.saneAgeTicking != this.f_19797_) {
            StandPowers standPowers;
            LivingEntity lv2;
            int ticks;
            this.lastRenderSize = this.lastRenderSize < (float)this.getMaxSize() ? (this.lastRenderSize += (float)this.getAccrualRate()) : (float)this.getMaxSize();
            if (!ClientUtil.checkIfGamePaused() && (ticks = ConfigManager.getClientConfig().particleSettings.cfhTicksPerFlameParticle.intValue()) > -1 && this.f_19797_ % ticks == 0 && (lv2 = this.getUser()) != null && (standPowers = ((StandUser)lv2).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                PowersMagiciansRed MR = (PowersMagiciansRed)standPowers;
                this.m_9236_().m_7106_((ParticleOptions)MR.getFlameParticle(), this.m_20208_(0.26), this.getRandomY(0.26) + (double)this.m_20206_() * 0.55, this.m_20262_(0.26), 0.0, 0.0, 0.0);
            }
        }
        this.saneAgeTicking = this.f_19797_;
        super.m_8119_();
        if (!client && this.isEffectivelyInWater()) {
            this.m_146870_();
            return;
        }
        if (le != null && (lv2 = ((StandUser)this.getStandUser()).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PMR = (PowersMagiciansRed)lv2;
            int crossnum = this.getCrossNumber();
            if (crossnum == 7) {
                stand = ((StandUser)le).roundabout$getStand();
                if (stand == null) {
                    this.m_146870_();
                    return;
                }
                stand.m_20248_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                stand.m_146926_(this.m_146909_());
            }
        }
    }

    public LivingEntity getUser() {
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            return LE;
        }
        return null;
    }

    public double getRandomY(double $$0) {
        return this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * $$0);
    }

    protected void m_8060_(BlockHitResult $$0) {
        int crossno = this.getCrossNumber();
        if (crossno <= 0 || crossno == 7) {
            this.radialExplosion(null);
            if (!this.m_9236_().m_5776_()) {
                StandPowers standPowers;
                LivingEntity user = this.getStandUser();
                int size = this.getSize();
                if (user != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                    PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
                    BlockPos pos = $$0.m_82425_().m_121945_($$0.m_82434_());
                    PMR.createStandFire2(pos);
                    if (size >= PowersMagiciansRed.getChargingCrossfireSize()) {
                        PMR.createStandFire2(pos.m_122024_().m_122024_());
                        PMR.createStandFire2(pos.m_122024_().m_122012_());
                        PMR.createStandFire2(pos.m_122024_().m_122019_());
                        PMR.createStandFire2(pos.m_122029_().m_122029_());
                        PMR.createStandFire2(pos.m_122029_().m_122012_());
                        PMR.createStandFire2(pos.m_122029_().m_122019_());
                        PMR.createStandFire2(pos.m_122012_().m_122012_());
                        PMR.createStandFire2(pos.m_122019_().m_122019_());
                        PMR.createStandFire2(pos.m_7494_().m_7494_());
                        PMR.createStandFire2(pos.m_7495_().m_7495_());
                        PMR.createStandFire2(pos.m_122024_().m_7494_());
                        PMR.createStandFire2(pos.m_122012_().m_7494_());
                        PMR.createStandFire2(pos.m_122019_().m_7494_());
                        PMR.createStandFire2(pos.m_122029_().m_7494_());
                        PMR.createStandFire2(pos.m_122024_().m_7495_());
                        PMR.createStandFire2(pos.m_122012_().m_7495_());
                        PMR.createStandFire2(pos.m_122019_().m_7495_());
                        PMR.createStandFire2(pos.m_122029_().m_7495_());
                    }
                    if (size >= PowersMagiciansRed.getChargingCrossfireSpecialSize()) {
                        PMR.createStandFire2(pos.m_122024_());
                        PMR.createStandFire2(pos.m_122012_());
                        PMR.createStandFire2(pos.m_122019_());
                        PMR.createStandFire2(pos.m_122029_());
                        PMR.createStandFire2(pos.m_7494_());
                        PMR.createStandFire2(pos.m_7495_());
                    }
                }
            }
            this.m_146870_();
        }
    }

    public void shootFromRotationDeltaAgnostic(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.m_6686_($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
    }

    protected void m_5790_(EntityHitResult $$0) {
        int crossno = this.getCrossNumber();
        if (crossno <= 0 || crossno == 7) {
            Entity $$1 = $$0.m_82443_();
            if (this.getUserID() != $$1.m_19879_() && !($$1 instanceof MagiciansRedEntity)) {
                if ($$1 instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)$$1;
                    this.radialExplosion(LE);
                } else {
                    this.radialExplosion(null);
                }
                this.m_146870_();
            }
        }
    }

    public void radialExplosion(LivingEntity mainTarget) {
        StandPowers standPowers;
        LivingEntity user;
        if (!this.m_9236_().m_5776_() && (user = this.getStandUser()) != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            List<Entity> entityList;
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.CROSSFIRE_EXPLODE_EVENT, SoundSource.PLAYERS, 2.0f, 1.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 200, 0.01, 0.01, 0.01, 0.1);
            if (mainTarget != null) {
                this.getEntity((Entity)mainTarget, true, PMR);
            }
            if (!(entityList = DamageHandler.genHitbox(user, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0, 2.0, 2.0)).isEmpty()) {
                for (Entity value : entityList) {
                    if (mainTarget != null && value.m_7306_((Entity)mainTarget) || !value.m_6087_()) continue;
                    this.getEntity(value, false, PMR);
                }
            }
        }
    }

    public static void blastEntity(Entity gotten, Entity proj, int size, LivingEntity user, boolean direct, PowersMagiciansRed PMR, boolean fireStorm) {
        LivingEntity LE;
        float dmg = 1.0f;
        float strength = 0.85f;
        if (direct) {
            dmg = PMR.getHurricaneDirectDamage(gotten, size, fireStorm);
            strength *= 2.0f;
        } else {
            dmg = PMR.getHurricaneDamage(gotten, size, fireStorm);
        }
        if (gotten.m_6469_(ModDamageTypes.of(gotten.m_9236_(), ModDamageTypes.CROSSFIRE, (Entity)user), dmg)) {
            float degrees = MainUtil.getLookAtEntityYaw(proj, gotten);
            MainUtil.takeUnresistableKnockbackWithY(gotten, strength, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
            if (gotten instanceof LivingEntity) {
                LivingEntity LE2 = (LivingEntity)gotten;
                StandUser userLE = (StandUser)LE2;
                int ticks = 21;
                ticks += size * 3;
                if (userLE.roundabout$getRemainingFireTicks() > -1) {
                    ticks += userLE.roundabout$getRemainingFireTicks();
                }
                userLE.roundabout$setOnStandFire(PMR.getFireColor(), user);
                userLE.roundabout$setRemainingStandFireTicks(ticks);
            }
        } else if (gotten instanceof LivingEntity && (LE = (LivingEntity)gotten).m_21254_()) {
            int breakShield = 0;
            if (size >= PowersMagiciansRed.getChargingCrossfireSize()) {
                breakShield = 10 + size * 2;
            } else if (size >= PowersMagiciansRed.getChargingCrossfireSpecialSize()) {
                breakShield = (int)(10.0 + (double)size * 0.5);
            }
            if (breakShield > 0) {
                MainUtil.knockShieldPlusStand((Entity)LE, breakShield);
            }
        }
    }

    public void getEntity(Entity gotten, boolean direct, PowersMagiciansRed PMR) {
        if (gotten != null && gotten.m_19879_() != this.getUserID()) {
            int size = this.getSize();
            CrossfireHurricaneEntity.blastEntity(gotten, (Entity)this, size, this.standUser, direct, PMR, this.fireStormCreated);
        }
    }

    protected ParticleOptions m_5967_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50016_.m_49966_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USER_ID, (Object)-1);
        this.f_19804_.m_135372_(SIZE, (Object)0);
        this.f_19804_.m_135372_(CROSS_NUMBER, (Object)0);
        this.f_19804_.m_135372_(MAX_SIZE, (Object)0);
    }

    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
    }

    public LivingEntity getStandUser() {
        if (this.standUser != null) {
            return this.standUser;
        }
        if (this.standUserUUID != null && !this.m_9236_().m_5776_()) {
            Entity ett = ((ServerLevel)this.m_9236_()).m_8791_(this.standUserUUID);
            if (ett instanceof LivingEntity) {
                LivingEntity lett;
                this.standUser = lett = (LivingEntity)ett;
                this.setUserID(lett.m_19879_());
            }
        } else {
            Entity entity = this.m_9236_().m_6815_(this.getUserID());
            if (entity instanceof LivingEntity) {
                LivingEntity LE;
                this.standUser = LE = (LivingEntity)entity;
            }
        }
        return this.standUser;
    }

    public int getAccrualRate() {
        if (this.getCrossNumber() == 6) {
            return 10;
        }
        return 1;
    }

    @Override
    public boolean preRender(Entity ent, double $$1, double $$2, double $$3, float $$4, PoseStack pose, MultiBufferSource $$6) {
        if (ent instanceof CrossfireHurricaneEntity) {
            StandPowers standPowers;
            LivingEntity user;
            CrossfireHurricaneEntity cfhe = (CrossfireHurricaneEntity)ent;
            if (((TimeStop)ent.m_9236_()).inTimeStopRange(ent)) {
                $$4 = 0.0f;
            }
            if ((user = cfhe.getStandUser()) != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
                if (cfhe.getCrossNumber() > 0) {
                    if (cfhe.getCrossNumber() < 5) {
                        ArrayList<CrossfireHurricaneEntity> hurricaneSpecial2;
                        if (PMR.hurricaneSpecial == null) {
                            PMR.hurricaneSpecial = new ArrayList<CrossfireHurricaneEntity>();
                        }
                        if (!(hurricaneSpecial2 = new ArrayList<CrossfireHurricaneEntity>(PMR.hurricaneSpecial){}).isEmpty()) {
                            PMR.spinint = PMR.lastSpinInt + (double)$$4 * PMR.maxSpinint;
                            int totalnumber = hurricaneSpecial2.size();
                            double lerpX = user.m_20185_() * (double)$$4 + user.f_19790_ * (double)(1.0f - $$4);
                            double lerpY = user.m_20186_() * (double)$$4 + user.f_19791_ * (double)(1.0f - $$4);
                            double lerpZ = user.m_20189_() * (double)$$4 + user.f_19792_ * (double)(1.0f - $$4);
                            PMR.transformHurricane(cfhe, totalnumber, lerpX, lerpY, lerpZ, this.getRenderSize());
                        }
                    } else if (cfhe.getCrossNumber() == 5) {
                        double lerpX = user.m_20185_() * (double)$$4 + user.f_19790_ * (double)(1.0f - $$4);
                        double lerpY = user.m_20186_() * (double)$$4 + user.f_19791_ * (double)(1.0f - $$4);
                        double lerpZ = user.m_20189_() * (double)$$4 + user.f_19792_ * (double)(1.0f - $$4);
                        PMR.transformHurricane(cfhe, 1, lerpX, lerpY, lerpZ, this.getRenderSize());
                    } else if (cfhe.getCrossNumber() == 6) {
                        PMR.transformGiantHurricane(cfhe);
                    }
                }
            }
        }
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }
}

