/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import javax.annotation.Nullable;
import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class HarpoonEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(HarpoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(HarpoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack harpoonItem = new ItemStack((ItemLike)ModItems.HARPOON);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;
    public boolean skyHit = false;

    public HarpoonEntity(EntityType<? extends HarpoonEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    public HarpoonEntity(Level $$0, LivingEntity $$1, ItemStack $$2) {
        super(ModEntities.THROWN_HARPOON, $$1, $$0);
        this.harpoonItem = $$2.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)$$2)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)$$2.m_41790_());
    }

    public HarpoonEntity(Level $$0, LivingEntity $$1, ItemStack $$2, double p_36862_, double p_36863_, double p_36864_) {
        super(ModEntities.THROWN_HARPOON, p_36862_, p_36863_, p_36864_, $$0);
        this.harpoonItem = $$2.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)$$2)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)$$2.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        LivingEntity targetMob;
        if (!(this.m_9236_().f_46443_ || (targetMob = MainUtil.homeOnFlier(this.m_9236_(), this.m_20182_(), 13.0, this.m_19749_())) == null || this.m_19749_() != null && this.m_19749_().m_20148_() == targetMob.m_20148_() || this.m_36797_())) {
            double ln = targetMob.m_20184_().m_82542_((double)1.2f, (double)1.2f, (double)1.2f).m_82553_();
            if (this.m_20184_().m_82553_() > ln) {
                ln = this.m_20184_().m_82542_((double)1.2f, (double)1.2f, (double)1.2f).m_82553_();
            }
            this.m_20256_(targetMob.m_20182_().m_82520_(0.0, (double)targetMob.m_20192_(), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_(ln));
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity $$0 = this.m_19749_();
        int $$1 = 2;
        if ($$1 > 0 && (this.dealtDamage || this.m_36797_()) && $$0 != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 $$2 = $$0.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + $$2.f_82480_ * 0.015 * (double)$$1, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double $$3 = 0.05 * (double)$$1;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_($$2.m_82541_().m_82490_($$3)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(ModSounds.HARPOON_RETURN_EVENT, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity $$0 = this.m_19749_();
        return $$0 == null || !$$0.m_6084_() ? false : !($$0 instanceof ServerPlayer) || !$$0.m_5833_();
    }

    protected ItemStack m_7941_() {
        return this.harpoonItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 $$0, Vec3 $$1) {
        return this.dealtDamage ? null : super.m_6351_($$0, $$1);
    }

    protected void m_8060_(BlockHitResult $$0) {
        ((IAbstractArrowAccess)((Object)this)).roundabout$setLastState(this.m_9236_().m_8055_($$0.m_82425_()));
        BlockState BSS = this.m_9236_().m_8055_($$0.m_82425_());
        BSS.m_60669_(this.m_9236_(), BSS, $$0, (Projectile)this);
        Vec3 $$1 = $$0.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_($$1);
        Vec3 $$2 = $$1.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - $$2.f_82479_, this.m_20186_() - $$2.f_82480_, this.m_20189_() - $$2.f_82481_);
        this.m_5496_(ModSounds.HARPOON_GROUND_EVENT, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36740_(SoundEvents.f_11685_);
        this.m_36793_(false);
        ((IAbstractArrowAccess)((Object)this)).roundabout$resetPiercedEntities();
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity $$1 = $$0.m_82443_();
        float $$2 = 6.0f;
        if ($$1 instanceof LivingEntity) {
            LivingEntity $$3 = (LivingEntity)$$1;
            int f = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44969_, (LivingEntity)$$3);
            $$2 = (float)((double)$$2 * (1.0 - (double)f * 0.03));
            $$2 += EnchantmentHelper.m_44833_((ItemStack)this.harpoonItem, (MobType)$$3.m_6336_());
        }
        Entity $$4 = this.m_19749_();
        DamageSource $$5 = ModDamageTypes.of(this.m_9236_(), ModDamageTypes.HARPOON, (Entity)this, (Entity)($$4 == null ? this : $$4));
        this.dealtDamage = true;
        this.skyHit = false;
        if ($$1.m_6469_($$5, $$2 = this.addSkyDamage($$1, $$2))) {
            if ($$1.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)$$1;
                if ($$4 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)$$7, (Entity)$$4);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)$$4), (Entity)$$7);
                }
                this.m_7761_($$7);
            }
        }
        ((IAbstractArrowAccess)((Object)this)).roundabout$cancelSuperThrow();
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float $$8 = 1.0f;
        if (this.skyHit) {
            this.m_5496_(ModSounds.HARPOON_CRIT_EVENT, $$8, 1.0f);
        } else {
            this.m_5496_(ModSounds.HARPOON_HIT_EVENT, $$8, 1.0f);
        }
    }

    public float addSkyDamage(Entity target, float damage) {
        if (target instanceof Player) {
            int airTime;
            if (((Player)target).m_21255_()) {
                this.skyHit = true;
                damage += 10.0f;
            }
            if ((airTime = ((IPlayerEntity)target).roundabout$getAirTime()) > 0) {
                damage += Math.min(12.0f, (float)airTime / 10.0f);
                this.skyHit = true;
            }
        } else if (target instanceof Phantom || target instanceof Bat) {
            this.skyHit = true;
            damage += 10.0f;
        }
        if (!(target.m_20096_() || target.m_20069_() || target.m_6069_() || target.m_20159_())) {
            damage += 4.0f;
            this.skyHit = true;
        }
        return damage;
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.harpoonItem);
    }

    protected boolean m_142470_(Player $$0) {
        return super.m_142470_($$0) || this.m_36797_() && this.m_150171_((Entity)$$0) && $$0.m_150109_().m_36054_(this.m_7941_());
    }

    public void m_6123_(Player $$0) {
        if (this.m_150171_((Entity)$$0) || this.m_19749_() == null) {
            super.m_6123_($$0);
        }
    }

    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
        if ($$0.m_128425_("Harpoon", 10)) {
            this.harpoonItem = ItemStack.m_41712_((CompoundTag)$$0.m_128469_("Harpoon"));
        }
        this.dealtDamage = $$0.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.harpoonItem)));
    }

    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
        if (!this.harpoonItem.m_41619_()) {
            $$0.m_128365_("Harpoon", (Tag)this.harpoonItem.m_41739_(new CompoundTag()));
        }
        $$0.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        int $$0 = 1;
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || $$0 <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double $$0, double $$1, double $$2) {
        return true;
    }
}

