/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SethanRenderer {
    public static ResourceLocation SETHAN_TEXTURE = new ResourceLocation("roundabout:textures/stand/sethan.png");
    private static final RenderType SHADOW_RENDER_TYPE = RenderType.m_110485_((ResourceLocation)SETHAN_TEXTURE);

    public static void renderEntity(EntityRenderDispatcher entityRenderDispatcher, Entity castingEntity, double x, double y, double z, float delta, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        double deltaX = Mth.m_14139_((double)delta, (double)castingEntity.f_19790_, (double)castingEntity.m_20185_());
        double deltaY = Mth.m_14139_((double)delta, (double)castingEntity.f_19791_, (double)castingEntity.m_20186_());
        double deltaZ = Mth.m_14139_((double)delta, (double)castingEntity.f_19792_, (double)castingEntity.m_20189_());
        float yRotation = Mth.m_14179_((float)delta, (float)castingEntity.f_19859_, (float)castingEntity.m_146908_());
        SethanRenderer.render(entityRenderDispatcher, castingEntity, deltaX - x, deltaY - y, deltaZ - z, yRotation, delta, poseStack, multiBufferSource, entityRenderDispatcher.m_114394_(castingEntity, delta));
    }

    public static <E extends Entity> void render(EntityRenderDispatcher entityRenderDispatcher, E castingEntity, double deltaX, double deltaY, double deltaZ, float yRotation, float delta, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightCoords) {
        EntityRenderer entityrenderer = entityRenderDispatcher.m_114382_(castingEntity);
        Vec3 vec3 = entityrenderer.m_7860_(castingEntity, delta);
        double deltaXOffset = deltaX + vec3.m_7096_();
        double deltaYOffset = deltaY + vec3.m_7098_();
        double deltaZOffset = deltaZ + vec3.m_7094_();
        poseStack.m_85836_();
        poseStack.m_85837_(deltaXOffset, deltaYOffset, deltaZOffset);
        poseStack.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
        float shadowStrength = 5.0f;
        float scale = 3.0f;
        float alpha = 1.0f;
        SethanRenderer.renderSethan(poseStack, multiBufferSource, castingEntity, shadowStrength, delta, (LevelReader)castingEntity.m_9236_(), scale, alpha);
        poseStack.m_85849_();
    }

    private static void renderSethan(PoseStack poseStack, MultiBufferSource multiBufferSource, Entity castingEntity, float shadowStrength, float delta, LevelReader levelReader, float scale, float alpha) {
        Mob mobentity;
        float f = scale;
        if (castingEntity instanceof Mob && (mobentity = (Mob)castingEntity).m_6162_()) {
            f = scale * 0.5f;
        }
        double deltaX = Mth.m_14139_((double)delta, (double)castingEntity.f_19790_, (double)castingEntity.m_20185_());
        double deltaY = Mth.m_14139_((double)delta, (double)castingEntity.f_19791_, (double)castingEntity.m_20186_());
        double deltaZ = Mth.m_14139_((double)delta, (double)castingEntity.f_19792_, (double)castingEntity.m_20189_());
        int i = Mth.m_14107_((double)(deltaX - (double)f));
        int j = Mth.m_14107_((double)(deltaX + (double)f));
        int distanceRenderedDown = Mth.m_14107_((double)(deltaY - 100.0));
        int l = Mth.m_14107_((double)deltaY);
        int i1 = Mth.m_14107_((double)(deltaZ - (double)f));
        int j1 = Mth.m_14107_((double)(deltaZ + (double)f));
        PoseStack.Pose matrixstack$entry = poseStack.m_85850_();
        VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(SHADOW_RENDER_TYPE);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(i, distanceRenderedDown, i1), (BlockPos)new BlockPos(j, l + 1, j1))) {
            SethanRenderer.renderBlockShadow(matrixstack$entry, ivertexbuilder, levelReader, blockpos, deltaX, deltaY, deltaZ, f, scale, alpha);
        }
    }

    private static void renderBlood(PoseStack poseStack, MultiBufferSource multiBufferSource, Entity castingEntity, float shadowStrength, float delta, LevelReader levelReader, float scale, float alpha) {
        Mob mobentity;
        float f = scale;
        if (castingEntity instanceof Mob && (mobentity = (Mob)castingEntity).m_6162_()) {
            f = scale * 0.5f;
        }
        double deltaX = Mth.m_14139_((double)delta, (double)castingEntity.f_19790_, (double)castingEntity.m_20185_());
        double deltaY = Mth.m_14139_((double)delta, (double)castingEntity.f_19791_, (double)castingEntity.m_20186_());
        double deltaZ = Mth.m_14139_((double)delta, (double)castingEntity.f_19792_, (double)castingEntity.m_20189_());
        int i = Mth.m_14107_((double)(deltaX - (double)f));
        int j = Mth.m_14107_((double)(deltaX + (double)f));
        int distanceRenderedDown = Mth.m_14107_((double)(deltaY - 100.0));
        int l = Mth.m_14107_((double)deltaY);
        int i1 = Mth.m_14107_((double)(deltaZ - (double)f));
        int j1 = Mth.m_14107_((double)(deltaZ + (double)f));
        PoseStack.Pose matrixstack$entry = poseStack.m_85850_();
        VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(SHADOW_RENDER_TYPE);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(i, distanceRenderedDown, i1), (BlockPos)new BlockPos(j, l + 1, j1))) {
            SethanRenderer.renderBlockShadow(matrixstack$entry, ivertexbuilder, levelReader, blockpos, deltaX, deltaY, deltaZ, f, scale, alpha);
        }
    }

    private static void renderBlockShadow(PoseStack.Pose pose, VertexConsumer textureCoords, LevelReader levelReader, BlockPos blockPos, double deltaX, double deltaY, double deltaZ, float moddedScale, float scale, float alpha) {
        float f;
        VoxelShape voxelshape;
        BlockPos blockpos = blockPos.m_7495_();
        BlockState blockstate = levelReader.m_8055_(blockpos);
        if (blockstate.m_60838_((BlockGetter)levelReader, blockpos) && !(voxelshape = blockstate.m_60808_((BlockGetter)levelReader, new BlockPos(blockPos.m_123341_(), blockPos.m_123342_() - 200, blockPos.m_123343_()))).m_83281_() && (f = alpha) >= 0.0f) {
            if (f > 1.0f) {
                f = 1.0f;
            }
            AABB axisalignedbb = voxelshape.m_83215_();
            double minX = (double)blockPos.m_123341_() + axisalignedbb.f_82288_;
            double maxX = (double)blockPos.m_123341_() + axisalignedbb.f_82291_;
            double minY = (double)blockPos.m_123342_() + axisalignedbb.f_82289_;
            double minZ = (double)blockPos.m_123343_() + axisalignedbb.f_82290_;
            double maxZ = (double)blockPos.m_123343_() + axisalignedbb.f_82293_;
            float f1 = (float)(minX - deltaX);
            float f2 = (float)(maxX - deltaX);
            float f3 = (float)(minY - deltaY);
            float f4 = (float)(minZ - deltaZ);
            float f5 = (float)(maxZ - deltaZ);
            float f6 = -f1 / 2.0f / moddedScale + 0.5f;
            float f7 = -f2 / 2.0f / moddedScale + 0.5f;
            float f8 = -f4 / 2.0f / moddedScale + 0.5f;
            float f9 = -f5 / 2.0f / moddedScale + 0.5f;
            SethanRenderer.shadowVertex(pose, textureCoords, f, f1, f3, f4, f6, f8);
            SethanRenderer.shadowVertex(pose, textureCoords, f, f1, f3, f5, f6, f9);
            SethanRenderer.shadowVertex(pose, textureCoords, f, f2, f3, f5, f7, f9);
            SethanRenderer.shadowVertex(pose, textureCoords, f, f2, f3, f4, f7, f8);
        }
    }

    private static void shadowVertex(PoseStack.Pose p_229091_0_, VertexConsumer p_229091_1_, float p_229091_2_, float p_229091_3_, float p_229091_4_, float p_229091_5_, float p_229091_6_, float p_229091_7_) {
        p_229091_1_.m_252986_(p_229091_0_.m_252922_(), p_229091_3_, p_229091_4_, p_229091_5_).m_85950_(1.0f, 1.0f, 1.0f, p_229091_2_).m_7421_(p_229091_6_, p_229091_7_).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(p_229091_0_.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

