/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.powers.stand.presets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.stand.presets.DashPreset;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PunchingStand
extends DashPreset {
    public boolean consumeClickInput = false;
    public boolean wentForCharge = false;

    public PunchingStand(LivingEntity self) {
        super(self);
    }

    @Override
    public boolean canSummonStand() {
        return true;
    }

    @Override
    public boolean interceptAttack() {
        return true;
    }

    @Override
    public boolean interceptGuard() {
        return true;
    }

    @Override
    public boolean isMiningStand() {
        return true;
    }

    public SoundEvent getLastRejectionHitSound() {
        return null;
    }

    public boolean canGuard() {
        return !this.isBarraging() && !this.isClashing();
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        if (!this.isGuarding() && this.canGuard()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(3, true);
            ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)3);
            return true;
        }
        return false;
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (attackTarget != null && attackTarget.m_6084_()) {
            Entity targetEntity;
            if (this.getActivePower() == 1 || this.getActivePower() == 5 || attackTarget.m_20270_((Entity)this.getSelf()) <= 5.0f) {
                this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                this.getSelf().m_146922_(yrot);
                this.getSelf().m_5616_(yrot);
            }
            if ((targetEntity = this.getTargetEntity(this.self, -1.0f)) != null && targetEntity.m_7306_((Entity)attackTarget) && this.attackTimeDuring <= -1) {
                double RNG = Math.random();
                if (RNG < 0.35 && targetEntity instanceof Player && this.activePowerPhase <= 0 && !this.wentForCharge) {
                    this.wentForCharge = true;
                    ((StandUser)this.getSelf()).roundabout$tryPower(4, true);
                } else {
                    Objects.requireNonNull(this);
                    if (this.activePowerPhase < 3 || this.attackTime >= this.attackTimeMax) {
                        this.wentForCharge = false;
                        ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                    }
                }
            }
        }
    }

    @Override
    public boolean setPowerAttack() {
        if (this.activePowerPhase >= 3) {
            this.activePowerPhase = 1;
        } else {
            this.activePowerPhase = (byte)(this.activePowerPhase + 1);
            this.attackTimeMax = this.activePowerPhase == 3 ? ClientNetworking.getAppropriateConfig().cooldownsInTicks.finalStandPunchInString.intValue() : ClientNetworking.getAppropriateConfig().cooldownsInTicks.standPunch.intValue();
        }
        this.attackTimeDuring = 0;
        this.setActivePower((byte)1);
        this.setAttackTime(0);
        this.animateStand(this.activePowerPhase);
        this.poseStand((byte)1);
        return true;
    }

    @Override
    public void updateAttack() {
        if (this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else if (this.attackTimeDuring == 5 && this.activePowerPhase == 1 || this.attackTimeDuring == 6) {
                this.standPunch();
            }
        }
    }

    @Override
    public void punchImpact(Entity entity) {
        SoundEvent SE;
        this.setAttackTimeDuring(-10);
        if (entity != null) {
            float knockbackStrength;
            float pow;
            boolean lasthit = false;
            if (this.getActivePowerPhase() >= this.getActivePowerPhaseMax()) {
                pow = this.getHeavyPunchStrength(entity);
                knockbackStrength = 1.0f;
                lasthit = true;
            } else {
                pow = this.getPunchStrength(entity);
                knockbackStrength = 0.2f;
            }
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (Entity)this.self)) {
                if (entity instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)entity;
                    if (lasthit) {
                        this.addEXP(2, LE);
                    } else {
                        this.addEXP(1, LE);
                    }
                }
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            } else {
                Objects.requireNonNull(this);
                if (this.activePowerPhase >= 3) {
                    this.knockShield2(entity, 40);
                }
            }
        } else {
            float distMax = this.getDistanceOut(this.self, this.getReach(), false);
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
            if (!this.self.m_9236_().f_46443_) {
                ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
        float pitch = 1.0f;
        Objects.requireNonNull(this);
        if (this.activePowerPhase >= 3) {
            if (!this.self.m_9236_().m_5776_()) {
                Byte LastHitSound = this.getLastHitSound();
                this.playStandUserOnlySoundsIfNearby(LastHitSound, 15.0, false, true);
            }
            if (entity != null) {
                SE = ModSounds.PUNCH_4_SOUND_EVENT;
                pitch = 1.2f;
            } else {
                SE = ModSounds.PUNCH_2_SOUND_EVENT;
            }
        } else if (entity != null) {
            SE = ModSounds.PUNCH_3_SOUND_EVENT;
            pitch = 1.1f + 0.07f * (float)this.activePowerPhase;
        } else {
            SE = ModSounds.PUNCH_1_SOUND_EVENT;
        }
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), SE, SoundSource.PLAYERS, 0.95f, pitch);
        }
    }

    @Override
    public boolean setPowerBarrageCharge() {
        this.animateStand((byte)11);
        this.attackTimeDuring = 0;
        this.setActivePower((byte)4);
        this.poseStand((byte)1);
        this.clashDone = false;
        this.playBarrageChargeSound();
        return true;
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        return $$1;
    }

    @Override
    public boolean setPowerBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)5);
        this.poseStand((byte)1);
        this.setAttackTimeMax(this.getBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.animateStand((byte)12);
        this.playBarrageCrySound();
        return true;
    }

    @Override
    public void updateMovesFromPacket(byte activePower) {
        if (activePower == 5) {
            Objects.requireNonNull(this);
            this.setActivePowerPhase((byte)3);
        }
        super.updateMovesFromPacket(activePower);
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_()) {
            float kbs = 0.0f;
            float pow = 0.0f;
            boolean throwPunch = false;
            SoundEvent SE = null;
            float pitch = 0.0f;
            if (effect.m_19557_() == 13 || effect.m_19557_() == 7) {
                kbs = 0.2f;
                pow = this.getPunchStrength((Entity)this.getSelf());
                throwPunch = true;
                SE = ModSounds.PUNCH_3_SOUND_EVENT;
                pitch = effect.m_19557_() == 7 ? 1.24f : 1.17f;
            } else if (effect.m_19557_() == 1) {
                kbs = 1.0f;
                pow = this.getHeavyPunchStrength((Entity)this.getSelf());
                throwPunch = true;
                SE = ModSounds.PUNCH_4_SOUND_EVENT;
                pitch = 1.2f;
                if (!this.self.m_9236_().m_5776_()) {
                    Byte LastHitSound = this.getLastHitSound();
                    this.playStandUserOnlySoundsIfNearby(LastHitSound, 15.0, false, true);
                }
            }
            if (throwPunch) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), SE, SoundSource.PLAYERS, 0.95f, pitch);
                if (this.StandDamageEntityAttack((Entity)this.getSelf(), pow, 0.0f, (Entity)this.self)) {
                    float f;
                    this.takeDeterminedKnockback(this.self, (Entity)this.getSelf(), kbs);
                    kbs *= (float)(1.0 - this.getSelf().m_21133_(Attributes.f_22278_));
                    if ((double)f <= 0.0) {
                        return;
                    }
                    this.getSelf().f_19864_ = true;
                    Vec3 vec3d2 = new Vec3((double)Mth.m_14031_((float)(this.getSelf().m_146908_() * ((float)Math.PI / 180))), 0.0, (double)(-Mth.m_14089_((float)(this.getSelf().m_146908_() * ((float)Math.PI / 180))))).m_82541_().m_82490_((double)kbs).m_82548_();
                    this.getSelf().m_20334_(-vec3d2.f_82479_, this.getSelf().m_20096_() ? 0.28 : 0.0, -vec3d2.f_82481_);
                    this.getSelf().f_19812_ = true;
                }
            }
        }
    }

    public void standPunch() {
        if (this.self instanceof Player) {
            if (this.isPacketPlayer()) {
                this.attackTimeDuring = -10;
                ModPacketHandler.PACKET_ACCESS.StandPunchPacket(this.getTargetEntityId(this.getPunchAngle()), this.activePowerPhase);
            }
        } else {
            Entity targetEntity = this.getTargetEntity(this.self, -1.0f, this.getPunchAngle());
            this.punchImpact(targetEntity);
        }
    }

    public float getPunchAngle() {
        return ClientNetworking.getAppropriateConfig().basePunchAngle.intValue();
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        float attackTimeDuring = standUser.roundabout$getAttackTimeDuring();
        if (standOn && standUser.roundabout$isClashing()) {
            int ClashTime = 15 - Math.round(attackTimeDuring / 60.0f * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageAttacking() && attackTimeDuring > -1.0f) {
            int ClashTime = 15 - Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageLength() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageCharging()) {
            int ClashTime = Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageWindup() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else {
            float attackTime;
            float finalATime;
            int barTexture = 0;
            Entity TE = standUser.roundabout$getStandPowers().getTargetEntity((LivingEntity)playerEntity, -1.0f, this.getPunchAngle());
            float attackTimeMax = standUser.roundabout$getAttackTimeMax();
            if (attackTimeMax > 0.0f && (finalATime = (attackTime = (float)standUser.roundabout$getAttackTime()) / attackTimeMax) <= 1.0f) {
                barTexture = standUser.roundabout$getActivePowerPhase() == standUser.roundabout$getActivePowerPhaseMax() ? 24 : (TE != null ? 12 : 18);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            }
            if (standOn && TE != null && barTexture == 0) {
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        }
    }
}

