/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.c2s;

import java.util.function.Supplier;
import net.hydra.jojomod.event.powers.StandUser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ForgeClashUpdatePacketC2S {
    private final float clashProg;
    private final boolean clashDone;

    public ForgeClashUpdatePacketC2S(float clashProg, boolean clashDone) {
        this.clashProg = clashProg;
        this.clashDone = clashDone;
    }

    public ForgeClashUpdatePacketC2S(FriendlyByteBuf buf) {
        this.clashProg = buf.readFloat();
        this.clashDone = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.clashProg);
        buf.writeBoolean(this.clashDone);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null && ((StandUser)player).roundabout$isClashing()) {
                ((StandUser)player).roundabout$getStandPowers().setClashProgress(this.clashProg);
                ((StandUser)player).roundabout$getStandPowers().setClashDone(this.clashDone);
            }
        });
        return true;
    }
}

