/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.c2s;

import java.util.function.Supplier;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ForgeCreativeModeSlotPacket {
    private final int slotNo;
    private final ItemStack stack;
    private final byte cont;

    public ForgeCreativeModeSlotPacket(int slotNo, ItemStack stack, byte dataContext) {
        this.slotNo = slotNo;
        this.stack = stack;
        this.cont = dataContext;
    }

    public ForgeCreativeModeSlotPacket(FriendlyByteBuf buf) {
        this.slotNo = buf.readInt();
        this.stack = buf.m_130267_();
        this.cont = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotNo);
        buf.m_130055_(this.stack);
        buf.writeByte((int)this.cont);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ServerLevel level = (ServerLevel)player.m_9236_();
                MainUtil.handleSetCreativeModeSlot((Player)player, this.slotNo, this.stack, this.cont);
            }
        });
        return true;
    }
}

