/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.c2s;

import java.util.function.Supplier;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ForgeFloatC2SPacket {
    private final float data;
    private final byte dataContext;

    public ForgeFloatC2SPacket(float data, byte dataContext) {
        this.data = data;
        this.dataContext = dataContext;
    }

    public ForgeFloatC2SPacket(FriendlyByteBuf buf) {
        this.data = buf.readFloat();
        this.dataContext = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.data);
        buf.writeByte((int)this.dataContext);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ServerLevel level = (ServerLevel)player.m_9236_();
                MainUtil.handleFloatPacketC2S((Player)player, this.data, this.dataContext);
            }
        });
        return true;
    }
}

