/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.c2s;

import java.util.function.Supplier;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ForgePilotPacket {
    private final float getX;
    private final float getY;
    private final float getZ;
    private final float getYRot;
    private final float getXRot;
    private final int getStand;

    public ForgePilotPacket(float getX, float getY, float getZ, float getYRot, float getXRot, int getStand) {
        this.getX = getX;
        this.getY = getY;
        this.getZ = getZ;
        this.getYRot = getYRot;
        this.getXRot = getXRot;
        this.getStand = getStand;
    }

    public ForgePilotPacket(FriendlyByteBuf buf) {
        this.getX = buf.readFloat();
        this.getY = buf.readFloat();
        this.getZ = buf.readFloat();
        this.getYRot = buf.readFloat();
        this.getXRot = buf.readFloat();
        this.getStand = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.getX);
        buf.writeFloat(this.getY);
        buf.writeFloat(this.getZ);
        buf.writeFloat(this.getYRot);
        buf.writeFloat(this.getXRot);
        buf.writeInt(this.getStand);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ServerLevel level = (ServerLevel)player.m_9236_();
                MainUtil.handleMovePilot(this.getX, this.getY, this.getZ, this.getYRot, this.getXRot, (Player)player, this.getStand);
            }
        });
        return true;
    }
}

