/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeGuardUpdatePacket {
    private final float guardPoints;
    private final boolean guardBroken;

    public ForgeGuardUpdatePacket(float guardPoints, boolean guardBroken) {
        this.guardPoints = guardPoints;
        this.guardBroken = guardBroken;
    }

    public ForgeGuardUpdatePacket(FriendlyByteBuf buf) {
        this.guardPoints = buf.readFloat();
        this.guardBroken = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.guardPoints);
        buf.writeBoolean(this.guardBroken);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handleGuardUpdate(this.guardPoints, this.guardBroken));
        return true;
    }
}

