/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgePowerFloatPacket {
    private final byte activePower;
    private final float data;

    public ForgePowerFloatPacket(byte activePowers, float data) {
        this.activePower = activePowers;
        this.data = data;
    }

    public ForgePowerFloatPacket(FriendlyByteBuf buf) {
        this.activePower = buf.readByte();
        this.data = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.activePower);
        buf.writeFloat(this.data);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handlePowerFloatPacket(this.activePower, this.data));
        return true;
    }
}

