/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeTimeStoppingEntityPacket {
    private final int entityID;
    private final double x;
    private final double y;
    private final double z;
    private final double range;
    private final int duration;
    private final int maxDuration;

    public ForgeTimeStoppingEntityPacket(int entityID, double x, double y, double z, double range, int duration, int maxDuration) {
        this.entityID = entityID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.range = range;
        this.duration = duration;
        this.maxDuration = maxDuration;
    }

    public ForgeTimeStoppingEntityPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.range = buf.readDouble();
        this.duration = buf.readInt();
        this.maxDuration = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.range);
        buf.writeInt(this.duration);
        buf.writeInt(this.maxDuration);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handleTimeStoppingEntityPacket(this.entityID, this.x, this.y, this.z, this.range, this.duration, this.maxDuration));
        return true;
    }
}

