/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.IFireBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.block.StandFireBlockEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.entity.projectile.GasolineCanEntity;
import net.hydra.jojomod.entity.projectile.GasolineSplatterEntity;
import net.hydra.jojomod.entity.substand.LifeTrackerEntity;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersMagiciansRed;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2424;
import net.minecraft.class_2429;
import net.minecraft.class_2530;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public class StandFireBlock
extends class_2237 {
    private final float fireDamage;
    public static final int MAX_AGE = 15;
    public static final class_2758 AGE;
    public static final class_2758 COLOR;
    public static final class_2746 NORTH;
    public static final class_2746 EAST;
    public static final class_2746 SOUTH;
    public static final class_2746 WEST;
    public static final class_2746 UP;
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION;
    private static final class_265 UP_AABB;
    private static final class_265 WEST_AABB;
    private static final class_265 EAST_AABB;
    private static final class_265 NORTH_AABB;
    private static final class_265 SOUTH_AABB;
    private final Map<class_2680, class_265> shapesCache;
    private static final int IGNITE_INSTANT = 60;
    private static final int IGNITE_EASY = 30;
    private static final int IGNITE_MEDIUM = 15;
    private static final int IGNITE_HARD = 5;
    private static final int BURN_INSTANT = 100;
    private static final int BURN_EASY = 60;
    private static final int BURN_MEDIUM = 20;
    private static final int BURN_HARD = 5;
    private final Object2IntMap<class_2248> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<class_2248> burnOdds = new Object2IntOpenHashMap();
    private static final int SECONDS_ON_FIRE = 8;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final class_265 DOWN_AABB;

    public void method_9536(class_2680 $$0, class_1937 $$1, class_2338 $$2, class_2680 $$3, boolean $$4) {
        if (!$$0.method_27852($$3.method_26204())) {
            class_2586 class_25862 = $$1.method_8321($$2);
            if (class_25862 instanceof StandFireBlockEntity) {
                StandFireBlockEntity standFireBlockEntity = (StandFireBlockEntity)class_25862;
            }
            super.method_9536($$0, $$1, $$2, $$3, $$4);
        }
    }

    public class_2586 method_10123(class_2338 $$0, class_2680 $$1) {
        return new StandFireBlockEntity($$0, $$1);
    }

    public StandFireBlock(class_4970.class_2251 $$0) {
        super($$0);
        this.fireDamage = 1.0f;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(0)));
        this.shapesCache = ImmutableMap.copyOf(this.field_10647.method_11662().stream().filter($$0x -> (Integer)$$0x.method_11654((class_2769)AGE) == 0).collect(Collectors.toMap(Function.identity(), StandFireBlock::calculateShape)));
    }

    private boolean isFacingDown(class_2680 s) {
        return (Boolean)s.method_11654((class_2769)UP) == false && (Boolean)s.method_11654((class_2769)NORTH) == false && (Boolean)s.method_11654((class_2769)EAST) == false && (Boolean)s.method_11654((class_2769)SOUTH) == false && (Boolean)s.method_11654((class_2769)WEST) == false;
    }

    private static class_265 calculateShape(class_2680 state) {
        class_265 $$1 = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            $$1 = UP_AABB;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            $$1 = class_259.method_1084((class_265)$$1, (class_265)NORTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            $$1 = class_259.method_1084((class_265)$$1, (class_265)SOUTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            $$1 = class_259.method_1084((class_265)$$1, (class_265)EAST_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            $$1 = class_259.method_1084((class_265)$$1, (class_265)WEST_AABB);
        }
        return $$1.method_1110() ? DOWN_AABB : $$1;
    }

    public class_2680 method_9559(class_2680 $$0, class_2350 $$1, class_2680 $$2, class_1936 $$3, class_2338 $$4, class_2338 $$5) {
        if ($$0.method_27852(ModBlocks.STAND_FIRE)) {
            int color = (Integer)$$0.method_11654((class_2769)COLOR);
            return this.method_9558($$0, (class_4538)$$3, $$4) ? (class_2680)this.getStateWithAge($$3, $$4, (Integer)$$0.method_11654((class_2769)AGE)).method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(color)) : class_2246.field_10124.method_9564();
        }
        return class_2246.field_10124.method_9564();
    }

    public class_265 method_9530(class_2680 $$0, class_1922 $$1, class_2338 $$2, class_3726 $$3) {
        return this.shapesCache.get($$0.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    public class_2680 method_9605(class_1750 $$0) {
        return this.getStateForPlacement((class_1922)$$0.method_8045(), $$0.method_8037());
    }

    public class_2680 getStateForPlacement(class_1922 getter, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = getter.method_8320(belowPos);
        if (!this.canBurn(belowState) && !belowState.method_26206(getter, belowPos, class_2350.field_11036)) {
            class_2350[] directions;
            class_2680 finalizedState = this.method_9564();
            for (class_2350 direction : directions = class_2350.values()) {
                class_2746 property = PROPERTY_BY_DIRECTION.get(direction);
                if (property == null) continue;
                finalizedState = (class_2680)finalizedState.method_11657((class_2769)property, (Comparable)Boolean.valueOf(this.canBurn(getter.method_8320(pos.method_10093(direction)))));
            }
            finalizedState = (class_2680)finalizedState.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false));
            return finalizedState;
        }
        return this.method_9564();
    }

    public boolean method_9558(class_2680 $$0, class_4538 $$1, class_2338 $$2) {
        class_2338 $$3 = $$2.method_10074();
        return $$1.method_8320($$3).method_26206((class_1922)$$1, $$3, class_2350.field_11036) || this.isValidFireLocation((class_1922)$$1, $$2);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 $$0, class_2680 $$1, class_2591<T> $$2) {
        return StandFireBlock.method_31618($$2, ModBlocks.STAND_FIRE_BLOCK_ENTITY, StandFireBlockEntity::tickFire);
    }

    protected boolean isNearRain(class_1937 $$0, class_2338 $$1) {
        return $$0.method_8520($$1) || $$0.method_8520($$1.method_10067()) || $$0.method_8520($$1.method_10078()) || $$0.method_8520($$1.method_10095()) || $$0.method_8520($$1.method_10072());
    }

    private int getBurnOdds(class_2680 $$0) {
        return ((IFireBlock)class_2246.field_10036).roundabout$getBurnOdds($$0);
    }

    private int getIgniteOdds(class_2680 $$0) {
        return ((IFireBlock)class_2246.field_10036).roundabout$getIgniteOdds($$0);
    }

    public void checkBurnOut(class_1937 $$0, class_2338 $$1, int $$2, class_5819 $$3, int $$4, StandFireBlockEntity sfb) {
        int $$5 = this.getBurnOdds($$0.method_8320($$1));
        if ($$3.method_43048($$2) < $$5) {
            class_2680 $$6 = $$0.method_8320($$1);
            if ($$3.method_43048($$4 + 10) < 5 && !$$0.method_8520($$1)) {
                StandPowers standPowers;
                if (sfb.standUser != null && (standPowers = ((StandUser)sfb.standUser).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                    PowersMagiciansRed PM = (PowersMagiciansRed)standPowers;
                    int $$7 = Math.min($$4 + $$3.method_43048(5) / 4, 15);
                    if (sfb.method_11010().method_27852(ModBlocks.STAND_FIRE)) {
                        int color = (Integer)sfb.method_11010().method_11654((class_2769)COLOR);
                        class_2680 bs = this.getStateWithAge((class_1936)$$0, $$1, $$7);
                        if (bs.method_27852(ModBlocks.STAND_FIRE)) {
                            bs = (class_2680)bs.method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(color));
                            $$0.method_8501($$1, bs);
                            class_2586 be = $$0.method_8321($$1);
                            if (be instanceof StandFireBlockEntity) {
                                StandFireBlockEntity sfbe = (StandFireBlockEntity)be;
                                sfbe.snapNumber = sfb.snapNumber;
                                sfbe.standUser = sfb.standUser;
                                sfbe.fireColorType = sfb.fireColorType;
                                sfbe.fireIDNumber = PM.getNewFireId();
                            }
                        }
                    }
                }
            } else {
                $$0.method_8650($$1, false);
            }
            class_2248 $$8 = $$6.method_26204();
            if ($$8 instanceof class_2530) {
                class_2530.method_10738((class_1937)$$0, (class_2338)$$1);
            }
        }
    }

    public class_2680 getStateWithAge(class_1936 $$0, class_2338 $$1, int $$2) {
        class_2680 $$3 = StandFireBlock.getState((class_1922)$$0, $$1);
        return $$3.method_27852(ModBlocks.STAND_FIRE) ? (class_2680)$$3.method_11657((class_2769)AGE, (Comparable)Integer.valueOf($$2)) : $$3;
    }

    public boolean isValidFireLocation(class_1922 $$0, class_2338 $$1) {
        for (class_2350 $$2 : class_2350.values()) {
            if (!this.canBurn($$0.method_8320($$1.method_10093($$2)))) continue;
            return true;
        }
        return false;
    }

    public int getIgniteOdds(class_4538 $$0, class_2338 $$1) {
        if (!$$0.method_22347($$1)) {
            return 0;
        }
        int $$2 = 0;
        for (class_2350 $$3 : class_2350.values()) {
            class_2680 $$4 = $$0.method_8320($$1.method_10093($$3));
            $$2 = Math.max(this.getIgniteOdds($$4), $$2);
        }
        return $$2;
    }

    public static class_2680 getState(class_1922 $$0, class_2338 $$1) {
        class_2338 $$2 = $$1.method_10074();
        class_2680 $$3 = $$0.method_8320($$2);
        return ((StandFireBlock)ModBlocks.STAND_FIRE).getStateForPlacement($$0, $$1);
    }

    public void method_9496(class_2680 $$0, class_1937 $$1, class_2338 $$2, class_5819 $$3) {
        if ($$3.method_43048(24) == 0) {
            $$1.method_8486((double)$$2.method_10263() + 0.5, (double)$$2.method_10264() + 0.5, (double)$$2.method_10260() + 0.5, class_3417.field_14993, class_3419.field_15245, 1.0f + $$3.method_43057(), $$3.method_43057() * 0.7f + 0.3f, false);
        }
    }

    protected boolean canBurn(class_2680 $$0) {
        return this.getIgniteOdds($$0) > 0;
    }

    /*
     * Unable to fully structure code
     */
    public void method_9548(class_2680 $$0, class_1937 $$1, class_2338 $$2, class_1297 $$3) {
        block6: {
            block7: {
                if ($$1.method_8608() || !((var6_5 = $$1.method_8321($$2)) instanceof StandFireBlockEntity)) break block6;
                fb = (StandFireBlockEntity)var6_5;
                if (fb.standUser == null || !fb.standUser.method_5779($$3) && !$$3.method_5626((class_1297)fb.standUser) && (fb.standUser == null || fb.standUser instanceof class_1657 || fb.standUser instanceof class_1588 || $$3 instanceof class_1588 || (var8_7 = fb.standUser) instanceof class_1308 && (LE = (class_1308)var8_7).method_5968() != null && LE.method_5968().method_5779($$3)) && (!($$3 instanceof class_1321) || (TA = (class_1321)$$3).method_35057() == null || !TA.method_35057().method_5779((class_1297)fb.standUser))) break block7;
                $$1.method_8650($$2, false);
                break block6;
            }
            if (!($$3 instanceof class_1309)) ** GOTO lbl-1000
            LE = (class_1309)$$3;
            if (!($$3 instanceof LifeTrackerEntity)) {
                user = (StandUser)$$3;
                user.roundabout$setRemainingStandFireTicks(user.roundabout$getRemainingFireTicks() + 1);
                if (user.roundabout$getRemainingFireTicks() == 0 && (var11_10 = $$1.method_8321($$2)) instanceof StandFireBlockEntity) {
                    $$5 = (StandFireBlockEntity)var11_10;
                    user.roundabout$setSecondsOnStandFire(3);
                    if (fb.standUser != null) {
                        user.roundabout$setOnStandFire($$5.fireColorType, fb.standUser);
                    } else {
                        user.roundabout$setOnStandFire($$5.fireColorType);
                    }
                }
                fd = 1.0f;
                fd = user.roundabout$getStandPowers().getReducedDamage((class_1297)LE) != false ? (float)((double)fd * ((double)ClientNetworking.getAppropriateConfig().magiciansRedSettings.standFireOnPlayersMult.intValue() * 0.01)) : (float)((double)fd * ((double)ClientNetworking.getAppropriateConfig().magiciansRedSettings.standFireOnMobsMult.intValue() * 0.01));
                prevVelocity = LE.method_18798();
                LE.method_5643(ModDamageTypes.of($$1, ModDamageTypes.STAND_FIRE, (class_1297)fb.standUser), fd);
                LE.method_18799(prevVelocity);
            } else if (($$3 instanceof GasolineSplatterEntity || $$3 instanceof GasolineCanEntity) && !$$3.method_31481()) {
                ((class_3218)$$1).method_14199((class_2394)class_2398.field_11240, $$3.method_23317(), $$3.method_23318() + (double)$$3.method_5751(), $$3.method_23321(), 40, 0.0, 0.2, 0.0, 0.2);
                ((class_3218)$$1).method_14199((class_2394)class_2398.field_11236, $$3.method_23317(), $$3.method_23318() + (double)$$3.method_5751(), $$3.method_23321(), 1, 0.5, 0.5, 0.5, 0.2);
                MainUtil.gasExplode(null, (class_3218)$$3.method_37908(), $$3.method_23312(), 0, 2, 4, MainUtil.gasDamageMultiplier() * 14.0f);
                $$3.method_31472();
            }
        }
        super.method_9548($$0, $$1, $$2, $$3);
    }

    private static boolean inPortalDimension(class_1937 $$0) {
        return $$0.method_27983() == class_1937.field_25179 || $$0.method_27983() == class_1937.field_25180;
    }

    protected void method_33614(class_1937 $$0, class_1657 $$1, class_2338 $$2, class_2680 $$3) {
    }

    public void method_9576(class_1937 $$0, class_2338 $$1, class_2680 $$2, class_1657 $$3) {
        if (!$$0.method_8608()) {
            $$0.method_8444(null, 1009, $$1, 0);
        }
        super.method_9576($$0, $$1, $$2, $$3);
    }

    public static boolean canBePlacedAt(class_1937 $$0, class_2338 $$1, class_2350 $$2) {
        class_2680 $$3 = $$0.method_8320($$1);
        return !$$3.method_26215() ? false : StandFireBlock.getState((class_1922)$$0, $$1).method_26184((class_4538)$$0, $$1) || StandFireBlock.isPortal($$0, $$1, $$2);
    }

    private static boolean isPortal(class_1937 $$0, class_2338 $$1, class_2350 $$2) {
        if (!StandFireBlock.inPortalDimension($$0)) {
            return false;
        }
        class_2338.class_2339 $$3 = $$1.method_25503();
        boolean $$4 = false;
        for (class_2350 $$5 : class_2350.values()) {
            if (!$$0.method_8320((class_2338)$$3.method_10101((class_2382)$$1).method_10098($$5)).method_27852(class_2246.field_10540)) continue;
            $$4 = true;
            break;
        }
        if (!$$4) {
            return false;
        }
        class_2350.class_2351 $$6 = $$2.method_10166().method_10179() ? $$2.method_10160().method_10166() : class_2350.class_2353.field_11062.method_33465($$0.field_9229);
        return class_2424.method_30485((class_1936)$$0, (class_2338)$$1, (class_2350.class_2351)$$6).isPresent();
    }

    public void method_9615(class_2680 $$0, class_1937 $$1, class_2338 $$2, class_2680 $$3, boolean $$4) {
        if (!$$3.method_27852($$0.method_26204())) {
            Optional $$5;
            if (StandFireBlock.inPortalDimension($$1) && ($$5 = class_2424.method_30485((class_1936)$$1, (class_2338)$$2, (class_2350.class_2351)class_2350.class_2351.field_11048)).isPresent()) {
                ((class_2424)$$5.get()).method_10363();
                return;
            }
            if (!$$0.method_26184((class_4538)$$1, $$2)) {
                $$1.method_8650($$2, false);
            }
        }
    }

    private static int getFireTickDelay(class_5819 $$0) {
        return 30 + $$0.method_43048(10);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> $$0) {
        $$0.method_11667(new class_2769[]{AGE, NORTH, EAST, SOUTH, WEST, UP, COLOR});
    }

    private void setFlammable(class_2248 $$0, int $$1, int $$2) {
        this.igniteOdds.put((Object)$$0, $$1);
        this.burnOdds.put((Object)$$0, $$2);
    }

    static {
        COLOR = ModBlocks.COLOR;
        DOWN_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        AGE = class_2741.field_12498;
        NORTH = class_2429.field_11332;
        EAST = class_2429.field_11335;
        SOUTH = class_2429.field_11331;
        WEST = class_2429.field_11328;
        UP = class_2429.field_11327;
        PROPERTY_BY_DIRECTION = (Map)class_2429.field_11329.entrySet().stream().filter($$0 -> $$0.getKey() != class_2350.field_11033).collect(class_156.method_664());
        UP_AABB = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        EAST_AABB = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

