/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util.config;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydra.jojomod.Roundabout;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class BlockBlacklist {
    private static final Gson GSON = new Gson();
    public static BlacklistData data = new BlacklistData();
    private static boolean shouldBlacklistBlocks = true;
    private static final Pattern tagKeyPattern = Pattern.compile("TagKey\\[(\\S+)\\s*/");

    public static boolean load(Path path, String filename) {
        try {
            Path blacklistPath = path.resolve(filename + ".json");
            if (!Files.exists(blacklistPath, new LinkOption[0])) {
                Files.write(blacklistPath, GSON.toJson((Object)data).getBytes(), new OpenOption[0]);
            } else {
                data = (BlacklistData)GSON.fromJson((Reader)Files.newBufferedReader(blacklistPath), BlacklistData.class);
                if (BlockBlacklist.data.blockTags == null || BlockBlacklist.data.blockIdentifiers == null) {
                    shouldBlacklistBlocks = false;
                    throw new IOException("Missing field \"blockTags\" or \"blockIdentifiers\" in \"" + filename + ".json\"");
                }
            }
        }
        catch (IOException e) {
            Roundabout.LOGGER.warn("Failed to load blacklist \"{}.json\" (error: [\"{}\"])", (Object)filename, (Object)e.toString());
            e.printStackTrace();
            return false;
        }
        Roundabout.LOGGER.debug("Loaded blacklist \"{}.json\" successfully.", (Object)filename);
        return true;
    }

    public static boolean canBlacklistBlocks() {
        return shouldBlacklistBlocks;
    }

    public static boolean isBlockAcceptable(class_2680 block) {
        if (!shouldBlacklistBlocks || BlockBlacklist.data.blockIdentifiers == null || BlockBlacklist.data.blockTags == null) {
            return true;
        }
        for (String s : BlockBlacklist.data.blockIdentifiers) {
            if (!class_7923.field_41175.method_10221((Object)block.method_26204()).toString().matches(BlockBlacklist.wildcardToRegex(s))) continue;
            return false;
        }
        for (String s : BlockBlacklist.data.blockTags) {
            for (class_6862 tag : block.method_40144().toList()) {
                String extractedTag;
                Matcher matcher = tagKeyPattern.matcher(tag.toString());
                if (!matcher.find() || !(extractedTag = matcher.group(1)).matches(BlockBlacklist.wildcardToRegex(s))) continue;
                return false;
            }
        }
        return true;
    }

    public static String wildcardToRegex(String wildcard) {
        return "^" + wildcard.replace(".", "\\.").replace("*", ".*") + "$";
    }

    public static class BlacklistData {
        public Set<String> blockTags = new HashSet<String>(List.of("#*:*_ore"));
        public Set<String> blockIdentifiers = new HashSet<String>(List.of("*:*_ore", "*:*_block"));
    }
}

