/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.block.MiningAlertBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;

public class PowersHeyYa
extends NewDashPreset {
    int ticksSinceLastYap = 0;
    int maxTicksSinceLastYap = 400;
    public int meltDodgeTicks = -1;
    public int yapTime = 0;
    public static final byte YAP = 1;
    public static final byte MANGA = 1;
    public static final byte GOTHIC = 2;
    public static final byte VOLUME_2 = 3;
    public static final byte CHAPTER_24 = 4;
    public static final byte GREENER = 5;
    public static final byte WORLD = 6;
    public static final byte FIRE_AND_ICE = 7;
    public static final byte WARDEN = 8;
    public static final byte ICE_COLD = 9;
    public static final byte VILLAGER = 10;
    public static final byte GEEZER = 11;
    public static final byte SKELETON = 12;
    public static final byte WITHER = 13;
    public static final byte TUSK = 14;
    public static final byte DEVIL = 15;
    public static final byte HELL_NAH = 16;
    public static final byte ALIEN = 17;
    public static final byte AMERICA = 18;
    public static final byte ZOMBIE = 19;
    public static final byte ANTI = 20;
    public static final byte GREY_YA = 21;
    public static final byte ANGEL = 22;
    public static final byte KNIGHT = 23;
    public static final byte SAINT = 24;
    public static final byte YAP_1 = 61;
    public static final byte YAP_2 = 62;
    public static final byte YAP_3 = 63;
    public static final byte YAP_4 = 64;
    public static final byte YAP_5 = 65;
    public static final byte YAP_6 = 66;
    public static final byte YAP_7 = 67;

    public PowersHeyYa(class_1309 self) {
        super(self);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().heyYaSettings.enableHeyYa;
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersHeyYa(entity);
    }

    public boolean dangerYappingOn() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public boolean rendersPlayer() {
        return true;
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        if (this.dangerYappingOn()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.DANGER_YAP_DISABLE, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.DANGER_YAP, (byte)0);
        }
        this.setSkillIcon(context, x, y, 2, StandIcons.MINING_YAP, (byte)1);
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        this.setSkillIcon(context, x, y, 4, StandIcons.YAP_YAP, (byte)3);
        super.renderIcons(context, x, y);
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.toggleDangerYapClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.miningYapClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.yapClient();
            }
        }
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                return this.switchDangerMode();
            }
            case 27: {
                return this.doYap();
            }
            case 23: {
                return this.scoutForOresOnClient();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    public void toggleDangerYapClient() {
        this.tryPower(21, true);
        this.tryPowerPacket((byte)21);
    }

    public void miningYapClient() {
        if (!this.onCooldown((byte)1)) {
            this.tryPower(23, true);
            this.tryPowerPacket((byte)23);
        }
    }

    public void yapClient() {
        if (!this.onCooldown((byte)3)) {
            this.tryPower(27, true);
            this.tryPowerPacket((byte)27);
        }
    }

    public boolean scoutForOresOnClient() {
        this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().heyYaSettings.oreDetectionCooldown);
        if (this.isClient()) {
            int range = ClientNetworking.getAppropriateConfig().heyYaSettings.oreDetectionRadius;
            int oremaxout = 0;
            int oremaxoutMax = ClientNetworking.getAppropriateConfig().heyYaSettings.oreDetectionMaximum;
            for (int x = -range; x < range; ++x) {
                for (int y = -range; y < range; ++y) {
                    for (int z = -range; z < range; ++z) {
                        class_2338 pos = this.self.method_24515().method_10081((class_2382)new class_2338(x, y, z));
                        class_2680 blk = this.self.method_37908().method_8320(pos);
                        if (!MainUtil.confirmIsOre(blk) || !this.confirmSpace(pos.method_10074()) && !this.confirmSpace(pos.method_10078()) && !this.confirmSpace(pos.method_10067()) && !this.confirmSpace(pos.method_10095()) && !this.confirmSpace(pos.method_10072()) && !this.confirmSpace(pos.method_10084()) || ++oremaxout < oremaxoutMax) continue;
                        return true;
                    }
                }
            }
        } else {
            this.yapSounds();
            if (this.isEvilYapper()) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)("text.roundabout.hey_ya_messaging.mining.evil.no_" + (class_3532.method_15357((double)(Math.random() * (double)ClientNetworking.getAppropriateConfig().heyYaSettings.numberOfEvilMiningYapLines.intValue())) + 1))).method_27692(class_124.field_1065), true);
            } else {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)("text.roundabout.hey_ya_messaging.mining.no_" + (class_3532.method_15357((double)(Math.random() * (double)ClientNetworking.getAppropriateConfig().heyYaSettings.numberOfMiningYapLines.intValue())) + 1))).method_27692(class_124.field_1065), true);
            }
        }
        return true;
    }

    public void yapSounds() {
        if (!this.isYapping()) {
            this.setYapTime(40);
            this.getStandUserSelf().roundabout$setStandAnimation((byte)1);
            this.playStandUserOnlySoundsIfNearby((byte)(61 + class_3532.method_15357((double)(Math.random() * 7.0))), 100.0, false, true);
        }
    }

    public boolean confirmSpace(class_2338 pos) {
        class_2680 state = this.self.method_37908().method_8320(pos);
        if (state.method_26215() || state.method_27852(class_2246.field_10382)) {
            this.tryBlockPosPowerPacket((byte)37, pos);
            return true;
        }
        return false;
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.getSelf().method_37908().method_8608() && effect.method_5584() == 50) {
            this.yapSounds();
        }
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        --this.ticksSinceLastYap;
        if (!this.hasStandActive(this.self)) {
            ((IMob)this.self).roundabout$setRetractTicks(500);
            this.getStandUserSelf().roundabout$summonStand(this.self.method_37908(), true, false);
        }
        if (this.ticksSinceLastYap <= 0) {
            this.yapSounds();
            this.ticksSinceLastYap = this.maxTicksSinceLastYap;
        }
    }

    public void tryHighlightOre(class_2338 pos) {
        class_2680 state = this.self.method_37908().method_8320(pos);
        if (state.method_26215()) {
            this.self.method_37908().method_8501(pos, (class_2680)ModBlocks.MINING_ALERT_BLOCK.method_9564().method_11657((class_2769)MiningAlertBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        } else if (state.method_27852(class_2246.field_10382)) {
            this.self.method_37908().method_8501(pos, (class_2680)ModBlocks.MINING_ALERT_BLOCK.method_9564().method_11657((class_2769)MiningAlertBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean switchDangerMode() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.dangerYappingOn());
        return true;
    }

    public boolean doYap() {
        this.setCooldown((byte)3, ClientNetworking.getAppropriateConfig().heyYaSettings.yapCooldown);
        if (!this.isClient()) {
            this.yapSounds();
            if (this.isEvilYapper()) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)("text.roundabout.hey_ya_messaging.evil.no_" + (class_3532.method_15357((double)(Math.random() * (double)ClientNetworking.getAppropriateConfig().heyYaSettings.numberOfEvilYapLines.intValue())) + 1))).method_27692(class_124.field_1065), true);
            } else {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)("text.roundabout.hey_ya_messaging.no_" + (class_3532.method_15357((double)(Math.random() * (double)ClientNetworking.getAppropriateConfig().heyYaSettings.numberOfYapLines.intValue())) + 1))).method_27692(class_124.field_1065), true);
            }
        }
        return true;
    }

    @Override
    public boolean tryBlockPosPower(int move, boolean forced, class_2338 Pos) {
        switch (move) {
            case 37: {
                this.tryHighlightOre(Pos);
                return true;
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public void tickPower() {
        if (!this.isClient()) {
            if (this.isYapping()) {
                this.getStandUserSelf().roundabout$setStandAnimation((byte)1);
            } else {
                this.getStandUserSelf().roundabout$setStandAnimation((byte)0);
            }
            this.tickYapping();
        }
        super.tickPower();
    }

    @Override
    public void updateIntMove(int in) {
        super.updateIntMove(in);
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public void reactToAggro(class_1308 mob) {
        if (!(!this.dangerYappingOn() || mob.method_5968() != null && mob.method_5968().method_5779((class_1297)this.self) || mob.method_6065() != null && mob.method_6065().method_5779((class_1297)this.self) || !MainUtil.getIfMobIsAttacking(mob))) {
            this.yapSounds();
            if (this.isEvilYapper()) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43469((String)("text.roundabout.hey_ya_messaging.danger.evil.no_" + (class_3532.method_15357((double)(Math.random() * (double)ClientNetworking.getAppropriateConfig().heyYaSettings.numberOfEvilDangerYapLines.intValue())) + 1)), (Object[])new Object[]{mob.method_5476()}).method_27692(class_124.field_1061), true);
            } else {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43469((String)("text.roundabout.hey_ya_messaging.danger.no_" + (class_3532.method_15357((double)(Math.random() * (double)ClientNetworking.getAppropriateConfig().heyYaSettings.numberOfDangerYapLines.intValue())) + 1)), (Object[])new Object[]{mob.method_5476()}).method_27692(class_124.field_1061), true);
            }
        }
    }

    public boolean isYapping() {
        return this.yapTime > 0;
    }

    public int getYapTime() {
        return this.yapTime;
    }

    public void setYapTime(int yapTime) {
        this.yapTime = yapTime;
    }

    public void tickYapping() {
        if (this.yapTime > 0) {
            --this.yapTime;
        }
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)3, (byte)4, (byte)2, (byte)5, (byte)7, (byte)9, (byte)11, (byte)17, (byte)23, (byte)18, (byte)6, (byte)14, (byte)10, (byte)19, (byte)12, (byte)13, (byte)8, (byte)21, (byte)24, (byte)22, (byte)15, (byte)20, (byte)16);
    }

    public boolean isEvilYapper() {
        switch (this.getStandUserSelf().roundabout$getStandSkin()) {
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.gothic");
            case 3 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.volume_2");
            case 4 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.chapter_24");
            case 5 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.greener");
            case 6 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.world");
            case 8 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.warden");
            case 7 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.fire_and_ice");
            case 9 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.ice_cold");
            case 10 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.villager");
            case 11 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.geezer");
            case 15 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.devil");
            case 14 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.tusk");
            case 12 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.skeleton");
            case 13 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.wither");
            case 16 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.hell_nah");
            case 17 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.alien");
            case 18 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.america");
            case 19 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.zombie");
            case 20 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.anti");
            case 21 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.grey_ya");
            case 22 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.angel");
            case 23 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.knight");
            case 24 -> class_2561.method_43471((String)"skins.roundabout.hey_ya.saint");
            default -> class_2561.method_43471((String)"skins.roundabout.hey_ya.manga");
        };
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        switch (soundChoice) {
            case 18: {
                return ModSounds.HEY_YA_SUMMON_EVENT;
            }
            case 61: {
                return ModSounds.HEY_YA_1_EVENT;
            }
            case 62: {
                return ModSounds.HEY_YA_2_EVENT;
            }
            case 63: {
                return ModSounds.HEY_YA_3_EVENT;
            }
            case 64: {
                return ModSounds.HEY_YA_4_EVENT;
            }
            case 65: {
                return ModSounds.HEY_YA_5_EVENT;
            }
            case 66: {
                return ModSounds.HEY_YA_6_EVENT;
            }
            case 67: {
                return ModSounds.HEY_YA_7_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public byte worthinessType() {
        return 2;
    }

    @Override
    public class_2561 getPosName(byte posID) {
        if (posID == 1) {
            return class_2561.method_43471((String)"idle.roundabout.hey_ya_2");
        }
        return class_2561.method_43471((String)"idle.roundabout.hey_ya_1");
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.danger_yap", "instruction.roundabout.press_skill", StandIcons.DANGER_YAP, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.mining_yap", "instruction.roundabout.press_skill", StandIcons.MINING_YAP, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.yap_yap", "instruction.roundabout.press_skill", StandIcons.YAP_YAP, 4, level, bypass));
        return $$1;
    }
}

