/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import java.util.List;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.stand.MultipleTypeStand;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersSurvivor;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1828;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class SurvivorEntity
extends MultipleTypeStand {
    protected static final class_2940<Float> RANDOM_SIZE = class_2945.method_12791(SurvivorEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Boolean> ACTIVATED = class_2945.method_12791(SurvivorEntity.class, (class_2941)class_2943.field_13323);
    public int dryUpInNetherTicks = 0;
    public int shockCountUpTicks = 0;

    public SurvivorEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    public final void setRandomSize(float randSize) {
        this.field_6011.method_12778(RANDOM_SIZE, (Object)Float.valueOf(randSize));
    }

    public final void setActivated(boolean active) {
        this.field_6011.method_12778(ACTIVATED, (Object)active);
    }

    public final float getRandomSize() {
        return ((Float)this.field_6011.method_12789(RANDOM_SIZE)).floatValue();
    }

    public final boolean getActivated() {
        return (Boolean)this.field_6011.method_12789(ACTIVATED);
    }

    @Override
    public boolean validatePowers(class_1309 user) {
        return ((StandUser)user).roundabout$getStandPowers() instanceof PowersSurvivor;
    }

    @Override
    public boolean hasNoPhysics() {
        return false;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getUser() != null && MainUtil.isStandDamage(source) && !this.forceDespawnSet) {
            this.forceDespawn(true);
            return this.getUser().method_5643(source, amount * 0.5f);
        }
        return false;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (!this.getActivated() && this.method_5637()) {
                this.setActivated(true);
            }
            if (this.method_37908().method_27983() == class_1937.field_25180) {
                int dryTickMax = ClientNetworking.getAppropriateConfig().survivorSettings.dryUpInNetherTicks;
                if (this.getActivated()) {
                    ++this.dryUpInNetherTicks;
                    if (this.dryUpInNetherTicks > dryTickMax) {
                        this.setActivated(false);
                        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15102, class_3419.field_15254, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11237, this.method_23317(), this.method_23318(), this.method_23321(), 0, 0.0, 0.0, 0.0, 0.015);
                    }
                } else {
                    --this.dryUpInNetherTicks;
                }
                this.dryUpInNetherTicks = class_3532.method_15340((int)this.dryUpInNetherTicks, (int)0, (int)dryTickMax);
            }
            if (this.getActivated()) {
                ++this.shockCountUpTicks;
                if (this.shockCountUpTicks > 15) {
                    this.attemptShock();
                    this.shockCountUpTicks = 0;
                }
            } else {
                --this.shockCountUpTicks;
            }
            this.shockCountUpTicks = class_3532.method_15340((int)this.shockCountUpTicks, (int)0, (int)15);
        }
    }

    public static void drawParticleLine(class_1297 from, class_1297 to, int particleCount) {
        class_1937 class_19372 = from.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_243 start = from.method_19538();
        class_243 end = to.method_19538();
        class_243 diff = end.method_1020(start);
        for (int i = 0; i <= particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            class_243 point = start.method_1019(diff.method_1021(progress));
            serverLevel.method_14199((class_2394)ModParticles.ZAP, point.field_1352, point.field_1351, point.field_1350, 1, 0.0, (double)0.2f, 0.0, 0.0);
        }
    }

    public void matchEntities(class_1309 one, class_1309 two) {
        ((StandUser)one).roundabout$setZappedToID(two.method_5628());
        ((StandUser)one).roundabout$aggressivelyEnforceZapAggro();
        ((StandUser)two).roundabout$setZappedToID(one.method_5628());
        ((StandUser)two).roundabout$aggressivelyEnforceZapAggro();
        SurvivorEntity.drawParticleLine((class_1297)this, (class_1297)one, 10);
        SurvivorEntity.drawParticleLine((class_1297)this, (class_1297)two, 10);
        SurvivorEntity.drawParticleLine((class_1297)one, (class_1297)two, 10);
        this.sendMessageTo(one, two);
        this.sendMessageTo(two, one);
        this.method_37908().method_8396(null, this.method_24515(), ModSounds.SURVIVOR_SHOCK_EVENT, class_3419.field_15254, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
    }

    public void sendMessageTo(class_1309 LE, class_1309 LE2) {
        if (LE instanceof class_3222) {
            class_3222 PE = (class_3222)LE;
            PE.method_7353((class_2561)class_2561.method_43469((String)"text.roundabout.survivor.match", (Object[])new Object[]{LE2.method_5476()}).method_27692(class_124.field_1061), true);
        }
    }

    public static boolean canZapEntity(class_1297 ent) {
        class_1309 LE;
        class_1657 PL;
        return !(ent == null || !ent.method_5805() || ent.method_31481() || !(ent instanceof class_1308) && !(ent instanceof class_1657) || ent instanceof StandEntity || ent instanceof FallenMob || !ent.method_5863() || ent.method_5655() || ent instanceof class_1657 && (PL = (class_1657)ent).method_7337() || !(ent instanceof class_1309) || ((StandUser)(LE = (class_1309)ent)).roundabout$isBubbleEncased());
    }

    public void attemptShock() {
        class_1309 user = this.getUser();
        if (user != null && !((StandUser)user).roundabout$getUniqueStandModeToggle()) {
            List<class_1297> mobsInRange = MainUtil.getEntitiesInRange(this.method_37908(), this.method_24515(), ClientNetworking.getAppropriateConfig().survivorSettings.survivorRange.intValue(), (class_1297)this);
            class_1309 firstTarget = null;
            if (!mobsInRange.isEmpty()) {
                for (class_1297 ent : mobsInRange) {
                    class_1657 PE;
                    class_1309 class_13092;
                    class_1309 LE;
                    if (!SurvivorEntity.canZapEntity(ent) || !(ent instanceof class_1309) || ((StandUser)(LE = (class_1309)ent)).roundabout$getZappedToID() > -1 || MainUtil.isBossMob(LE) && !ClientNetworking.getAppropriateConfig().survivorSettings.canUseSurvivorOnBossesInSurvival.booleanValue() && (!((class_13092 = this.getUser()) instanceof class_1657) || !(PE = (class_1657)class_13092).method_7337())) continue;
                    if (firstTarget == null) {
                        firstTarget = LE;
                        continue;
                    }
                    if (!MainUtil.canActuallyHit((class_1297)firstTarget, (class_1297)LE)) continue;
                    this.matchEntities(firstTarget, LE);
                    return;
                }
            }
        }
    }

    @Override
    public boolean method_5863() {
        if (this.method_37908().method_8608()) {
            return ClientUtil.isPlayer((class_1297)this.getUser());
        }
        return false;
    }

    public class_1269 method_5664(class_1657 player, class_243 location, class_1268 intHand) {
        if (!player.method_37908().method_8608()) {
            class_1792 class_17922;
            class_1799 plrItem;
            if (player.method_7325()) {
                return class_1269.field_5812;
            }
            if (!this.getActivated() && !(plrItem = player.method_5998(intHand)).method_7960() && (class_17922 = plrItem.method_7909()) instanceof class_1812) {
                class_1812 PI = (class_1812)class_17922;
                if (class_1844.method_8063((class_1799)plrItem) == class_1847.field_8991 && !(PI instanceof class_1828)) {
                    if (!player.method_31549().field_7477) {
                        plrItem.method_7934(1);
                        player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8469));
                    }
                    this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14779, class_3419.field_15254, 1.0f, 0.9f);
                    this.setActivated(true);
                    return class_1269.field_5812;
                }
            }
        }
        return class_1269.field_21466;
    }

    @Override
    public boolean needsActive() {
        return false;
    }

    @Override
    protected void method_5693() {
        if (!this.field_6011.method_51696(RANDOM_SIZE)) {
            super.method_5693();
            this.field_6011.method_12784(RANDOM_SIZE, (Object)Float.valueOf(0.0f));
            this.field_6011.method_12784(ACTIVATED, (Object)false);
        }
    }

    @Override
    public void method_5652(class_2487 $$0) {
        $$0.method_10548("roundabout.randomSize", this.getRandomSize());
        $$0.method_10556("roundabout.activated", this.getActivated());
        super.method_5652($$0);
    }

    @Override
    public void method_5749(class_2487 $$0) {
        this.setRandomSize($$0.method_10583("roundabout.randomSize"));
        this.setActivated($$0.method_10577("roundabout.activated"));
        super.method_5749($$0);
    }
}

