/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.fates.powers;

import net.hydra.jojomod.access.AccessFateFoodData;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.fates.FatePowers;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class VampiricFate
extends FatePowers {
    public static final byte BLOOD_SUCK = 27;
    public static final byte BLOOD_SPEED = 28;
    public static final byte BLOOD_REGEN = 29;
    public static final byte WALL_WALK = 30;
    public class_2350 wallWalkDirection = class_2350.field_11033;
    public float walkDistLast = 0.0f;
    public int speedActivated = 0;
    public int justFlippedTicks = 0;
    public final float bloodSpread = 3.0f;
    public final int duration = 100;
    public int mercyTicks = 0;
    public class_1297 bloodSuckingTarget = null;
    public float sunkRegen = 0.0f;
    public class_2680 saveState = null;

    public VampiricFate(class_1309 self) {
        super(self);
    }

    public VampiricFate() {
    }

    public class_2350 getWallWalkDirection() {
        return this.wallWalkDirection;
    }

    public void setWallWalkDirection(class_2350 dir) {
        this.wallWalkDirection = dir;
    }

    public void wallLatch() {
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.setCooldown((byte)2, 10);
            if (!this.self.method_37908().method_8608()) {
                if (this.saveState != null) {
                    this.self.method_37908().method_8396(null, this.self.method_24515(), this.saveState.method_26231().method_10595(), class_3419.field_15248, 1.0f, 0.9f);
                    this.blockBreakParticles(this.saveState.method_26204(), new class_243(this.self.method_23317(), this.self.method_23318(), this.self.method_23321()));
                }
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.WALL_LATCH_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                class_2350 gd = RotationUtil.getRealFacingDirection2(this.self);
                this.setWallWalkDirection(gd);
                ((IGravityEntity)this.self).roundabout$setGravityDirection(gd);
                this.justFlippedTicks = 7;
            }
        }
    }

    public void blockBreakParticles(class_2248 block, class_243 pos) {
        if (!this.self.method_37908().method_8608()) {
            ((class_3218)this.self.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, block.method_9564()), pos.field_1352, pos.field_1351, pos.field_1350, 100, 0.2, 0.2, 0.2, 0.5);
        }
    }

    public boolean isFast() {
        return this.speedActivated > 0;
    }

    public int getSpeedActivated() {
        return this.speedActivated;
    }

    public void setSpeedActivated(int sped) {
        this.speedActivated = sped;
    }

    @Override
    public void tickPower() {
        this.tickBloodSuck();
        this.tickSpeed();
        this.tickBloodRegen();
        super.tickPower();
        if (this.self.method_37908().method_8608()) {
            if (this.isPlantedInWall() && !this.getStandUserSelf().rdbt$getJumping() && !this.self.method_24828() && this.self.method_18798().field_1351 < 0.0) {
                this.self.method_18799(this.self.method_18798().method_1031(0.0, -0.14, 0.0));
            }
        } else {
            if (this.self.method_5681()) {
                this.setWallWalkDirection(this.getIntendedDirection());
            }
            if (this.isPlantedInWall()) {
                if (this.justFlippedTicks > 0) {
                    --this.justFlippedTicks;
                } else {
                    boolean isOnValidBlock;
                    class_243 newVec = new class_243(0.0, -0.2, 0.0);
                    class_243 newVec2 = new class_243(0.0, -1.0, 0.0);
                    class_243 newVec4 = new class_243(0.0, -0.5, 0.0);
                    class_243 newVec5 = new class_243(0.0, -1.1, 0.0);
                    newVec = RotationUtil.vecPlayerToWorld(newVec, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec));
                    newVec2 = RotationUtil.vecPlayerToWorld(newVec2, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos2 = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec2));
                    newVec4 = RotationUtil.vecPlayerToWorld(newVec4, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos4 = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec4));
                    newVec5 = RotationUtil.vecPlayerToWorld(newVec5, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos5 = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec5));
                    class_2680 state1 = this.self.method_37908().method_8320(pos);
                    class_2680 state2 = this.self.method_37908().method_8320(pos2);
                    class_2680 state4 = this.self.method_37908().method_8320(pos4);
                    class_2680 state5 = this.self.method_37908().method_8320(pos5);
                    boolean bl = isOnValidBlock = MainUtil.isBlockWalkableSimplified(state1) && MainUtil.isBlockWalkableSimplified(state4);
                    this.mercyTicks = this.self.method_24828() && MainUtil.isBlockWalkableSimplified(this.self.method_25936()) && isOnValidBlock ? 5 : (MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos)) || MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos2)) || MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos4)) || MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos5)) ? --this.mercyTicks : 0);
                    if (this.self.method_6113() || (!this.self.method_24828() || !isOnValidBlock) && this.mercyTicks <= 0 || this.self.method_5668() != this.self) {
                        this.wallWalkDirection = this.getIntendedDirection();
                        ((IGravityEntity)this.self).roundabout$setGravityDirection(this.wallWalkDirection);
                        this.setWallWalkDirection(this.wallWalkDirection);
                    }
                }
            } else {
                this.setWallWalkDirection(this.getIntendedDirection());
            }
        }
    }

    public class_2350 getIntendedDirection() {
        class_2350 rightAxis = class_2350.field_11033;
        class_1293 mi = this.self.method_6112(ModEffects.GRAVITY_FLIP);
        if (mi != null) {
            if (mi.method_5578() == 0) {
                rightAxis = class_2350.field_11043;
            }
            if (mi.method_5578() == 1) {
                rightAxis = class_2350.field_11035;
            }
            if (mi.method_5578() == 2) {
                rightAxis = class_2350.field_11034;
            }
            if (mi.method_5578() == 3) {
                rightAxis = class_2350.field_11039;
            }
            if (mi.method_5578() == 4) {
                rightAxis = class_2350.field_11036;
            }
        }
        return rightAxis;
    }

    public void tickBloodRegen() {
        if (!this.self.method_37908().method_8608() && this.getActivePower() == 29) {
            class_1657 PE;
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof class_1657 && !(PE = (class_1657)class_13092).method_7337()) {
                PE.method_7344().method_7580(0);
            }
            float spreadX = (float)(Math.random() * 3.0 - 1.5);
            float spreadY = (float)(Math.random() * 3.0 - 1.5);
            float spreadZ = (float)(Math.random() * 3.0 - 1.5);
            class_243 shotPos = new class_243((double)spreadX, (double)spreadY, (double)spreadZ);
            class_243 spawnPos = shotPos.method_1019(this.self.method_5836(1.0f));
            shotPos = shotPos.method_18806(new class_243(-1.0, -1.0, -1.0));
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.BLOOD_MIST, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, 0, shotPos.field_1352, shotPos.field_1351, shotPos.field_1350, 0.03);
            float healthBack = this.sunkRegen / 100.0f * 0.9f;
            float health = this.self.method_6032();
            float maxHealth = this.self.method_6063();
            if (health < maxHealth) {
                if ((health += healthBack) < maxHealth) {
                    this.self.method_6033(health);
                } else {
                    this.self.method_6033(maxHealth);
                }
            }
            if (this.attackTimeDuring > 100 || this.self.method_6032() >= maxHealth) {
                this.xTryPower((byte)0, true);
                this.stopSoundsIfNearby((byte)-6, 100.0, false);
                this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.BLOOD_REGEN_FINISH_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public void tickSpeed() {
        if (this.isFast()) {
            class_1309 class_13092;
            this.setSpeedActivated(this.getSpeedActivated() - 1);
            if (!this.isFast() && (class_13092 = this.self) instanceof class_1657) {
                class_1657 pl = (class_1657)class_13092;
                if (this.self.method_37908().method_8608()) {
                    C2SPacketUtil.trySingleBytePacket((byte)32);
                } else {
                    S2CPacketUtil.sendGenericIntToClientPacket(pl, (byte)9, 0);
                }
            }
        }
    }

    public boolean isOnWrongAxis() {
        if (this.self.method_37908().method_8608()) {
            return ClientUtil.getDirectionRight(this.self);
        }
        class_2350 rightAxis = class_2350.field_11033;
        class_1293 mi = this.self.method_6112(ModEffects.GRAVITY_FLIP);
        if (mi != null) {
            if (mi.method_5578() == 0) {
                rightAxis = class_2350.field_11043;
            }
            if (mi.method_5578() == 1) {
                rightAxis = class_2350.field_11035;
            }
            if (mi.method_5578() == 2) {
                rightAxis = class_2350.field_11034;
            }
            if (mi.method_5578() == 3) {
                rightAxis = class_2350.field_11039;
            }
            if (mi.method_5578() == 4) {
                rightAxis = class_2350.field_11036;
            }
        }
        return ((IGravityEntity)this.self).roundabout$getGravityDirection() != rightAxis;
    }

    public void tickBloodSuck() {
        if (!this.self.method_37908().method_8608()) {
            class_1297 TE;
            if (this.self.method_6115() && (this.bloodSuckingTarget != null || this.getActivePower() == 27)) {
                this.bloodSuckingTarget = null;
                this.xTryPower((byte)0, true);
            }
            if (this.bloodSuckingTarget != null && (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (class_1297)this.self) && this.self.field_6235 <= 0 && this.bloodSuckingTarget.method_5779(TE)) {
                if (TE instanceof class_1309) {
                    class_1309 LE = (class_1309)TE;
                    ((StandUser)LE).roundabout$setDazed((byte)3);
                    LE.method_18800(0.0, (double)-0.1f, 0.0);
                }
                if (this.self.field_6012 % 2 == 0) {
                    double random = Math.random() * 0.8 - 0.4;
                    double random2 = Math.random() * 0.8 - 0.4;
                    double random3 = Math.random() * 0.8 - 0.4;
                    class_2400 particle = ModParticles.BLOOD;
                    if (MainUtil.hasBlueBlood(TE)) {
                        particle = ModParticles.BLUE_BLOOD;
                    }
                    ((class_3218)this.self.method_37908()).method_14199((class_2394)particle, TE.method_23317() + random, TE.method_23318() + (double)TE.method_5751() + random2, TE.method_23321() + random3, 0, this.self.method_23317() - TE.method_23317(), this.self.method_23318() - TE.method_23318() + (double)TE.method_5751(), this.self.method_23321() - TE.method_23321(), 0.08);
                }
            }
            if (this.getActivePower() == 27) {
                if (this.attackTimeDuring == 0 || this.attackTimeDuring == 5) {
                    this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.BLOOD_SUCK_EVENT, class_3419.field_15248, 1.0f, 0.95f + (float)(Math.random() * 0.1));
                }
                if (this.attackTimeDuring >= 20) {
                    this.finishSucking();
                    this.bloodSuckingTarget = null;
                }
            }
        } else {
            class_1297 TE;
            if (!(this.bloodSuckingTarget == null || (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (class_1297)this.self) && this.self.field_6235 <= 0 && this.bloodSuckingTarget.method_5779(TE))) {
                this.xTryPower((byte)0, true);
                C2SPacketUtil.cancelSuckingPacket();
                this.bloodSuckingTarget = null;
            }
            if (this.getActivePower() == 27 && this.attackTimeDuring >= 20 && this.isPacketPlayer() && this.attackTimeDuring == 20) {
                C2SPacketUtil.finishSuckingPacket();
            }
        }
    }

    public void packetFinish() {
        if (this.getActivePower() == 27) {
            this.finishSucking();
        }
    }

    public void packetCancel() {
        if (this.getActivePower() == 27) {
            this.xTryPower((byte)0, true);
        }
        this.bloodSuckingTarget = null;
    }

    public boolean canUseBloodSpeed() {
        class_1657 PE;
        class_1309 class_13092 = this.self;
        return class_13092 instanceof class_1657 && (PE = (class_1657)class_13092).method_7344().method_7586() >= 10 && !this.isFast() && this.getActivePower() != 29;
    }

    public boolean canUseRegen() {
        class_1657 PE;
        class_1309 class_13092 = this.self;
        return class_13092 instanceof class_1657 && (PE = (class_1657)class_13092).method_7344().method_7586() >= 1 && !this.isFast() && this.getActivePower() != 29;
    }

    public void regenClient() {
        if (this.canUseRegen() && !this.onCooldown((byte)15)) {
            this.tryPowerPacket((byte)29);
        }
    }

    public void bloodSpeedClient() {
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.doWallLatchClient();
        } else if (this.canUseBloodSpeed() && !this.onCooldown((byte)15)) {
            this.tryPowerPacket((byte)28);
        }
    }

    public void dashOrWallWalk() {
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.doWallLatchClient();
        } else if (!this.isPlantedInWall()) {
            this.dash();
        }
    }

    public void doWallLatchClient() {
        if (!this.onCooldown((byte)12)) {
            ((StandUser)this.getSelf()).roundabout$tryPower(30, true);
            this.tryPowerPacket((byte)30);
        }
    }

    public void bloodRegen() {
        if (this.canUseRegen()) {
            class_1657 PE;
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof class_1657 && !(PE = (class_1657)class_13092).method_7337()) {
                int foodLevel = PE.method_7344().method_7586();
                this.sunkRegen = foodLevel;
                PE.method_7344().method_7580(0);
            }
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)29);
            this.playSoundsIfNearby((byte)-6, 100.0, true);
        }
    }

    public void bloodSpeed() {
        if (this.canUseBloodSpeed()) {
            class_1657 PE;
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof class_1657 && !(PE = (class_1657)class_13092).method_7337()) {
                int foodLevel = PE.method_7344().method_7586();
                PE.method_7344().method_7580(foodLevel - 10);
            }
            this.setFast();
            this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.BLOOD_SPEED_EVENT, class_3419.field_15248, 1.0f, 0.95f + (float)(Math.random() * 0.1));
        }
    }

    public boolean isVisionOn() {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.dynamicSettings != null) {
            return clientConfig.dynamicSettings.vampireVisionMode;
        }
        return true;
    }

    @Override
    public boolean interceptAttack() {
        return this.getActivePower() == 27;
    }

    public void clientChangeVision() {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.dynamicSettings != null) {
            clientConfig.dynamicSettings.vampireVisionMode = clientConfig.dynamicSettings.vampireVisionMode == false;
            ConfigManager.saveClientConfig();
        }
    }

    public boolean isPlantedInWall() {
        return this.isOnWrongAxis();
    }

    public boolean forceBlock() {
        return !MainUtil.isBlockWalkableSimplified(this.self.method_37908().method_8320(this.self.method_23312()));
    }

    public boolean canLatchOntoWall() {
        class_2680 bs;
        if (this.onCooldown((byte)1) || this.self.method_5681()) {
            return false;
        }
        if (this.forceBlock()) {
            return false;
        }
        if (this.self.method_24828() && !this.isPlantedInWall() || !this.self.method_24828() && this.isPlantedInWall()) {
            return false;
        }
        class_243 mpos = this.self.method_30950(1.0f);
        class_2350 gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        switch (gravdir) {
            case field_11033: {
                mpos = mpos.method_1031(0.0, (double)0.1f, 0.0);
                break;
            }
            case field_11036: {
                mpos = mpos.method_1031(0.0, (double)-0.1f, 0.0);
                break;
            }
            case field_11043: {
                mpos = mpos.method_1031(0.0, 0.0, (double)0.1f);
                break;
            }
            case field_11035: {
                mpos = mpos.method_1031(0.0, 0.0, (double)-0.1f);
                break;
            }
            case field_11039: {
                mpos = mpos.method_1031((double)0.1f, 0.0, 0.0);
                break;
            }
            case field_11034: {
                mpos = mpos.method_1031((double)-0.1f, 0.0, 0.0);
            }
        }
        class_2338 pos1 = class_2338.method_49638((class_2374)mpos);
        class_2350 rd = RotationUtil.getRealFacingDirection2(this.self);
        if (rd == gravdir) {
            return false;
        }
        pos1 = pos1.method_10093(RotationUtil.getRealFacingDirection2(this.self));
        this.saveState = bs = this.self.method_37908().method_8320(pos1);
        return MainUtil.isBlockWalkable(bs);
    }

    public void finishSucking() {
        class_1309 class_13092;
        if (this.bloodSuckingTarget != null && (class_13092 = this.self) instanceof class_1657) {
            class_1297 class_12972;
            class_1657 pl = (class_1657)class_13092;
            boolean canDrainGood = MainUtil.canDrinkBloodCrit(this.bloodSuckingTarget, (class_1297)this.self);
            class_1282 sauce = ModDamageTypes.of(this.self.method_37908(), ModDamageTypes.BLOOD_DRAIN);
            if (this.bloodSuckingTarget.method_5643(sauce, this.getSuckDamage()) && (class_12972 = this.bloodSuckingTarget) instanceof class_1309) {
                class_1309 LE = (class_1309)class_12972;
                if (canDrainGood) {
                    if (pl.method_7332(false)) {
                        pl.method_7344().method_7585(6, 1.0f);
                    } else if (((AccessFateFoodData)pl.method_7344()).rdbt$getRealSaturation() < 7.0f) {
                        pl.method_7344().method_7585(6, 0.5f);
                    } else {
                        pl.method_7344().method_7585(6, 0.0f);
                    }
                    this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.BLOOD_SUCK_DRAIN_EVENT, class_3419.field_15248, 1.0f, 1.4f + (float)(Math.random() * 0.1));
                    this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), class_3417.field_15016, class_3419.field_15248, 1.0f, 1.0f + (float)(Math.random() * 0.1));
                    boolean $$23 = true;
                    ((class_3218)this.self.method_37908()).method_14199((class_2394)class_2398.field_11205, this.bloodSuckingTarget.method_33571().field_1352, this.bloodSuckingTarget.method_33571().field_1351, this.bloodSuckingTarget.method_33571().field_1350, 15, 0.2, 0.2, 0.2, 0.0);
                } else {
                    this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.BLOOD_SUCK_DRAIN_EVENT, class_3419.field_15248, 1.0f, 1.4f + (float)(Math.random() * 0.1));
                    pl.method_7344().method_7585(2, 0.0f);
                }
                MainUtil.makeBleed(this.bloodSuckingTarget, 0, 200, null);
            }
            this.bloodSuckingTarget = null;
            this.xTryPower((byte)0, true);
        }
    }

    public void suckBlood() {
        class_1297 TE;
        if (!this.onCooldown((byte)11) && (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (class_1297)this.self) && this.getActivePower() != 29) {
            this.setActivePower((byte)27);
            this.self.method_5728(false);
            this.tryIntPowerPacket((byte)27, TE.method_5628());
            this.bloodSuckingTarget = TE;
            this.attackTimeDuring = 0;
            this.setCooldown((byte)11, 44);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (this.activePower == 27 && move != 27 && !this.self.method_37908().method_8608()) {
            super.setPlayerPos2((byte)0);
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 27) {
            this.bloodSuckingTarget = this.self.method_37908().method_8469(chargeTime);
            this.setActivePower((byte)27);
            this.self.method_5728(false);
            if (!this.self.method_37908().method_8608()) {
                super.setPlayerPos2((byte)1);
            }
            this.attackTimeDuring = 0;
            if (this.bloodSuckingTarget != null) {
                this.bloodSuckingTarget.method_18799(class_243.field_1353);
            }
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.isPlantedInWall()) {
            basis *= 0.5f;
        }
        if (this.getActivePower() == 27) {
            basis *= 0.2f;
        } else if (this.getActivePower() == 29) {
            basis *= 0.1f;
        } else if (this.isFast()) {
            basis *= 2.0f;
        }
        return basis;
    }

    public void setFast() {
        this.speedActivated = 120;
        if (!this.self.method_37908().method_8608()) {
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof class_1657) {
                class_1657 pl = (class_1657)class_13092;
                S2CPacketUtil.sendGenericIntToClientPacket(pl, (byte)9, this.speedActivated);
            }
            this.speedActivated += 60;
        }
    }

    @Override
    public float zoomMod() {
        if (this.getActivePower() == 27) {
            return 0.6f;
        }
        if (this.isFast()) {
            return 1.1f;
        }
        return 1.0f;
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 28) {
            this.bloodSpeed();
        } else if (move == 29) {
            this.bloodRegen();
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        class_1297 TE;
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8 - 1;
        if (!standOn && (TE = this.getTargetEntity((class_1309)playerEntity, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (class_1297)this.self)) {
            class_1309 LE;
            if (this.getActivePower() == 27) {
                int test = (int)(0.85f * (float)class_3532.method_15340((int)this.attackTimeDuring, (int)0, (int)20));
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 192, 36, 17, 8);
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 192, 44, 17 - test, 8);
            } else if (TE instanceof class_1309 && (LE = (class_1309)TE).method_6032() - this.getSuckDamage() <= 0.0f) {
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 192, 52, 17, 8);
            } else {
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 192, 44, 17, 8);
            }
        }
    }

    public float getSuckDamage() {
        return 4.0f;
    }

    @Override
    public boolean cancelSprintJump() {
        return this.getActivePower() == 27 || this.getActivePower() == 29;
    }

    @Override
    public boolean cancelSprint() {
        return this.getActivePower() == 27 || this.getActivePower() == 29;
    }

    @Override
    public boolean cancelSprintParticles() {
        return this.getActivePower() == 27 || this.getActivePower() == 29 || this.isPlantedInWall();
    }

    @Override
    public boolean cancelJump() {
        return this.getActivePower() == 29;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        class_1297 TE = this.getUserData(this.self).roundabout$getStandPowers().getTargetEntity(this.self, 3.0f, 15.0f);
        if (slot == 2 && !MainUtil.canDrinkBloodFair(TE, (class_1297)this.self) && !this.isHoldingSneak()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    public boolean canWallWalkConfig() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableWallWalking;
    }

    @Override
    public class_2960 getIconYes(int slot) {
        if ((slot == 2 || slot == 3) && this.isHoldingSneak()) {
            return StandIcons.SQUARE_ICON_BLOOD;
        }
        return StandIcons.SQUARE_ICON;
    }
}

