/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.Nullable;

public class FollowingStandEntity
extends StandEntity {
    protected static final class_2940<Integer> ANCHOR_PLACE = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> ANCHOR_PLACE_ATTACK = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Byte> OFFSET_TYPE = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Float> DISTANCE_OUT = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> SIZE_PERCENT = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> IDLE_ROTATION = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> IDLE_Y_OFFSET = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13320);
    public byte lastOffsetType = 0;
    @Nullable
    public class_1309 Following;
    protected static final class_2940<Integer> FOLLOWING_ID = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Byte> MOVE_FORWARD = class_2945.method_12791(FollowingStandEntity.class, (class_2941)class_2943.field_13319);

    protected FollowingStandEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    public final void setAnchorPlace(Integer degrees) {
        this.field_6011.method_12778(ANCHOR_PLACE, (Object)degrees);
    }

    public final void setAnchorPlaceAttack(Integer degrees) {
        this.field_6011.method_12778(ANCHOR_PLACE_ATTACK, (Object)degrees);
    }

    public final void setDistanceOut(float blocks) {
        this.field_6011.method_12778(DISTANCE_OUT, (Object)Float.valueOf(blocks));
    }

    public final float getDistanceOut() {
        return ((Float)this.field_6011.method_12789(DISTANCE_OUT)).floatValue();
    }

    public final void setSizePercent(float blocks) {
        this.field_6011.method_12778(SIZE_PERCENT, (Object)Float.valueOf(blocks));
    }

    public final float getSizePercent() {
        return ((Float)this.field_6011.method_12789(SIZE_PERCENT)).floatValue();
    }

    public final void setIdleRotation(float blocks) {
        this.field_6011.method_12778(IDLE_ROTATION, (Object)Float.valueOf(blocks));
    }

    public final float getIdleRotation() {
        return ((Float)this.field_6011.method_12789(IDLE_ROTATION)).floatValue();
    }

    public final void setIdleYOffset(float blocks) {
        this.field_6011.method_12778(IDLE_Y_OFFSET, (Object)Float.valueOf(blocks));
    }

    public final float getIdleYOffset() {
        return ((Float)this.field_6011.method_12789(IDLE_Y_OFFSET)).floatValue();
    }

    public final int getAnchorPlace() {
        return (Integer)this.field_6011.method_12789(ANCHOR_PLACE);
    }

    public final int getAnchorPlaceAttack() {
        return (Integer)this.field_6011.method_12789(ANCHOR_PLACE_ATTACK);
    }

    public final byte getOffsetType() {
        if (this.method_37908().method_8608() && ClientUtil.getScreenFreeze()) {
            return this.lastOffsetType;
        }
        return (Byte)this.field_6011.method_12789(OFFSET_TYPE);
    }

    @Override
    public boolean redirectKnockbackToUser() {
        return true;
    }

    public final void setOffsetType(byte oft) {
        this.field_6011.method_12778(OFFSET_TYPE, (Object)oft);
    }

    @Override
    public void method_5773() {
        this.validateUUID();
        float pitch = this.method_36455();
        float yaw = this.method_36454();
        byte ot = this.getOffsetType();
        if (this.lastOffsetType != ot) {
            this.lastOffsetType = ot;
        }
        super.method_5773();
        if (!this.method_37908().method_8608() && !this.forceVisible && OffsetIndex.OffsetStyle(ot) == 2) {
            this.method_36457(pitch);
            this.method_36456(yaw);
            this.method_5636(yaw);
            this.field_6004 = pitch;
            this.field_5982 = yaw;
        }
    }

    public class_243 getStandOffsetVector(class_1309 standUser) {
        byte ot = this.getOffsetType();
        if (OffsetIndex.OffsetStyle(ot) == 0) {
            return this.getIdleOffset(standUser);
        }
        if (OffsetIndex.OffsetStyle(ot) == 1) {
            class_2350 direction = ((IGravityEntity)standUser).roundabout$getGravityDirection();
            class_243 finalized = this.getAttackOffset(standUser, ot);
            if (direction != class_2350.field_11033) {
                finalized = RotationUtil.vecPlayerToWorld(finalized.method_1020(standUser.method_19538()), direction).method_1019(standUser.method_19538());
            }
            return finalized;
        }
        return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public class_243 getAttackOffset(class_1309 standUser, byte ot) {
        float distanceFront;
        if (ot == 6) {
            class_243 frontVectors = this.FrontVectors((class_1297)standUser, 180.0, 0.0f);
            return new class_243(frontVectors.field_1352, frontVectors.field_1351 - 1.1, frontVectors.field_1350);
        }
        float standrotDir2 = 0.0f;
        float standrotDir = (float)this.getPunchYaw(this.getAnchorPlaceAttack(), 1.0);
        if (standrotDir > 0.0f) {
            standrotDir2 = 90.0f;
        } else if (standrotDir < 0.0f) {
            standrotDir2 = -90.0f;
        }
        float addY = 0.3f;
        float addXYZ = 0.3f;
        float addXZ = 0.7f;
        if (ot == 2 || ot == 8) {
            addXZ -= 0.015f;
            distanceFront = 1.05f;
        } else if (ot == 9) {
            addXZ += 0.15f;
            distanceFront = 1.05f;
        } else {
            distanceFront = ((StandUser)standUser).roundabout$getStandPowers().getDistanceOutAccurate((class_1297)standUser, ((StandUser)standUser).roundabout$getStandReach(), true);
        }
        class_243 frontVectors = this.FrontVectors((class_1297)standUser, 0.0, distanceFront);
        class_243 vec3d2 = DamageHandler.getRotationVector(0.0f, standUser.method_5791() + standrotDir2);
        frontVectors = frontVectors.method_1031(vec3d2.field_1352 * (double)addXZ, 0.0, vec3d2.field_1350 * (double)addXZ);
        return new class_243(frontVectors.field_1352, frontVectors.field_1351 + (double)standUser.method_18381(standUser.method_18376()) + (double)addY - 1.6, frontVectors.field_1350);
    }

    public class_243 getIdleOffset(class_1309 standUser) {
        int vis = this.getFadeOut();
        double r = (double)vis / 8.0 * (double)(standUser.method_17681() / 2.0f + this.getDistanceOut());
        if (r < 0.5) {
            r = 0.5;
        }
        double yawfix = standUser.method_36454();
        if ((yawfix += (double)this.getAnchorPlace()) > 360.0) {
            yawfix -= 360.0;
        } else if (yawfix < 0.0) {
            yawfix += 360.0;
        }
        double ang = (yawfix - 180.0) * Math.PI;
        double mcap = 0.3;
        class_243 xyz = standUser.method_18798();
        double yy = xyz.method_10214() * 0.3;
        if (yy > mcap) {
            yy = mcap;
        } else if (yy < -mcap) {
            yy = -mcap;
        }
        if (this.method_5681() || this.method_20448() || this.method_6128()) {
            yy += 1.0;
        }
        class_2350 dir = ((IGravityEntity)standUser).roundabout$getGravityDirection();
        class_243 offset = new class_243(-(-1.0 * (r * Math.sin(ang / 180.0))), (double)this.getIdleYOffset() - yy, -(r * Math.cos(ang / 180.0)));
        if (dir != class_2350.field_11033) {
            offset = RotationUtil.vecPlayerToWorld(offset, dir);
        }
        double x1 = standUser.method_23317() + offset.field_1352;
        double y1 = standUser.method_23318() + offset.field_1351;
        double z1 = standUser.method_23321() + offset.field_1350;
        return new class_243(x1, y1, z1);
    }

    public class_1309 getFollowing() {
        if (this.method_37908().field_9236) {
            return (class_1309)this.method_37908().method_8469(((Integer)this.field_6011.method_12789(FOLLOWING_ID)).intValue());
        }
        if (this.Following != null && this.Following.method_31481()) {
            this.setFollowing(null);
        }
        return this.Following;
    }

    @Override
    public boolean canBeHitByStands() {
        return this.isRemoteControlled() || this.getFollowing() != this.getUser() || this.getFollowing() == null && this.getUser() == null;
    }

    @Override
    public void setFollowing(class_1309 StandSet) {
        this.Following = StandSet;
        int standSetId = -1;
        if (StandSet != null) {
            standSetId = StandSet.method_5628();
        }
        this.field_6011.method_12778(FOLLOWING_ID, (Object)standSetId);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FOLLOWING_ID, (Object)-1);
        this.field_6011.method_12784(OFFSET_TYPE, (Object)0);
        this.field_6011.method_12784(ANCHOR_PLACE, (Object)55);
        this.field_6011.method_12784(ANCHOR_PLACE_ATTACK, (Object)55);
        this.field_6011.method_12784(DISTANCE_OUT, (Object)Float.valueOf(1.07f));
        this.field_6011.method_12784(MOVE_FORWARD, (Object)0);
        this.field_6011.method_12784(SIZE_PERCENT, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(IDLE_ROTATION, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(IDLE_Y_OFFSET, (Object)Float.valueOf(0.1f));
    }

    public final void setMoveForward(Byte MF) {
        this.field_6011.method_12778(MOVE_FORWARD, (Object)MF);
    }

    public final byte getMoveForward() {
        return (Byte)this.field_6011.method_12789(MOVE_FORWARD);
    }

    public void tickStandOut() {
        byte ot = this.getOffsetType();
        if (this.lockPos()) {
            this.method_18799(class_243.field_1353);
        }
        this.method_5773();
        if (this.getFollowing() == null) {
            return;
        }
        if (OffsetIndex.OffsetStyle(ot) != 2 || this.method_5787()) {
            ((StandUser)this.getFollowing()).roundabout$updateStandOutPosition(this);
        }
    }
}

