/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class StoneMaskBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    @Nullable
    private BlockPattern snowGolemBase;
    @Nullable
    private BlockPattern snowGolemFull;
    @Nullable
    private BlockPattern ironGolemBase;
    @Nullable
    private BlockPattern ironGolemFull;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = $$0 -> $$0 != null && ($$0.m_60713_(Blocks.f_50143_) || $$0.m_60713_(Blocks.f_50144_));

    protected StoneMaskBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6807_(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.m_60713_($$0.m_60734_())) {
            this.trySpawnGolem($$1, $$2);
        }
    }

    public boolean canSpawnGolem(LevelReader $$0, BlockPos $$1) {
        return this.getOrCreateSnowGolemBase().m_61184_($$0, $$1) != null || this.getOrCreateIronGolemBase().m_61184_($$0, $$1) != null;
    }

    private void trySpawnGolem(Level $$0, BlockPos $$1) {
        BlockPattern.BlockPatternMatch $$2 = this.getOrCreateSnowGolemFull().m_61184_((LevelReader)$$0, $$1);
        if ($$2 != null) {
            SnowGolem $$3 = (SnowGolem)EntityType.f_20528_.m_20615_($$0);
            if ($$3 != null) {
                StoneMaskBlock.spawnGolemInWorld($$0, $$2, (Entity)$$3, $$2.m_61229_(0, 2, 0).m_61176_());
            }
        } else {
            IronGolem $$5;
            BlockPattern.BlockPatternMatch $$4 = this.getOrCreateIronGolemFull().m_61184_((LevelReader)$$0, $$1);
            if ($$4 != null && ($$5 = (IronGolem)EntityType.f_20460_.m_20615_($$0)) != null) {
                $$5.m_28887_(true);
                StoneMaskBlock.spawnGolemInWorld($$0, $$4, (Entity)$$5, $$4.m_61229_(1, 2, 0).m_61176_());
            }
        }
    }

    private static void spawnGolemInWorld(Level $$0, BlockPattern.BlockPatternMatch $$1, Entity $$2, BlockPos $$3) {
        StoneMaskBlock.clearPatternBlocks($$0, $$1);
        $$2.m_7678_((double)$$3.m_123341_() + 0.5, (double)$$3.m_123342_() + 0.05, (double)$$3.m_123343_() + 0.5, 0.0f, 0.0f);
        $$0.m_7967_($$2);
        for (ServerPlayer $$4 : $$0.m_45976_(ServerPlayer.class, $$2.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_($$4, $$2);
        }
        StoneMaskBlock.updatePatternBlocks($$0, $$1);
    }

    public static void clearPatternBlocks(Level $$0, BlockPattern.BlockPatternMatch $$1) {
        for (int $$2 = 0; $$2 < $$1.m_155970_(); ++$$2) {
            for (int $$3 = 0; $$3 < $$1.m_155971_(); ++$$3) {
                BlockInWorld $$4 = $$1.m_61229_($$2, $$3, 0);
                $$0.m_7731_($$4.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                $$0.m_46796_(2001, $$4.m_61176_(), Block.m_49956_((BlockState)$$4.m_61168_()));
            }
        }
    }

    public static void updatePatternBlocks(Level $$0, BlockPattern.BlockPatternMatch $$1) {
        for (int $$2 = 0; $$2 < $$1.m_155970_(); ++$$2) {
            for (int $$3 = 0; $$3 < $$1.m_155971_(); ++$$3) {
                BlockInWorld $$4 = $$1.m_61229_($$2, $$3, 0);
                $$0.m_6289_($$4.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext $$0) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)$$0.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.m_61104_(new Property[]{FACING});
    }

    private BlockPattern getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();
        }
        return this.snowGolemBase;
    }

    private BlockPattern getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#", "#"}).m_61244_('^', BlockInWorld.m_61169_(PUMPKINS_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();
        }
        return this.snowGolemFull;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', $$0 -> $$0.m_61168_().m_60795_()).m_61249_();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(PUMPKINS_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', $$0 -> $$0.m_61168_().m_60795_()).m_61249_();
        }
        return this.ironGolemFull;
    }
}

