/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.IPlayerModel;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.ModStrayModels;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.stand.powers.PowersMandom;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MandomLayer<T extends LivingEntity, A extends HumanoidModel<T>>
extends RenderLayer<T, A> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final EntityRenderDispatcher dispatcher;
    float scale = 1.0f;

    public MandomLayer(EntityRendererProvider.Context context, LivingEntityRenderer<T, A> livingEntityRenderer) {
        super(livingEntityRenderer);
        this.dispatcher = context.m_174022_();
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float var5, float var6, float var7, float partialTicks, float var9, float var10) {
        if (entity != null) {
            Player PL;
            byte style;
            int mandomTicks;
            boolean hasMandomOut;
            if (((IEntityAndData)entity).roundabout$getTrueInvisibility() > -1 && !ClientUtil.checkIfClientCanSeeInvisAchtung()) {
                return;
            }
            StandUser user = (StandUser)entity;
            boolean hasMandom = user.roundabout$getStandPowers() instanceof PowersMandom;
            boolean bl = hasMandomOut = user.roundabout$getActive() && hasMandom;
            if (ClientUtil.canSeeStands(ClientUtil.getPlayer()) && !entity.m_20145_() && ((mandomTicks = user.roundabout$getMandomVanishTicks()) > 0 || hasMandomOut)) {
                byte skin = user.roundabout$getStandSkin();
                if (user.roundabout$getLastStandSkin() != skin) {
                    user.roundabout$setLastStandSkin(skin);
                    mandomTicks = 0;
                    user.roundabout$setMandomVanishTicks(0);
                }
                float heyFull = 0.0f;
                float fixedPartial = partialTicks - (float)((int)partialTicks);
                if (((TimeStop)entity.m_9236_()).CanTimeStopEntity((Entity)entity)) {
                    fixedPartial = 0.0f;
                }
                if (hasMandomOut) {
                    heyFull = (float)mandomTicks + fixedPartial;
                    heyFull = Math.min(heyFull / 10.0f, 1.0f);
                } else {
                    heyFull = (float)mandomTicks - fixedPartial;
                    heyFull = Math.max(heyFull / 10.0f, 0.0f);
                }
                ClientUtil.pushPoseAndCooperate(poseStack, 26);
                ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
                boolean isHurt = ((LivingEntity)entity).f_20916_ > 0;
                float r = isHurt ? 1.0f : 1.0f;
                float g = isHurt ? 0.4f : 1.0f;
                float b = isHurt ? 0.4f : 1.0f;
                ModStrayModels.MANDOM.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, heyFull, skin);
                ClientUtil.popPoseAndCooperate(poseStack, 26);
            }
            if (hasMandom && entity instanceof Player && (style = ((IPlayerEntity)(PL = (Player)entity)).roundabout$getWatchStyle()) != 0) {
                PlayerModel PM;
                poseStack.m_85836_();
                ((HumanoidModel)this.m_117386_()).f_102811_.m_104299_(poseStack);
                boolean isHurt = ((LivingEntity)entity).f_20916_ > 0;
                float r = isHurt ? 1.0f : 1.0f;
                float g = isHurt ? 0.4f : 1.0f;
                float b = isHurt ? 0.4f : 1.0f;
                EntityModel entityModel = this.m_117386_();
                if (entityModel instanceof PlayerModel && ((IPlayerModel)(PM = (PlayerModel)entityModel)).roundabout$getSlim()) {
                    ModStrayModels.MANDOM_WATCH_SMALL.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, style);
                } else {
                    ModStrayModels.MANDOM_WATCH.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, style);
                }
                poseStack.m_85849_();
            }
        }
    }

    public static void renderWatchFirstPerson(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, LivingEntity entity, float var5, float var6, float var7, float partialTicks, float var9, float var10, ModelPart handarm, boolean slim) {
        if (entity != null) {
            Player PL;
            byte style;
            boolean hasMandomOut;
            StandUser user = (StandUser)entity;
            boolean hasMandom = user.roundabout$getStandPowers() instanceof PowersMandom;
            boolean bl = hasMandomOut = user.roundabout$getActive() && hasMandom;
            if (hasMandom && entity instanceof Player && (style = ((IPlayerEntity)(PL = (Player)entity)).roundabout$getWatchStyle()) != 0) {
                float b;
                ClientUtil.pushPoseAndCooperate(poseStack, 54);
                handarm.m_104299_(poseStack);
                boolean isHurt = entity.f_20916_ > 0;
                float r = isHurt ? 1.0f : 1.0f;
                float g = isHurt ? 0.4f : 1.0f;
                float f = b = isHurt ? 0.4f : 1.0f;
                if (slim) {
                    ModStrayModels.MANDOM_WATCH_SMALL.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, style);
                } else {
                    ModStrayModels.MANDOM_WATCH.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, r, g, b, 1.0f, style);
                }
                ClientUtil.popPoseAndCooperate(poseStack, 55);
            }
        }
    }
}

