/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.stand.D4CEntity;
import net.hydra.jojomod.entity.visages.CloneEntity;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersD4C;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class D4CCloneEntity
extends CloneEntity
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> SELECTED = SynchedEntityData.m_135353_(D4CCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vector3f sizeOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public D4CCloneEntity(EntityType<? extends PathfinderMob> entity, Level world) {
        super(entity, world);
    }

    public void m_8119_() {
        if (this.player == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_21008_(InteractionHand.MAIN_HAND, this.player.m_21205_());
            this.m_21008_(InteractionHand.OFF_HAND, this.player.m_21206_());
        } else {
            Player player;
            ItemStack mainHand = this.m_21205_();
            if (mainHand.m_204117_(ItemTags.f_271360_) || mainHand.m_204117_(ItemTags.f_271388_)) {
                // empty if block
            }
            if ((player = ClientUtil.getPlayer()) == null) {
                return;
            }
            StandUser standUserPlayer = (StandUser)player;
            if (standUserPlayer.roundabout$getStand() instanceof D4CEntity && this.player == player) {
                PowersD4C powers = (PowersD4C)standUserPlayer.roundabout$getStandPowers();
                this.setSelected(powers.targetingClone == this);
            }
        }
        super.m_8119_();
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::shouldAngerAt));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, this::shouldAngerAt));
    }

    private boolean shouldAngerAt(LivingEntity entity) {
        return entity instanceof Enemy;
    }

    public boolean m_7327_(Entity target) {
        ItemStack mainHand = this.m_21205_();
        float hurtAmount = (float)this.m_21133_(Attributes.f_22281_);
        if (!mainHand.m_41619_()) {
            Roundabout.LOGGER.info("hurtAmount: {}", (Object)Float.valueOf(hurtAmount += (float)mainHand.m_41773_()));
        }
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        boolean hurt = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), hurtAmount);
        if (hurt) {
            this.m_21011_(InteractionHand.MAIN_HAND, true);
            this.m_21335_(target);
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
        }
        return hurt;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SELECTED, (Object)false);
    }

    public void setSizeOffset(Vector3f value) {
        this.sizeOffset = value;
    }

    public Vector3f getSizeOffset() {
        return this.sizeOffset;
    }

    public void setSelected(boolean value) {
        this.f_19804_.m_135381_(SELECTED, (Object)value);
    }

    public boolean isSelected() {
        return (Boolean)this.m_20088_().m_135370_(SELECTED);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int $$0) {
        this.remainingPersistentAngerTime = $$0;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID $$0) {
        this.persistentAngerTarget = $$0;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

