/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.List;
import net.hydra.jojomod.access.IEnderMan;
import net.hydra.jojomod.block.FogBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersSoftAndWet;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SoftAndWetExplosiveBubbleEntity
extends SoftAndWetBubbleEntity {
    public boolean madeWithBarrage = false;

    public SoftAndWetExplosiveBubbleEntity(EntityType<? extends SoftAndWetExplosiveBubbleEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    public SoftAndWetExplosiveBubbleEntity(LivingEntity $$1, Level $$2) {
        super(ModEntities.EXPLOSIVE_BUBBLE, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    @Override
    public int getDistanceUntilPopping() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.maxExplosiveBubbleTravelDistanceBeforePopping;
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            --this.lifeSpan;
            if (this.lifeSpan <= 0 || this.standUser == null || !(((StandUser)this.standUser).roundabout$getStandPowers() instanceof PowersSoftAndWet)) {
                this.popBubble();
                return;
            }
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.BUBBLE_TRAIL, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.015);
            if (!this.m_213877_()) {
                Vec3 currentPos = this.m_20182_();
                Vec3 nextPos = currentPos.m_82549_(this.m_20184_());
                AABB sweptBox = this.m_20191_().m_82369_(this.m_20184_()).m_82400_((double)(this.m_20205_() * 1.0f) + 0.1);
                EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)sweptBox, x$0 -> this.m_5603_((Entity)x$0));
                if (entityHitResult != null) {
                    this.m_5790_(entityHitResult);
                }
            }
        }
    }

    @Override
    public void popBubble() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.EXPLOSIVE_BUBBLE_POP_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.015);
            this.m_146870_();
        }
    }

    @Override
    protected void m_8060_(BlockHitResult $$0) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_9236_().m_8055_($$0.m_82425_())), $$0.m_82450_().f_82479_, $$0.m_82450_().f_82480_, $$0.m_82450_().f_82481_, 30, 0.2, 0.05, 0.2, 0.3);
            BlockState bs = this.m_9236_().m_8055_($$0.m_82425_());
            if (MainUtil.getIsGamemodeApproriateForGrief(this.m_19749_())) {
                BlockPos relativePos = $$0.m_82425_().m_121945_($$0.m_82434_());
                BlockState bs2 = this.m_9236_().m_8055_(relativePos);
                Block block = bs.m_60734_();
                if (block instanceof TntBlock) {
                    TntBlock tnt = (TntBlock)block;
                    this.m_9236_().m_46953_($$0.m_82425_(), false, this.m_19749_());
                    this.wasExploded(this.m_9236_(), $$0.m_82425_());
                } else if (bs.m_60734_() instanceof AbstractGlassBlock || bs.m_60734_() instanceof StainedGlassPaneBlock || bs.m_60734_().m_49966_().m_60713_(Blocks.f_50185_) || bs.m_204336_(BlockTags.f_13035_) || bs.m_204336_(BlockTags.f_13047_)) {
                    this.m_9236_().m_46953_($$0.m_82425_(), false, this.m_19749_());
                    this.blockBreakParticles(bs.m_60734_(), new Vec3((double)$$0.m_82425_().m_123341_() + 0.5, (double)$$0.m_82425_().m_123342_() + 0.5, (double)$$0.m_82425_().m_123343_() + 0.5));
                    this.m_5496_(bs.m_60734_().m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                } else if (bs.m_247087_() && !(bs.m_60734_() instanceof FogBlock) && !bs.m_278721_()) {
                    this.m_9236_().m_46953_($$0.m_82425_(), false, this.m_19749_());
                    this.blockBreakParticles(bs.m_60734_(), new Vec3((double)relativePos.m_123341_() + 0.5, (double)relativePos.m_123342_() + 0.5, (double)relativePos.m_123343_() + 0.5));
                    this.m_5496_(bs.m_60734_().m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                } else if (bs2.m_247087_() && !(bs2.m_60734_() instanceof FogBlock) && !bs2.m_278721_()) {
                    this.m_9236_().m_46953_(relativePos, false, this.m_19749_());
                    this.blockBreakParticles(bs2.m_60734_(), new Vec3((double)relativePos.m_123341_() + 0.5, (double)relativePos.m_123342_() + 0.5, (double)relativePos.m_123343_() + 0.5));
                    this.m_5496_(bs2.m_60734_().m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                }
            }
        }
        this.popOnGroundWithForce($$0.m_82450_());
    }

    public void blockBreakParticles(Block block, Vec3 pos) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100, 0.0, 0.0, 0.0, 0.5);
        }
    }

    public void wasExploded(Level $$0, BlockPos $$1) {
        if (!$$0.f_46443_) {
            PrimedTnt $$3 = new PrimedTnt($$0, (double)$$1.m_123341_() + 0.5, (double)$$1.m_123342_(), (double)$$1.m_123343_() + 0.5, null);
            int $$4 = $$3.m_32100_();
            $$3.m_32085_((int)((short)($$0.f_46441_.m_188503_($$4 / 4) + $$4 / 8)));
            $$0.m_7967_((Entity)$$3);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult $$0) {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity LE;
            Object object;
            Entity entity = $$0.m_82443_();
            if (entity instanceof EnderMan) {
                EnderMan em = (EnderMan)entity;
                ((IEnderMan)em).roundabout$teleport();
                return;
            }
            Entity ent = $$0.m_82443_();
            if (!(ent instanceof SoftAndWetBubbleEntity) && (object = this.m_19749_()) instanceof LivingEntity && (object = ((StandUser)(LE = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersSoftAndWet) {
                PowersSoftAndWet PW = (PowersSoftAndWet)object;
                if (!MainUtil.isMobOrItsMounts(ent, this.m_19749_()) && !MainUtil.isCreativeOrInvincible(ent)) {
                    float str = PW.getExplosiveBubbleStrength(ent);
                    float kb = 1.05f;
                    if (this.getMadeWithBarrage()) {
                        kb = 0.1f;
                    }
                    if (ent.m_6469_(ModDamageTypes.of(ent.m_9236_(), ModDamageTypes.EXPLOSIVE_STAND, this.m_19749_()), str) && ent instanceof LivingEntity) {
                        LivingEntity LIVE = (LivingEntity)ent;
                        LE.m_21335_((Entity)LIVE);
                        PW.addEXP(1);
                    }
                    float degrees = MainUtil.getLookAtEntityYawWithAngle(ent.m_20182_().m_82549_(this.m_20184_().m_82548_()), ent);
                    MainUtil.takeKnockbackWithY(ent, kb, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
                    this.popBubble();
                }
            }
        }
    }

    public void popOnGroundWithForce(Vec3 location) {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity LE;
            List<Entity> entityList;
            Entity user = this.m_19749_();
            if (user instanceof LivingEntity && !(entityList = DamageHandler.genHitbox(LE = (LivingEntity)user, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0, 3.0, 3.0)).isEmpty()) {
                for (Entity ent : entityList) {
                    StandPowers standPowers;
                    if (ent instanceof SoftAndWetBubbleEntity || !((standPowers = ((StandUser)LE).roundabout$getStandPowers()) instanceof PowersSoftAndWet)) continue;
                    PowersSoftAndWet PW = (PowersSoftAndWet)standPowers;
                    if (MainUtil.isMobOrItsMounts(ent, this.m_19749_()) || MainUtil.isCreativeOrInvincible(ent)) continue;
                    float degrees = MainUtil.getLookAtEntityYawWithAngle(location, ent);
                    MainUtil.takeKnockbackWithY(ent, 0.6f, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
                }
            }
            this.popBubble();
        }
    }

    public void setMadeWithBarrage(boolean made) {
        this.madeWithBarrage = made;
    }

    public boolean getMadeWithBarrage() {
        return this.madeWithBarrage;
    }

    public void popWithForce() {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity LE;
            List<Entity> entityList;
            Entity user = this.m_19749_();
            if (user instanceof LivingEntity && !(entityList = DamageHandler.genHitbox(LE = (LivingEntity)user, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0, 5.0, 5.0)).isEmpty()) {
                for (Entity ent : entityList) {
                    StandPowers standPowers;
                    if (ent instanceof SoftAndWetBubbleEntity || !((standPowers = ((StandUser)LE).roundabout$getStandPowers()) instanceof PowersSoftAndWet)) continue;
                    PowersSoftAndWet PW = (PowersSoftAndWet)standPowers;
                    if (MainUtil.isMobOrItsMounts(ent, this.m_19749_()) || MainUtil.isCreativeOrInvincible(ent)) continue;
                    float degrees = MainUtil.getLookAtEntityYawWithAngle(this.m_20182_(), ent);
                    MainUtil.takeKnockbackWithY(ent, 1.05f, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
                }
            }
            this.popBubble();
        }
    }
}

