/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.List;
import net.hydra.jojomod.access.IEnderMan;
import net.hydra.jojomod.block.FogBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.entity.projectile.ThrownObjectEntity;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersSoftAndWet;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SoftAndWetItemLaunchingBubbleEntity
extends SoftAndWetBubbleEntity {
    public boolean canGiveYouItem = true;
    protected static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(SoftAndWetItemLaunchingBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public boolean hasDitchedItem = false;

    public SoftAndWetItemLaunchingBubbleEntity(EntityType<? extends SoftAndWetItemLaunchingBubbleEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    public SoftAndWetItemLaunchingBubbleEntity(LivingEntity $$1, Level $$2) {
        super(ModEntities.ITEM_LAUNCHING_BUBBLE_ENTITY, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public void m_7380_(CompoundTag $$0) {
        CompoundTag compoundtag = new CompoundTag();
        $$0.m_128365_("roundabout.HeldItem", (Tag)this.getHeldItem().m_41739_(compoundtag));
        $$0.m_128379_("roundabout.ditchedItem", this.hasDitchedItem);
        $$0.m_128379_("roundabout.canGiveYouItem", this.canGiveYouItem);
        $$0.m_128350_("roundabout.speed", this.getSped());
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        CompoundTag compoundtag = $$0.m_128469_("roundabout.HeldItem");
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
        this.hasDitchedItem = $$0.m_128471_("roundabout.ditchedItem");
        this.canGiveYouItem = $$0.m_128471_("roundabout.canGiveYouItem");
        this.setSped($$0.m_128457_("roundabout.speed"));
        this.setHeldItem(itemstack);
        super.m_7378_($$0);
    }

    @Override
    protected float m_6884_() {
        return 0.97f;
    }

    @Override
    public int getDistanceUntilPopping() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.maxExplosiveBubbleTravelDistanceBeforePopping;
    }

    public final ItemStack getHeldItem() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM);
    }

    public final void setHeldItem(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM, (Object)stack);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        if (!this.f_19804_.m_285897_(HELD_ITEM)) {
            this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
        }
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            --this.lifeSpan;
            if (this.lifeSpan <= 0 || this.standUser == null || !(((StandUser)this.standUser).roundabout$getStandPowers() instanceof PowersSoftAndWet)) {
                this.popBubble();
                return;
            }
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            Vec3 currentPos = this.m_20182_();
            Vec3 nextPos = currentPos.m_82549_(this.m_20184_());
            AABB sweptBox = this.m_20191_().m_82369_(this.m_20184_()).m_82400_((double)(this.m_20205_() * 1.0f) + 0.1);
            EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)sweptBox, x$0 -> this.m_5603_((Entity)x$0));
            if (entityHitResult != null) {
                this.m_5790_(entityHitResult);
            }
        }
    }

    public void addItemLight() {
        if (this.canGiveYouItem && !this.hasDitchedItem) {
            LivingEntity livingEntity = this.standUser;
            if (livingEntity instanceof Player) {
                Player PE = (Player)livingEntity;
                $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
                $$4.m_32010_(40);
                $$4.m_32052_(this.standUser.m_20148_());
                this.standUser.m_9236_().m_7967_((Entity)$$4);
            } else {
                $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
                $$4.m_32010_(40);
                this.m_9236_().m_7967_((Entity)$$4);
            }
        }
    }

    public void m_142687_(Entity.RemovalReason $$0) {
        if (!this.getHeldItem().m_41619_() && !this.m_9236_().m_5776_()) {
            this.addItemLight();
        }
        super.m_142687_($$0);
    }

    @Override
    public void popBubble() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.EXPLOSIVE_BUBBLE_POP_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.015);
            this.m_146870_();
        }
    }

    @Override
    protected void m_8060_(BlockHitResult $$0) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_9236_().m_8055_($$0.m_82425_())), $$0.m_82450_().f_82479_, $$0.m_82450_().f_82480_, $$0.m_82450_().f_82481_, 30, 0.2, 0.05, 0.2, 0.3);
            BlockState bs = this.m_9236_().m_8055_($$0.m_82425_());
            if (MainUtil.getIsGamemodeApproriateForGrief(this.m_19749_())) {
                BlockPos relativePos = $$0.m_82425_().m_121945_($$0.m_82434_());
                BlockState bs2 = this.m_9236_().m_8055_(relativePos);
                Block block = bs.m_60734_();
                if (block instanceof TntBlock) {
                    TntBlock tnt = (TntBlock)block;
                    this.m_9236_().m_7731_($$0.m_82425_(), Blocks.f_50016_.m_49966_(), 3);
                    this.wasExploded(this.m_9236_(), $$0.m_82425_());
                } else if (bs.m_60734_() instanceof AbstractGlassBlock || bs.m_60734_() instanceof StainedGlassPaneBlock || bs.m_60734_().m_49966_().m_60713_(Blocks.f_50185_) || bs.m_204336_(BlockTags.f_13035_) || bs.m_204336_(BlockTags.f_13047_)) {
                    this.m_9236_().m_7731_($$0.m_82425_(), Blocks.f_50016_.m_49966_(), 3);
                    this.blockBreakParticles(bs.m_60734_(), new Vec3((double)$$0.m_82425_().m_123341_() + 0.5, (double)$$0.m_82425_().m_123342_() + 0.5, (double)$$0.m_82425_().m_123343_() + 0.5));
                    this.m_5496_(bs.m_60734_().m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                } else if (bs.m_247087_() && !(bs.m_60734_() instanceof FogBlock) && !bs.m_278721_()) {
                    this.m_9236_().m_7731_($$0.m_82425_(), Blocks.f_50016_.m_49966_(), 3);
                    this.blockBreakParticles(bs.m_60734_(), new Vec3((double)relativePos.m_123341_() + 0.5, (double)relativePos.m_123342_() + 0.5, (double)relativePos.m_123343_() + 0.5));
                    this.m_5496_(bs.m_60734_().m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                } else if (bs2.m_247087_() && !(bs2.m_60734_() instanceof FogBlock) && !bs2.m_278721_()) {
                    this.m_9236_().m_7731_(relativePos, Blocks.f_50016_.m_49966_(), 3);
                    this.blockBreakParticles(bs2.m_60734_(), new Vec3((double)relativePos.m_123341_() + 0.5, (double)relativePos.m_123342_() + 0.5, (double)relativePos.m_123343_() + 0.5));
                    this.m_5496_(bs2.m_60734_().m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
                }
            }
        }
        this.popOnGroundWithForce($$0.m_82450_());
    }

    public void blockBreakParticles(Block block, Vec3 pos) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100, 0.0, 0.0, 0.0, 0.5);
        }
    }

    public void wasExploded(Level $$0, BlockPos $$1) {
        if (!$$0.f_46443_) {
            PrimedTnt $$3 = new PrimedTnt($$0, (double)$$1.m_123341_() + 0.5, (double)$$1.m_123342_(), (double)$$1.m_123343_() + 0.5, null);
            int $$4 = $$3.m_32100_();
            $$3.m_32085_((int)((short)($$0.f_46441_.m_188503_($$4 / 4) + $$4 / 8)));
            $$0.m_7967_((Entity)$$3);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult $$0) {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity LE;
            Object object;
            Entity entity = $$0.m_82443_();
            if (entity instanceof EnderMan) {
                EnderMan em = (EnderMan)entity;
                ((IEnderMan)em).roundabout$teleport();
                return;
            }
            Entity ent = $$0.m_82443_();
            if (!(ent instanceof SoftAndWetBubbleEntity) && (object = this.m_19749_()) instanceof LivingEntity && (object = ((StandUser)(LE = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersSoftAndWet) {
                PowersSoftAndWet PW = (PowersSoftAndWet)object;
                if (!MainUtil.isMobOrItsMounts(ent, this.m_19749_()) && !MainUtil.isCreativeOrInvincible(ent)) {
                    if (ent.m_6469_(ModDamageTypes.of(ent.m_9236_(), ModDamageTypes.EXPLOSIVE_STAND, this.m_19749_()), PW.getExplosiveBubbleStrength(ent))) {
                        // empty if block
                    }
                    float degrees = MainUtil.getLookAtEntityYawWithAngle(ent.m_20182_().m_82549_(this.m_20184_().m_82548_()), ent);
                    MainUtil.takeKnockbackWithY(ent, 1.05f, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
                    this.popBubble();
                }
            }
        }
    }

    public void popOnGroundWithForce(Vec3 location) {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity LE;
            List<Entity> entityList;
            Entity user = this.m_19749_();
            if (user instanceof LivingEntity && !(entityList = DamageHandler.genHitbox(LE = (LivingEntity)user, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0, 3.0, 3.0)).isEmpty()) {
                for (Entity ent : entityList) {
                    StandPowers standPowers;
                    if (ent instanceof SoftAndWetBubbleEntity || !((standPowers = ((StandUser)LE).roundabout$getStandPowers()) instanceof PowersSoftAndWet)) continue;
                    PowersSoftAndWet PW = (PowersSoftAndWet)standPowers;
                    if (MainUtil.isMobOrItsMounts(ent, this.m_19749_()) || MainUtil.isCreativeOrInvincible(ent)) continue;
                    float degrees = MainUtil.getLookAtEntityYawWithAngle(location, ent);
                    MainUtil.takeKnockbackWithY(ent, 0.6f, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
                }
            }
            this.popBubble();
        }
    }

    public float getPopAccuracy() {
        return 0.0f;
    }

    public float getBundleAccuracy() {
        return 0.5f;
    }

    public float getThrowAngle() {
        return -0.5f;
    }

    public float getThrowAngle2() {
        return 0.8f;
    }

    public float getThrowAngle3() {
        return -3.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getCanPlace(LivingEntity self) {
        if (self instanceof Player) {
            Player PE = (Player)self;
            if (((ServerPlayer)PE).f_8941_.m_9290_() == GameType.SPECTATOR) return false;
        }
        if (self instanceof Player) {
            Player PE2 = (Player)self;
            if (((ServerPlayer)PE2).f_8941_.m_9290_() == GameType.ADVENTURE) return false;
        }
        if (!self.m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING)) return false;
        return true;
    }

    public void popWithForce(Vec3 launch2) {
        if (!this.m_9236_().m_5776_()) {
            Entity user = this.m_19749_();
            if (user instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)user;
                if (launch2 != null && !this.getHeldItem().m_41619_()) {
                    Vec2 yes = MainUtil.getRotationsBetween(this.m_20182_(), launch2);
                    float xRot = yes.f_82470_;
                    float yRot = yes.f_82471_;
                    if (ThrownObjectEntity.throwAnObject(LE, false, this.getHeldItem(), this.getPopAccuracy(), this.getBundleAccuracy(), this.getThrowAngle(), this.getThrowAngle2(), this.getThrowAngle3(), this.getCanPlace(LE), (byte)3, xRot, yRot, new Vec3(this.m_20185_(), this.m_20188_() - (double)0.1f, this.m_20189_()), false, 0.85f, this.canGiveYouItem)) {
                        this.hasDitchedItem = true;
                    }
                }
            }
            this.popBubble();
        }
    }
}

